<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file Authentification.class.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Classe permettant l'authentification des utilisateurs selon la méthode configurée dans config.php
 * @todo annoncé que le compte est suspendu : désactivé
 */

class Authentification
{

    protected $id_session;
    private $sel = SEL;

    /**
     * @brief à l'instanciation l'utilisateur est quoi qu'il arrive non identifié = 0
     * @public
     */
    public function __construct()
    {
        $this->id_session = 0;
    }

    public function getId() {
        return $this->id_session;
    }

    function setId($id_session) {
        $this->id_session = $id_session;
    }

    /**
     * @brief Authentification SQL de l'utilisateur
     * @param login et password saisi par l'utilisateur dans le formulaire de connection
     * @return False si le login n'est pas trouvé ou si le password n'est pas le bon ou -1 si le compte existe mais est désactivé
     * @public
     */
    public function validUserSql($login,$password) {
        // connexion à la BDD
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        // récupération des informations de l'utilisateur par rapport au login
        $sql = 'SELECT * FROM user WHERE login = :login';
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('login', $login, PDO::PARAM_STR);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('selectionner tous de l\'utilisateur');
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
        // le login n'existe pas
        if($count == 0)
            return False;
        elseif($count > 1)
            throw new MyException (ERR_SELECT_NB_ROW);
        elseif ($count == 1) {
            // comparaison du password
            $passwordEncode = md5($this->sel.$_POST['password']);
            if (($result["password"] == $passwordEncode)&&($result["enabled"]==True)) {
                $_SESSION['id_user'] = $result["id_user"];
                $_SESSION['login'] = $result["login"];
                $_SESSION['lastname'] = $result["lastname"];
                $_SESSION['firstname'] = $result["firstname"];
                $_SESSION["admin"] = $result["admin"];
                $_SESSION["email"] = $result["email"];
                $_SESSION["birthdate"] = $result["birth_date"];
                $_SESSION["profile"] = $result["id_profile"];
                $_SESSION["rules"] = $result["rules"];
                return True;
            } elseif (($result["password"] == $passwordEncode)&&($result["enabled"]==False))
                return -1;
            else
                return False;
        }
    }

    /**
     * @brief authentification CAS de l'utilisateur
     * @param  login et password saisi par l'utilisateur dans le formulaire de connection
     * @todo Ecrire cette méthode d'authentification
     */
    function validUserCas() {
        //throw new MyException (ERR_EMPTY_FUNC);

        require_once("configCAS/cas.inc.php");
        require_once("CAS-1.3.1/eoleCAS.php");
        if (__CAS_DEBUG){
            eolephpCAS::setDebug("/var/log/posh/cdc-cas.log");
        }
        eolephpCAS::client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, false);
        
        // Maj pour phpCAS 1.3.1
        if (__CAS_VALIDER_CA) {
            eolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // vérification par rapport à la CA
        } else {
            if (method_exists("EolephpCAS", "setNoCasServerValidation")){
                eolephpCAS::setNoCasServerValidation();
            }
        }

		if (__CAS_LOGOUT){
		   if (method_exists(eolephpCAS, 'eolelogoutRequests')){
			  eolephpCAS::eolelogoutRequests(false);
		   }
		}
   
        eolephpCAS::forceAuthentication();

        // A partir d'ici l'utilisateur est authentifié

        $resultCAS = eolephpCAS::getDetails();

        // Vérification de la présence de l'utisiateur en base
        // connexion à la BDD
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        // récupération des informations de l'utilisateur par rapport au login
        $sql = 'SELECT * FROM user WHERE login = :login';
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('login', $resultCAS["utilisateur"]["user"][0], PDO::PARAM_STR);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True){
            Logger::log('selectionner données utilisateur='.$resultCAS["utilisateur"]["user"][0]);
            Logger::log('nombre de lignes renvoyées : '.$count);
        }
        // le login n'existe pas
        if($count == 0){
            // **********************
            // Code copié et modifié depuis Admin.class.php :: addUser

            // Ajout de l'utilisateur en base
            $db = Connection::getInstance();
            if(!$db) {
                throw new MyException (ERR_CONNECT_DB);
            }
            $sql = "INSERT INTO user (login,lastname,firstname,email,birth_date,id_profile,enabled,admin) VALUES (:login,:lastname,:firstname,:email,:birthdate,:profile,:enabled,:admin)";
            if (DEBUG==True)
                Logger::log('insertion d\'un nouvel utilisateur : '.$sql);
            $stmt = $db->prepare($sql);
            if ($stmt === null) {
                throw new MyException ('erreur de préparation à la requête');
            }
            $stmt->bindParam('login', $resultCAS["utilisateur"]["user"][0], PDO::PARAM_STR);
            $stmt->bindParam('lastname', $resultCAS["utilisateur"]["nom"][0], PDO::PARAM_STR);
            $stmt->bindParam('firstname', $resultCAS["utilisateur"]["prenom"][0], PDO::PARAM_STR);
            $stmt->bindParam('email', $resultCAS["utilisateur"]["email"][0], PDO::PARAM_STR);
            $stmt->bindParam('birthdate', $resultCAS["utilisateur"]["dateNaissance"][0], PDO::PARAM_STR);
            $stmt->bindParam('profile', $resultCAS["utilisateur"]["profile"][0], PDO::PARAM_INT);

            if (DEBUG==True)
                Logger::log('admin avant = '.$resultCAS["utilisateur"]["ad"][0]);


            $admin=($resultCAS["utilisateur"]["user"][0]=="admin")?1:0; // seule le compte admin peut etre admin (!)

            if (DEBUG==True)
                Logger::log('admin après = '.$resultCAS["utilisateur"]["ad"][0]);


            $stmt->bindParam('admin', $admin, PDO::PARAM_BOOL);

            $enabled=True; // lors d'une première connexion avec CAS le compte est toujours activé
            $stmt->bindParam('enabled', $enabled, PDO::PARAM_BOOL);

            if ($stmt->execute() === false) {
                if (DEBUG==True){
                    $err = $stmt->errorInfo();
                    Logger::log("erreur d'insertion : ".$err[2]);
                    exit("Erreur d'insertion du compte : ".$err[2]);
                }
            }
            // **********************

            // maintenant l'utilisateur est créé donc redirection vers la page d'index
            // FIXME mettre éventuellement un message de 1ère connexion avant la redirection
        }elseif($count > 1)
            throw new MyException (ERR_SELECT_NB_ROW);
        elseif ($count == 1) {
            // utilisateur trouvé donc remplissage des donées
            $_SESSION['id_user'] = $result["id_user"];
            $_SESSION['login'] = $result["login"];
            $_SESSION['lastname'] = $result["lastname"];
            $_SESSION['firstname'] = $result["firstname"];
            $_SESSION["admin"] = $result["admin"];
            $_SESSION["email"] = $result["email"];
            $_SESSION["birthdate"] = $result["birth_date"];
            $_SESSION["profile"] = $result["id_profile"];
            $_SESSION["rules"] = $result["rules"];
            return True;
        }

        return False;
    }
}
