<?php
/**
 * @author CETIAD Dijon
 * @date Octobre 2011
 * @file Box.class.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Classe permettant la gestion du carnet
 */

class Box
{
    /**
     * @brief le constructeur permet de loguer l'instanciation de la classe
     */
    public function __construct()
    {
        if (DEBUG==True)
            Logger::log('instanciation d\'une box');
    }

    /**
     * @brief recuperer tous les messages d'une box
     * @param (int) id de l'utilisateur
     * @return (array) contenant les messages
     */
    function getBox($id_user)
    {
        if (DEBUG==True)
            Logger::log('passage dans getBox, Box.class.php');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT m.id_message,title,content,validation,DATE_FORMAT(date,'%d/%m/%Y') as date,DATE_FORMAT(date,'%k:%i') as time,firstname,lastname FROM belong JOIN message m ON belong.id_message=m.id_message JOIN user ON user.id_user=m.transmitter WHERE belong.id_recipient = :id_user AND user.id_user <> :id_user ORDER BY m.date DESC";
        if (DEBUG == True)
            Logger::log('affiche tous les messages : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('id_user', $id_user, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
        return $result;
    }

    /**
     * @brief recuperer tous les messages émis par l'utilisateur
     * @param (int) id de l'utilisateur
     * @return (array) contenant les messages émis par l'utilisateur
     */
    function getSentMessages($id_user)
    {
        if (DEBUG==True)
            Logger::log('passage dans getSentMessages, Box.class.php');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT m.id_message,title,content,validation,DATE_FORMAT(date,'%d/%m/%Y') as date,DATE_FORMAT(date,'%k:%i') as time,firstname,lastname FROM message m JOIN belong ON m.id_message=belong.id_message JOIN user ON user.id_user=belong.id_recipient WHERE m.transmitter = :id_user AND belong.id_recipient <> :id_user ORDER BY m.date DESC";
        if (DEBUG == True)
            Logger::log('affiche tous les messages émis par l\'utilisateur : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('id_user', $id_user, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
        return $result;
    }
}
?>
