<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file Connexion.class.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Classe singleton permettant une seule connexion à la BDD MySQL
 * @todo seule une BDD mysql est gérée
 */

class Connection extends PDO
{
    private $host = HOST;
    private $base = BASE;
    private $user = USER;
    private $pass = PASS;
    private static $instance = null;

    /**
     * @brief Connection à la BDD lors de l'instanciation de la classe
     */
    public function __construct()
    {
	try {
	    if (DEBUG==True){
		Logger::log('connection à la bdd : '.HOST.' '.BASE );
	    }
	    // si la base de données est MySQL
	    if (DSN == 'mysql') 
		parent::__construct('mysql:host='.$this->host.';dbname='.$this->base, $this->user, $this->pass);
	    // si la base de données est postgres
	    elseif (DSN == 'postgres'){
		// FIXME
		echo 'non pris en charge';
	    }
	    $this->query("SET NAMES utf8");
	    $this->query("SET CHARACTER SET 'utf8'");
	}
	catch (PDOexception $e){
	    //echo 'erreur : '.$e->getmessage().'<br>';
	    if (DEBUG == True) {
		throw new MyException (ERR_CONNECT_DB);
	    }
	    //echo 'L\'application rencontre un problème, veuillez contacter l\administrateur.';
	    die();
	}
    }

    /**
     * @brief Méthode static permettant une instanciation unique de la classe
     * @return une instance de la classe
     */
    public static function getInstance()
    {
	if (!isset(self::$instance))
	{
	    self::$instance = new Connection();
	}
	return self::$instance;
    }

    #    public function query($statement)
    #    {
    #        try {
    #            if (DEBUG==True)
    #                Logger::log('la requete : '.$statement);
    #            parent::query($statement);
    #        }  
    #        catch (PDOException $e) {
    #            echo $e->getMessage();
    #        }
    #    }
}
?>
