<?php
/**
 * @author CETIAD Dijon
 * @date Mars 2011
 * @file Discipline.class.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Classe permettant de gérer les disciplines des Enseignants
 */

class Discipline
{
    public function __construct()
    {
    }

    /**
     * @brief sélectionner toutes les disciplines
     * @return un tableau contenant toutes les disciplines
     */
    static function selectAllDiscipline()
    {
        Logger::log('passage dans selectAllDiscipline');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT * FROM discipline ORDER BY id_discipline DESC";
        if (DEBUG==True)
            Logger::log('selection de toutes les disciplines : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        if($count == 0)
            throw new MyException (ERR_SELECT_NB_NULL);
        return $result;
    }

    /**
     * @brief méthode renvoyant un tableau contenant les infos d'une discipline
     * @param l'id de la discipline
     * @return retourne un tableau contenant les différentes infos de la discipline sélectionnée
     */
	static function selectDiscipline($idDiscipline)
	{
        Logger::log('passage dans selectDiscipline');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "SELECT * FROM discipline WHERE id_discipline = :idDiscipline";
		if (DEBUG==True)
            Logger::log('selection du nom d\'une discipline : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idDiscipline', $idDiscipline, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
		if($count == 0)
			throw new MyException (ERR_SELECT_NB_NULL);
        return $result;
	}


	/**
     * Description: méthode pour obtenir le nombre de professeurs dans une discipline
     * Paramètres: l'id de la discipline
     * Return: retourne le nombre de professeurs d'une discipline
     */
	static function countTeacherInDiscipline($idDiscipline)
	{
        Logger::log('passage dans countTeacherInDiscipline');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "SELECT COUNT( * ) AS nbInTeacher FROM discipline, user, teacher WHERE discipline.id_discipline = :idDiscipline AND teacher.id_user = user.id_user AND discipline.id_discipline = teacher.id_discipline AND user.id_profile =30";
		if (DEBUG==True)
            Logger::log('comptage du nombre de professeurs dans une discipline : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idDiscipline', $idDiscipline, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $result;
	}



	/**
     * Description: méthode pour obtenir la liste de professeurs dans une discipline
     * Paramètres: l'id de la discipline
     * Return: retourne un tableau contenant la liste de professeurs dans une discipline
     */
	static function TeacherInDiscipline($idDiscipline)
	{
        Logger::log('passage dans TeacherInDiscipline');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "SELECT user.id_user, user.firstname, user.lastname, user.login, user.email, user.enabled FROM discipline, user, teacher WHERE discipline.id_discipline = :idDiscipline AND teacher.id_user = user.id_user AND discipline.id_discipline = teacher.id_discipline AND user.id_profile =30";
		if (DEBUG==True)
            Logger::log('Liste de professeurs dans une discipline : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idDiscipline', $idDiscipline, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $result;
	}

}
?>
