<?php
/**
 *
 * CETIAD Dijon
 * Class permettant la gestion des classes : liste des classes, suppression, ajout
 *
 */


class Level
{

	public function __construct()
	{

	}

    /**
     * Description: selection de toutes les classes
     * Paramètres: null
     * Return: retourne un tableau contenant la liste des classes
     */
	static function selectAllLevel()
	{
        Logger::log('passage dans selectAllLevel : Level.class.php');
        $db = Connection::getInstance();
        //$sql = "SELECT * FROM level ORDER BY name";
        // On ordonne par niveau de classes croissantes
        $sql = "SELECT * FROM level ORDER BY id_level DESC";
        if (DEBUG==True)
            Logger::log('selection de toutes les classes : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return $result;
	}

    /**
     * Description: méthode renvoyant un tableau contenant les infos d'une classe
     * Paramètres: l'id de la classe
     * Return: retourne un tableau contenant les différentes classes et leur ID
     */
	static function selectLevel($idLevel)
	{
        Logger::log('passage dans selectLevel');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "SELECT * FROM level WHERE id_level = :idLevel";
		if (DEBUG==True)
            Logger::log('selection du nom d\'une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idLevel', $idLevel, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
		if($count == 0)
			throw new MyException (ERR_SELECT_NB_NULL);
        return $result;
	}

    /**
     * Description: méthode pour obtenir le nombre d'utilisateur dans une classe
     * Paramètres: l'id de la classe
     * Return: retourne le nombre de membre de la classe
     */
	static function countInLevel($idLevel)
	{
        Logger::log('passage dans countInLevel');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "SELECT COUNT(*) AS nbInLevel FROM member_of_level WHERE id_level = :idLevel";
		if (DEBUG==True)
            Logger::log('comptage du nombre de membre dans une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idLevel', $idLevel, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $result;
	}

	/**
     * Description: méthode pour obtenir le nombre d'élèves dans une classe
     * Paramètres: l'id de la classe
     * Return: retourne le nombre d'élèves d'une classe
     */
	static function countStudentInLevel($idLevel)
	{
        Logger::log('passage dans countInLevel');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "SELECT COUNT(*) as nbInLevel FROM level, user, member_of_level WHERE member_of_level.id_level = :idLevel AND member_of_level.id_user = user.id_user AND level.id_level = member_of_level.id_level AND user.id_profile = 10";
		if (DEBUG==True)
            Logger::log('comptage du nombre nombre d\'élèves dans une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idLevel', $idLevel, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $result;
	}

	/**
     * Description: méthode pour obtenir le nombre de professeurs dans une classe
     * Paramètres: l'id de la classe
     * Return: retourne le nombre de professeurs d'une classe
     */
	static function countTeacherInLevel($idLevel)
	{
        Logger::log('passage dans countTeacherInLevel');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "SELECT COUNT(*) as nbInLevel FROM level, user, member_of_level WHERE member_of_level.id_level = :idLevel AND member_of_level.id_user = user.id_user AND level.id_level = member_of_level.id_level AND user.id_profile = 30";
		if (DEBUG==True)
            Logger::log('comptage du nombre nombre de professeurs dans une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idLevel', $idLevel, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $result;
	}


    /**
     * Description: méthode pour obtenir les prof principaux dans une classe
     * Paramètres: l'id de la classe
     * Return: retourne les noms des prof principaux
     */
	static function managerOfLevel($idLevel)
	{
        Logger::log('passage dans managerOfLevel');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "SELECT user.id_user,firstname,lastname FROM member_of_level JOIN user ON member_of_level.id_user = user.id_user WHERE id_level = :idLevel AND manager = True";
		if (DEBUG==True)
            Logger::log('select des prof principaux dans une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idLevel', $idLevel, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $result;
	}

	 /**
     * Description: méthode pour obtenir l'effectif d'une classe
     * Paramètres: l'id de la classe
     * Return: retourne l'effectif d'une classe
     */
	static function selectSizeOfLevel($selectIdLevel)
	{
        Logger::log('passage dans sizeOfLevel');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "select count(*) as nombre from level, user, member_of_level where level.id_level =: selectIdLevel and member_of_level.id_user = user.id_user and level.id_level = member_of_level.id_level";
		if (DEBUG==True)
            Logger::log('affiche l\'effectif d\'une classe  : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idLevel', $idLevel, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $result;
	}
}
?>
