<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file Logger.class.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Classe permettant de gérer l'écriture des logs
 */

class Logger
{

    /**
     * @brief méthode static pour écrire les logs
     * @param (string) message à afficher dans les logs
     * @static
     * @fixme utiliser les exceptions
     * @fixme concatener les valeurs et n'écrire qu'une seule fois ?
     */
    static function log($message) {
        global $DEBUGTAB;
        if (DEBUG == True) {
            if (DEBUG_DISPLAY == True) {
                $DEBUGTAB[] = $message;
            }
            if (DEBUG_LOG == True) {
                $filename = DEBUG_FILE;
                $filepath = DEBUG_PATH.$filename;
                $file = fopen($filepath, 'a+');
                $today = date("[Y F j H:i:s]");
                $save = $today.' '.$message;
                fwrite($file, $save."\n");
                fclose($file);
            }
        }
    } 

    /**
     * @brief méthode static pour afficher les logs
     * @static
     */
    static function getLog()
    {
        global $DEBUGTAB;
        echo '<span class="bold">Affichage des logs :</span><br />';
        foreach ($DEBUGTAB as $id => $value) {
            echo $value.'<br />', chr(10);
        }
    }
}
?>
