<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file Message.class.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Classe permettant la gestion des messages
 */

class Message
{
    /**
     * @brief le constructeur permet de loguer l'instanciation d'un nouveau message
     */
    public function __construct()
    {
        if (DEBUG==True)
            Logger::log('instanciation d\'un nouveau message');
    }

    /**
     * @brief valider un mot
     * @param (int) id du message que l'on souhaite valider
     * @param (int) id de l'utilisateur qui le valide
     */
    function validMessage($idMessage,$idUser) {
        if (DEBUG==True)
            Logger::log('passage dans validMessage');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = 'UPDATE belong SET validation = True, id_recipient = :idUser, validation_date = :date WHERE id_message  = :idMessage';
        if (DEBUG == True)
            Logger::log('met à jour la validation d\'un message : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation de la requête');
        }
        $today = date("Y-m-d H:i:s");
        if (DEBUG == True)
            Logger::log($today);
        $stmt->bindParam('idMessage', $idMessage, PDO::PARAM_INT);
        $stmt->bindParam('date', $today, PDO::PARAM_STR);
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }

    /**
     * @brief selectionner un mot du carnet
     * @param (int) id du message que l'on souhaite obtenir
     * @return (array) contenant les propriétés du message
     */

    function getMessage($idMessage) {
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "SELECT m.id_message,transmitter,title,content, belong.id_report as idSchoolReport,s.id_user as studentIdUser, s.firstname as studentFirstname,s.lastname as studentLastname,level.id_level as idLevel, level.name as classe, DATE_FORMAT(validation_date,'%d/%m/%Y') as v_date,DATE_FORMAT(validation_date,'%k:%i') as v_time,validation,DATE_FORMAT(date,'%d/%m/%Y') as date,DATE_FORMAT(date,'%k:%i') as time,user.id_user as id_user, user.firstname as firstname,user.lastname as lastname,user.id_profile as id_profile,r.id_user as id_userRecipient, r.lastname as lastnameRecipient, r.firstname as firstnameRecipient FROM message m JOIN belong ON m.id_message=belong.id_message JOIN user ON user.id_user=m.transmitter JOIN user as r ON r.id_user = belong.id_recipient JOIN school_report ON school_report.id_report =  belong.id_report JOIN user as s ON s.id_user = school_report.id_user JOIN member_of_level ON s.id_user = member_of_level.id_user JOIN level ON level.id_level = member_of_level.id_level WHERE m.id_message = :idMessage";
        if (DEBUG == True)
            Logger::log('selectionne un message : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idMessage', $idMessage, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
        return $result;
    }

    /**
     * @brief ajouter un mot
     * @param (string) titre du message
     * @param (string) contenu du message
     * @param (int) id de l'émetteur
     * @param (int) id du récepteur
     * @param (int) id du carnet dans lequel ajouter le message
     */
    function addMessage($title,$content,$idTransmitter,$idRecipient,$idSchoolReport) {
        if (DEBUG==True)
            Logger::log('passage dans addMessage');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = 'INSERT INTO message (title,content,transmitter) VALUES (:title,:content,:idTransmitter)';
        if (DEBUG==True)
            Logger::log('insertion d\'un nouveau message : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('title', $title, PDO::PARAM_STR);
        $stmt->bindParam('content', $content, PDO::PARAM_STR);
        $stmt->bindParam('idTransmitter', $idTransmitter, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        // retourne le dernier ID
        $idMessage = $db->lastInsertId();
        $sql2 = 'INSERT INTO belong (id_message,id_report,id_recipient) VALUES (:idMessage,:idSchoolReport,:idRecipient)';
        if (DEBUG==True)
            Logger::log('insertion des paramètres du message : '.$sql2);
        $stmt = $db->prepare($sql2);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idMessage', $idMessage, PDO::PARAM_INT);
        $stmt->bindParam('idSchoolReport', $idSchoolReport, PDO::PARAM_INT);
        $stmt->bindParam('idRecipient', $idRecipient, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        // ajout de la méthode pour l'envoi de courriel
        if (EMAIL == True) {
            $this->sentEmail($idRecipient,$idMessage,$idTransmitter,$title,$content,$idSchoolReport);
        }
    }

    /**
     * Description: poste un courriel
     * Paramètres: (int) id du destinataire
     * Paramètres: (int) id du message
     * Paramètres: (int) id de l'émetteur
     * Paramètres: (varchar) le titre
     * Paramètres: (varchar) le contenu du message
     * Paramètres: (int) id du carnet
     * Return: (Bool)
     * @fixme prise en charge de message à multiple destinataire
     */
    public function sentEmail($idRecipient,$idMessage,$idTransmitter,$title,$content,$idSchoolReport) {
        if (DEBUG==True)
            Logger::log('passage dans sentEmail');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        // récupérer l'adresse du destinataire
        $sql = 'SELECT id_recipient,id_user,email,firstname,lastname,profil FROM belong JOIN user ON belong.id_recipient = user.id_user WHERE belong.id_recipient = :idRecipient AND belong.id_message = :idMessage';
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idRecipient', $idRecipient, PDO::PARAM_INT);
        $stmt->bindParam('idMessage', $idMessage, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        $header = 'From: '.NAME_OF_SENDER.' <'.EMAIL_OF_SENDER.'>';
        if($count > 0) {
            if (DEBUG==True) {
                Logger::log('sentmail nouveau message @ '.$idRecipient.' id du message :'.$idMessage );
                Logger::log(htmlentities($header));
                Logger::log('Pour :'.$result[0]['firstname'].' '.$result[0]['lastname'].' '.$result[0]['email']);
                Logger::log('Titre :'.$title);
                Logger::log('Contenu :'.$content);
            }
            // on procède à l'envoi
            # if(mail($result[0]['email'],$title,$content,$header))
            # {
            # if (DEBUG==True)
            #     Logger::log('Le courriel a été envoyé à '.$idRecipient.' id du message :'.$idMessage );
            # }
            # else
            # {
            #     if (DEBUG==True)
            # 	Logger::log('L\'envoi du courriel pour '.$idRecipient.' id du message :'.$idMessage.' a echoué');
            # }
        }
        // récupérer les responsables liés au carnet sauf s'il est l'émetteur
        if (DEBUG==True) {
            Logger::log('passage dans la deuxième partie de sentEmail');
            Logger::log('idSchoolReport : '.$idSchoolReport);
            Logger::log('idTransmitter : '.$idTransmitter);
        }
        $sql2 = 'SELECT id_responsible,id_user,email,firstname,lastname FROM responsible JOIN user ON id_responsible = user.id_user WHERE responsible.id_student = :idSchoolReport AND user.id_user <> :idTransmitter';
        $stmt2 = $db->prepare($sql2);
        if ($stmt2 === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt2->bindParam('idSchoolReport', $idSchoolReport, PDO::PARAM_INT);
        $stmt2->bindParam('idTransmitter', $idTransmitter, PDO::PARAM_INT);
        if ($stmt2->execute() === false) {
            $stmt2->errorInfo();
        }
        $result = $stmt2->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt2->rowCount();
        if (DEBUG==True)
            Logger::log('résultat de la requête, nombre de responsible :'.$count);
        if($count > 0) {
            foreach ($result as $id => $value) {
                if (DEBUG==True) {
                    Logger::log('sentmail nouveau message @ '.$result[$id]['email'].' id du message :'.$idMessage );
                    Logger::log('De :'.$header);
                    Logger::log('Pour :'.$result[$id]['firstname'].' '.$result[$id]['lastname'].' '.$result[$id]['email']);
                    Logger::log('Titre :'.$title);
                    Logger::log('Contenu :'.$content);
                }
                // on procède à l'envoi
                # if(mail($result[0]['email'],$title,$content,$header))
                # {
                # if (DEBUG==True)
                #     Logger::log('Le courriel a été envoyé à '.$idRecipient.' id du message :'.$idMessage );
                # }
                # else
                # {
                #     if (DEBUG==True)
                # 	Logger::log('L\'envoi du courriel pour '.$idRecipient.' id du message :'.$idMessage.' a echoué');
                # }
            }
        }
    }

    /**
     * @brief Sélectionner un utilisateur.
     * @return un tableau contenant les informations sur un professeur ayant envoyé un message
     * @public
     */
    function getInfoTransmitter($idTransmitter){
        Logger::log('passage dans getInfoTransmitter : Message.class.php');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT user.id_user,user.lastname,user.firstname,user.login,user.email,user.birth_date,discipline.name as matiere, from user JOIN teacher On user.id_user = teacher.id_user JOIN discipline ON teacher.id_discipline = discipline.id_discipline WHERE user.id_user = :idTransmitter";
        if (DEBUG==True)
            Logger::log('selection d\'un utilisateur : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idTransmitter', $idTransmitter, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
    }

	/**
	* @brief Vidage de la table message
	* Suppression de tous les mots de l'année écoulée après le dump
	*/
	public function deleteMessage(){
		//global $compteur_message;
		$db = Connection::getInstance();
		if(!$db){
			throw new MyExeption (ERR_CONNECT_DB);
		}
		$sql = "DELETE FROM message";
		 if (DEBUG==True)
            Logger::log('selection d\'un utilisateur : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        //$stmt->bindParam('idTransmitter', $idTransmitter, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
	}

    #/**
    # * Description: retourne la liste des personnes joingnables dans une classe selon le niveau d'autorisation
    # * Paramètres: (int) id de la classe
    # * Return: (array) les id des user joingnables
    # * @fixme non utilisé car MysqlConnection::getInstance()
    # */
    #public function selectAllMemberLevel($id_profile) {
    #    if (DEBUG==True)
    #        Logger::log('passage dans selectAllMemberLevel');
    #    $db = MysqlConnection::getInstance();
    #    //$sql = 'SELECT id_user,firstname,lastname FROM user JOIN be_level ON be_level.id_user = user.id_user WHERE be_level.id_level = :id_level';
    #    $sql = 'SELECT id_user,firstname,lastname FROM user WHERE id_profile = :id_profile';
    #    $stmt = $db->prepare($sql);
    #    if ($stmt === null) {
    #        throw new MyException ('erreur de préparation à la requête');
    #    }
    #    $stmt->bindParam('id_profile', $id_profile, PDO::PARAM_INT);
    #    if ($stmt->execute() === false) {
    #        $stmt->errorInfo();
    #    }
    #    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    #    $count = $stmt->rowCount();
    #    if($count == 0)
    #        throw new MyException (ERR_SELECT_NB_NULL);
    #    return($result);
    #}

    #	function selectTypeMessage() {
    #		$db = new Connexion();
    #		if(!$db)
    #			throw new MyException (ERR_CONNECT_DB);
    #		$query = "SELECT * FROM type";
    #		$rsType = mysql_query($query,$db->connexion);
    #		if(!$rsType)
    #			throw new MyException (ERR_QUERY);
    #		$cnt = 0;
    #		$tabAllType=array();
    #		while ($row = mysql_fetch_array($rsType)) {
    #			$tabAllType[$cnt]['id_type'] = $row['id_type'];
    #			$tabAllType[$cnt]['wording'] = $row['wording'];
    #			$cnt++;
    #		}
    #		return $tabAllType;
    #	}

    #	// calcul du nombre de mots non valider
    #	function num_message() {
    #		$db = new Connexion();
    #		if (!$db) {
    #
    #			throw new MyException (ERR_CONNECT_DB);
    #		}
    #		$query = "SELECT Count(id_message) as '.$nbMessage.'; FROM message,belong,school_report,user WHERE WHERE m.id_message=b.id_message AND b.id_report=s.id_report AND s.id_user=u.id_user id_user='$id_user'";
    #		$rsNbMessage = mysql_query($query,$db->connexion);
    #		$row = mysql_fetch_array($rsNbMessage);
    #		if(!$rsNbMessage) {
    #			throw new MyException (ERR_QUERY);
    #		}
    #		$this->message = $nbMessage;
    #	}

    #	// FIXME est-ce vraiment utile??????
    #	function selectUser($id)
    #	{
    #		echo "passage dans selectUser<br />";
    #		$db = new Connexion();
    #		if(!$db) {
    #			throw new MyException (ERR_CONNECT_DB);
    #		}
    #		$query="SELECT * FROM user WHERE id_user='$id'";
    #		echo $query;
    #		$rsUser = mysql_query($query,$db->connexion);
    #		if(!$rsUser) {
    #			throw new MyException (ERR_SELECT_NB_ROW);
    #		}
    #		$row = mysql_fetch_array($rsUser);
    #		$this->login = $row["login"];
    #		$this->name = $row["name"];
    #		$this->surname = $row["surname"];
    #		$this->birth_date = $row["birth_date"];
    #		$this->profile = $row["profile"];
    #	}

    // FIXME est-ce vraiment utile ?????????????
    #function displayUser()
    #{
    #	echo "fonction displayUser";
    #	echo "<td>$this->login</td>";
    #	echo "<SCRIPT LANGUAGE=\"JavaScript\">";
    #	echo "Ext.Msg.prompt('Identification', '".$this->login." :', function(btn, text){";
    #	echo "if (btn == 'ok'){";
    #	echo "Ext.Msg.prompt('Mot de passe', 'Entrez votre password :', function(btn, text){";
    #	echo "if (btn == 'ok'){}});";
    #	echo "}});";
    #	echo "</SCRIPT>	";
    #thr#ow new MyException (ERR_EMPTY_FUNC);
    #}
}
?>
