<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file Profile.class.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Classe permettant de gérer les profiles utilisateurs
 */

class Profile
{
    public function __construct()
    {
    }

    /**
     * @brief sélectionner tous les types de profiles
     * @return un tableau contenant tous les profiles
     */
    static function selectAllProfile()
    {
        Logger::log('passage dans selectAllProfile');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT * FROM profile ORDER BY id_profile";
        if (DEBUG==True)
            Logger::log('selection de tous les profiles : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        if($count == 0)
            throw new MyException (ERR_SELECT_NB_NULL);
        return $result;
    }
    
    /**
     * @brief méthode renvoyant un tableau contenant les infos d'un profile
     * @param l'id du profile
     * @return retourne un tableau contenant les différentes infos du profile sélectionné
     */
	static function selectProfile($idProfile)
	{
        Logger::log('passage dans selectProfile');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "SELECT * FROM profile WHERE id_profile = :idProfile";
		if (DEBUG==True)
            Logger::log('selection du nom d\'une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idProfile', $idProfile, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
		if($count == 0)
		#	throw new MyException (ERR_SELECT_NB_NULL);
        return $result;
	}
}
?>
