<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file SchoolReport.class.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Classe permettant la gestion du carnet
 */

class SchoolReport
{
    protected $id = NULL ;
    protected $id_user = NULL ;
    protected $statut = NULL;

    /**
     * @brief le constructeur permet de loguer l'instanciation de la classe
     */
    public function __construct($id_user)
    {
        if (DEBUG==True)
            Logger::log('instanciation d\'un carnet');
        $this->id = $this->selectIdSchoolReport($id_user);
        $this->id_user = $id_user;
    }

    /**
     * @brief retourne le numéro du carnet de l'utilisateur
     * @param (int) id de l'utilisateur
     * @return: (int) l'id du carnet
     */
    private function selectIdSchoolReport($id_user) {
    if (DEBUG==True)
        Logger::log('passage dans getIdSchoolReport');
    $db = Connection::getInstance();
    if(!$db) {
        throw new MyException (ERR_CONNECT_DB);
    }
    $sql = "SELECT id_report FROM school_report WHERE id_user = :id_user";
    $stmt = $db->prepare($sql);
    if ($stmt === null) {
        throw new MyException ('erreur de préparation à la requête');
    }
    $stmt->bindParam('id_user', $id_user, PDO::PARAM_INT);
    if ($stmt->execute() === false) {
        $stmt->errorInfo();
    }
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $count = $stmt->rowCount();
    if($count == 0)
        throw new MyException (ERR_SELECT_NB_NULL);
    return $result['id_report'];
    }

    /**
     * @brief retourne le numéro du carnet de l'utilisateur
     * @return: (int) l'id du carnet
     */
    public function getIdSchoolReport() {
        return $this->id;
    }

    /**
     * @brief retourne l'id du possesseur du carnet
     * @return: (int) l'id du possesseur du carnet
     */
    public function getIdSchoolReportOwner() {
        return $this->id_user;
    }

    /**
     * @brief recuperer tous les messages d'un carnet
     * @param (int) id du carnet que l'on souhaite obtenir
     * @return (array) contenant les messages
     */
    function getSchoolReport($idSchoolReport)
    {
        if (DEBUG==True)
            Logger::log('passage dans getSchoolReport');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT m.id_message,title,content,validation,transmitter,DATE_FORMAT(validation_date,'%d/%m/%Y') as v_date,DATE_FORMAT(validation_date,'%k:%i') as v_time,DATE_FORMAT(date,'%d/%m/%Y') as date,DATE_FORMAT(date,'%k:%i') as time,user.firstname,user.lastname, r.lastname as lastnameRecipient, r.firstname as firstnameRecipient FROM message m JOIN belong ON m.id_message=belong.id_message JOIN school_report ON belong.id_report=school_report.id_report JOIN user ON user.id_user=m.transmitter JOIN user as r ON r.id_user = belong.id_recipient WHERE school_report.id_report = :idSchoolReport ORDER BY m.date DESC";
        if (DEBUG == True)
            Logger::log('affiche tout les messages du carnet : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idSchoolReport', $idSchoolReport, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
        // les responsables
        $_SESSION['tabAllResponsible'] = $this->getAllResponsible($idSchoolReport);
        return $result;
    }

    /**
     * @brief recuperer les messages non validés d'un carnet
     * @param (int) id du carnet que l'on souhaite obtenir
     * @return (array) contenant les messages
     */
    function getSchoolReportToValidate($idSchoolReport)
    {
        if (DEBUG==True)
            Logger::log('passage dans getSchoolReport');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT m.id_message,title,content,validation,transmitter,DATE_FORMAT(validation_date,'%d/%m/%Y') as v_date,DATE_FORMAT(validation_date,'%k:%i') as v_time,DATE_FORMAT(date,'%d/%m/%Y') as date,DATE_FORMAT(date,'%k:%i') as time,user.firstname,user.lastname, r.lastname as lastnameRecipient, r.firstname as firstnameRecipient FROM message m JOIN belong ON m.id_message=belong.id_message JOIN school_report ON belong.id_report=school_report.id_report JOIN user ON user.id_user=m.transmitter JOIN user as r ON r.id_user = belong.id_recipient WHERE school_report.id_report = :idSchoolReport AND belong.validation=0 ORDER BY m.date DESC";
        if (DEBUG == True)
            Logger::log('affiche les messages non validés du carnet : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idSchoolReport', $idSchoolReport, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
        // les responsables
        $_SESSION['tabAllResponsible'] = $this->getAllResponsible($idSchoolReport);
        return $result;
    }

    /**
     * Description: recuperer tous les messages du carnet
     * Paramètres: (int) id du carnet que l'on souhaite contrôler
     * Return: (array) contenant les messages
     */
    function getCountUncheck($idSchoolReport)
    {
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = 'SELECT title,content,validation,date FROM message m,belong ,school_report WHERE m.id_message=belong.id_message AND belong.id_report=school_report.id_report AND school_report.id_report = :idSchoolReport AND belong.validation = 0';
        if (DEBUG == True)
            Logger::log('affiche tout les messages du carnet non validés : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idSchoolReport', $idSchoolReport, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
        return $count;
    }

    /**
     * @brief recuperer le status  d'un carnet
     * @param (int) id du carnet que l'on souhaite obtenir
     * @return (array) contenant les messages
     */
    function getStatus($idSchoolReport)
    {
        if (DEBUG==True)
            Logger::log('passage dans getStatus');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT status, id_user FROM school_report WHERE id_report = :idSchoolReport";
        if (DEBUG == True)
            Logger::log('renvoit l\'état du carnet : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idSchoolReport', $idSchoolReport, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
        if($count > 1)
            throw new MyException (ERR_SELECT_NB_ROW);
        elseif ($count == 1)
            return $result;
    }

    /**
     * @brief récupérer les id des autres responsables du carnet
     * @param (int) id du carnet
     * @return (array) les id des autres responsables
     * @public
     */
    public function getAllResponsible($idSchoolReport)
    {
        if (DEBUG==True)
            Logger::log('passage dans getAllResponsible');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        //      SELECT id_responsible FROM school_report JOIN user ON school_report.id_user = user.id_user JOIN responsible ON responsible.id_student = school_report.id_user WHERE school_report.id_report = 3
        $sql = 'SELECT id_responsible FROM school_report JOIN user ON school_report.id_user = user.id_user JOIN responsible ON responsible.id_student = school_report.id_user WHERE school_report.id_report = :idSchoolReport';
        if (DEBUG==True)
            Logger::log('selection de tous les responsables : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idSchoolReport', $idSchoolReport, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return $result;
    }

    /**
     * @brief recuperer le nom et prénom du propriétaire du carnet
     * @param (int) id du carnet
     * @return (array) contenant le nom et le prénom du propriétaire
     * @static
     */
    static function getOwnerInfos($idSchoolReport)
    {
        if (DEBUG==True)
            Logger::log('passage dans getOwnerInfos');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT id_user,firstname,lastname FROM school_report JOIN user ON user.id_user = school_report.id_user WHERE id_report = :idSchoolReport";
        if (DEBUG == True)
            Logger::log('renvoit le nom et prénom du propriétaire du carnet : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idSchoolReport', $idSchoolReport, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
        if($count > 1)
            throw new MyException (ERR_SELECT_NB_ROW);
        elseif ($count == 1)
            return $result;
    }
}
?>
