<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file Student.class.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Classe regroupant les méthodes utilisés par les étudiants
 */

class Student extends User
{

    /**
     * @brief le constructeur permet de loguer l'instanciation d'un élève
     */
    public function __construct()
    {
    if (DEBUG==True)
        Logger::log('création d\'un nouveau Student');
    }

    /**
     * @brief permet de récupérer le réglement intérieur
     * @return tableau contenant le réglement
     */
    function getRules() {
    Logger::log('passage dans getRules');
    $db = Connection::getInstance();
    if(!$db) {
        throw new MyException (ERR_CONNECT_DB);
    }
    $sql = "SELECT rules FROM config";
    if (DEBUG==True)
        Logger::log('selection du règlement intérieur : '.$sql);
    $stmt = $db->prepare($sql);
    if ($stmt->execute() === false) {
        $stmt->errorInfo();
    }
    $count = $stmt->rowCount();
    if (DEBUG == True)
        Logger::log('nombre de ligne renvoyées : '.$count);
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    return $result;
    }

    /**
     * @bried mise à jour des informations utilisateurs
     * @param login
     * @param lastname
     * @param firstname
     * @param password
     * @param email
     * @param birthdate
     * @param id de l'utilisateur
     */
    public function updateMyCount($login,$lastname,$firstname,$password,$email,$birthdate,$profile,$idUser) {
        Logger::log('passage dans updateMyCount');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        // récupération des informations de l'utilisateur par rapport au login
        $sql = "UPDATE user SET login= :login,lastname= :lastname,firstname= :firstname,password= :password,email= :email,birth_date= :birthdate WHERE id_user= :idUser";
        $sqlAlt = "UPDATE user SET login= :login,lastname= :lastname,firstname= :firstname,email= :email,birth_date= :birthdate WHERE id_user= :idUser";
        if (empty($password)) {
            if (DEBUG==True)
                Logger::log('mise à jour des infos utilisateur sans mdp : '.$sqlAlt);
            $stmt = $db->prepare($sqlAlt);
        }
        else {
            if (DEBUG==True)
                Logger::log('mise à jour des infos utilisateur : '.$sql);
            $stmt = $db->prepare($sql);
        }
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('login', $login, PDO::PARAM_STR);
        $stmt->bindParam('lastname', $lastname, PDO::PARAM_STR);
        $stmt->bindParam('firstname', $firstname, PDO::PARAM_STR);
        if (!empty($password))
            $stmt->bindParam('password', $password, PDO::PARAM_STR);
        $stmt->bindParam('email', $email, PDO::PARAM_STR);
        $stmt->bindParam('birthdate', $birthdate, PDO::PARAM_STR);
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes modifiées : '.$count);
        if($count == 0)
            return 2;
        elseif($count > 1)
            throw new MyException (ERR_UPDATE_NB_ROW);
        elseif($count == 1) {
            // on recharge les variables de sessions avec les changements
            $this->refreshUserInfos($idUser);
        }
    }

    /**
     * @bried Obtenir les informations utilisateurs
     * @param Id de l'utilisateur en cours
     * @return Tableau contenant les informations utilisateurs
     * @todo l'id en paramètre n'est pas souhaitable
     */
    public function getUserInfos($idUser) {
        Logger::log('passage dans getUserInfos '.$idUser);
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }

        // récupération des informations de l'utilisateur par rapport au login
        $sql = "SELECT firstname,lastname,login,email,birth_date as birthdate,DATE_FORMAT(birth_date,'%Y') as year,
                DATE_FORMAT(birth_date,'%m') as month,DATE_FORMAT(birth_date,'%d') as day, level.id_level as idLevel, level.name as classe
                FROM user
                JOIN member_of_level ON user.id_user = member_of_level.id_user
                JOIN level ON level.id_level = member_of_level.id_level
                WHERE user.id_user = :idUser";
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('selectionner tous de l\'utilisateur');
            Logger::log('nombre de lignes renvoyées : '.$count);
        if($count == 0){
            // le login n'existe pas
            return False;
        } elseif ($count > 1){
            throw new MyException (ERR_SELECT_NB_ROW);
        } elseif ($count == 1) {

            // récupération des responsables de l'utilisateur
            $sql_resp = "SELECT id_user,firstname,lastname
                    FROM responsible
                    JOIN user ON user.id_user = id_responsible
                    WHERE id_student = :idUser";
            $stmt_resp = $db->prepare($sql_resp);
            if ($stmt_resp === null) {
                throw new MyException ('erreur de préparation à la requête');
            }
            $stmt_resp->bindParam('idUser', $idUser, PDO::PARAM_INT);
            if ($stmt_resp->execute() === false) {
                $stmt_resp->errorInfo();
            }
            $result_resp = $stmt_resp->fetchAll();
            $count_resp = $stmt_resp->rowCount();
            if($count_resp != 0){
                // des responsables ont été trouvés ajout au tableau de résultat
                $result["responsables"]=$result_resp;
            }

            return $result;
        } else {
            return False;
        }
    }

    /**
     * @bried Rafraîchir les infos utilisateur
     * @param Id de l'utilisateur en cours
     */
    public function refreshUserInfos($idUser) {
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = 'SELECT login,lastname,firstname,admin,email,birth_date,id_profile FROM user WHERE id_user = :idUser';
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $_SESSION['login'] = $result["login"];
        $_SESSION['lastname'] = $result["lastname"];
        $_SESSION['firstname'] = $result["firstname"];
        $_SESSION["admin"] = $result["admin"];
        $_SESSION["email"] = $result["email"];
        $_SESSION["birthdate"] = $result["birth_date"];
        $_SESSION["profile"] = $result["id_profile"];
    }

    /**
     * @bried mise à jour des informations utilisateurs
     * @param login
     */
    public function approbationRules($idUser) {
        Logger::log('passage dans approbationRules');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        // récupération des informations de l'utilisateur par rapport au login
        $sql = "UPDATE user SET rules = True WHERE id_user= :idUser";
            $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam(':idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }
}
?>
