<?php
/**
 *
 * CETIAD Dijon
 *
 */

class Teacher extends Responsible
{

    public function __construct()
    {
        if (DEBUG==True)
            Logger::log('création d\'un nouveau Teacher');
    }

    /**
     * Description: retourne les id des personnes dont l'user est responsable
     * Paramètres: (int) id du responsable
     * Return: (array) les id user et le nom
     */
    public function allResponsible($id_user) {
        if (DEBUG==True)
            Logger::log('passage dans allResponsible');
        $db = MysqlConnection::getInstance();
        $sql = 'SELECT id_student,firstname,lastname FROM responsible JOIN user ON responsible.id_student = user.id_user WHERE responsible.id_responsible = :id_user';
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('id_user', $id_user, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if($count == 0)
            throw new MyException (ERR_SELECT_NB_NULL);
        return($result);
    }

    /**
     * @brief retourne la liste des personnes faisant partie d'une classe selon le niveau d'autorisation
     * @param (int) id de la classe
     * @param (int) id du profil
     * @return (array) les attributs des utilisateurs de la classe
     * @public
     */
    public function selectAllMemberLevel($id_level,$id_profile) {
        if (DEBUG==True) {
            Logger::log('passage dans selectAllMemberLevel, class Teacher.class.php');
        }
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = 'SELECT user.id_user,firstname,lastname,level.name as nameLevel,school_report.id_report,status FROM user JOIN member_of_level ON member_of_level.id_user = user.id_user JOIN level ON member_of_level.id_level = level.id_level JOIN school_report ON school_report.id_user = user.id_user WHERE user.id_profile = :id_profile AND member_of_level.id_level = :id_level order by lastname ASC';
        if (DEBUG==True)
            Logger::log('selection de toutes les personnes d\'une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('id_profile', $id_profile, PDO::PARAM_INT);
        $stmt->bindParam('id_level', $id_level, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
    }

    /**
     * @brief on va chercher les infos de l'utilisateur
     * @param (int) id du destinataire
     * @return (array) le nom et le prénom du destinataire
     * @public
     */
    public function selectOnRecipient($idRecipient)
    {
        if (DEBUG==True)
            Logger::log('passage dans selectOnRecipient');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        //$sql = 'SELECT firstname,lastname FROM user WHERE id_user= :idRecipient';
        $sql = 'SELECT firstname,lastname,id_report FROM user JOIN school_report ON user.id_user = school_report.id_user WHERE user.id_user= :idRecipient';
        if (DEBUG==True)
            Logger::log('selection des infos d\'un destinataire : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idRecipient', $idRecipient, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        if($count == 0)
            throw new MyException (ERR_SELECT_NB_NULL);
        if($count > 1)
            throw new MyException (ERR_SELECT_NB_ROW);
        else
            return $result;
    }

    /**
     * @brief retourne la liste des élèves faisant partie d'une classe avec le status de leur carnet
     * @param (int) id de la classe
     * @return (array) les attributs des éléves et le status du carnet
     * @public
     */
    public function selectAllSchoolReportSuspend($id_level) {
        if (DEBUG==True) {
            Logger::log('passage dans selectAllSchoolReportSuspend, class Teacher.class.php');
        }
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = 'SELECT user.id_user,firstname,lastname,level.name as nameLevel,school_report.id_report,status FROM user JOIN member_of_level ON member_of_level.id_user = user.id_user JOIN level ON member_of_level.id_level = level.id_level JOIN school_report ON school_report.id_user = user.id_user WHERE user.id_profile = 10 AND member_of_level.id_level = :id_level AND school_report.status = True';
        if (DEBUG==True)
            Logger::log('selection de toutes les personnes d\'une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('id_level', $id_level, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        return($result);
    }

    /**
     * @brief Méthode permettant de suspendre un carnet
     * @param L'id du carnet à mettre à jour
     * @public
     */
    public function suspend($idSchoolReport,$value) {
        Logger::log('passage dans suspend');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "UPDATE school_report SET status = :value WHERE id_report = :idSchoolReport";
        if (DEBUG==True)
            Logger::log('mise à jour du carnet : '.$sql);
        $stmt = $db->prepare($sql);
        $stmt->bindParam('idSchoolReport', $idSchoolReport, PDO::PARAM_INT);
        $stmt->bindParam('value', $value, PDO::PARAM_BOOL);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
    }

    /**
     * @bried Obtenir les informations utilisateurs
     * @param Id de l'utilisateur en cours
     * @return Tableau contenant les informations utilisateurs
     * @todo l'id en paramètre n'est pas souhaitable
     */
    public function getUserInfos($idUser) {
        Logger::log('passage dans getUserInfos '.$idUser);
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }

        // récupération des informations de l'utilisateur par rapport au login
        $sql = "SELECT firstname,lastname,login,email,birth_date as birthdate,DATE_FORMAT(birth_date,'%Y') as year,
                DATE_FORMAT(birth_date,'%m') as month,DATE_FORMAT(birth_date,'%d') as day
                FROM user
                WHERE user.id_user = :idUser";
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('selectionner tous de l\'utilisateur');
            Logger::log('nombre de lignes renvoyées : '.$count);
        if($count == 0){
            // le login n'existe pas
            return False;
        } elseif ($count > 1){
            throw new MyException (ERR_SELECT_NB_ROW);
        } elseif ($count == 1) {
            // récupération des classes gérées
            $sql_class = "SELECT level.name as classe, manager
                            FROM level
                            JOIN member_of_level ON level.id_level = member_of_level.id_level
                            WHERE id_user = :idUser";
            $stmt_class = $db->prepare($sql_class);
            if ($stmt_class === null) {
                throw new MyException ('erreur de préparation à la requête');
            }
            $stmt_class->bindParam('idUser', $idUser, PDO::PARAM_INT);
            if ($stmt_class->execute() === false) {
                $stmt_class->errorInfo();
            }
            $result_class = $stmt_class->fetchAll();
            $count_class = $stmt_class->rowCount();
            if($count_class != 0){
                // des classes ont été trouvées ajout au tableau de résultat
                $result["classes_en_charge"]=$result_class;
            } else {
                // on ajoute quand même un tableau vide
                $result["classes_en_charge"]=array();
            }


            return $result;
        } else {
            return False;
        }
    }

    /**
     * @brief retourne la liste des classes enseignées par un professeur
     * @param (int) id de la classe
     * @return (array) les attributs des classes
     * @public
     */

    static function selectAllLevelForTeacher($idUser){
		Logger::log('passage dans selectAllLevelForTeacher : Teacher.class.php');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		//$sql = "select level.id_level,level.name from level, teacher, member_of_level, user where teacher.id_user= :idUser and teacher.id_user=member_of_level.id_user and member_of_level.id_level = level.id_level and user.id_user=teacher.id_user";
		$sql = "select distinct(level.id_level),level.name, user.lastname, discipline.name, level.name from user JOIN teacher On user.id_user = teacher.id_user JOIN discipline ON teacher.id_discipline = discipline.id_discipline JOIN member_of_level ON user.id_user = member_of_level.id_user JOIN level ON member_of_level.id_level = level.id_level where user.id_user = :idUser ORDER BY id_level DESC";
		if (DEBUG==True)
            Logger::log('selection de toutes les classes enseignées par un professeur : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        //$result = array_unique($result);
        return $result;
	}

    /**$tabAllStudentsInfos = $u->selectAllStudentForTeacher();
		displayUsers($tabAllStudentsInfos);
     * @brief retourne la liste des élèves suivis par un professeur avec le status de leur carnet
     * @param (int) id de la classe
     * @return (array) les attributs des éléves et le status du carnet
     * @public
     */

    static function selectAllStudentForTeacher($idLevel){
		Logger::log('passage dans selectAllStudentForTeacher : Teacher.class.php');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "SELECT level.id_level, level.name, user.id_user, user.lastname,user.firstname,user.login FROM level, user, member_of_level WHERE level.id_level = :idLevel and member_of_level.id_user = user.id_user and level.id_level = member_of_level.id_level and user.id_profile = 10";
		//$sql = "SELECT * FROM user LEFT JOIN member_of_level ON member_of_level.id_user = user.id_user WHERE id_profile = 10 AND (member_of_level.id_level is NULL OR member_of_level.id_level = :idLevel) ORDER BY lastname";
		if (DEBUG==True)
            Logger::log('selection de tous les élèves dans une classe : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idLevel', $idLevel, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $result;
	}


	/**
     * @brief Sélectionner un utilisateur.
     * @return un tableau contenant toutes les informations sur un professeur
     * @public
     */
    static function selectOneUserForTeacher($idUser){
        Logger::log('passage dans selectOneUserForTeacher : Teacher.class.php');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        //$sql = "SELECT * FROM user ORDER BY lastname";
        $sql = "SELECT id_user,lastname,firstname,login,email,birth_date,password,enabled,user.id_profile as profile,admin,profile.grade FROM user JOIN profile ON profile.id_profile=user.id_profile WHERE user.id_user = :idUser";
        if (DEBUG==True)
            Logger::log('selection d\'un utilisateur : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
    }

     /**
     * @brief Sélectionner un élève.
     * @return un tableau contenant tous les élèves
     * @public
     */
    function selectOneStudent($idUser){
        Logger::log('passage dans selectOneStudent : Teacher.class.php');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
        $sql = "SELECT user.id_user, user.lastname, user.firstname, user.login,user.email,user.birth_date,user.password,user.enabled,user.id_profile ,level.id_level,name FROM user JOIN member_of_level ON member_of_level.id_user=user.id_user JOIN level ON level.id_level=member_of_level.id_level WHERE user.id_user = :idUser";
        if (DEBUG==True)
            Logger::log('selection d\'un utilisateur : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG == True)
            Logger::log('nombre de ligne renvoyées : '.$count);
        return($result);
    }


	/**
     * @brief méthode renvoyant un tableau contenant les la ou les disciplines d'un professeur
     * @param l'id du professeur
     * @return retourne un tableau contenant les différentes infos de la discipline sélectionnée
     */
	static function selectAllDisciplineForTeacher($idUser)
	{
        Logger::log('passage dans selectAllDisciplineForTeacher');
        $db = Connection::getInstance();
        if(!$db) {
            throw new MyException (ERR_CONNECT_DB);
        }
		$sql = "SELECT discipline.id_discipline, discipline.name FROM user LEFT JOIN teacher ON teacher.id_user = user.id_user LEFT JOIN discipline ON teacher.id_discipline = discipline.id_discipline where user.id_user = :idUser ORDER BY id_discipline DESC";
		if (DEBUG==True)
            Logger::log('selection des disciplines : '.$sql);
        $stmt = $db->prepare($sql);
        if ($stmt === null) {
            throw new MyException ('erreur de préparation à la requête');
        }
        $stmt->bindParam('idUser', $idUser, PDO::PARAM_INT);
        if ($stmt->execute() === false) {
            $stmt->errorInfo();
        }
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $count = $stmt->rowCount();
        if (DEBUG==True)
            Logger::log('nombre de lignes renvoyées : '.$count);
		if($count == 0)
			throw new MyException (ERR_SELECT_NB_NULL);
        return $result;
	}

}
?>
