<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file index.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Bootstrap de l'application
 */
// installation
if(!file_exists("config.php")) {
    header("Location: ./install/index.php");
    exit;
}
include("cdc.config.php");
include("config.php");
include("constant.php");
include_once("function.php");
function __autoload($classname) {
    include_once("includes/" . $classname . ".class.php");
}
// redefinir la gestion des logs
$modeLog = redefineLog();
// internationnalisation
include_once("./lang/".LANG."/main.php");

session_start();
// AUTH CAS
if ((!isset($_SESSION['id_user']))&&(AUTH == 'cas')) {
    if (DEBUG==True)
        Logger::log('passage dans connexion AUTH CAS');
    $session = New Authentification();
    $session->validUserCas();
    echo '<script language="javascript" type="text/javascript">', chr(10);
    echo '<!--', chr(10);
    echo 'window.location.replace("'.$page.'")', chr(10);
    echo '-->', chr(10);
    echo '</script>';
    exit;
}
$info = "";
// defaut de configuration du serveur
header('Content-Type: text/html; charset=utf-8');
echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">', chr(10);
echo '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr" lang="fr">', chr(10);
echo '<head>', chr(10);
echo '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />', chr(10);
echo '<link type="image/x-icon" href="./images/favicon.ico" rel="icon" />', chr(10);
echo '<link type="image/x-icon" href="./images/favicon.ico" rel="shortcut icon" />', chr(10);
// choix de la CSS
if (isset($theme)) {
    echo '<link rel="stylesheet" type="text/css" href="./themes/'.$theme.'/css/theme.css" />', chr(10);
}
else {
    echo '<link rel="stylesheet" type="text/css" href="./themes/default/css/theme.css" />', chr(10);
}
// css pour les tableaux
echo '<link rel="stylesheet" type="text/css" href="./css/demo_table_jui.css" />', chr(10);
echo '<link rel="stylesheet" type="text/css" href="./css/jquery-ui-1.8.4.custom.css" />', chr(10);

echo '<title>'.$title.'</title>',chr(10);
// chargement des librairies si l'utilisateur est authentifié
if ((isset($_SESSION['id_user']))) {
    echo '<script type="text/javascript" src="./js/lib/jquery-1.6.4.min.js"></script>',chr(10);
    echo '<script type="text/javascript" src="./js/lib/jquery-ui-1.8.16.custom.min.js"></script>',chr(10);
    echo '<script type="text/javascript" src="./js/lib/jquery.validate.js"></script>',chr(10);
    echo '<script type="text/javascript" src="./js/lib/jquery.crypt.js"></script>',chr(10);
    echo '<script type="text/javascript" src="./js/cdc.form.js"></script>',chr(10);
    echo '<script type="text/javascript" src="./js/cdc.function.js"></script>',chr(10);
    // chargement de tinymce que si nécessaire
    if((isset($_GET['content']))&&(($_GET['content']=='addmessage')||(($_GET['content']=='rules')&&($_SESSION['admin'])))) {
        echo '<script type="text/javascript" src="./js/tiny_mce/jquery.tinymce.js"></script>',chr(10);
    }
}

// Inclusion de la sonde piwik envole
include "/var/www/html/piwik/envoleProfil.php";
?>
<script src="/piwik/envoleTrackeur.js.php?appli=cdc&amp;profil=<?php print $profil ?>"></script>
<?php

echo '</head>',chr(10);
echo '<body>',chr(10);
echo '<div>',chr(10);

// affichage de l'avertissement si le log est activé
echo $modeLog, chr(10);
// bandeau bêta version
echo '<img class="icone" src="./images/icons/dialog-warning.png" alt="Attention" /> Version Bêta de test et de démonstration!!! <br />',chr(10);
echo '</div>',chr(10);

// affichage du header si l'utilisateur est authentifié
if (isset($_SESSION['id_user'])) {
    if (HEADER == True) {
        echo '<div id="header">',chr(10);
        echo '<div id="leftBloc">',chr(10);
        echo '</div><!-- fermeture du leftBloc -->',chr(10);
        echo '<div id="rightBloc">',chr(10);
        echo '<img alt="logo du theme" src="themes/'.$theme.'/images/logo.png" />',chr(10);
        echo '<br /><h1>'.$title.'</h1>';
        echo '</div><!-- fermeture du rightBloc -->',chr(10);
        echo '</div><!-- fermeture du header -->',chr(10);
    }
}

// @fixme le http_referer n'ai plus utilisé, à voir si besoin pour rediriger en cas de perte de session, pouvoir revenir sur la page ou l'on était
//if (isset($_SERVER['HTTP_REFERER'])) {
//    Logger::log($_SERVER['HTTP_REFERER']);
//}

try {
    // l'utilisateur n'est pas authentifié
    if ((!isset($_SESSION['id_user']))&&(AUTH == 'sql')) {
        $session = New Authentification();
        include("connection.php");
    }
    // l'utilisateur est authentifié instanciation d'un utilisateur
    else {
        if ($_SESSION['admin'] == True) {
            $u = New Admin();
        }
        elseif ($_SESSION['profile'] >= 40)
            $u = New Manager();
        elseif ($_SESSION['profile'] >= 30)
            $u = New Teacher();
        elseif ($_SESSION['profile'] >= 20)
            $u = New Responsible();
        elseif ($_SESSION['profile'] >= 10) {
            // si l'élève est majeur
            if(adultStudent($_SESSION['birthdate'])) {
                if (DEBUG==True)
                    Logger::log('élève majeur');
                $u = New Responsible();
                $_SESSION['profile'] = 20;
                $_SESSION['adultStudent'] = True;
                // @todo ajout d'un message ? humour ou explicatif
            }
            else
                $u = New Student();
        }
        else
            $u = New User();
        /**
         * Affichage de la board trois colonnes : leftcolum(whoami), middlecolumn(), rigthcolumn()
         */
        echo '<div id="board">', chr(10);
        echo '<div id="leftcolumn">', chr(10);
        // affichage des paramètres de connection
        echo '<p>'.$GLOBALS['index']['connected'].$_SESSION['firstname'].' '.$_SESSION['lastname'].'</p>';
        echo '</div><!-- fin leftcolumn -->', chr(10);
        /**
         * Colonne du milieu
         */
        if ($_SESSION['profile'] == 20) {
            echo '<div id="middlecolumn">', chr(10);
            // on récupère la liste des personnes qui sont sous sa responsabilité
            $allUnderCare = $u->allUnderCare($_SESSION['id_user']);
            // on récupère la liste des personnes appartenant à une classe qui sont sous sa responsabilité
            $allUnderCareInLevel = $u->allUnderCareInLevel($_SESSION['id_user']);
            // on récupère la liste des personnes appartenant pas à une classe qui sont sous sa responsabilité
            $allUnderCareNoLevel = $u->allUnderCareNoLevel($_SESSION['id_user']);
            // si l'utilisateur à plusieurs élèves sous sa responsabilité on affiche un select option
            if (sizeof($allUnderCare) > 1) {
                // on fixe l'id du carnet a la première valeur par défaut si aucun n'est sélectionné
                if (isset($_POST['selectIdUser'])) {
                    //Suppression des infos du précédent élève
                    unset($_SESSION['infoSchoolReport']);
                    unset($_SESSION['schoolReportFirstname']);
                    unset($_SESSION['schoolReportLastname']);
                    unset($_SESSION['selectIdStudent']);
                    foreach($allUnderCareInLevel as $id => $value) {
                        if ($_POST['selectIdUser'] == $allUnderCareInLevel[$id]['id_student']){
                            $schoolReport = New SchoolReport($_POST['selectIdUser']);
                            $_SESSION['idSchoolReport'] = $schoolReport->getIdSchoolReport();
                            $_SESSION['infoSchoolReport'] = 1;
                            // obtenir le statut du carnet en cours
                            $status = $schoolReport->getStatus($_SESSION['idSchoolReport']);
                            $_SESSION['status'] = $status[0]['status'];
                            $_SESSION['schoolReportFirstname'] = $allUnderCareInLevel[$id]['firstname'];
                            $_SESSION['schoolReportLastname'] = $allUnderCareInLevel[$id]['lastname'];
                            $_SESSION['selectIdStudent'] =  $_POST['selectIdUser'];
                            break;
                        }
                        else {
                            foreach($allUnderCareNoLevel as $id => $value) {
                                if ($_POST['selectIdUser'] == $allUnderCareNoLevel[$id]['id_student']){
                                    $_SESSION['infoSchoolReport'] == '';
                                    $_SESSION['schoolReportFirstname'] = $allUnderCareNoLevel[$id]['firstname'];
                                    $_SESSION['schoolReportLastname'] = $allUnderCareNoLevel[$id]['lastname'];
                                    $_SESSION['selectIdStudent'] =  $_POST['selectIdUser'];
                                    break;
                                }
                            }
                        }

                    }
                }
                else {
                    if($_SESSION['schoolReportFirstname'] == '') {
                        $schoolReport = New SchoolReport($allUnderCare[0]['id_student']);
                        $_SESSION['idSchoolReport'] = $schoolReport->getIdSchoolReport();
                        foreach($allUnderCareInLevel as $id => $value){
                            if ($allUnderCare[0]['id_student'] == $allUnderCareInLevel[$id]['id_student']){
                                $_SESSION['infoSchoolReport'] = 1;
                            }
                            else {
                                $_SESSION['infoSchoolReport'] == '';
                            }
                        }
                        // obtenir le statut du carnet en cours
                        $status = $schoolReport->getStatus($_SESSION['idSchoolReport']);
                        $_SESSION['status'] = $status[0]['status'];
                        $_SESSION['schoolReportFirstname'] = $allUnderCare[0]['firstname'];
                        $_SESSION['schoolReportLastname'] = $allUnderCare[0]['lastname'];
                        $_SESSION['selectIdStudent'] =  $allUnderCare[0]['id_student'];
                    }
                    else {
                        $schoolReport = New SchoolReport($_SESSION['selectIdStudent']);
                        $_SESSION['idSchoolReport'] = $schoolReport->getIdSchoolReport();
                        $_SESSION['infoSchoolReport'] = 1;
                        // obtenir le statut du carnet en cours
                        $status = $schoolReport->getStatus($_SESSION['idSchoolReport']);
                        $_SESSION['status'] = $status[0]['status'];
                        //$_SESSION['schoolReportFirstname'] ne change pas
                        //$_SESSION['schoolReportLastname']  ne change pas
                        //$_SESSION['selectIdStudent']  ne change pas
                    }
                }
                echo '<form action="'.htmlentities($_SERVER['PHP_SELF']).'" method="post" name="selectIdUser">', chr(10);
                echo '<p>Carnet de : </p>', chr(10);
                echo '<select name="selectIdUser">', chr(10);
                foreach ($allUnderCare as $id => $value) {
                    echo '<option value="'.$allUnderCare[$id]['id_student'].'" ';
                    if (isset($_POST['selectIdUser'])) {
                        if ($_POST['selectIdUser'] == $allUnderCare[$id]['id_student'])
                            echo 'selected="selected"';
                    }
                    elseif (isset($_SESSION['selectIdStudent'])) {
                        if ($_SESSION['selectIdStudent'] == $allUnderCare[$id]['id_student'])
                            echo 'selected="selected"';
                    }
                    echo '>'.$allUnderCare[$id]['firstname'].' '.$allUnderCare[$id]['lastname'].'</option>', chr(10);
                }
                echo '</select>', chr(10);
                echo '</form>', chr(10);
                //affichage des mots non validés du carnet
				echo '<div id="rightcolumn"><p><a href="index.php?view=notvalidate">', chr(10);
				$unCheck = $schoolReport->getCountUncheck($_SESSION['idSchoolReport']);
				if ($unCheck == 0)
					echo '<img class="icone" src="./images/icons/help-about.png"> aucun ';
				else
					echo '<img class="icone" src="./images/icons/mail-mark-important.png" alt="mot non validé" /> '.$unCheck.' ';
				echo ' mot';
				if ($unCheck > 1)
					echo 's';
				echo ' à faire valider dans votre carnet';
				echo '</a></p></div><!-- fin rightcolumn -->', chr(10);
            }
            // si l'utilisateur a une personne sous sa responsabilité
            elseif(sizeof($allUnderCare) == 1) {
                // création d'un carnet
                $schoolReport = New SchoolReport($allUnderCare[0]['id_student']);
                // on fixe l'id du carnet a la première valeur par défaut si aucun n'est sélectionné
                $_SESSION['idSchoolReport'] = $schoolReport->getIdSchoolReport();
                foreach($allUnderCareInLevel as $id => $value){
                    if ($allUnderCare[0]['id_student'] == $allUnderCareInLevel[$id]['id_student']){
                        $_SESSION['infoSchoolReport'] = 1;
                    }else {
                        $_SESSION['infoSchoolReport'] == '';
                    }
                }
                // obtenir le statut du carnet en cours
                $status = $schoolReport->getStatus($_SESSION['idSchoolReport']);
                $_SESSION['status'] = $status[0]['status'];
                $_SESSION['schoolReportFirstname'] = $allUnderCare[0]['firstname'];
                $_SESSION['schoolReportLastname'] = $allUnderCare[0]['lastname'];
                //echo '<p>Carnet de : '.$allUnderCare[0]['firstname'].' '.$allUnderCare[0]['lastname'].'</p>', chr(10);
                //affichage des mots non validés du carnet ouvert
				echo '<div id="rightcolumn"><p><a href="index.php?view=notvalidate">', chr(10);
				$unCheck = $schoolReport->getCountUncheck($_SESSION['idSchoolReport']);
				if ($unCheck == 0)
					echo '<img class="icone" src="./images/icons/help-about.png"> aucun ';
				else
					echo '<img class="icone" src="./images/icons/mail-mark-important.png" alt="mot non validé" /> '.$unCheck.' ';
				echo ' mot';
				if ($unCheck > 1)
					echo 's';
				echo ' à faire valider dans votre carnet';
				echo '</a></p></div><!-- fin rightcolumn -->', chr(10);
            }
            // si l'utilisateur est un élève majeur
            elseif($_SESSION['adultStudent'] == True) {
                // création d'un carnet
                $schoolReport = New SchoolReport($_SESSION['id_user']);
                // on fixe l'id du carnet
                $_SESSION['idSchoolReport'] = $schoolReport->getIdSchoolReport();
                // obtenir le statut du carnet en cours
                $status = $schoolReport->getStatus($_SESSION['idSchoolReport']);
                //  @fixme dans propriété de l'objet
                $_SESSION['status'] = $status[0]['status'];
                //affichage des mots non validés du carnet
				echo '<div id="rightcolumn"><p><a href="index.php?view=notvalidate">', chr(10);
				$unCheck = $schoolReport->getCountUncheck($_SESSION['idSchoolReport']);
				if ($unCheck == 0)
					echo '<img class="icone" src="./images/icons/help-about.png"> aucun ';
				else
					echo '<img class="icone" src="./images/icons/mail-mark-important.png" alt="mot non validé" /> '.$unCheck.' ';
				echo ' mot';
				if ($unCheck > 1)
					echo 's';
				echo ' à faire valider dans votre carnet';
				echo '</a></p></div><!-- fin rightcolumn -->', chr(10);

			}
			echo '</div><!-- fin middlecolumn -->', chr(10);
        }
        /**
         * Colonne de droite
         */
        // si elève alors affichage des mots non validés du carnet
        if ($_SESSION['profile'] == 10) {
            echo '<div id="rightcolumn"><p><a href="index.php?view=notvalidate">', chr(10);
            $schoolReport = New SchoolReport($_SESSION['id_user']);
            $_SESSION['idSchoolReport'] = $schoolReport->getIdSchoolReport();
            // obtenir le statut du carnet en cours
            $status = $schoolReport->getStatus($_SESSION['idSchoolReport']);
            $_SESSION['status'] = $status[0]['status'];
            $unCheck = $schoolReport->getCountUncheck($_SESSION['idSchoolReport']);
            if ($unCheck == 0)
                echo '<img class="icone" src="./images/icons/help-about.png"> aucun ';
            else
                echo '<img class="icone" src="./images/icons/mail-mark-important.png" alt="mot non validé" /> '.$unCheck.' ';
            echo ' mot';
            if ($unCheck > 1)
                echo 's';
            echo ' à faire valider dans votre carnet';
            echo '</a></p></div><!-- fin rightcolumn -->', chr(10);
        }
        // sinon si responsable ?

        echo '</div><!-- fin de board -->', chr(10);


        /**
         * Affichage de la page : menu et content
         */
        echo '<div id="page">', chr(10);
        echo '<div id="menu">', chr(10);
        if ($_SESSION['admin']) {
            echo '<a href="index.php?content=dashboard"><img class="icone" src="./images/icons/rating.png" alt="étoile" />'.$GLOBALS['menu']['menuDashboard'].'</a><br />', chr(10);
        }else
            echo '<a href="index.php"><img class="icone" src="./images/icons/go-home.png" alt="maison" />'.$GLOBALS['menu']['menuMainPage'].'</a><br />', chr(10);
        echo '<a href="index.php?content=rules"><img class="icone" src="./images/icons/mail-signed.png" alt="règlement" />'.$GLOBALS['menu']['menuRules'].'</a><br />', chr(10);
        // droits enseignant
        if ($_SESSION['profile'] >= 30) {
            echo '<a href="index.php"><img class="icone" src="./images/icons/school-report.png" alt="carnet" /> Mots à votre attention</a><br />', chr(10);
            echo '<a href="index.php?content=sentMessages"><img class="icone" src="./images/icons/school-report.png" alt="carnet" /> Mots émis</a><br />', chr(10);
        }
        if ($_SESSION['profile'] == 10) {
            echo '<a href="index.php"><img class="icone" src="./images/icons/school-report.png" alt="carnet" />'.$GLOBALS['menu']['menuSchoolReport'].'</a><br />', chr(10);
        }
        // droits responsable
        if ((($_SESSION['profile'] == 20)&&(sizeof($allUnderCare) >= 1))&&(($_SESSION['status'] == False)||(SUSPEND==False))) {
            if (sizeof($allUnderCare) > 1) {
                echo '<a href="index.php?content=addmessage"><img class="icone" src="./images/icons/accessories-text-editor.png" alt="nouveau message" />'.$GLOBALS['menu']['menuAddMessageToSchoolReport'].$_SESSION['schoolReportFirstname'].'</a><br />', chr(10);
            } else
                echo '<a href="index.php?content=addmessage"><img class="icone" src="./images/icons/accessories-text-editor.png" alt="nouveau message" />'.$GLOBALS['menu']['menuAddMessageToSchoolReport'].$_SESSION['schoolReportFirstname'].'</a><br />', chr(10);
        }
        // droits élève majeur
        if((isset($_SESSION['adultStudent']))&&($_SESSION['adultStudent'] == True)&&(($_SESSION['status'] == False)||(SUSPEND==False))) {
            echo '<a href="index.php?content=addmessage"><img class="icone" src="./images/icons/accessories-text-editor.png" alt="nouveau message" /> Ajouter un mot dans votre carnet</a><br />', chr(10);
        }
        // droits enseignant
        elseif ($_SESSION['profile'] > 20) {
            echo '<a href="index.php?content=addmessage"><img class="icone" src="./images/icons/accessories-text-editor.png" alt="nouveau message" /> Ajouter un mot dans un carnet</a><br />', chr(10);
            echo '<a href="index.php?content=addmessage&level"><img class="icone" src="./images/icons/accessories-text-editor.png" alt="nouveau message" /> Ajouter un mot à une classe</a><br />', chr(10);
            echo '<a href="index.php?content=viewSchoolReport"><img class="icone" src="./images/icons/school-report.png" alt="carnet" />'.$GLOBALS['menu']['menuStudentSchoolReport'].'</a><br />', chr(10);
        }
        // droits enseignant
        if (($_SESSION['profile'] >= 30)&&(SUSPEND == True)) {
            echo '<a href="index.php?content=suspend"><img class="icone" src="./images/icons/preferences-desktop-user-password.png" alt="utilisateur cadenas" /> Suspendre un carnet</a><br />', chr(10);
        }
        // droits admin
        //if ($_SESSION['admin']) {
        //    echo '<a href="index.php?content=manageUser"><img class="icone" src="./images/icons/system-users.png" alt="utilisateurs" /> Gérer les utilisateurs</a><br />', chr(10);
        //}
        echo '<a href="index.php?content=count"><img class="icone" src="./images/icons/preferences-desktop-user.png" alt="utilisateur propriétés" /> Détail de votre compte</a><br />', chr(10);
        echo '<a href="logout.php"><img class="icone" src="./images/icons/system-shutdown.png" alt="déconnexion" /> Déconnexion</a><br />', chr(10);
        echo '</div><!-- fermeture du menu -->', chr(10);

        // bloc d'information pour les actions utilisateurs
        echo '<div id="infoboard">', chr(10);
        echo '</div><!-- fin infoboard -->', chr(10);

        echo '<div id="content">', chr(10);
        // validation du règlement
        if ((($_SESSION['profile'] == 10)||($_SESSION['profile'] == 20))&&($_SESSION['rules'] == False)) {
            // si le règlement est en cours de validation avant rechargement de la page
            if ((!isset($_GET['action']))||($_GET['action'] != "approbation")) {
                echo '<span class="alert">Vous devez lire et approuver le <a href="index.php?content=rules">règlement intérieur</a></span>', chr(10);
            }
        }
        // page demandée
        if((isset($_GET['content']))&&($_GET['content']=='count')){
            include('count.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='deluser')&&($_SESSION['admin'])) {
            include('delUser.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='manageUser')&&($_SESSION['admin'])) {
            include('manageUser.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='manageLevel')&&($_SESSION['admin'])) {
            include('manageLevel.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='manageMembership')&&($_SESSION['admin'])) {
            include('manageMembership.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='manageRules')&&($_SESSION['admin'])) {
            include('manageRules.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='suspend')&&($_SESSION['profile'] >= 30)) {
            include('manageSuspend.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='bug')&&($_SESSION['admin'])) {
            include('bugReport.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='stats')&&($_SESSION['admin'])) {
            include('stats.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='config')&&($_SESSION['admin'])) {
            include('config.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='addmessage')) {
            include('addMessage.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='rules')) {
            include('rules.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='importLdap')&&($_SESSION['admin'])) {
            include('importLdap.content.php');
        }
        elseif ((isset($_GET['content']))&&($_GET['content']=='dashboard')&&($_SESSION['admin']==True)) {
            include('dashboard.content.php');
        }
        elseif ((isset($_GET['content']))&&($_GET['content']=='credits')&&($_SESSION['admin']==True)) {
            include('credits.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='viewSchoolReport')&&($_SESSION['profile'] >= 30)) {
            include('viewSchoolReport.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='manageAffiliate')&&($_SESSION['profile'] >= 30)) {
            include('manageAffiliate.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='listResponsible')&&($_SESSION['profile'] >= 30)) {
            include('listResponsible.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='listStudent')&&($_SESSION['profile'] >= 30)) {
            include('listStudent.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='manageDiscipline')&&($_SESSION['profile'] >= 30)) {
            include('manageDiscipline.content.php');
        }
        elseif((isset($_GET['content']))&&($_GET['content']=='newSchoolYear')&&($_SESSION['profile'] >= 30)) {
            include('newSchoolYear.content.php');
        }
        // sinon page d'accueil
        else {
            // page d'accueil pour un enseignant
            if ($_SESSION['profile'] >= 30)
                include('box.content.php');
            elseif ($_SESSION['admin'])
                include('dashboard.content.php');
            // la page d'accueil est le carnet pour un utilisateur (élève ou responsable)
            // si idSchoolReport est définit on affiche son carnet
            elseif (isset($_SESSION['idSchoolReport'])) {
                if (sizeof($allUnderCare) > 1) {
                    // on affiche le carnet si le responsable a plusieurs élèves sous sa responsabilité
                    include('moreSchoolReport.content.php');
                }
                else {
                    // on affiche le carnet si le responsable à un seul élève
                    include('schoolReport.content.php');
                }
            }
            // pas de page d'accueil si responsable de personne
            elseif(($_SESSION['profile'] == 20)&&(sizeof($allUnderCare) == 0)) {
                echo '<h2>Bienvenue ' .$_SESSION['firstname'].' '.$_SESSION['lastname'].'</h2>';
                echo '<div id="empty"><p>Vous êtes vu comme un responsable d\'élève mais vous n\'avez pas d\'élève sous votre responsabilité !</p>',chr(10);
                echo '<p>Veuillez contacter l\'administrateur de CDC !</p></div>',chr(10);
            }
        }
        echo '</div><!-- fermeture de content -->', chr(10);
        echo '<div id="clear"></div>', chr(10);
    }
}
catch (MyException $myException) {
    echo $myException->showError();
}

/**
 * Affichage du bottom contenant aussi l'affichage du Debug
 */

// l'utilisateur n'est pas authentifié
if (!isset($_SESSION['id_user'])) {
    echo '<div id="loginBottom">', chr(10);
}
// l'utilisateur est authentifié
else {
    echo '</div><!-- fermeture de page-->', chr(10);
    echo '<div id="bottom">', chr(10);
}
echo '<img src="images/button-php.png" alt="pub php" /> <a href="http://validator.w3.org/check?uri=referer"><img src="images/button-xhtml.png" alt="pub php" /></a> <a href="http://jigsaw.w3.org/css-validator/check/referer"><img src="images/button-css.png" alt="pub css" /></a><br />', chr(10);
echo '<a href="http://dev-eole.ac-dijon.fr/projects/cdc/">CDC</a> ver : ';
include("VERSION.txt");
echo '<br />', chr(10);
echo 'Logiciel libre distribué sous <a href="http://fr.wikipedia.org/wiki/Licence_publique_g%C3%A9n%C3%A9rale_GNU">licence GNU GPL</a>', chr(10);
echo '</div><!-- fermeture de bottom-->', chr(10);
// si debug = true alors on log les variables de session
if (DEBUG == True) {
    if (DEBUG_DISPLAY == True) {
        echo '<div id="log">', chr(10);
        Logger::getLog();
        echo '<span class="bold">contenu des variables de SESSION :</span><br />';
        foreach ($_SESSION as $id => $value) {
            echo '$_SESSION[\''.$id.'\'] = '.$value.'<br />';
        }
        echo '<span class="bold">contenu des variables de POST :</span><br />';
        foreach ($_POST as $id => $value) {
            echo '$_POST[\''.$id.'\'] = '.$value.'<br />';
        }
        echo '<span class="bold">contenu des variables de GET :</span><br />';
        foreach ($_GET as $id => $value) {
            echo '$_GET[\''.$id.'\'] = '.$value.'<br />', chr(10);
        }
        echo '</div><!-- fermeture de log-->', chr(10);
    }
    if (DEBUG_LOG == True) {
        Logger::log('contenu des variables de SESSION :');
        foreach ($_SESSION as $id => $value) {
            Logger::log('$_SESSION[\''.$id.'\'] = '.$value);
        }
        Logger::log('contenu des variables de POST :');
        foreach ($_POST as $id => $value) {
            Logger::log('$_POST[\''.$id.'\'] = '.$value);
        }
    }
}
echo '</body>', chr(10);
echo '</html>', chr(10);
?>
