$(document).ready(function(){
        if ($("textarea[id='editRules']").length == 1) {
            // tinyMCE pour le règlement
            $("textarea[id='editRules']").tinymce({
                    // Location of TinyMCE script
                    script_url : './js/tiny_mce/tiny_mce.js',
                    // General options
                    mode : "textareas",
                    language : "fr",
                    theme : "advanced",
                    plugins : "autoresize,pagebreak,style,table,save,advhr,advimage,advlink,iespell,inlinepopups,media,searchreplace,print,contextmenu,paste,directionality,noneditable,visualchars,nonbreaking,xhtmlxtras",

                    // Theme options
                    theme_advanced_buttons1 : "save,print,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,sub,sup,|,formatselect,fontselect,fontsizeselect,|,forecolor,backcolor",
                    theme_advanced_buttons2 : "cut,copy,paste,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,code,visualchars,hr",
                    theme_advanced_buttons3 : "tablecontrols",
                    theme_advanced_toolbar_location : "top",
                    theme_advanced_toolbar_align : "left",
                    theme_advanced_statusbar_location : "bottom",
                    theme_advanced_resizing : true,

                    // Example content CSS (should be your site CSS)
                    //content_css : "themes/default/css/theme.css",
                    content_css : "./css/tinyMCE.css",

                    // Drop lists for link/image/media/template dialogs
                    template_external_list_url : "js/template_list.js",
                    external_link_list_url : "js/link_list.js",
                    external_image_list_url : "js/image_list.js",
                    media_external_list_url : "js/media_list.js",
                });
        }

        if ($("textarea[class='addMessage']").length == 1) {
            // tinyMCE pour l'ajout de message
            $("textarea[class='addMessage']").tinymce({
                    // Location of TinyMCE script
                    script_url : './js/tiny_mce/tiny_mce.js',
                    // General options
                    mode : "textareas",
                    language : "fr",
                    theme : "advanced",
                    plugins : "autoresize,style,advimage,iespell,preview",

                    // Theme options
                    theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,justifyfull,|,formatselect,|,forecolor,backcolor,|,bullist,numlist,|,outdent,indent,|,undo,redo",
                    theme_advanced_buttons2 : "",
                    theme_advanced_buttons3 : "",
                    theme_advanced_toolbar_location : "top",
                    theme_advanced_toolbar_align : "left",
                    theme_advanced_statusbar_location : "bottom",
                    theme_advanced_resizing : true,

                    // Example content CSS (should be your site CSS)
                    //content_css : "themes/default/css/theme.css",
                    content_css : "./css/tinyMCE.css",

                    // Drop lists for link/image/media/template dialogs
                    external_image_list_url : "js/image_list.js",

                    // limitation du nombre de caractères dans un message
                    setup : function(ed)
                    {
                        var mCh=800; // max characters

                        ed.onKeyUp.add(function(ed,e)
                            {
                                var sH=tinyMCE.activeEditor.getContent();
                                var sW = (sH.replace(/(<([^>]+)>)/ig,""));
                                if (sW.length>mCh) {
                                    //alert("Il ne vous reste plus beaucoup de caractère");
                                    //tinyMCE.activeEditor.setContent("attention !");
                                    $("#message_tip_maxcar").attr("class","surlignage");
                                    $("#seeAddMessage").prop('disabled', true);
                                    //$("iframe")[0].contents().find('.mceContentBody').css('background-color','red');
                                    //$(".mceContentBody").css('background-color','red');
                                }
                                else if ($("#message_tip_maxcar").attr("class")=="surlignage"){
                                    $("#message_tip_maxcar").attr("class","");
                                    $("#seeAddMessage").prop('disabled', false);
                                }

                            });
                        }
                    });
            }

            /* formulaire ajout d'un utilisateur */
            function selected() {
                var str = "";
                $("select[name='id_profile'] option:selected").each(function () {
                        str += $(this).text();
                    });
                $(".masque").hide();
                if (str == "Élève") {
                    $("p[name='student']").show("slow");
                    $("span[name='student']").show();
                }
                /*
                 if (str == "Enseignant") {
                 $("p[name='teacher']").show("slow");
                 $("span[name='teacher']").show();
             }
             else if (str == "Élève") {
             $("p[name='student']").show("slow");
             $("span[name='student']").show();
         }
         else if (str == "Responsable") {
         $("p[name='responsible']").show("slow");
         $("span[name='responsible']").show("slow");
     }*/
            }

            /* poste automatiquement le choix du carnet */
            $('select[name="selectIdUser"]').change(function() {
                    $('form[name="selectIdUser"]').submit();
                });

            /* poste automatiquement le choix de la classe */
            $('select[name="selectIdLevel"]').change(function() {
                    $('form[name="selectLevel"]').submit();
                });

            /* poste automatiquement du choix de la classe */
            $('select[name="selectedIdLevelTeacher"]').change(function() {
                    $('form[name="selectLevelTeacher"]').submit();
                });


            /* message lors d'une action utilisateur */

			/* vérification de la sélection de checkbox du formulaire des Gestion des utilisateurs avant submit*/
			$('#displayUsers').submit(function() {
				if ($('input:checkbox', this).is(':checked')) {
					// Action
					var action = $(this).parent().find('select[name="doAction"]').val();
                    var msg = "";
                    if (action == 1) {
                        msg = 'Voulez-vous vraiment activer le ou les comptes utilisateurs sélectionné(s) ?';
                    }
                    else if (action == 2) {
                        msg = 'Voulez-vous vraiment désactiver le ou les comptes utilisateurs sélectionné(s) ?';
                    }
                    else if (action == 3) {
                        msg = 'Voulez-vous vraiment supprimer le ou les comptes utilisateurs sélectionné(s) ?';
                    }
                    return window.confirm(this.title || msg);
				} else {
					alert('Veuillez sélectionner au minimum un utilisateur !');
					return false;
				}
			});



            /* message lors d'une action carnet */
            /* vérification de la sélection de checkbox du formulaire sur Suspendre un carnet avant submit */
				$('#displaySuspendStudents').submit(function() {
					if ($('input:checkbox', this).is(':checked')) {
						// si checkbox coché
						var action = $(this).parent().find('select[name="doSuspend"]').val();
						var msg = "";
						if (action == 1) {
							msg = 'Voulez-vous vraiment suspendre le ou les carnet(s) sélectionné(s) ?';
						}
						else if (action == 2) {
							msg = 'Voulez-vous vraiment rendre le ou les carnet(s) sélectionné(s) ?';
						}
						return window.confirm(this.title || msg);

					} else {
						alert('Veuillez sélectionner au minimum un élève !');
						return false;
					}
			});

			/* message lors d'une action classe */
			$('#displayLevel').submit(function() {
					if ($('input:checkbox', this).is(':checked')) {
						var action = $(this).parent().find('select[name="doActionLevel"]').val();
						var msg = "";
						if (action == 1) {
							msg = 'Voulez-vous vraiment supprimer la ou les classe(s) sélectionnée(s) ?';
						}
						return window.confirm(this.title || msg);
					} else {
						alert('Veuillez sélectionner au minimum une classe !');
						return false;
					}
			});

			/* message lors d'une action discipline */
			$('#displayDisciplines').submit(function() {
					if ($('input:checkbox', this).is(':checked')) {
						 var action = $(this).parent().find('select[name="doActionDiscipline"]').val();
						var msg = "";
						if (action == 1) {
							msg = 'Voulez-vous vraiment supprimer la ou les discipline(s) sélectionnée(s) ?';
						}
						return window.confirm(this.title || msg);
					} else {
						alert('Veuillez sélectionner au minimum une discipline !');
						return false;
					}
			});

			/* vérification de la sélection de checkbox du formulaire sur Gestion des disciplines avant submit pour action sur les professeurs */
			$('#displayTeacher').submit(function() {
				if ($('input:checkbox', this).is(':checked')) {
					// Action
					var action = $(this).parent().find('select[name="doActionTeacherInDiscipline"]').val();
                    var msg = "";
                    if (action == 1) {
                        msg = 'Voulez-vous vraiment activer le ou les comptes utilisateurs sélectionné(s) ?';
                    }
                    else if (action == 2) {
                        msg = 'Voulez-vous vraiment désactiver le ou les comptes utilisateurs sélectionné(s) ?';
                    }
                    else if (action == 3) {
                        msg = 'Voulez-vous vraiment retirer cette discipline au(x) comptes utilisateurs sélectionné(s) ?';
                    }
                    return window.confirm(this.title || msg);
					} else {
						alert('Veuillez sélectionner au minimum un professeur !');
						return false;
					}
				});


            /* message lors d'une action dans un carnet ouvert */
            $('input[name="postSchoolReportAction"]').click(function() {
                    var action = $(this).parent().find('select[name="doAction"]').val();
                    var msg = "";
                    if (action == 1) {
                        window.location.href = "index.php?content=addmessage&selectStudent";
                    }
                    else if (action == 2) {
                        msg = 'Voulez-vous vraiment suspendre le carnet sélectionné ?';
                        return window.confirm(this.title || msg);
                    }
                    else if (action == 3) {
                        msg = 'Voulez-vous vraiment rendre le carnet sélectionné ?';
                        return window.confirm(this.title || msg);
                    }
             });

			/* message lors de la création ou du retrait de la filiation */
            $('input[name="postAffiliateAction"]').click(function() {
                    var action = $(this).parent().find('select[name="doAction"]').val();
                    var msg = "";
					if (action == 1) {
                        msg = 'Voulez-vous vraiment affilié le ou les élève(s) sélectionné(s) ?';
                        return window.confirm(this.title || msg);
                    }
                    else if (action == 2) {
                        msg = 'Voulez-vous vraiment retirer la filiation de ou des élève(s) sélectionné(s) ?';
                        return window.confirm(this.title || msg);
                    }
             });

			/* message lors d'une action sur la liste des carnets sélectionnés
            $('input[name="postMultipleSchoolReportAction"]').click(function() {
                    var action = $(this).parent().find('select[name="doAction"]').val();
                    var msg = "";
                    if (action == 1) {
                        window.location.href = "index.php?content=addmessage&multipleStudent";
                    }
                    else if (action == 2) {
                        msg = 'Voulez-vous vraiment suspendre le ou les carnet(s) sélectionné(s) ?';
                        return window.confirm(this.title || msg);
                    }
                    else if (action == 3) {
                        msg = 'Voulez-vous vraiment rendre le ou les carnet(s) sélectionné(s) ?';
                        return window.confirm(this.title || msg);
                    }
               });
			*/
            /* lancer la fonction selected */
            selected()

            $("select[name='id_profile']").change(function() {
                    selected()
                });

            $("input[name='email']").focusout(function() {
                    var email = $("input[name='email']").val();
                    this.value = email.toLowerCase();
                });

            $('#btnLogin').click(function() {
                    var pwEncrypt;
                    if( $('#pw').val() != '' ) {
                        pwEncrypt = $().crypt( {
                                method: 'md5',
                                source: $('#pw').val()
                            });
                        alert(pwEncrypt);
                        return;
                    } else {
                        alert('You must enter a password!');
                        return false;
                    }
                });



			// Masquage du select pour l'attribution d'une discipline à un professeur
			$('#displayDiscipline').hide();

			$("select[name='id_discipline']").change(function() {
                    selected()
                });

			$("select[name='id_profile']").change(function() {
					var valueIdProfile = $("select[name='id_profile']").val();
					if(valueIdProfile >= 30){
						// Masquage du select pour l'attribution d'une discipline à un professeur
						$('#displayDiscipline').show();
					}
					if(valueIdProfile < 30){
						// Masquage du select pour l'attribution d'une discipline à un professeur
						$('#displayDiscipline').hide();
					}
                });

				$("select[name='id_discipline']").change(function() {
					var valueIdDiscipline = $("select[name='id_discipline']").val();
                });

            /*
             $.ajax({
             type: "POST",
             url: "./ajax/some.php",
             data: "name=John&location=Boston",
             success: function(msg){
             alert( "Data Saved: " + msg );
         }
     });

     $.ajax({
     type: "GET",
     url: "./ajax/test.htm",
     error:function(msg){
     alert( "Error !: " + msg );
 },
 success:function(data){
 alert(data);
 $("#infoboard").fadeIn(2000, function () {
 $(this).html(data);
 });
 $("#infoboard").delay(3000);
 $("#infoboard").fadeOut("slow");
        }
    });

    $("input[name='oldpasswordcheck']").focusout(function() {
    var oldpasswordcheck;
    oldpasswordcheck = $().crypt({
    method: 'md5',
    source: $("input[name='oldpasswordcheck']").val()
});
alert(oldpasswordcheck);
            });
            */

            /* validation du formulaire d'ajout d'un utilisateur */
            $("#addUser").validate({
                    rules: {
                        id_user: {
                            required: false
                        },
                        firstname: {
                            required: true
                        },
                        lastname: {
                            required: true
                        },
                        password: "required",
                        passwordcheck: {
                            equalTo: "#password"
                        },
                        email: {
                            required: true
                        },
                        day: {
                            required: true,
                            number: true,
                            range: [1, 31]
                        },
                        month: {
                            required: true,
                            number: true,
                            range: [1, 12]
                        },
                        year: {
                            required: true,
                            number: true,
                            min:1900
                        },
						birth_date: {
                            required: true
                        },
                        id_profile: {
                            required: true,
                            min:10
                        },
						/*
						id_discipline: {
                            required: false,
							min:1
                        },*/
                    },
                    messages: {
                        id_user: {
                            required: ""
                        },
                        firstname: {
                            required: "Saisissez le prénom"
                        },
                        lastname: {
                            required: "Saisissez le nom"
                        },
                        password: {
                            required: "Saissisez un mot de passe"
                        },
                        passwordcheck: {
                            required: "Retapez votre mot de passe",
                            equalTo: "Le mot de passe n'est pas le même"
                        },
                        email: {
                            required: "Vous devez saisir une adresse courriel",
                            email: "Vous devez saisir une adresse courriel valide"
                        },
                        day: {
                            required: "Vous devez saisir le jour de naissance",
                            number: "Veuillez saisir un nombre"
                        },
                        month: {
                            required: "Vous devez saisir le mois de naissance",
                            number: "Veuillez saisir un nombre"
                        },
                        year: {
                            required: "Vous devez saisir l'année de naissance",
                            number: "Veuillez saisir un nombre",
                            min: "Veuillez saisir une date cohérente"
                        },
                        birth_date: {
                            required: "Vous devez sélectionner une date"
                        },
                        id_profile: {
                            required: "Vous devez choisir un profil",
                            min: "Veuillez choisir un profil pour le nouvel utilisateur"
                        },
						id_discipline: {
                            required: "Vous devez choisir une discipline",
							min: "Veuillez choisir une discipline pour le nouvel utilisateur"
                        },
                    }
                });

            /* validation du formulaire de modification de son compte par l'utilisateur */
            $("#updateUser").validate({
                    rules: {
                        firstname: {
                            required: true
                        },
                        lastname: {
                            required: true
                        },
                        login: {
                            required: true
                        },
                        email: {
                            required: true
                        },
                        passwordcheck: {
                            equalTo: "#password"
                        },
                        oldpasswordcheck: {
                            equalTo: "#oldpassword"
                        },
                        day: {
                            required: true,
                            number: true,
                            range: [1, 31]
                        },
                        month: {
                            required: true,
                            number: true,
                            range: [1, 12]
                        },
                        year: {
                            required: true,
                            number: true,
                            min:1900
                        },
                    },
                    messages: {
                        firstname: {
                            required: "Saisissez le prénom"
                        },
                        lastname: {
                            required: "Saisissez le nom"
                        },
                        login: {
                            required: "Saisissez le login"
                        },
                        oldpassword: {
                            required: "Taper votre mot de passe actuel",
                        },
                        oldpasswordcheck: {
                            required: "Taper votre mot de passe actuel",
                            equalTo: "Le mot de passe ne correspond pas à votre mot de passe actuel"
                        },
                        password: {
                            required: "Saissisez un nouveau mot de passe"
                        },
                        passwordcheck: {
                            required: "Retapez votre nouveau mot de passe",
                            equalTo: "Le mot de passe n'est pas le même"
                        },
                        email: {
                            required: "Vous devez saisir une adresse courriel",
                            email: "Vous devez saisir une adresse courriel valide"
                        },
                        day: {
                            required: "Vous devez saisir le jour de naissance",
                            number: "Veuillez saisir un nombre"
                        },
                        month: {
                            required: "Vous devez saisir le mois de naissance",
                            number: "Veuillez saisir un nombre"
                        },
                        year: {
                            required: "Vous devez saisir l'année de naissance",
                            number: "Veuillez saisir un nombre",
                            min: "Veuillez saisir une date cohérente"
                        },
                    }
                });

            /* proposer un login composé de name et surname */
            $("#login").focus(function() {
                    var firstname = $("#firstname").val();
                    var lastname = $("#lastname").val();
                    if(firstname && lastname && !this.value) {
                        var login = firstname + "." + lastname;
                        this.value = login.toLowerCase();
                    }
                });

            /* verification addLevel */
            $("#addLevel").validate({
                    rules: {
                        name: {
                            required: true,
                            maxlength: 20
                        }
                    },
                    messages: {
                        name: {
                            required: "Saisissez le nom de la classe",
                            maxlength: "Vous ne pouvez dépasser 20 caractères"
                        }
                    }
                });

                $('#add').click(function() {
                   // return !$('#fromBox option:selected').remove().appendTo('#toBox');
                    if ($('#fromBox option:selected').remove().appendTo('#toBox')) {
						return false;
					}
                });
                $('#remove').click(function() {
                   // return !$('#toBox option:selected').remove().appendTo('#fromBox');
                    if($('#toBox option:selected').remove().appendTo('#fromBox')) {
						return false;
					}
                });

				//Sélectionnés tous les utilisateurs
				$('#select_all').change(function() {
					var checkboxes = $(this).closest('form').find(':checkbox');
					var rowCount = $('#tableAllMessages >tbody >tr');
					if($(this).is(':checked')) {
						checkboxes.attr('checked', 'checked');
						//var rowCount = $('#tableAllMessages >tbody >tr').length;
						rowCount.css("background-color","#EBF8A4");
					} else {
						checkboxes.removeAttr('checked');
						rowCount.css("background-color","#FFFFFF");
					}
                });
				// Differenciation de la ligne d'un checkbox coché
				// Function Live : Lie un gestionnaire à un évènement pour les éléments sélectionnés.
				$("tr :checkbox").live("click", function() {
					$(this).closest("tr").css("background-color", this.checked ? "#EBF8A4" : "");
				});


				/* vérification de la sélection de checkbox du formulaire sur Carnet de vos élèves avant submit */
				$('#viewCarnet').submit(function() {
					if ($('input:checkbox', this).is(':checked')) {
						// Action
					} else {
						alert('Veuillez sélectionner au minimum un élève !');
						return false;
					}
				});


				// Récupération du du select option (multiple ou pas) sous forme de tableaux js
				function multipleSelectOnSubmit(multipleSelect){
					// Récupération des éléments de tobox sous forme de tableau pour l'ajout
					NbCol1 = document.forms[multipleSelect].elements.toBox.length;
					for(i=0; i<NbCol1; i++){
					document.forms[multipleSelect].elements.toBox.options[i].selected = true;
					}
					document.forms[multipleSelect].elements.toBox.name = "toBox[]";

					// Récupération des éléments de fromBox sous forme de tableau pour la suppression
					NbCol2 = document.forms[multipleSelect].elements.fromBox.length;
					for(i=0; i<NbCol2; i++){
					document.forms[multipleSelect].elements.fromBox.options[i].selected = true;
					document.forms[multipleSelect].elements.fromBox.name = "fromBox[]";
					}
					// Envoie des données
					document.forms[multipleSelect].submit();

				}


				// Masquage du bouton de validation pour création ou retrait de filiation
				//$('#displayValidate').hide();
				/* Affichage du bouton de validation pour création ou retrait de filiation
				$('input[type="checkbox"]').bind('click',function() {
					 if($(this).is(':checked')) {
						 $('#displayValidate').show();
					}
				 });
				*/

				// Formulaire de recherche pour l'affiliation des élèves
				// détection de la saisie dans le champ de recherche responsible
				$('#responsible').keyup(function(){
					$fieldResponsible = $('#responsible').val();
					//console.log($fieldResponsible);
					//$('#resultResponsible').append($fieldResponsible);
					// on vide les resultats quand on arrête de saisir
					$('#resultResponsible').html('');
					$('#ajax-loader').remove(); // on retire le loader ajax-loader.gif
					// Traitement à partir du second caractère
					if($fieldResponsible.length>1){
						//$('#resultResponsible').append($fieldResponsible);
						$.ajax({
							type: 'GET',
							//url: 'listResponsible.php?action=listResponsible',
							url: 'listResponsible.content.php',
							//url: 'index.php?content=toJoin&action=search_term',
							// données à envoyer en  GET ou POST
							//data : 'search_term=$fieldResponsible',
							data: 'search_term='+$fieldResponsible,
							// traitements JS à faire AVANT l'envoi
							beforeSend : function() {
								// ajout d'un loader pour signifier l'action
								$('#resultResponsible').after('<img class="icone" src="./images/ajax-loader.gif" alt="loader" id="ajax-loader" />');
							},
							// traitements JS à faire en cas de succès
							success : function(data){
								$('#ajax-loader').remove(); // on enleve le loader
								//affichage des résultats dans le bloc
								$('#resultResponsible').html(data);
								 //$('#responsible').focus();
							}

						});

					}
				});

				// détection de la saisie dans le champ de recherche élève
				$('#student').keyup(function(){
					$fieldStudent = $('#student').val();
					//console.log($fieldStudent);
					//$('#resultStudent').append($fieldStudent);
					$('#resultStudent').html('');
					$('#ajax-loader').remove(); // on retire le loader ajax-loader.gif
					// Traitement à partir du second caractère
					if($fieldStudent.length>1){
						$.ajax({
							type: 'GET',
							url: 'listStudent.content.php',
							data: 'search_term='+$fieldStudent,
							// traitements JS à faire AVANT l'envoi
							beforeSend : function() {
								// ajout d'un loader pour signifier l'action
								$('#resultStudent').after('<img class="icone" src="./images/ajax-loader.gif" alt="loader" id="ajax-loader" />');
							},
							// traitements JS à faire APRES le retour d'ajax-search.php
							success : function(data){
								$('#ajax-loader').remove(); // on enleve le loader
								//affichage des résultats dans le bloc
								$('#resultStudent').html(data);
							}

						});
					}
				});




			/* message de suspension lors du click sur l'image de suspension */

			$('#tableAllMessages >tbody >tr >td[idSchoolReport]').click(function(){
				// Récupération de la colonne sélectionnée
				var tr = $(this).parent();
				for (var i = 0; i < tr.children().length; i++) {
					if (tr.children().get(i) == this) {
						var column = i;
						break;
					}
				}
				// Récupération de la ligne sélectionnée
				var tbody = tr.parent();
				for (var j = 0; j < tbody.children().length; j++) {
					if (tbody.children().get(j) == tr.get(0)) {
						var row = j;
						break;
					}
				}
				//console.log(row + ', ' + column);
				// Récupération de numéro du carnet de l'élève : idSchoolReport
				$idSchoolReport = tr.find('input[name=idSchoolReport]').val();
				//Récupération du nom et du status de l'élève
				$status = tr.find('input[name=status]').val();
				$nameStudent = tr.find('input[name=nameStudent]').val();
				if($status == 0){
					msg = 'Voulez-vous vraiment suspendre le carnet de '+$nameStudent+ ' ?' ;
				}
				else{
					msg = 'Voulez-vous vraiment rendre le le carnet de '+$nameStudent+ ' ?' ;
				}
				if (window.confirm(this.title || msg)){
					$.ajax({
						type: 'GET',
						url: 'index.php?content=suspend',
						data: 'idSchoolReport='+$idSchoolReport,
						success : function(data){
							$page = 'index.php?content=suspend';
							window.location.replace($page);
							/*
							if($status == 0){
								$('#img-nosuspend').after('<img class="icone" src="./images/icons/preferences-desktop-user-password.png" alt="rendre ce carnet" title="Rendre le carnet '+$nameStudent+' " id="img-suspend" />');
								$('#img-nosuspend').remove();
								console.log($status);
								console.log('  le carnet de '+$nameStudent+ ' a bien été suspendu');
								$status = 1;
							}
							else{
								$('#img-suspend').after('<img class="icone" src="./images/icons/user-identity.png" alt="Suspendre ce carnet" title="Suspendre le carnet '+$nameStudent+' " id="img-nosuspend" />');
								$('#img-suspend').remove();
								console.log($status);
								console.log('  le carnet de '+$nameStudent+ ' a bien été rendu ');
								$status = 0;
							}
							*/
						}
					});
				}
			});


		/* dump - vidage des données du cdc et à préparation d'une nouvelle année ( proposition d'import Ldap ) */

		// Interception de la validation du formulaire pour afficher l'image d'attente de vidage du cdc
        $("#newSchoolYear").click(function() {
		//$("#form_dump input['submitted']").click(function() {
		msg = 'Voulez-vous vraiment débuter une nouvelle année ?' ;
			if (window.confirm(this.title || msg)){
				$("#form_p input").hide();
				$("#form_p img").show();
				return true;
			}else{
				return false;
			}
        });
});
