$(document).ready(function(){

	/*Récupération de la date en cas de mise à jour pour affichage de la date par defaut */
	var defDate =  new Date();
	var defDate = $('#datepicker').val();
	if(defDate){
		var defDate = defDate.replace(/-/g, "");
		var defautlDay = defDate[1]+defDate[2];
		var defautlMonth = defDate[3]+defDate[4];
		var defautlYear = defDate[5]+defDate[6]+defDate[7]+defDate[8];
		inputDefautlDay = new Date(defautlYear+"-"+defautlMonth+"-"+defautlDay);
	}

	/*Récupération de la date courante */
	var currentDate = new Date();
	var currentDay = currentDate.getDate();
	var currentMonth = currentDate.getMonth() + 1;
	var currentYear = currentDate.getFullYear();
	inputCurrentDay = new Date(currentYear+"-"+currentMonth+"-"+currentDay);

	// Mise en place d'une date par defaut
	if(defDate){
		// Spécification du fichier de langue utilisé : le patch français
		jQuery.datepicker.setDefaults(jQuery.datepicker.regional['fr']);
		$('#datepicker').datepicker({
			showOn: 'button',
			buttonImage: './images/icons/view-calendar.png',
			//buttonText: 'Sélectionner une date de naissance',
			showAnim: 'slide',
			changeMonth: true,
			changeYear: true,
			showButtonPanel: true,
			dateFormat: 'dd-mm-yy',
			defaultDate:  inputDefautlDay,
			minDate: new Date((currentYear-120), 1 - 1, 1),
			maxDate: new Date((currentYear-5), 12 - 1, 30)
		});
	}else {
		jQuery.datepicker.setDefaults(jQuery.datepicker.regional['fr']);
		$('#datepicker').datepicker({
			showOn: 'button',
			buttonImage: './images/icons/view-calendar.png',
			changeMonth: true,
			changeYear: true,
			showButtonPanel: true,
			showAnim: 'slide',
			dateFormat: 'dd-mm-yy',
			defaultDate:  currentDate,
			minDate: new Date((currentYear-120), 1 - 1, 1),
			maxDate: new Date((currentYear-5), 12 - 1, 30)
		});
	}



});
