<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file listStudent.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Affilier un responsable et un élève
 */

include_once("cdc.config.php");
include_once("config.php");
session_start();
function __autoload($classname) {
    include_once("includes/" . $classname . ".class.php");
}
// l'utilisateur n'est pas authentifié
if ((!isset($_SESSION['id_user']))&&(AUTH == 'sql')) {
    $session = New Authentification();
    include("connection.php");
}
if ($_SESSION['admin'] == True) {
    $u = New Admin();
}

// choix de la CSS
if (isset($theme)) {
    echo '<link rel="stylesheet" type="text/css" href="./themes/'.$theme.'/css/theme.css" />', chr(10);
}
else {
    echo '<link rel="stylesheet" type="text/css" href="./themes/default/css/theme.css" />', chr(10);
}
// css pour les tableaux
echo '<link rel="stylesheet" type="text/css" href="./css/demo_table_jui.css" />', chr(10);
echo '<link rel="stylesheet" type="text/css" href="./css/jquery-ui-1.8.4.custom.css" />', chr(10);

// protection page admin
if ($_SESSION['admin']) {
    // affichage des informations pour validation
    if(isset($_GET['action'])&&($_GET['action']=='save')) {
    }
    else{
		$tabAllUsersInfos = $u->selectAllUsers();
        if (empty($tabAllUsersInfos))
            echo '<div id="empty">Il n\'y a pas d\'utilisateur !</div>', chr(10);
        else{
            if (!empty($_GET['search_term'])) {
				$tabAllPossibleStudent = $u->selectAllPossibleStudent(trim($_GET['search_term']));
				if(sizeOf($tabAllPossibleStudent) == 0 ){
					echo '<div id="empty">Pas de résultat pour cette recherche </div>', chr(10);
				}
				else{
					echo '<h3>Elève(s) trouvé(s) </h3>', chr(10);
					 echo '<table id="tableAllMessages" name="tableAllMessages" summary="Tableau des messages">', chr(10);
					echo '<caption />', chr(10);
					echo '<thead>', chr(10);
					echo '<tr>', chr(10);
					echo '<th></th>', chr(10);
					echo '<th>Prénom</th>', chr(10);
					echo '<th>Nom</th>', chr(10);
					echo '<th>Responsable(s)</th>', chr(10);
					echo '</tr>', chr(10);
					echo '</thead>', chr(10);
					echo '<tbody>', chr(10);
					if (isset($tabAllPossibleStudent)) {
						foreach ($tabAllPossibleStudent as $id => $value) {
							echo '<tr>', chr(10);
							echo '<td><input type="checkbox" name="idSelectStudent[]" value="'.$tabAllPossibleStudent[$id]['id_user'].'" /></td>', chr(10);
							echo '<td>'.$tabAllPossibleStudent[$id]['firstname'].'</td>', chr(10);
							echo '<td>'.$tabAllPossibleStudent[$id]['lastname'].'</td>', chr(10);
							//echo '<td>'.$tabAllPossibleStudent[$id]['login'].' ', chr(10);
							echo '<td>', chr(10);
							$tabStudentInfos = Student::getUserInfos($tabAllPossibleStudent[$id]['id_user']);
							if(sizeOf($tabStudentInfos['responsables'])>0){
								echo "\n<ul class='affiliate'>\n";
								foreach ($tabStudentInfos['responsables'] as $resp) {
									echo '<li> <img class="icone" src="./images/icons/draw-bezier-curves.png" alt="Son affiliation" title="Son affiliation" /> '.$resp["lastname"].' '.$resp["firstname"].'</li>';
								}
								echo "\n</ul>\n";
							}
							else
								echo 'Pas de responsable',chr(10);
							echo '</td>', chr(10);
							echo '</tr>', chr(10);
						}
						echo '</tbody>', chr(10);
						echo '</table>', chr(10);
					}
				}
            }
            else
				echo '<div id="empty">Veuillez entrer le nom d\'un élève !</div>', chr(10);
		}
    }
}
else {
    $page = 'index.php';
    echo '<script language="javascript" type="text/javascript">', chr(10);
    echo '<!--', chr(10);
    echo 'window.location.replace("'.$page.'")', chr(10);
    echo '-->', chr(10);
    echo '</script>';
    exit;
}
?>
