<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file logout.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief vide les variables de session et redirige vers la page index.php
 */
include_once("cdc.config.php");
include_once("config.php");
include_once("constant.php");
function __autoload($classname) {
    include_once("includes/" . $classname . ".class.php");
}

function cas_logout(){
    require_once("configCAS/cas.inc.php");
    require_once("CAS-1.3.1/eoleCAS.php");
    if (__CAS_DEBUG){
        eolephpCAS::setDebug("/var/log/posh/cdc-cas.log");
    }
    eolephpCAS::client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, false);
    // Maj pour phpCAS 1.3.1
    if (__CAS_VALIDER_CA) {
        eolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // vérification par rapport à la CA
    } else {
        if (method_exists("EolephpCAS", "setNoCasServerValidation")){
            eolephpCAS::setNoCasServerValidation();
        }
    }
   if (method_exists(eolephpCAS, 'eoleLogoutRequests')){
        eolephpCAS::eoleLogoutRequests(false);
   }
   $orig_url = $_SERVER['SCRIPT_URI'];
   $url = str_replace('logout.php', 'index.php', $orig_url);
   eolephpCAS::logout(array("url"=>$url));
}

if (DEBUG==True)
    Logger::log('arrivée dans logout.php');

if (AUTH == 'cas') {
    if (DEBUG==True)
        Logger::log('passage dans déconnexion CAS');
    session_start();
    session_unset();
    session_destroy();
    cas_logout();
}
elseif (AUTH == 'sql'){
    session_start();
    session_unset();
    session_destroy();
    header('Location: index.php');
}
elseif(AUTH ==''){
    echo 'protocole d\'authentification non géré';
}
?>
