<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file manageAffiliate.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Affilier un responsable et un élève
 */
?>
<script type="text/javascript" src="./js/lib/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="./js/cdc.tables.js"></script>
<script type="text/javascript" src="./js/function.datepicker.js"></script>
<?php
// protection page admin
if ($_SESSION['admin']) {
	echo '<h2>Affiliation des Elèves </h2>', chr(10);
    // affichage des informations pour validation
    //if(isset($_GET['action'])&&($_GET['action']=='save')) {
    if(isset($_POST['postAffiliateAction'])) {
		// Création d'une filiation
		if($_POST['doAction']=="1"){
			if( isset($_POST['idSelectStudent']) && (isset($_POST['idSelectResponsible'])) ){
				$idSelectResponsible = $_POST['idSelectResponsible'];
				$countResponsible = count($idSelectResponsible);
				$idSelectStudent = $_POST['idSelectStudent'];
				$countStudent = count($idSelectStudent);
				// Traitement par responsable : si on a un responsable
				if($countResponsible==1){
					// on récupère la liste des personnes qui sont sous sa responsabilité
					$allUnderCare = $u->allUnderCare($idSelectResponsible[0]);
					// Si le responsable a au moins une personne sous sa responsabilité
					// On verifie s'il n'y a déjà eu affiliation et on evite un submit multiple
					if (sizeof($allUnderCare) >= 1){
						for($i=0;$i<$countStudent;$i++){
							$tabStudentInfos = $u->getUserInfos($idSelectStudent[$i]);
							$tabResponsibleInfos = $u->getUserInfos($idSelectResponsible[0]);
							$compteur = 0;
							foreach ($allUnderCare as $id => $value) {
								if ($idSelectStudent[$i] == $allUnderCare[$id]['id_student']){
									$compteur = $compteur + 1;
									break;
								}
							}
							if(floor($compteur) == 1){
								// infoboard
								$info .= 'Impossible d\'affilier l\'élève <span class=\"bold\">'.$tabStudentInfos['firstname'].' '.$tabStudentInfos['lastname'].'<\/span> au responsable <span class=\"bold\"> '.$tabResponsibleInfos['lastname'].' '.$tabResponsibleInfos['firstname'].' <\/span> car il y est déjà sous sa responsabilité<br />\n';
								$type_message = 'warning';
							}
							else{
								//echo ' '.$idSelectResponsible[0].' : '.$idSelectStudent[$i].'<br/>';
								if ($u->addAffiliate($idSelectStudent[$i],$idSelectResponsible[0])) {
									// infoboard
									$info = 'La filiation de l\'élève a échoué ';
									$type_message = 'warning';
								}else {
									$info .= 'L\'élève <span class=\"bold\">'.$tabStudentInfos['firstname'].' '.$tabStudentInfos['lastname'].'<\/span> a bien été affilié au responsable <span class=\"bold\"> '.$tabResponsibleInfos['firstname'].' '.$tabResponsibleInfos['lastname'].' <\/span><br />\n';
									$type_message = 'info';
								}
							}
						}
					}
					// Le responsable n'a personne sous sa responsabilité
					else {
						for($i=0;$i<$countStudent;$i++){
							if ($u->addAffiliate($idSelectStudent[$i],$idSelectResponsible[0])) {
								// infoboard
								$info = 'La filiation de l\'élève a échoué ';
								$type_message = 'warning';
							}else {
								$tabStudentInfos = $u->getUserInfos($idSelectStudent[$i]);
								$tabResponsibleInfos = $u->getUserInfos($idSelectResponsible[0]);
								foreach ($tabStudentInfos as $value) {
									$info = 'L\'élève <span class=\"bold\">'.$tabStudentInfos['firstname'].' '.$tabStudentInfos['lastname'].'<\/span> a bien été affilié au responsable <span class=\"bold\"> '.$tabResponsibleInfos['firstname'].' '.$tabResponsibleInfos['lastname'].' <\/span><br />\n';
								}
								$type_message = 'info';
							}
						}
					}
				}
				// infoboard
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("'.$type_message.'",message);';
				echo '</script>';
				displaySearchFom();
			}
			else{
				// infoboard
				$info = 'Il n\'y a pas de filiation à faire, vous n\'avez pas lier de responsable à au moins un élève !';
				$type_message = 'warning';
				//echo '<div id="empty">Il n\'y a pas de filiation à faire, vous n\'avez pas lier de responsable à au moins un élève !</div>', chr(10);
				// infoboard
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("'.$type_message.'",message);';
				echo '</script>';
				displaySearchFom();
			}
		}
		// Retrait d'une filiation
		elseif($_POST['doAction']=="2"){
			if( isset($_POST['idSelectStudent']) && (isset($_POST['idSelectResponsible'])) ){
				$idSelectResponsible = $_POST['idSelectResponsible'];
				$countResponsible = count($idSelectResponsible);
				$idSelectStudent = $_POST['idSelectStudent'];
				$countStudent = count($idSelectStudent);
				// Traitement par responsable : si on a un responsable
				if($countResponsible==1){
					// on récupère la liste des personnes qui sont sous sa responsabilité
					$allUnderCare = $u->allUnderCare($idSelectResponsible[0]);
					// Si le responsable a au moins une personne sous sa responsabilité
					if (sizeof($allUnderCare) >= 1){
						for($i=0;$i<$countStudent;$i++){
							$tabStudentInfos = Student::getUserInfos($idSelectStudent[$i]);
							$tabResponsibleInfos = $u->getUserInfos($idSelectResponsible[0]);
							$compteur = 0;
							// l'élève n'a pas de responsable donc pas de retrait
							if(sizeof($tabStudentInfos['responsables']) == 0){
								// infoboard
								$info .= 'Impossible de retirer l\'élève <span class=\"bold\">'.$tabStudentInfos['firstname'].' '.$tabStudentInfos['lastname'].'<\/span> au responsable <span class=\"bold\"> '.$tabResponsibleInfos['lastname'].' '.$tabResponsibleInfos['firstname'].' <\/span> car il n\'y a pas de filiation<br />\n';
								$type_message = 'warning';
							}
							else{
								//Vérification si l'élève a un d'autre responsable autre que celui choisit
								foreach ($tabStudentInfos['responsables'] as $resp) {
									if($idSelectResponsible[0] == $resp["id_user"]){
										//echo ''.$resp["lastname"].' '.$resp["firstname"].'';
										$compteur = $compteur + 1;
										break;
									}
								}
								// s'il y a un lien alors on retire la filiation
								if(floor($compteur) == 1){
									if ($u->removeAffiliate($idSelectStudent[$i],$idSelectResponsible[0])) {
										// infoboard
										$info = 'Le retrait de filiation de l\'élève a échoué ';
										$type_message = 'warning';
									}else {
										$info .= 'L\'élève <span class=\"bold\">'.$tabStudentInfos['firstname'].' '.$tabStudentInfos['lastname'].'<\/span> n\'est plus affilié au responsable <span class=\"bold\"> '.$tabResponsibleInfos['firstname'].' '.$tabResponsibleInfos['lastname'].' <\/span><br />\n';
										$type_message = 'info';
									}
								}
								else{
									// infoboard
									$info .= 'Impossible de retirer l\'élève <span class=\"bold\">'.$tabStudentInfos['firstname'].' '.$tabStudentInfos['lastname'].'<\/span> au responsable <span class=\"bold\"> '.$tabResponsibleInfos['lastname'].' '.$tabResponsibleInfos['firstname'].' <\/span> car il n\'y a pas de de lien de filiation<br />\n';
									$type_message = 'warning';
								}
							}
						}
					}
					// Le responsable n'a personne sous sa responsabilité
					else {
						$tabResponsibleInfos = $u->getUserInfos($idSelectResponsible[0]);
						$info = ' Le responsable <span class=\"bold\"> '.$tabResponsibleInfos['firstname'].' '.$tabResponsibleInfos['lastname'].' <\/span> n\'a personne sous sa responsabilité donc pas de retrait de filiation !';
						$type_message = 'warning';
					}
				}
				// infoboard
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("'.$type_message.'",message);';
				echo '</script>';
				displaySearchFom();
			}
			else{
				// infoboard
				$info = 'Il n\'y a pas de retrait de filiation à faire, vous n\'avez pas retirer de responsable à au moins un élève !';
				$type_message = 'warning';
				//echo '<div id="empty">Il n\'y a pas de filiation à faire, vous n\'avez pas lier de responsable à au moins un élève !</div>', chr(10);
				// infoboard
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("'.$type_message.'",message);';
				echo '</script>';
				displaySearchFom();
			}
		}
		else
			 displaySearchFom();
    }
    else{
		$tabAllUsersInfos = $u->selectAllUsers();
        if (empty($tabAllUsersInfos))
            echo '<div id="empty">Il n\'y a pas d\'utilisateur !</div>', chr(10);
        else{
            displaySearchFom();
		}
    }
}
else {
    $page = 'index.php';
    echo '<script language="javascript" type="text/javascript">', chr(10);
    echo '<!--', chr(10);
    echo 'window.location.replace("'.$page.'")', chr(10);
    echo '-->', chr(10);
    echo '</script>';
    exit;
}


/**
 * @brief Fonction d'affichage du formulaire de recherche d'un responsable et d'un élève
 */

function displaySearchFomResponsible(){
	echo '<form action="'.htmlentities($_SERVER['PHP_SELF']).'" method="get">', chr(10);
	echo '<label for="responsible">Rechercher un responsable par son nom</label><br />', chr(10);
	echo '<input type="text" name="responsible" id="responsible" size="30" />',chr(10);
	echo '</form>', chr(10);
	echo '<div id="resultResponsible"></div>', chr(10);
 }


 /**
 * @brief Fonction d'affichage du formulaire de recherche d'un responsable et d'un élève
 */

function displaySearchFomStudent(){
	echo '<form action="'.htmlentities($_SERVER['PHP_SELF']).'" method="get">', chr(10);
	echo '<label for="student">Rechercher un élève par son nom </label><br />', chr(10);
	echo '<input type="text" name="student" id="student" size="30" />',chr(10);
	echo '</form>', chr(10);
	echo '<div id="resultStudent"></div>', chr(10);
 }


/**
 * @brief Fonction d'affichage du formulaire de recherche d'un responsable et d'un élève
 */

function displaySearchFom(){
	displaysubAction("manageUsers");
	echo '<form name="displayAffiliate" action="'.$_SERVER['PHP_SELF'].'?content=manageAffiliate&action=save" method="post" name="displayAffiliate">', chr(10);
	echo '<div id="formSearch">',chr(10);
	echo '<div id="formLeft">',chr(10);
	displaySearchFomStudent();
	echo '</div>',chr(10);
	echo '<div id="formRight">',chr(10);
	displaySearchFomResponsible();
    echo '</div>',chr(10);
    echo '<div id="clear"></div>',chr(10);
	echo '<div id="displayValidate">',chr(10);
	echo '<br/>',chr(10);
	echo '<div class="action">Action sur les élèves : <select name="doAction">
            <option value="1">Créer la filiation</option>
            <option value="2">Retirer la filiation</option>
            </select>
            <input name="postAffiliateAction" value="Valider" type="submit">
            </div>', chr(10);
	echo '</div><!-- ferme le displayValidate -->',chr(10);
	echo '</div><!-- ferme le formSearch -->',chr(10);
    echo '</form>', chr(10);
 }


?>
