<?php
/**
 * @author CETIAD Dijon
 * @date Mars 2012
 * @file manageDiscipline.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Affichage, recherche et édition des disciplines
 * @todo conformité W3C
 */

?>

<script type="text/javascript" src="./js/lib/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="./js/cdc.tables.js"></script>

<?php
if ($_SESSION['admin']) {
    // protection page admin
    echo '<h2>Gestion des disciplines</h2>', chr(10);
    if(isset($_GET['action'])&&($_GET['action']=='view')) {
        // affichage des informations pour validation
        displaysubAction("manageDisciplines");
        echo '<h3>Vérifier les informations</h3>', chr(10);
        $tabAllDiscipline = Discipline::selectAllDiscipline();
		$disciplineName = $_POST['name'];
		// Protection contre insertion multiple après submit du formulaire
		$compteur = 0;
		foreach ($tabAllDiscipline as $id => $value) {
			$searchDisciplineName  = $tabAllDiscipline[$id]['name'];
			if(strpos($searchDisciplineName, $disciplineName) !== false) {
				$compteur = $compteur + 1;
				break;
			}
		}
		if(floor($compteur) == 1){
			// infoboard
			$info = 'Impossible d\'ajouter la discipline <span class=\"bold\"> '.$_POST['name'].' <\/span> car elle existe déjà ! ';
			echo '<script type="text/javascript">';
			echo 'var message = "'.$info.'";';
			echo 'displayInfoboard("warning",message);';
			echo '</script>';
		}
		else{
			echo '<form action="'.$_SERVER['PHP_SELF'].'?content=manageDiscipline&action=save" method="post">', chr(10);
			displayViewDiscipline();
			echo '<input type="submit" value="Enregister" name="btnValid"/><br />';
			echo '</form>';
        }
        displayAddDiscipline();
    }
    elseif(isset($_GET['action'])&&($_GET['action']=='save')) {
		$tabAllDiscipline = Discipline::selectAllDiscipline();
		$disciplineName = $_POST['name'];
		// Protection contre insertion multiple après submit du formulaire
		$compteur = 0;
		foreach ($tabAllDiscipline as $id => $value) {
			$searchDisciplineName  = $tabAllDiscipline[$id]['name'];
			if(strpos($searchDisciplineName, $disciplineName) !== false) {
				$compteur = $compteur + 1;
				break;
			}
		}
		if(floor($compteur) == 1){
			// infoboard
			$info = 'Impossible d\'ajouter la discipline <span class=\"bold\"> '.$_POST['name'].' <\/span> car elle existe déjà ! ';
			echo '<script type="text/javascript">';
			echo 'var message = "'.$info.'";';
			echo 'displayInfoboard("warning",message);';
			echo '</script>';
		}
		else{
			// sauvegarder les informations du nouveau compte dans la base de données
			if ($u->addDiscipline($_POST['name'])) {
				// infoboard
				$info = 'L\'enregistrement n\'ai pas ajouté';
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("warning",message);';
				echo '</script>';
			}
			else {
				// infoboard
				$info = 'La discipline de <span class=\"bold\"> '.$_POST['name'].'  <\/span> a bien été ajouté';
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("info",message);';
				echo '</script>';
			}
        }
        $tabAllDiscipline = Discipline::selectAllDiscipline();
        displaysubAction("addDiscipline");
        displayAllDiscipline($tabAllDiscipline);
    }
    // affichage du formulaire pour saisir les informations du nouvel utilisateur
    elseif(isset($_GET['action'])&&($_GET['action']=='add')) {
        displaysubAction("manageDisciplines");
        echo '<h3>Ajouter une discipline</h3>', chr(10);
        displayAddDiscipline();
    }
    // affichage du formulaire pour edition des informations de l'utilisateur
    elseif((isset($_GET['action']))&&($_GET['action']=='edit')) {
		displaysubAction("manageDisciplines");
        $tabAllDiscipline = Discipline::selectAllDiscipline();
        $compteur = 0;
        foreach ($tabAllDiscipline as $id => $value) {
			if ( $_GET['id_discipline'] == $tabAllDiscipline[$id]['id_discipline']){
			$compteur = $compteur + 1;
			break;
			}
		}
		if(floor($compteur) == 1){
			$tabDisciplineInfos = Discipline::selectDiscipline( $_GET['id_discipline']);
			echo '<h3>Édition de la discipline : '.$tabDisciplineInfos[0]['name'].'</h3>', chr(10);
			displayEditDiscipline($tabDisciplineInfos);
		}
		else
			echo '<div id="empty">Aucune discipline ne correspond à votre recherche !</div>', chr(10);
    }
    // affichage des informations pour mise à jour
    elseif(isset($_GET['action'])&&($_GET['action']=='viewUpdate')) {
        displaysubAction("manageDisciplines");
        echo '<h3>Vérifivation des informations</h3>', chr(10);
        $tabAllDiscipline = Discipline::selectAllDiscipline();
        $disciplineName = $_POST['name'];
        $tabDisciplineInfos = Discipline::selectDiscipline($_POST['id_discipline']);
        $compteur = 0;
		foreach ($tabAllDiscipline as $id => $value) {
			$searchDisciplineName  = $tabAllDiscipline[$id]['name'];
			if(strpos($searchDisciplineName, $disciplineName) !== false) {
				$compteur = $compteur + 1;
				break;
			}
		}
		if(floor($compteur) == 1){
			// infoboard
			$info = 'Impossible de modifier <span class=\"bold\"> '.$tabDisciplineInfos[0]['name'].'  <\/span> en <span class=\"bold\"> '.$_POST['name'].' <\/span> car elle existe déjà ! ';
			echo '<script type="text/javascript">';
			echo 'var message = "'.$info.'";';
			echo 'displayInfoboard("warning",message);';
			echo '</script>';
		}
		else{
			echo '<form action="'.$_SERVER['PHP_SELF'].'?content=manageDiscipline&action=update" method="post">', chr(10);
			displayViewDiscipline();
			echo '<input type="submit" value="Enregistrer" name="btnValid"/><br />', chr(10);
			echo ' </form>', chr(10);
        }
        displayEditDiscipline();
    }
    // mise à jour des informations
    elseif(isset($_GET['action'])&&($_GET['action']=='update')) {
        $tabAllDiscipline = Discipline::selectAllDiscipline();
        $disciplineName = $_POST['name'];
        $tabDisciplineInfos = Discipline::selectDiscipline($_POST['id_discipline']);
        $compteur = 0;
		foreach ($tabAllDiscipline as $id => $value) {
			$searchDisciplineName  = $tabAllDiscipline[$id]['name'];
			if(strpos($searchDisciplineName, $disciplineName) !== false) {
				$compteur = $compteur + 1;
				break;
			}
		}
		if(floor($compteur) == 1){
			// infoboard
			$info = 'Impossible de modifier <span class=\"bold\"> '.$tabDisciplineInfos[0]['name'].'  <\/span> en <span class=\"bold\"> '.$_POST['name'].' <\/span> car elle existe déjà ! ';
			echo '<script type="text/javascript">';
			echo 'var message = "'.$info.'";';
			echo 'displayInfoboard("warning",message);';
			echo '</script>';
		}
		else{
			// sauvegarder les informations du nouveau compte dans la base de données
			if ($u->updateDisciplineInfos($_POST['name'],$_POST['id_discipline'])){
				// infoboard
				$info = 'L\'enregistrement n\'ai pas ajouté';
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("warning",message);';
				echo '</script>';
			}
			else {
				// infoboard
				$info = 'La discipline <span class=\"bold\"> '.$tabDisciplineInfos[0]['name'].'  <\/span> a bien été modifié en <span class=\"bold\"> '.$_POST['name'].'  <\/span>';
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("info",message);';
				echo '</script>';
			}
        }
        $tabAllDiscipline = Discipline::selectAllDiscipline();
        displaysubAction("addDiscipline");
        displayAllDiscipline($tabAllDiscipline);
    }
    // affichage des professeurs enseignants une discipline
    elseif(isset($_GET['action'])&&($_GET['action']=='viewTeacher')) {
        displaysubAction("manageDisciplines");
        $tabAllDiscipline = Discipline::selectAllDiscipline();
        $compteur = 0;
        foreach ($tabAllDiscipline as $id => $value) {
			if ( $_GET['id_discipline'] == $tabAllDiscipline[$id]['id_discipline']){
			$compteur = $compteur + 1;
			break;
			}
		}
		if(floor($compteur) == 1){
			$tabAllTeachersInfos =Discipline::TeacherInDiscipline($_GET['id_discipline']);
			$tabDisciplineInfos = Discipline::selectDiscipline($_GET['id_discipline']);
			$idDiscipline = $_GET['id_discipline'];
			if (sizeof($tabAllTeachersInfos) != 0) {
			echo '<h3>Liste des des professeurs enseignants la discipline : '.$tabDisciplineInfos[0]['name'].' </h3>', chr(10);
            //displayTeachers($tabAllTeachersInfos);
            displayTeachers($tabAllTeachersInfos,$idDiscipline);
			}
			else
				echo '<div id="empty">Il n\'y a aucun professeur enseignant la discipline : '.$tabDisciplineInfos[0]['name'].' pour le moment !</div>', chr(10);
		}
		else
			echo '<div id="empty">Aucune discipline ne correspond à votre recherche !</div>', chr(10);

    }
    // doaction
    elseif(isset($_POST['postActionDiscipline'])) {
		// supprimer
		if($_POST['doActionDiscipline']=="1"){
			foreach ($_POST['idSelect'] as $numTab => $idDiscipline) {
			$tabAllDiscipline = Discipline::selectAllDiscipline();
			$compteur = 0;
			foreach ($tabAllDiscipline as $id => $value) {
				if ($idDiscipline == $tabAllDiscipline[$id]['id_discipline']){
				$compteur = $compteur + 1;
				break;
				}
			}
			if(floor($compteur) == 1){
				$effectiveTeacher = Discipline::TeacherInDiscipline($idDiscipline);
				$disciplineInfos = Discipline::selectDiscipline($idDiscipline);
				if ( sizeof($effectiveTeacher) == 0){
					$u->removeDiscipline($idDiscipline);
					$info .= 'La discipline <span class=\"bold\"> '.$disciplineInfos[0]['name'].' <\/span> a bien été supprimée<br />\n';
				}
				else
					$info .= 'Impossible de supprimer la discipline <span class=\"bold\"> '.$disciplineInfos[0]['name'].' <\/span> car elle est encore enseignée .<br />\n';
				}
				else
					$info .= 'Aucune discipline à supprimer , Veuillez sélectionnér la ou les disciplines à avant !<br />\n';
				} // infoboard
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("info",message);';
				echo '</script>';
		}
		$tabAllDiscipline = Discipline::selectAllDiscipline();
		displaysubAction("addDiscipline");
		if (sizeof($tabAllDiscipline) != 0) {
            displayAllDiscipline($tabAllDiscipline);
		}
        else
            echo '<div id="empty">Il n\'y a aucune discipline pour le moment !</div>', chr(10);
    }
    else {
     // doaction
		if(isset($_POST['postActionTeacherInDiscipline'])) {
            // activer
            if($_POST['doActionTeacherInDiscipline']=="1"){
                foreach ($_POST['idSelect'] as $numTab => $idUser) {
                    $tabUserInfos = $u->getUserInfos($idUser);
                    $u->enabledUser($idUser,True);
                    $info .= 'Le compte <span class=\"bold\">'.$tabUserInfos['firstname'].' '.$tabUserInfos['lastname'].'<\/span> a bien été activé<br />\n';
                }
                // infoboard
                echo '<script type="text/javascript">';
                echo 'var message = "'.$info.'";';
                echo 'displayInfoboard("info",message);';
                echo '</script>';
            }
            // désactiver
            elseif($_POST['doActionTeacherInDiscipline']=="2"){
                foreach ($_POST['idSelect'] as $numTab => $idUser) {
                    $tabUserInfos = $u->getUserInfos($idUser);
                    $u->enabledUser($idUser,False);
                    $info .= 'Le compte <span class=\"bold\">'.$tabUserInfos['firstname'].' '.$tabUserInfos['lastname'].'<\/span> a bien été désactivé<br />\n';
                }
                // infoboard
                echo '<script type="text/javascript">';
                echo 'var message = "'.$info.'";';
                echo 'displayInfoboard("info",message);';
                echo '</script>';
            }
        }
		// sinon on affiche la liste des classes
       $tabAllDiscipline = Discipline::selectAllDiscipline();
       displaysubAction("addDiscipline");
       if (sizeof($tabAllDiscipline) != 0) {
			displayAllDiscipline($tabAllDiscipline);
       }
        else
            echo '<div id="empty">Il n\'y a aucune discipline pour le moment !</div>', chr(10);
    }
} else {
    // non admin
    $page = 'index.php';
    echo '<script language="javascript" type="text/javascript">', chr(10);
    echo '<!--', chr(10);
    echo 'window.location.replace("'.$page.'")', chr(10);
    echo '-->', chr(10);
    echo '</script>';
    exit;
}


/**
 * @brief Mise en forme de l'affichage des disciplines
 */
function displayAllDiscipline($tabAllDiscipline) {
	//echo '<form name="displayDiscipline" action="'.$_SERVER['PHP_SELF'].'?content=manageDiscipline" method="post" id="displayDiscipline" >', chr(10);
	echo '<form name="displayDisciplines" action="'.$_SERVER['PHP_SELF'].'?content=manageDiscipline" method="post" id="displayDisciplines">', chr(10);
    echo '<table id="tableAllMessages" summary="Tableau des messages">', chr(10);
    echo '<caption />', chr(10);
    echo '<thead>', chr(10);
    echo '<tr>', chr(10);
    echo '<th></th>', chr(10);
    echo '<th>'.$GLOBALS["titleMessage"]["titleDisciplineName"].'</th>', chr(10);
    echo '<th>'.$GLOBALS["titleMessage"]["titleStaffTeacher"].'</th>', chr(10);
    echo '</tr>', chr(10);
    echo '</thead>', chr(10);
    echo '<tbody>', chr(10);
    // affichage des disciplines
    if (isset($tabAllDiscipline)) {
        foreach ($tabAllDiscipline as $id => $value) {
            echo '<tr>', chr(10);
            echo '<td><input type="checkbox" name="idSelect[]" value="'.$tabAllDiscipline[$id]['id_discipline'].'" /></td>', chr(10);
            echo '<td><a href="index.php?content=manageDiscipline&action=edit&id_discipline='.$tabAllDiscipline[$id]['id_discipline'].'" title="Editer la discipline">'.$tabAllDiscipline[$id]['name'].'</a></td>', chr(10);
            echo '<td>';
            // effectif des professeurs dans une discipline
            $effectiveTeacher = Discipline::countTeacherInDiscipline($tabAllDiscipline[$id]['id_discipline']);
            echo '<a href="index.php?content=manageDiscipline&action=viewTeacher&id_discipline='.$tabAllDiscipline[$id]['id_discipline'].'" title="Voir la liste des professeurs">'.$effectiveTeacher[0]['nbInTeacher'].'</a>', chr(10);
            echo '</td>', chr(10);
            echo '</tr>', chr(10);
        }
        echo '</tbody>', chr(10);
        echo '</table>', chr(10);
        echo '</table><tr><td><input type="checkbox" id="select_all" />Tous sélectionnés</td></tr></table>', chr(10);
        echo '<br />', chr(10);
        echo '<div class="action">Action sur les disciplines : <select name="doActionDiscipline">
            <option value="1">'.$GLOBALS["formMessage"]["delete"].'</option>
            </select>
            <input name="postActionDiscipline" value="Valider" type="submit">
            </div></form>';
    }
}




/**
 * @brief Fonction d'affichage des utilisateurs en tableau
 * @param tableau contenant tous les utilisateurs
 */
function displayTeachers($tabAllTeachersInfos,$idDiscipline) {
	echo '<form name="displayTeacher" action="'.$_SERVER['PHP_SELF'].'?content=manageDiscipline" method="post" id="displayTeacher">', chr(10);
    echo '<table id="tableAllMessages" summary="Tableau des messages">', chr(10);
    echo '<caption />', chr(10);
    echo '<thead>', chr(10);
    echo '<tr>', chr(10);
    echo '<th></th>', chr(10);
    echo '<th>Nom</th>', chr(10);
    echo '<th>Prénom</th>', chr(10);
    echo '<th>Identifiant</th>', chr(10);
    echo '<th>Email</th>', chr(10);
    echo '<th>Compte activé</th>', chr(10);
    echo '</tr>', chr(10);
    echo '</thead>', chr(10);
    echo '<tbody>', chr(10);
    // affichage des messages présent dans le carnet
    if (isset($tabAllTeachersInfos)) {
        $tab=array();
        foreach ($tabAllTeachersInfos as $id => $value) {
            echo '<tr>', chr(10);
            echo '<td><input type="checkbox" name="idSelect[]" value="'.$tabAllTeachersInfos[$id]['id_user'].'" /></td>', chr(10);
            echo '<td><a href="index.php?content=manageUser&action=edit&idUser='.$tabAllTeachersInfos[$id]['id_user'].'">'.$tabAllTeachersInfos[$id]['lastname'].'</a></td>', chr(10);
            echo '<td><a href="index.php?content=manageUser&action=edit&idUser='.$tabAllTeachersInfos[$id]['id_user'].'">'.$tabAllTeachersInfos[$id]['firstname'].'</a></td>', chr(10);
            echo '<td>'.$tabAllTeachersInfos[$id]['login'].'</td>', chr(10);
            echo '<td>'.$tabAllTeachersInfos[$id]['email'].'</td>', chr(10);
            echo '<td>';
            if ($tabAllTeachersInfos[$id]['enabled']==0)
                echo '<span style="display:none;">0</span><img class="icone" src="./images/icons/layer-visible-off.png" alt="utilisateur inactif" />', chr(10);
            else
                echo '<span style="display:none;">1</span><img class="icone" src="./images/icons/layer-visible-on.png" alt="utilisateur actif" />', chr(10);
            echo '</td>', chr(10);
            echo '</tr>', chr(10);
        }
        echo '</tbody>', chr(10);
        echo '</table>', chr(10);
        echo '</table><tr><td><input type="checkbox" id="select_all" />Tous sélectionnés</td></tr></table>', chr(10);
        echo '<br />', chr(10);
        echo '<div class="action">Action sur les utilisateurs : <select name="doActionTeacherInDiscipline">
            <option value="1">Activer</option>
            <option value="2">Désactiver</option>
            </select>
              <input type="hidden" name="idDiscipline" value ="'.$idDiscipline.'" />
            <input name="postActionTeacherInDiscipline" value="Valider" type="submit">
            </div></form>';
    }
}


/**
 * @brief Fonction d'affichage du formulaire d'édition d'une classe : ajout ou édition
 * @param tableau contenant les informations classe
 */
function displayFields($tabDisciplineInfos = False) {
    echo 'Nom de la classe :<br />', chr(10);
    echo '<input type="text" name="name" value="';
    if (isset($tabDisciplineInfos[0]['name']))
        echo $tabDisciplineInfos[0]['name'];
    elseif (isset($_POST['name']))
        echo $_POST['name'];
    echo '" size="20" /><br />', chr(10);
    echo '<input id="id_discipline" type="hidden" name="id_discipline" value="';
    if (isset($tabDisciplineInfos[0]['id_discipline']))
        echo $tabDisciplineInfos[0]['id_discipline'];
    elseif (isset($_POST['id_discipline']))
        echo $_POST['id_discipline'];
    echo '" /><br />', chr(10);
}

/**
 * @brief Fonction d'affichage du formulaire d'ajout d'une classe
 */
function displayAddDiscipline() {
    echo '<form action="'.$_SERVER['PHP_SELF'].'?content=manageDiscipline&action=view" method="post" id="addDiscipline">', chr(10);
    displayFields();
    echo '<input type="submit" value="Valider" name="btnVal"/> <input type="reset" value="Effacer" name="btnDiscard" />', chr(10);
    echo '</form>', chr(10);
}

/**
 * @brief Fonction d'affichage des valeurs à vérifier
 */
function displayViewDiscipline() {
        echo 'Nom de la nouvelle discipline : '.$_POST['name'].'<br />', chr(10);
        echo '<input type="hidden" name="name" value ="'.$_POST['name'].'" />';
        echo '<input type="hidden" name="id_discipline" value ="'.$_POST['id_discipline'].'" />';
}

/**
 * @brief Fonction d'affichage du formulaire d'édition d'une classe
 * @param tableau contenant les informations d'une classe
 */
function displayEditDiscipline($tabDisciplineInfos) {
    echo '<form action="'.$_SERVER['PHP_SELF'].'?content=manageDiscipline&action=viewUpdate" method="post" id="editDiscipline">', chr(10);
    displayFields($tabDisciplineInfos);
    // bouton submit
    echo '<input type="submit" value="Valider" name="submit" class="submit" /> <input type="reset" value="Effacer" name="reset" />', chr(10);
    echo '</form>', chr(10);
}
?>
