<?php
/**
 * @author CETIAD Dijon
 * @date Octobre 2011
 * @file manageLevel.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Affichage, recherche et édition des classes
 * @todo empêcher la suppression d'une classe non vide
 * @todo confirmation de suppression non php mais jquery
 * @todo empêcher la réexecution des requêtes si rechargement des pages
 * @todo prise en charge de la pagination ?
 * @todo conformité W3C
 */

?>

<script type="text/javascript" src="./js/lib/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="./js/cdc.tables.js"></script>

<?php
if ($_SESSION['admin']) {
    // protection page admin
    echo '<h2>Gestion des classes</h2>', chr(10);
    if(isset($_GET['action'])&&($_GET['action']=='view')) {
        // affichage des informations pour validation
        displaysubAction("manageLevels");
        echo '<h3>Vérifier les informations</h3>', chr(10);
        $tabAllLevel = Level::selectAllLevel();
		$levelName = $_POST['name'];
		// Protection contre insertion multiple après submit du formulaire
		$compteur = 0;
		foreach ($tabAllLevel as $id => $value) {
			$searchLevelName  = $tabAllLevel[$id]['name'];
			if(strpos($searchLevelName, $levelName) !== false) {
				$compteur = $compteur + 1;
				break;
			}
		}
		if(floor($compteur) == 1){
			// infoboard
			$info = 'Impossible d\'ajouter la classe de <span class=\"bold\"> '.$_POST['name'].' <\/span> car elle existe déjà ! ';
			echo '<script type="text/javascript">';
			echo 'var message = "'.$info.'";';
			echo 'displayInfoboard("warning",message);';
			echo '</script>';
		}
		else{
			echo '<form action="'.$_SERVER['PHP_SELF'].'?content=manageLevel&action=save" method="post">', chr(10);
			displayViewLevel();
			echo '<input type="submit" value="Enregister" name="btnValid"/><br />';
			echo '</form>';
        }
        displayAddLevel();
    }
    elseif(isset($_GET['action'])&&($_GET['action']=='save')) {
		$tabAllLevel = Level::selectAllLevel();
		$levelName = $_POST['name'];
		// Protection contre insertion multiple après submit du formulaire
		$compteur = 0;
		foreach ($tabAllLevel as $id => $value) {
			$searchLevelName  = $tabAllLevel[$id]['name'];
			if(strpos($searchLevelName, $levelName) !== false) {
				$compteur = $compteur + 1;
				break;
			}
		}
		if(floor($compteur) == 1){
			// infoboard
			$info = 'Impossible d\'ajouter la classe de <span class=\"bold\"> '.$_POST['name'].' <\/span> car elle existe déjà ! ';
			echo '<script type="text/javascript">';
			echo 'var message = "'.$info.'";';
			echo 'displayInfoboard("warning",message);';
			echo '</script>';
		}
		else{
			// sauvegarder les informations du nouveau compte dans la base de données
			if ($u->addLevel($_POST['name'])) {
				// infoboard
				$info = 'L\'enregistrement n\'ai pas ajouté';
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("warning",message);';
				echo '</script>';
			}
			else {
				// infoboard
				$info = 'La classe de <span class=\"bold\"> '.$_POST['name'].'  <\/span> a bien été ajouté';
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("info",message);';
				echo '</script>';
			}
        }
        $tabAllLevel = Level::selectAllLevel();
        displaysubAction("addLevel");
        displayAllLevel($tabAllLevel);
    }
    // affichage du formulaire pour saisir les informations du nouvel utilisateur
    elseif(isset($_GET['action'])&&($_GET['action']=='add')) {
        displaysubAction("manageLevels");
        echo '<h3>Ajouter une classe</h3>', chr(10);
        displayAddLevel();
    }
    // affichage du formulaire pour edition des informations de l'utilisateur
    elseif((isset($_GET['action']))&&($_GET['action']=='edit')) {
        displaysubAction("manageLevels");
        $tabAllLevel = Level::selectAllLevel();
        $compteur = 0;
        foreach ($tabAllLevel as $id => $value) {
			if ( $_GET['idLevel'] == $tabAllLevel[$id]['id_level']){
			$compteur = $compteur + 1;
			break;
			}
		}
		if(floor($compteur) == 1){
			$tabLevelInfos = $u->getLevelInfos($_GET['idLevel']);
			echo '<h3>Édition de la classe '.$tabLevelInfos['name'].'</h3>', chr(10);
			displayEditLevel($tabLevelInfos);
		}
		else
			echo '<div id="empty">Aucune classe ne correspond à votre recherche !</div>', chr(10);
    }
    // affichage des informations pour mise à jour
    elseif(isset($_GET['action'])&&($_GET['action']=='viewUpdate')) {
        displaysubAction("manageLevels");
        echo '<h3>Vérifivation des informations</h3>', chr(10);
        $tabAllLevel = Level::selectAllLevel();
        $levelInfos = Level::selectLevel($_POST['id_level']);
        $levelName = $_POST['name'];
        $compteur = 0;
		foreach ($tabAllLevel as $id => $value) {
			$searchLevelName  = $tabAllLevel[$id]['name'];
			if(strpos($searchLevelName, $levelName) !== false) {
				$compteur = $compteur + 1;
				break;
			}
		}
		if(floor($compteur) == 1){
			// infoboard
			$info = 'Impossible de modifier la classe de <span class=\"bold\"> '.$levelInfos[0]['name'].'  <\/span> en <span class=\"bold\"> '.$_POST['name'].' <\/span> car elle existe déjà ! ';
			echo '<script type="text/javascript">';
			echo 'var message = "'.$info.'";';
			echo 'displayInfoboard("warning",message);';
			echo '</script>';
		}
		else{
			echo '<form action="'.$_SERVER['PHP_SELF'].'?content=manageLevel&action=update" method="post">', chr(10);
			displayViewLevel();
			echo '<input type="submit" value="Enregistrer" name="btnValid"/><br />', chr(10);
			echo ' </form>', chr(10);
        }
        displayEditLevel();
    }
    // mise à jour des informations
    elseif(isset($_GET['action'])&&($_GET['action']=='update')) {
        $tabAllLevel = Level::selectAllLevel();
        $levelInfos = Level::selectLevel($_POST['id_level']);
        $levelName = $_POST['name'];
        $compteur = 0;
		foreach ($tabAllLevel as $id => $value) {
			$searchLevelName  = $tabAllLevel[$id]['name'];
			if(strpos($searchLevelName, $levelName) !== false) {
				$compteur = $compteur + 1;
				break;
			}
		}
		if(floor($compteur) == 1){
			// infoboard
			$info = 'Impossible de modifier la classe de <span class=\"bold\"> '.$levelInfos[0]['name'].'  <\/span> en <span class=\"bold\"> '.$_POST['name'].' <\/span> car elle existe déjà ! ';
			echo '<script type="text/javascript">';
			echo 'var message = "'.$info.'";';
			echo 'displayInfoboard("warning",message);';
			echo '</script>';
		}
		else{
			// sauvegarder les informations du nouveau compte dans la base de données
			  if ($u->updateLevelInfos($_POST['name'],$_POST['id_level'])){
				// infoboard
				$info = 'L\'enregistrement n\'a pas été modifié';
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("warning",message);';
				echo '</script>';
			}
			else {
				// infoboard
				$info = 'La classe <span class=\"bold\"> '.$levelInfos[0]['name'].'  <\/span> a bien été modifié en <span class=\"bold\"> '.$_POST['name'].'  <\/span>';
				echo '<script type="text/javascript">';
				echo 'var message = "'.$info.'";';
				echo 'displayInfoboard("info",message);';
				echo '</script>';
			}
        }
        $tabAllLevel = Level::selectAllLevel();
        displaysubAction("addLevel");
        displayAllLevel($tabAllLevel);
    }
    // sinon on affiche la liste des classes
    else {
        // doaction
        if(isset($_POST['postActionLevel'])) {
            // supprimer
            if($_POST['doActionLevel']=="1"){
                foreach ($_POST['idSelect'] as $numTab => $idLevel) {
					$tabAllLevel = Level::selectAllLevel();
					// Protection contre suppression multiple au rafraichissement
					$compteur = 0;
					foreach ($tabAllLevel as $id => $value) {
						if($tabAllLevel[$id]['id_level'] == $idLevel) {
							$compteur = $compteur + 1;
							break;
						}
					}
					if(floor($compteur) == 1){
						$tabAllMemberLevelStudent = $u->selectAllMembership($idLevel,10);
						$tabAllMemberLevelTeacher = $u->selectAllMembership($idLevel,30);
						$levelInfos = Level::selectLevel($idLevel);
						if( (sizeof($tabAllMemberLevelStudent) == 0) && (sizeof($tabAllMemberLevelTeacher) == 0) ) {
							$u->removeLevel($idLevel);
							$info .= 'La classe de <span class=\"bold\"> '.$levelInfos[0]['name'].' <\/span> a bien été supprimée<br />\n';
							// infoboard
							echo '<script type="text/javascript">';
							echo 'var message = "'.$info.'";';
							echo 'displayInfoboard("info",message);';
							echo '</script>';
						}
						else{
							$info .= 'Impossible de supprimer la classe de <span class=\"bold\"> '.$levelInfos[0]['name'].' <\/span> car des utilisateurs y sont affectés.<br />\n';
							// infoboard
							echo '<script type="text/javascript">';
							echo 'var message = "'.$info.'";';
							echo 'displayInfoboard("warning",message);';
							echo '</script>';
							}
					}
					else{
						$info .= 'Aucune classe à supprimer , Veuillez sélectionnér la ou les classes à avant !<br />\n';
						 // infoboard
						echo '<script type="text/javascript">';
						echo 'var message = "'.$info.'";';
						echo 'displayInfoboard("warning",message);';
						echo '</script>';
						}

                }
            }
        }
        $tabAllLevel = Level::selectAllLevel();
        displaysubAction("addLevel");
        if (sizeof($tabAllLevel) != 0) {
            displayAllLevel($tabAllLevel);
        }
        else
            echo '<div id="empty">Il n\'y a aucune classe pour le moment !</div>', chr(10);
    }
} else {
    // non admin
    $page = 'index.php';
    echo '<script language="javascript" type="text/javascript">', chr(10);
    echo '<!--', chr(10);
    echo 'window.location.replace("'.$page.'")', chr(10);
    echo '-->', chr(10);
    echo '</script>';
    exit;
}
//==============================

/**
 * @brief Mise en forme de l'affichage des classes
 */
function displayAllLevel($tabAllLevel) {
    // affichage des libellés des mots du carnet
    echo '<form name="displayLevel" action="'.$_SERVER['PHP_SELF'].'?content=manageLevel" method="post" id="displayLevel">', chr(10);
    echo '<table id="tableAllMessages" summary="Tableau des messages">', chr(10);
    echo '<caption />', chr(10);
    echo '<thead>', chr(10);
    echo '<tr>', chr(10);
    echo '<th></th>', chr(10);
    echo '<th>'.$GLOBALS["titleMessage"]["titleLevelName"].'</th>', chr(10);
    echo '<th>'.$GLOBALS["titleMessage"]["titleStaffStudent"].'</th>', chr(10);
    echo '<th>'.$GLOBALS["titleMessage"]["titleStaffTeacher"].'</th>', chr(10);
    echo '<th>'.$GLOBALS["titleMessage"]["titleClassTeacher"].'</th>', chr(10);
    echo '</tr>', chr(10);
    echo '</thead>', chr(10);
    echo '<tbody>', chr(10);
    // affichage des classes
    if (isset($tabAllLevel)) {
        foreach ($tabAllLevel as $id => $value) {
            echo '<tr>', chr(10);
            echo '<td><input type="checkbox" name="idSelect[]" value="'.$tabAllLevel[$id]['id_level'].'" /></td>', chr(10);
            echo '<td><a href="index.php?content=manageLevel&action=edit&idLevel='.$tabAllLevel[$id]['id_level'].'">'.$tabAllLevel[$id]['name'].'</a></td>', chr(10);
            echo '<td>';
            // effectif des élèves d'une classe
            $effectiveStudent = Level::countStudentInLevel($tabAllLevel[$id]['id_level']);
            echo '<a href="index.php?content=manageMembership&idLevel='.$tabAllLevel[$id]['id_level'].'">'.$effectiveStudent[0]['nbInLevel'].'</a>', chr(10);
            echo '</td>', chr(10);
            echo '<td>';
            // effectif des professeurs d'une classe
            $effectiveTeacher = Level::countTeacherInLevel($tabAllLevel[$id]['id_level']);
            echo '<a href="index.php?content=manageMembership&idLevel='.$tabAllLevel[$id]['id_level'].'">'.$effectiveTeacher[0]['nbInLevel'].'</a>', chr(10);
            echo '</td>', chr(10);
            // noms des profs principaux
            $tabManagerOfLevel = Level::managerOfLevel($tabAllLevel[$id]['id_level']);
            echo '<td>';
            if (sizeof($tabManagerOfLevel)==0)
                echo '<span class="alert">pas de professeur principal</span>';
            else {
                foreach ($tabManagerOfLevel as $id => $value) {
                    echo $tabManagerOfLevel[$id]['firstname'].' '.$tabManagerOfLevel[$id]['lastname'].'<br />',chr(10);
                }
            }
            echo '</td>', chr(10);
            echo '</tr>', chr(10);
        }
        echo '</tbody>', chr(10);
        echo '</table>', chr(10);
        echo '</table><tr><td><input type="checkbox" id="select_all" />Tous sélectionnés</td></tr></table>', chr(10);
        echo '<br />', chr(10);
        echo '<div class="action">Action sur les classes : <select name="doActionLevel">
            <option value="1">'.$GLOBALS["formMessage"]["delete"].'</option>
            </select>
            <input name="postActionLevel" value="Valider" type="submit">
            </div></form>';
    }
}

/**
 * @brief Fonction d'affichage du formulaire d'édition d'une classe : ajout ou édition
 * @param tableau contenant les informations classe
 */
function displayFields($tabLevelInfos = False) {
    echo 'Nom de la classe :<br />', chr(10);
    echo '<input type="text" name="name" value="';
    if (isset($tabLevelInfos['name']))
        echo $tabLevelInfos['name'];
    elseif (isset($_POST['name']))
        echo $_POST['name'];
    echo '" size="20" /><br />', chr(10);
    echo '<input id="id_level" type="hidden" name="id_level" value="';
    if (isset($tabLevelInfos['id_level']))
        echo $tabLevelInfos['id_level'];
    elseif (isset($_POST['id_level']))
        echo $_POST['id_level'];
    echo '" /><br />', chr(10);
}

/**
 * @brief Fonction d'affichage du formulaire d'ajout d'une classe
 */
function displayAddLevel() {
    echo '<form action="'.$_SERVER['PHP_SELF'].'?content=manageLevel&action=view" method="post" id="addLevel">', chr(10);
    displayFields();
    echo '<input type="submit" value="Valider" name="btnVal"/> <input type="reset" value="Effacer" name="btnDiscard" />', chr(10);
    echo '</form>', chr(10);
}

/**
 * @brief Fonction d'affichage des valeurs à vérifier
 */
function displayViewLevel() {
        echo 'Nom de la nouvelle classe : '.$_POST['name'].'<br />', chr(10);
        echo '<input type="hidden" name="name" value ="'.$_POST['name'].'" />';
        echo '<input type="hidden" name="id_level" value ="'.$_POST['id_level'].'" />';
}

/**
 * @brief Fonction d'affichage du formulaire d'édition d'une classe
 * @param tableau contenant les informations d'une classe
 */
function displayEditLevel($tabLevelInfos) {
    echo '<form action="'.$_SERVER['PHP_SELF'].'?content=manageLevel&action=viewUpdate" method="post" id="editLevel">', chr(10);
    displayFields($tabLevelInfos);
    // bouton submit
    echo '<input type="submit" value="Valider" name="submit" class="submit" /> <input type="reset" value="Effacer" name="reset" />', chr(10);
    echo '</form>', chr(10);
}
?>
