<?php
/**
 * @author CETIAD Dijon
 * @date Octobre 2011
 * @file manageRules.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Gère l'affichage des personnes ayant validé ou non le réglement intérieur
 */
?>

<script type="text/javascript" src="./js/lib/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="./js/cdc.tables.js"></script>

<?php
// protection page enseignant
if ($_SESSION['admin']) {
    echo '<h2>Validation du réglement intérieur</h2>', chr(10);
    $tabAllForRulesValidation = $u->selectAllStudentAndResponsibleForRulesValidation();
    displayUsers($tabAllForRulesValidation);
} else {
    $page = 'index.php';
    echo '<script language="javascript" type="text/javascript">', chr(10);
    echo '<!--', chr(10);
    echo 'window.location.replace("'.$page.'")', chr(10);
    echo '-->', chr(10);
    echo '</script>';
    exit;
}

/**
 * @brief Fonction d'affichage des personnes
 * @param tableau contenant toutes personnes devant valider le réglement (élèves et responsables)
 */
function displayUsers($tabAllUsersInfos) {
    echo '<table id="tableAllMessages" summary="Tableau des messages">', chr(10);
    echo '<caption />', chr(10);
    echo '<thead>', chr(10);
    echo '<tr>', chr(10);
    echo '<th>Nom</th>', chr(10);
    echo '<th>Prénom</th>', chr(10);
    echo '<th>Rôle</th>', chr(10);
    echo '<th>Validation</th>', chr(10);
    echo '</tr>', chr(10);
    echo '</thead>', chr(10);
    echo '<tbody>', chr(10);
    // affichage des messages présent dans le carnet
    if (isset($tabAllUsersInfos)) {
        foreach ($tabAllUsersInfos as $id => $value) {
            echo '<tr>', chr(10);
            echo '<td>'.$tabAllUsersInfos[$id]['lastname'].'</td>', chr(10);
            echo '<td>'.$tabAllUsersInfos[$id]['firstname'].'</td>', chr(10);
            echo '<td>'.$tabAllUsersInfos[$id]['grade'].'</td>', chr(10);;
            echo '<td>';
            if ($tabAllUsersInfos[$id]['rules'] == True)
                echo '<span style="display:none;">1</span><img class="icone" src="./images/icons/mail-signed-verified.png" alt="réglement validé" title="réglement validé" />',chr(10);
            else
                echo '<span style="display:none;">0</span><img class="icone" src="./images/icons/mail-signature-unknown.png" alt="réglement non validé" title="réglement non validé" />',chr(10);
            echo '</td>', chr(10);
            echo '</tr>', chr(10);
        }
        echo '</tbody>', chr(10);
        echo '</table>', chr(10);
    }
}

?>
