<?php
/**
 * @author CETIAD Dijon
 * @date Octobre 2011
 * @file manageSuspend.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Gère l'affichage de la suspension du carnet
 */
?>

<script type="text/javascript" src="./js/lib/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="./js/cdc.tables.js"></script>

<?php
// protection page enseignant
if (($_SESSION['profile'] >= 30)&&(SUSPEND == True)) {
    if(isset($_GET['action'])&&($_GET['action']=='listSuspend')) {
        echo '<h2>Carnets suspendus - classe de ' .' '.$_SESSION['selectedNameLevelTeacher'].' </h2>', chr(10);
        displaysubAction("suspend");
        $tabAllInLevel = $u->selectAllInLevel($_SESSION['id_user']);
        // obtenir tous les carnets suspendus
        $tabAllSchoolReportSuspend = $u->selectAllSchoolReportSuspend($_SESSION['selectedIdLevelTeacher']);
        if (sizeof($tabAllSchoolReportSuspend) != 0) {
            displayUsers($tabAllSchoolReportSuspend);
        }
        else
            echo '<div id="empty">Pour le moment aucun carnet n\'est suspendu !</div>', chr(10);
    }
    elseif (!empty($_GET['idSchoolReport'])) {
		$status = SchoolReport::getStatus($_GET['idSchoolReport']);
		// Si le carnet n'est pas suspendu on le suspend
		if($status[0]['status'] == 0)
			$u->suspend($_GET['idSchoolReport'],True);
		else
			$u->suspend($_GET['idSchoolReport'],False);
    }
    // doaction
    elseif(isset($_POST['postSuspend'])) {
        // suspendre
        if($_POST['doSuspend']=="1"){
            foreach ($_POST['idSelect'] as $numTab => $idSchoolReport) {
                //$tabUserInfos = SchoolReport::getOwnerInfos($idSchoolReport);
                $tabSchoolReportInfos = SchoolReport::getStatus($idSchoolReport);
				$tabUserInfos = Student::getUserInfos($tabSchoolReportInfos[0]['id_user']);
                $u->suspend($idSchoolReport,True);
                $info .= 'Le carnet de <span class=\"bold\">'.$tabUserInfos['firstname'].' '.$tabUserInfos['lastname'].'<\/span> a bien été suspendu<br />\n';
            }
            // infoboard
            echo '<script type="text/javascript">';
            echo 'var message = "'.$info.'";';
            echo 'displayInfoboard("info",message);';
            echo '</script>';
        }
        // Rendre
        elseif($_POST['doSuspend']=="2"){
            foreach ($_POST['idSelect'] as $numTab => $idSchoolReport) {
                //$tabUserInfos = SchoolReport::getOwnerInfos($idSchoolReport);
                $tabSchoolReportInfos = SchoolReport::getStatus($idSchoolReport);
				$tabUserInfos = Student::getUserInfos($tabSchoolReportInfos[0]['id_user']);
                $u->suspend($idSchoolReport,False);
                $info .= 'Le carnet de <span class=\"bold\">'.$tabUserInfos['firstname'].' '.$tabUserInfos['lastname'].'<\/span> a bien été rendu<br />\n';
            }
            // infoboard
            echo '<script type="text/javascript">';
            echo 'var message = "'.$info.'";';
            echo 'displayInfoboard("info",message);';
            echo '</script>';
        }
        //echo '<h2>Suspendre un carnet</h2>', chr(10);
        echo '<h2> Suspendre un carnet - classe de ' .' '. $_SESSION['selectedNameLevelTeacher'].' </h2>';
        displaysubAction("suspend");
        $tabAllInLevel = $u->selectAllInLevel($_SESSION['id_user']);
        // obtenir tous les membres d'une classe
        $tabAllMemberLevel = $u->selectAllMemberLevel($_SESSION['selectedIdLevelTeacher'],10);
        if (sizeof($tabAllMemberLevel) != 0) {
            displayUsers($tabAllMemberLevel);
        }
        else
            echo '<div id="empty">Vous n\'avez aucun élève dans votre ou vos classe(s) !</div>', chr(10);
    }
    else {
		if (isset($_SESSION['id_user'])) {
			$tabAllLevelTeacher = $u->selectAllLevelForTeacher($_SESSION['id_user']);
			if($tabAllLevelTeacher){
				if (sizeof($tabAllLevelTeacher) != 0) {
					if (sizeof($tabAllLevelTeacher) == 1) {
						$tabAllUsersInfos = $u->selectAllMemberLevel($tabAllLevelTeacher[0]['id_level'],10);
						$_SESSION['selectedIdLevelTeacher'] = $tabAllLevelTeacher[0]['id_level'];
						$_SESSION['selectedNameLevelTeacher'] = $tabAllLevelTeacher[0]['name'];
						if(count($tabAllUsersInfos)>0){
							echo '<h2> Suspendre un carnet - classe de ' .' '. $tabAllLevelTeacher[0]['name'].' </h2>';
							displaysubAction("allSuspend");
							displayUsers($tabAllUsersInfos);
						}
						else {
							echo '<h2> Suspendre un carnet - classe de ' .' '. $tabAllLevelTeacher[0]['name'].' </h2>';
							displaysubAction("allSuspend");
							echo '<div id="empty">'.$GLOBALS["message"]["nostudentclass"].'</div>', chr(10);
						}
					}
					else {
						if (isset($_POST['selectedIdLevelTeacher'])){
							unset($_SESSION['selectedIdLevelTeacher']);
							unset($_SESSION['selectedNameLevelTeacher']);
							$tabLevelInfos = Level::selectLevel($_POST['selectedIdLevelTeacher']);
							$_SESSION['selectedNameLevelTeacher'] =  $tabLevelInfos[0]['name'];
							echo '<h2> Suspendre un carnet - classe de ' .' '. $tabLevelInfos[0]['name'].' </h2>';
							}
						elseif (isset($_SESSION['selectedIdLevelTeacher']))
							echo '<h2> Suspendre un carnet - classe de ' .' '. $_SESSION['selectedNameLevelTeacher'].' </h2>';
						else{
							//unset($_SESSION['selectedIdLevelTeacher']);
							//unset($_SESSION['selectedNameLevelTeacher']);
							$_SESSION['selectedIdLevelTeacher'] = $tabAllLevelTeacher[0]['id_level'];
							$_SESSION['selectedNameLevelTeacher'] = $tabAllLevelTeacher[0]['name'];
							echo '<h2> Suspendre un carnet - classe de ' .' '. $tabAllLevelTeacher[0]['name'].' </h2>';
							}
						displaysubAction("allSuspend");
						echo '<form name="selectLevelTeacher" method="post" action="'.htmlentities($_SERVER['PHP_SELF']).'?content=suspend">', chr(10);
						echo $GLOBALS["formMessage"]["classes"].' : <br />', chr(10);
						echo '<select name="selectedIdLevelTeacher">', chr(10);
						foreach($tabAllLevelTeacher as $id => $levelTeacher){
							echo '<option value="'.$levelTeacher['id_level'].'"';
							if ((isset($_POST['selectedIdLevelTeacher']))&&($_POST['selectedIdLevelTeacher'] == $levelTeacher['id_level']))
								echo ' selected="selected"';
							elseif ((isset($_SESSION['selectedIdLevelTeacher']))&&($_SESSION['selectedIdLevelTeacher'] == $levelTeacher['id_level']))
								echo ' selected="selected"';
							echo '>';
							echo $levelTeacher['name'];
							echo '</option>', chr(10);
						}
						if($_SESSION['javascript']== "inactif")
							echo '<input type="submit" name="submit" value="Ok"/>', chr(10);
						echo '</select>', chr(10);
						echo '</form>', chr(10);
						if (isset($_POST['selectedIdLevelTeacher'])){
							unset($_SESSION['selectedIdLevelTeacher']);
							//unset($_SESSION['selectedNameLevelTeacher']);
							$_SESSION['selectedIdLevelTeacher'] = $_POST['selectedIdLevelTeacher'];
							$idLevelteacher = $_POST['selectedIdLevelTeacher'];
							}
						elseif (isset($_SESSION['selectedIdLevelTeacher']))
							$idLevelteacher = $_SESSION['selectedIdLevelTeacher'];
						else{
							unset($_SESSION['selectedIdLevelTeacher']);
							unset($_SESSION['selectedNameLevelTeacher']);
							$idLevelteacher = $tabAllLevelTeacher[0]['id_level'];
							}
						$levelInfos = Level::selectLevel($idLevelteacher);
						$tabAllUsersInfos = $u->selectAllMemberLevel($idLevelteacher,10);
						if(count($tabAllUsersInfos)>0){
							displayUsers($tabAllUsersInfos);
						}else {
							echo '<div id="empty">'.$GLOBALS["message"]["nostudentclass"].'</div>', chr(10);
						}
					}
				}
				else {
					echo '<h2> Suspendre un carnet </h2>', chr(10);
					echo '<div id="empty">'.$GLOBALS["message"]["noclass"].'</div>', chr(10);
				}
			}
			else{
				echo '<h2> Suspendre un carnet </h2>', chr(10);
				displaysubAction();
				echo '<div id="empty">Vous ne pouvez suspendre de carnet car vous n\' avez pas de '.$GLOBALS["formMessage"]["classes"].' !</div>', chr(10);
			}
		}
    }
}
else {
    $page = 'index.php';
    echo '<script language="javascript" type="text/javascript">', chr(10);
    echo '<!--', chr(10);
    echo 'window.location.replace("'.$page.'")', chr(10);
    echo '-->', chr(10);
    echo '</script>';
    exit;
}

/**
 * @brief Fonction d'affichage des élèves
 * @param tableau contenant tous les élèves
 */
function displayUsers($tabAllUsersInfos) {
    // @fixme prb de rafraichissement lors d'une suppression
    // affichage des libellés des mots du carnet
    echo '<form name="displaySuspendStudents" action="'.$_SERVER['PHP_SELF'].'?content=suspend" method="post" name="suspendUsers" id="displaySuspendStudents">', chr(10);
    echo '<table id="tableAllMessages" summary="Tableau des messages">', chr(10);
    echo '<caption />', chr(10);
    echo '<thead>', chr(10);
    echo '<tr>', chr(10);
    echo '<th></th>', chr(10);
    echo '<th>Nom</th>', chr(10);
    echo '<th>Prénom</th>', chr(10);
    echo '<th>Classe</th>', chr(10);
    echo '<th>Statut du carnet</th>', chr(10);
    echo '</tr>', chr(10);
    echo '</thead>', chr(10);
    echo '<tbody>', chr(10);
    // affichage des messages présent dans le carnet
    if (isset($tabAllUsersInfos)) {
        foreach ($tabAllUsersInfos as $id => $value) {
            echo '<tr>', chr(10);
            echo '<td><input type="checkbox" name="idSelect[]" value="'.$tabAllUsersInfos[$id]['id_report'].'" /></td>', chr(10);
            echo '<td>'.$tabAllUsersInfos[$id]['lastname'].'</td>', chr(10);
            echo '<td>'.$tabAllUsersInfos[$id]['firstname'].'</td>', chr(10);
            echo '<td>'.$tabAllUsersInfos[$id]['nameLevel'].'</td>', chr(10);
            echo '<td idSchoolReport="'.$tabAllUsersInfos[$id]['id_report'].'">';
            if ($tabAllUsersInfos[$id]['status'] == True)
				echo '<input type="hidden" name="idSchoolReport" value="'.$tabAllUsersInfos[$id]['id_report'].'" /><span style="display:none;">0</span>
				<img class="icone" src="./images/icons/preferences-desktop-user-password.png" alt="rendre ce carnet" title="Rendre le carnet de '.$tabAllUsersInfos[$id]['firstname'].' '.$tabAllUsersInfos[$id]['lastname'].'" id="img-suspend" /><input type="hidden" name="status" value="'.$tabAllUsersInfos[$id]['status'].'" /><input type="hidden" name="nameStudent" value="'.$tabAllUsersInfos[$id]['lastname'].' '.$tabAllUsersInfos[$id]['firstname'].' " />',chr(10);
            else
                echo '<input type="hidden" name="idSchoolReport" value="'.$tabAllUsersInfos[$id]['id_report'].'" /><span style="display:none;">1</span><img class="icone" src="./images/icons/user-identity.png" alt="Suspendre ce carnet" title="Suspendre le carnet de '.$tabAllUsersInfos[$id]['firstname'].' '.$tabAllUsersInfos[$id]['lastname'].'" id="img-nosuspend" /><input type="hidden" name="status" value="'.$tabAllUsersInfos[$id]['status'].'" /><input type="hidden" name="nameStudent" value="'.$tabAllUsersInfos[$id]['lastname'].' '.$tabAllUsersInfos[$id]['firstname'].' " />',chr(10);
            echo '</td>', chr(10);
            echo '</tr>', chr(10);
        }
        echo '</tbody>', chr(10);
        echo '</table>', chr(10);
        echo '</table><tr><td><input type="checkbox" id="select_all" />Sélectionner tout</td></tr></table>', chr(10);
        echo '<br />', chr(10);
        echo '<div class="action">Action sur les utilisateurs : <select name="doSuspend">
            <option value="1">Suspendre</option>
            <option value="2">Rendre</option>
            </select>
            <input name="postSuspend" value="Valider" type="submit">
            </div>
            </form>';
    }
}

?>
