<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file manageUser.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Affichage, recherche et édition des utilisateurs. Désactivation du compte
 * @todo Empêcher l'insertion dans la bdd en cas de rechargement de la page.
 * @todo Vérifier la compatibilité W3C
 * @todo implémenter la fonction de recherche
 * @todo implémenter la fonction de pagination
 * @todo vérifier la sélection d'un checkbox avant submit
 * @todo le mot de passe transit en clair
 * @todo vérification javascript en cas de mise à jour d'un utilisateur ne fonctionne pas
 * @todo jquery : le message date mois au dessus de 12 est en anglais : between
 */
?>
<script type="text/javascript" src="./js/lib/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="./js/cdc.tables.js"></script>
<script type="text/javascript" src="./js/jquery.datepicker-fr.js"></script>
<script type="text/javascript" src="./js/function.datepicker.js"></script>
<script type="text/javascript" src="./js/lib/jquery.ui.datepicker.js"></script>
<?php
// css pour les saisies des date
echo '<link rel="stylesheet" type="text/css" href="./css/jquery.datepicker.css" />', chr(10);
// protection page admin
if ($_SESSION['admin']) {
    echo '<h2>Gestion des utilisateurs</h2>', chr(10);
    // affichage des informations pour validation
    if(isset($_GET['action'])&&($_GET['action']=='view')) {
        echo '<h3>Vérifier les informations</h3>', chr(10);
        echo '<form action="'.$_SERVER['PHP_SELF'].'?content=manageUser&action=save" method="post">', chr(10);
        // Fixe le nombre d'utilisateur à 1 pour éviter d'envoyer à nouveau après le submit
        $_SESSION['selectUser'] = 1;
        displayViewUser();
        echo '<input type="submit" value="Enregistrer" name="btnValid"/><br />', chr(10);
        echo ' </form>', chr(10);
        displayAddUser();
    }
    // sauvegarder les informations du nouveau compte dans la base de données
    elseif(isset($_GET['action'])&&($_GET['action']=='save')) {
        displaysubAction("addUsers");
        echo "<h3>Enregistrement des informations</h3>", chr(10);
        // On verifie qu'on envoie pas le même utlisateur plusieurs fois ( plusieurs submit à la fois)
        $selectUser = $_SESSION['selectUser'];
        $count = count($selectUser);
        if($count == 1){
            // Attribution de la discipline principale d'un enseignant
            if($_POST['id_discipline']){
                if ($u->addUserDiscipline($_POST['login'],$_POST['lastname'],$_POST['firstname'],$_POST['password'],$_POST['email'],$_POST['birth_date'],$_POST['id_profile'],$_POST['enabled'],$_POST['id_discipline'])) {
                // infoboard
                $info = 'L\'enregistrement n\'ai pas ajouté';
                echo '<script type="text/javascript">';
                echo 'var message = "'.$info.'";';
                echo 'displayInfoboard("warning",message);';
                echo '</script>';
                } else {
                    // Ajout terminée pour cet utilisateur
                    unset($_SESSION['selectUser']);
                    // infoboard
                    $info = 'L\'utisateur <span class=\"bold\">'.$_POST['login'].'<\/span> a bien été ajouté';
                    echo '<script type="text/javascript">';
                    echo 'var message = "'.$info.'";';
                    echo 'displayInfoboard("info",message);';
                    echo '</script>';
                }
            }else{
                if ($u->addUser($_POST['login'],$_POST['lastname'],$_POST['firstname'],$_POST['password'],$_POST['email'],$_POST['birth_date'],$_POST['id_profile'],$_POST['enabled'])) {
                    // infoboard
                    $info = 'L\'enregistrement n\'ai pas ajouté';
                    echo '<script type="text/javascript">';
                    echo 'var message = "'.$info.'";';
                    echo 'displayInfoboard("warning",message);';
                    echo '</script>';
                } else {
                    // Ajout terminée pour cet utilisateur
                    unset($_SESSION['selectUser']);
                    // infoboard
                    $info = 'L\'utisateur <span class=\"bold\">'.$_POST['login'].'<\/span> a bien été ajouté';
                    echo '<script type="text/javascript">';
                    echo 'var message = "'.$info.'";';
                    echo 'displayInfoboard("info",message);';
                    echo '</script>';
                }
            }
        }
        else{
            // infoboard
            $info = 'Imposible d\'ajouter l\'utisateur <span class=\"bold\">'.$_POST['login'].'<\/span> car il y est déjà !';
            $type_message = 'warning';
            echo '<script type="text/javascript">';
            echo 'var message = "'.$info.'";';
            echo 'displayInfoboard("warning",message);';
            echo '</script>';
        }
        $tabAllUsersInfos = $u->selectAllUsers();
        displayUsers($tabAllUsersInfos);
    }
    // affichage du formulaire pour saisir les informations du nouvel utilisateur
    elseif((isset($_GET['action']))&&($_GET['action']=='add')) {
        displaysubAction("manageUsers");
        echo '<h3>Ajouter un utilisateur</h3>', chr(10);
        displayAddUser();
    }
    // affichage du formulaire pour edition des informations de l'utilisateur
    elseif((isset($_GET['action']))&&($_GET['action']=='edit')) {
        $tabUserInfos = $u->getUserInfos($_GET['idUser']);
        displaysubAction("manageUsers");
        echo '<h3>Édition du compte '.$tabUserInfos['firstname'].' '.$tabUserInfos['lastname'].'</h3>', chr(10);
        displayEditUser($tabUserInfos);
    }
    // affichage des informations pour mise à jour
    elseif(isset($_GET['action'])&&($_GET['action']=='viewUpdate')) {
        displaysubAction("manageUsers");
        echo '<h3>Vérification des informations</h3>', chr(10);
        echo '<form action="'.$_SERVER['PHP_SELF'].'?content=manageUser&action=update" method="post">', chr(10);
        displayViewUser();
        echo '<input type="submit" value="Enregistrer" name="btnValid"/><br />', chr(10);
        echo ' </form>', chr(10);
        displayAddUser();
    }
    // mise à jour des informations
    elseif(isset($_GET['action'])&&($_GET['action']=='update')) {
        if ($u->updateUserInfos($_POST['login'],$_POST['lastname'],$_POST['firstname'],$_POST['password'],$_POST['email'],$_POST['birth_date'],$_POST['id_profile'],$_POST['enabled'],$_POST['id_user'])){
            // infoboard
            $info = 'L\'enregistrement n\'a pas été modifié';
            echo '<script type="text/javascript">';
            echo 'var message = "'.$info.'";';
            echo 'displayInfoboard("info",message);';
            echo '</script>';
        }
        else {
            // Modification de la matière d'un enseignant
            if($_POST['id_discipline']){
                $tabUserDiscipline = Teacher::selectAllDisciplineForTeacher($_POST['id_user']);
                // Si l'enseignant à déjà une matière au minimum on fait la modification
                if($tabUserDiscipline[0]['id_discipline'])
                    $u->updateDisciplineToTeacher($_POST['id_discipline'],$_POST['id_user'],$tabUserDiscipline[0]['id_discipline']);
                // L'enseignant n'a toujours de discipline alors on attribution sa discipline
                else{
                    $u->addDisciplineToTeacher($_POST['id_user'],$_POST['id_discipline']);
                    }
            }
            // infoboard
            $info = 'L\'utisateur <span class=\"bold\">'.$_POST['firstname'].' '.$_POST['lastname'].'<\/span> a bien été modifié';
            echo '<script type="text/javascript">';
            echo 'var message = "'.$info.'";';
            echo 'displayInfoboard("info",message);';
            echo '</script>';
        }
        $tabAllUsersInfos = $u->selectAllUsers();
        displayUsers($tabAllUsersInfos);
    }
    else {
        // doaction
        if(isset($_POST['postAction'])) {
            // activer
            if($_POST['doAction']=="1"){
                foreach ($_POST['idSelect'] as $numTab => $idUser) {
                    $tabUserInfos = $u->getUserInfos($idUser);
                    $u->enabledUser($idUser,True);
                    $info .= 'Le compte <span class=\"bold\">'.$tabUserInfos['firstname'].' '.$tabUserInfos['lastname'].'<\/span> a bien été activé<br />\n';
                }
                // infoboard
                echo '<script type="text/javascript">';
                echo 'var message = "'.$info.'";';
                echo 'displayInfoboard("info",message);';
                echo '</script>';
            }
            // désactiver
            elseif($_POST['doAction']=="2"){
                foreach ($_POST['idSelect'] as $numTab => $idUser) {
                    $tabUserInfos = $u->getUserInfos($idUser);
                    $u->enabledUser($idUser,False);
                    $info .= 'Le compte <span class=\"bold\">'.$tabUserInfos['firstname'].' '.$tabUserInfos['lastname'].'<\/span> a bien été désactivé<br />\n';
                }
                // infoboard
                echo '<script type="text/javascript">';
                echo 'var message = "'.$info.'";';
                echo 'displayInfoboard("info",message);';
                echo '</script>';
            }
            // supprimer
            elseif($_POST['doAction']=="3"){
                foreach ($_POST['idSelect'] as $numTab => $idUser) {
                    $tabUserInfos = $u->getUserInfos($idUser);
                    //Si l'uitilisateur est un enseignant on retire sa discipline
                    $tabUserDiscipline = Teacher::selectAllDisciplineForTeacher($idUser);
                    if($tabUserDiscipline[0]['id_discipline']){
                        //$u->removeDisciplineToTeacher($idUser,$tabUserDiscipline[0]['id_discipline']);
                    }
                    //Puis suppression de l'utilisateur
                    //$u->removeUser($idUser);
                    $info .= 'L\'utisateur <span class=\"bold\">'.$tabUserInfos['firstname'].' '.$tabUserInfos['lastname'].'<\/span> a bien été supprimé<br />\n';
                }
                // infoboard
                echo '<script type="text/javascript">';
                echo 'var message = "'.$info.'";';
                echo 'displayInfoboard("info",message);';
                echo '</script>';
            }
        }
        displaysubAction("addUsers");
        $tabAllUsersInfos = $u->selectAllUsers();
        if (empty($tabAllUsersInfos))
            echo '<div id="empty">Il n\'y a pas d\'utilisateur !</div>', chr(10);
        else
            displayUsers($tabAllUsersInfos);
    }
}
else {
    $page = 'index.php';
    echo '<script language="javascript" type="text/javascript">', chr(10);
    echo '<!--', chr(10);
    echo 'window.location.replace("'.$page.'")', chr(10);
    echo '-->', chr(10);
    echo '</script>';
    exit;
}

/**
 * @brief Fonction d'affichage des utilisateurs en tableau
 * @param tableau contenant tous les utilisateurs
 */
function displayUsers($tabAllUsersInfos) {
    // affichage des libellés des mots du carnet
    echo '<form name="displayUsers" action="'.$_SERVER['PHP_SELF'].'?content=manageUser&action=displayUsers" method="post" id="displayUsers">', chr(10);
    echo '<table id="tableAllMessages" name="tableAllMessages" summary="Tableau des messages">', chr(10);
    echo '<caption />', chr(10);
    echo '<thead>', chr(10);
    echo '<tr>', chr(10);
    echo '<th></th>', chr(10);
    echo '<th>Nom</th>', chr(10);
    echo '<th>Prénom</th>', chr(10);
    echo '<th>Identifiant</th>', chr(10);
    echo '<th>Profil</th>', chr(10);
    echo '<th>Compte activé</th>', chr(10);
    echo '</tr>', chr(10);
    echo '</thead>', chr(10);
    echo '<tbody>', chr(10);
    // affichage des messages présent dans le carnet
    if (isset($tabAllUsersInfos)) {
        $tab=array();
        foreach ($tabAllUsersInfos as $id => $value) {
            echo '<tr>', chr(10);
            echo '<td><input type="checkbox" name="idSelect[]" value="'.$tabAllUsersInfos[$id]['id_user'].'" /></td>', chr(10);
            echo '<td><a href="index.php?content=manageUser&action=edit&idUser='.$tabAllUsersInfos[$id]['id_user'].'">'.$tabAllUsersInfos[$id]['lastname'].'</a></td>', chr(10);
            echo '<td><a href="index.php?content=manageUser&action=edit&idUser='.$tabAllUsersInfos[$id]['id_user'].'">'.$tabAllUsersInfos[$id]['firstname'].'</a></td>', chr(10);
            echo '<td>'.$tabAllUsersInfos[$id]['login'].'</td>', chr(10);
            echo '<td>'.$tabAllUsersInfos[$id]['grade'].'</td>', chr(10);
            echo '<td>';
            if ($tabAllUsersInfos[$id]['enabled']==0)
                echo '<span style="display:none;">0</span><img class="icone" src="./images/icons/layer-visible-off.png" alt="utilisateur inactif" />', chr(10);
            else
                echo '<span style="display:none;">1</span><img class="icone" src="./images/icons/layer-visible-on.png" alt="utilisateur actif" />', chr(10);
            echo '</td>', chr(10);
            echo '</tr>', chr(10);
        }
        echo '</tbody>', chr(10);
        echo '</table>', chr(10);
        echo '</table><tr><td><input type="checkbox" id="select_all" />Tous sélectionnés</td></tr></table>', chr(10);
        echo '<br />', chr(10);
        echo '<div class="action">Action sur les utilisateurs : <select name="doAction">
            <option value="1">Activer</option>
            <option value="2">Désactiver</option>
            <option value="3">Supprimer</option>
            </select>
            <input name="postAction" value="Valider" type="submit">
            </div></form>';
    }
}

/**
 * @brief Fonction d'affichage du formulaire d'édition d'un utilisateur : ajout ou édition
 * @param tableau contenant les informations utilisateurs
 */
function displayFieldsUser($tabUserInfos = False) {
    echo '<label for="id_user"></label>', chr(10);
    echo '<input id="id_user" type="hidden" name="id_user" value="';
    if (isset($tabUserInfos['id_user']))
        echo $tabUserInfos['id_user'];
    elseif (isset($_POST['id_user']))
        echo $_POST['id_user'];
    echo '" class="required" /><br />', chr(10);
    echo '<label for="firstname">Prénom:</label><br />', chr(10);
    echo '<input id="firstname" type="text" name="firstname" value="';
    if (isset($tabUserInfos['firstname']))
        echo $tabUserInfos['firstname'];
    elseif (isset($_POST['firstname']))
        echo $_POST['firstname'];
    echo '" size="26" /><br />', chr(10);
    echo '<label for="lastname">Nom:</label><br />', chr(10);
    echo '<input id="lastname" type="text" name="lastname" value ="';
    if (isset($tabUserInfos['lastname']))
        echo $tabUserInfos['lastname'];
    elseif (isset($_POST['lastname']))
        echo $_POST['lastname'];
    echo '" size="26" class="required" /><br />', chr(10);
    echo '<label for="login">Login:</label><br />', chr(10);
    echo '<input id="login" type="text" name="login" size="26" value="';
    if (isset($tabUserInfos['login']))
        echo $tabUserInfos['login'];
    elseif (isset($_POST['login']))
        echo $_POST['login'];
    echo '"/><br />', chr(10);
    echo '<label for="password">Mot de passe :</label><br />', chr(10);
    echo '<input id="password" type="password" name="password" size="26" value="';
    if (isset($tabUserInfos['password']))
        echo $tabUserInfos['password'];
    elseif (isset($_POST['password']))
        echo $_POST['password'];
    echo '" /><br />', chr(10);
    echo '<label for="passwordcheck">Vérification du mot de passe :</label><br />', chr(10);
    echo '<input id="passwordcheck" type="password" name="passwordcheck" size="26" value="';
    if (isset($tabUserInfos['passwordcheck']))
        echo $tabUserInfos['passwordcheck'];
    elseif (isset($_POST['passwordcheck']))
        echo $_POST['passwordcheck'];
    echo '" /><br />', chr(10);
    echo '<label for="email">Adresse courriel :</label><br />',chr(10);
    echo '<input id="email" type="text" name="email" size="26" value="';
    if (isset($tabUserInfos['email']))
        echo $tabUserInfos['email'];
    elseif (isset($_POST['email']))
        echo $_POST['email'];
    echo '" class="required email" /><br />', chr(10);
    echo '<label for="profile">Profil utilisateur :</label><br />', chr(10);
    // appel de selectAllProfile méthode static
    $tabAllProfile = Profile::selectAllProfile();
    echo '<select id="profile" name="id_profile">', chr(10);
    echo '<option value="0">Choisir ...</option>', chr(10);
    foreach ($tabAllProfile as $id => $selectValue) {
        echo '<option value="'.$tabAllProfile[$id]['id_profile'].'" ';
        if (isset($tabUserInfos['profile'])) {
            if ($tabUserInfos['profile'] == $tabAllProfile[$id]['id_profile'])
                echo 'selected="selected"';
        }
        elseif (isset($_POST['id_profile'])) {
            if ($_POST['id_profile'] == $tabAllProfile[$id]['id_profile'])
                echo 'selected="selected"';
        }
        echo '>'.$tabAllProfile[$id]['grade'].'</option>', chr(10);
    }
    echo '</select><br />', chr(10);
    if ($tabUserInfos['profile'] >= 30){
        $tabUserDiscipline = Teacher::selectAllDisciplineForTeacher($tabUserInfos['id_user']);
        echo '<label for="matiere"> Matière :</label><br />', chr(10);
        // appel de selectAllDiscipline méthode static
        $tabAllDiscipline = Discipline::selectAllDiscipline();
        echo '<select id="discipline" name="id_discipline">', chr(10);
        echo '<option value="0">Choisir ...</option>', chr(10);
        foreach ($tabAllDiscipline as $id => $selectValue) {
        echo '<option value="'.$tabAllDiscipline[$id]['id_discipline'].'" ';
        if (isset($_POST['id_discipline'])) {
            if ($_POST['id_discipline'] == $tabAllDiscipline[$id]['id_discipline'])
                echo 'selected="selected"';
            }
            elseif(($tabUserDiscipline[0]['id_discipline']) == $tabAllDiscipline[$id]['id_discipline']){
                echo 'selected="selected"';
            }
            echo '>'.$tabAllDiscipline[$id]['name'].'</option>', chr(10);
            }
            echo '</select><br />', chr(10);
    }else{
    echo '<div id="displayDiscipline">',chr(10);
        // appel de selectAllDiscipline méthode static
        $tabAllDiscipline = Discipline::selectAllDiscipline();
        echo ' Matière : <select id="discipline" name="id_discipline">', chr(10);
        echo '<option value="0">Choisir ...</option>', chr(10);
        foreach ($tabAllDiscipline as $id => $selectValue) {
            echo '<option value="'.$tabAllDiscipline[$id]['id_discipline'].'" ';
            if (isset($_POST['id_discipline'])) {
            if ($_POST['id_discipline'] == $tabAllDiscipline[$id]['id_discipline'])
            echo 'selected="selected"';
            }
            echo '>'.$tabAllDiscipline[$id]['name'].'</option>', chr(10);
        }
        echo '</select><br />', chr(10);
        echo '</div>',chr(10);
    }
    // student
    //echo '<p class="masque" name="student">',chr(10);

    //Affichage de la date de naissance en langue française
    echo '<label for="datepicker"> Date de Naissance :</label></ br>', chr(10);
    echo '<input id="datepicker" name="birth_date" title="Entrer la date de naissance" size="10" type="text" value=" ';
    if (isset($tabUserInfos['birth_date'])){
        $birthdate_us = $tabUserInfos['birth_date'];
        list($year, $month, $day) = mb_split("-", $birthdate_us);
        $birthdate_new_fr = $day."-".$month."-".$year;
        echo $birthdate_new_fr;
    }
    elseif (isset($_POST['birth_date'])){
        $currentYear = date("Y");
        $birthdate_us = $_POST['birth_date'];
        list($year, $month, $day) = mb_split("-", $birthdate_us);
        //$birthdate_new_fr = $day."-".$month."-".$year;
        if($currentYear == $year){
            echo NULL;
        }elseif($year>0){
            //$birthdate_new_fr = $day."-".$month."-".$year;
            echo $birthdate_us;
        }else
            echo NULL;
    }
    echo '" />', chr(10);
    echo '<br/>', chr(10);

    // checkbox activation du compte
    echo '<label for="enabled">Activation du compte :</label><br />', chr(10);
    echo '<input type="checkbox" id="enabled" name="enabled"';
    if (isset($tabUserInfos['enabled']))
        echo ' checked="checked"';
    elseif (isset($_POST['enabled']))
        echo ' checked="checked"';
    elseif ((isset($_GET['action']))&&($_GET['action'] == "add"))
        echo ' checked="checked"';
    echo '" />', chr(10);
    echo '<br />', chr(10);
}

/**
 * @brief Fonction d'affichage du formulaire d'ajout d'un utilisateur
 */
function displayAddUser() {
    echo '<form action="'.$_SERVER['PHP_SELF'].'?content=manageUser&action=view" method="post" id="addUser">', chr(10);
    displayFieldsUser();
    // bouton submit
    echo '<input type="submit" value="Valider" name="submit" class="submit" /> <input type="reset" value="Effacer" name="reset" />', chr(10);
    echo '</form>', chr(10);
}

/**
 * @brief Fonction d'affichage du formulaire d'édition d'un utilisateur
 * @param tableau contenant les informations de l'utilisateur
 */
function displayEditUser($tabUserInfos) {
    echo '<form action="'.$_SERVER['PHP_SELF'].'?content=manageUser&action=viewUpdate" method="post" id="editUser">', chr(10);
    displayFieldsUser($tabUserInfos);
    // bouton submit
    echo '<input type="submit" value="Valider" name="submit" class="submit" /> <input type="reset" value="Effacer" name="reset" />', chr(10);
    echo '</form>', chr(10);
}

/**
 * @brief Fonction d'affichage des valeurs à vérifier
 */
function displayViewUser() {
    echo 'Nom : '.$_POST['lastname'].'<br />', chr(10);
    echo 'Prénom : '.$_POST['firstname'].'<br />', chr(10);
    echo 'Login : '.$_POST['login'].'<br />', chr(10);
    echo 'Adresse courriel : '.$_POST['email'].'<br />', chr(10);
    echo 'Mot de passe : ********<br />',chr(10);
    //echo '<span class="masque" name="student">';
    //echo 'Date de naissance : '.$_POST['birth_date'].'<br />', chr(10);
    $birth = $_POST['birth_date'];
    $currentYear = date("Y");
    list($day,$month,$year) = mb_split("-", $birth);
    if($currentYear == $year){
        echo 'Date de naissance : <br />', chr(10);
    }else
    echo 'Date de naissance : '.$_POST['birth_date'].'<br />', chr(10);
    echo '</span>', chr(10);
    if (isset($_POST['id_profile'])) {
        if (($_POST['id_discipline'])){
            $tabProfile = Profile::selectProfile($_POST['id_profile']);
            echo 'Profil : '.$tabProfile[0]['grade'].'<br />', chr(10);
            $tabDiscipline = Discipline::selectDiscipline($_POST['id_discipline']);
            echo 'Matière : '.$tabDiscipline[0]['name'].'<br />', chr(10);
            echo '<input type="hidden" name="id_discipline" value ="'.$_POST['id_discipline'].'" />', chr(10);
            echo '<input type="hidden" name="name_discipline" value ="'.$tabDiscipline[0]['name'].'" />', chr(10);
        }
        else{
            $tabProfile = Profile::selectProfile($_POST['id_profile']);
            echo 'Profil : '.$tabProfile[0]['grade'].'<br />', chr(10);
        }
    }
    echo 'Compte actif : ';
    if (isset($_POST['enabled']))
        echo 'oui';
    else
        echo 'non';
    echo '<br />', chr(10);
    echo '<input type="hidden" name="id_user" value ="'.$_POST['id_user'].'" />', chr(10);
    echo '<input type="hidden" name="login" value ="'.$_POST['login'].'" />', chr(10);
    echo '<input type="hidden" name="lastname" value ="'.$_POST['lastname'].'" />', chr(10);
    echo '<input type="hidden" name="firstname" value ="'.$_POST['firstname'].'" />', chr(10);
    if (!empty($_POST['password'])){
    // encodage et ajout d'un grain de sel
        $passwordEncode = md5(SEL.$_POST['password']);
        echo '<input type="hidden" name="password" value ="'.$passwordEncode.'" />', chr(10);
    }
    //Transformation du format de la date de FR en EN
    if (!empty($_POST['birth_date'])) {
        $birthdate_fr = date("Y-m-d", strtotime($_POST['birth_date']));
        if($birthdate_fr === "2012-02-17"){
            //$birthdate_fr = NULL;
            $birthdate_fr = "9999-01-01";
             echo '<input type="hidden" name="birth_date" value ="'.$birthdate_fr.'" />', chr(10);
        }else{
            //$_POST['birth_date'] = $birthdate_fr;
            echo '<input type="hidden" name="birth_date" value ="'.$birthdate_fr.'" />', chr(10);
        }
    }
    else
        $_POST['birth_date'] = NULL;

    echo '<input type="hidden" name="email" value ="'.$_POST['email'].'" />', chr(10);
    //echo '<input type="text" name="birth_date" value ="'.$_POST['birth_date'].'" />', chr(10);
    echo '<input type="hidden" name="id_profile" value ="'.$_POST['id_profile'].'" />', chr(10);
    if (isset($_POST['enabled']))
        $enabled = True;
    else
        $enabled = False;
    echo '<input type="hidden" name="enabled" value ="'.$enabled.'" />', chr(10);
}
?>
