<?php
/**
 * @author EOLE
 * @date Avril 2012
 * @file newSchoolYear.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief script de préparation à une nouvelle année
 * Script destiné à faire un dump - de vider les données du cdc et à préparer une nouvelle année ( proposition d'import Ldap )
 */

if ($_SESSION['admin']) {
	echo "<h2>Préparation à une nouvelle année</h2>";
	displaysubActionDashboard();
	if (!isset($_POST["submitted"])) {
		// Formulaire de validation pour la nouvelle année
	?>
	<h3>Vous êtes sur le point de démarrer une nouvelle année et de vider les données de la base du CDC de l'année écoulée .</h3>
	<div id="newSchoolYear">
		<form id="form_dump" method="POST" action="#">
		<p id="form_p">
			<img src='./images/ajax-loader.gif' style="display: none;" />
			<input type="submit" name="submitted" value="Démarrer une nouvelle année">
		</p>
		</form>
	</div>
	<?php
	}
	// Lancement du script de dumpet de vidage de la base du cdc
	else {
		/* le dumping avant de commencer une nouvelle année */
		if(dumpCdc()){
			// Sauvegarge des données de l'année antérieur
			dumpCdc();
			echo "<h4>Sauvegarde de toutes les données du cdc de l'année écoulée  ... OK</h4>", chr(10);

			// infoboard
			$info = ' Le démarrage de la nouvelle année a été effectué avec succès !';
			echo '<script type="text/javascript">';
			echo 'var message = "'.$info.'";';
			echo 'displayInfoboard("info",message);';
			echo '</script>';

			/* Suppression de tous les mots de l'année écoulée après le dump */
			deleteMessage();
			echo "<h4>Vidage de tous les mots de la base du cdc ... OK</h4>", chr(10);

			/* Suppression de toutes les infos d'échange entre les émetteurs et les récepteurs des mots de l'année écoulée après le dump */
			deleteBelong();
			echo "<h4>Vidage de toutes les infos d'échange entre les émetteurs et les récepteurs des mots de l'année écoulée de la base du cdc ... OK</h4>", chr(10);

			echo "<h4>Vidage de la base du cdc ... OK :  mise(s) à jour.</h4>";
			echo ' Vous pouvez importer les données d\'un serveur EOLE Scribe vers CDC pour la nouvelle année par <a href="index.php?content=importLdap" class="dashboard">Import LDAP</a>.', chr(10);
			echo '<p><a href="index.php?content=importLdap" class="dashboard"><img src="./images/icons/svn-update.png" alt="'.$GLOBALS["dashboard"]["import"].'" title="'.$GLOBALS["dashboard"]["import"].'" /></a><br/><span><a href="index.php?content=importLdap" class="dashboard">'.$GLOBALS["dashboard"]["import"].'</a></span><p/>', chr(10);
		}
		else{
			// infoboard
			$info = 'La sauvegarde du CDC a échoué' ;
			echo '<script type="text/javascript">';
			echo 'var message = "'.$info.'";';
			echo 'displayInfoboard("warning",message);';
			echo '</script>';
		}
	}
}
else {
    $page = 'index.php';
    echo '<script language="javascript" type="text/javascript">', chr(10);
    echo '<!--', chr(10);
    echo 'window.location.replace("'.$page.'")', chr(10);
    echo '-->', chr(10);
    echo '</script>';
    exit;
}

// ======== Fin du script global dump du cdc ==================================


/**
 * @brief Sauvegarde de la base cdc de l'année écoulée
 * Script de sauvegarde du cdc sur toutes les données de l'année écoulée
 */
function dumpCdc(){
	$db = Connection::getInstance();
	if(!$db){
		throw new MyExeption (ERR_CONNECT_DB);
	}
	//on récupère la liste des tables de la base de données
	$sql = "SHOW TABLES";
	if (DEBUG==True)
		Logger::log('récupèration de la liste des tables du cdc: '.$sql);
	$stmt = $db->prepare($sql);
    if ($stmt === null) {
		throw new MyException ('erreur de préparation à la requête');
	}
	if ($stmt->execute() === false) {
		$stmt->errorInfo();
	}
	$result = $stmt->fetchAll(PDO::FETCH_ASSOC);
	//return $result;
	// Libéllé du contenu du script dump cdc
	$data = '-- CDC SQL Dump -- '."\n";
	$data .='--'."\n";
	$data .= '-- Base de données : `cdc` -- '."\n";
	$data .='--'."\n";
	$data .= '-- --------------------------------------------------------'."\n";
	$data .="\n";
	$tableNames = $result;
	$tableResult = array();
	$count = sizeof($tableNames);
	for ($i=0; $i< $count; $i++){
		$table = $tableNames[$i]['Tables_in_cdc'];
		// on récupère le create table (structure de la table)
		$sql = "SHOW CREATE TABLE $table";
		if (DEBUG==True)
			Logger::log('récupèration de chaque table du cdc: '.$sql);
		$stmt = $db->prepare($sql);
		if ($stmt === null) {
			throw new MyException ('erreur de préparation à la requête');
		}
		if ($stmt->execute() === false) {
			$stmt->errorInfo();
		}
		$result2 = $stmt->fetchAll(PDO::FETCH_ASSOC);
		//array_push($tableResult, $result2);
		// structure de chaque table de la base (Récupéré)
		$tableInfos = $result2[0];
		// On Positionne le pointeur de tableau en fin de tableau
		$lastTableInfo = end($tableInfos);
		//$data .= '-- Structure de la table \''.$table.'\''."\n";
		$data .='--'."\n";
		$data .='-- Structure de la table \''.$table.'\''."\n";
		$data .='--'."\n";
		$data .="\n";
		// Enregistrement de la Structure de la table en cours
		$data .= $lastTableInfo.";\n";
		$data .="\n";
		// On récupère le select table (Contenu de la table)
		$data .='--'."\n";
		$data .='-- Contenu de la table \''.$table.'\''."\n";
		$data .='--'."\n";
		$data .="\n";
		// Requête de récupèration du select table (Contenu de la table)
		$sqlSelect = "SELECT * FROM $table";
		if (DEBUG==True)
			Logger::log('récupèration de tous les enregistrement de table en cours du cdc: '.$sqlSelect);
		$stmt3 = $db->prepare($sqlSelect);
		if ($stmt3 === null) {
			throw new MyException ('erreur de préparation à la requête');
		}
		if ($stmt3->execute() === false) {
			$stmt3->errorInfo();
		}
		$result3 = $stmt3->fetchAll(PDO::FETCH_ASSOC);
		$contentTable = $result3;
		$record = '';
		array_push($tableResult, $result3);
		$tabRecord = array();
		// Tableau qui contiendra chaque ligne de la table en cours
		$tabRows = array();
		// Tableau qui contiendra les entêtes (propiriétés ,clés) de la table en cours
		$tabKeys = array();
		$field = '';
		$fieldKey = '';
		$tabFields = array();
		$tabRecord =$result3;
		/* Récupération des entêtes (propiriétés de chaque tables en cours )*/
		$fieldKey .= '(';
		foreach($tabRecord as $key => $value) {
			array_push($tabKeys, $value);
		}
		// On a juste besoin des clés donc on travaille sur peu importe de le tableau ici on prend le dernier élément du tableau $tabRecord qui aussi un tableau
		$tabKey = end($tabKeys);
		foreach($tabKey as $key => $value) {
			$fieldKey .= '\''.$key.'\',';
		}
		$fieldKey = substr($fieldKey,0,strlen($fieldKey)-1);
		$fieldKey .= ')';
		//----------------------------------------------
		foreach( $tabRecord as $fields) {
			array_push($tabFields, $fields);
		}
		$countFields = sizeof($tabFields);
		// Chaque d'enregistrement
		for ($l=0; $l<$countFields; $l++){
			$tabRows = $tabFields[$l];
			$fieldRow .= '(';
			foreach( $tabRows as $row) {
				$fieldRow .= '\''.$row.'\',';
			}
			// Suppression de la dernière virgule (,)
			$fieldRow = substr($fieldRow,0,strlen($fieldRow)-1);
			//$fieldRow .= '),'."\n";
			$fieldRow .= '),'."\n";
		}
		// substr — Retourne un segment de chaîne ici on enlève les 2 derniers caractères l'aspostrophe et la virgule (',)
		$fieldRow = substr($fieldRow,0,strlen($fieldRow)-3);
		//$field .= '(';
		$field .= $fieldRow;
		$field .= '),';
		// Suppression de la première parathèse ' ( '
		//$field = substr($field,0,1);
		// Suppression de la dernière virgule (,)
		$field = substr($field,0,strlen($field)-1);
		//$record .=  'INSERT INTO \''.$table.'\' VALUES '.$field.'; ';
		$record .='INSERT INTO \''.$table.'\' '.$fieldKey.' VALUES'."\n";
		$record .=''.$field.'; ';
		$record .="\n";
		$data .= $record;
		// On vide le contenu de chaque chaine (table) après insertions ( récupèration des insertions)) pour la table suivante
		$fieldRow = '';
		$field = '';
		$record = '';
		$data .="\n";
		$data .= '-- --------------------------------------------------------'."\n";
		$data .="\n";
	}
	// sauvegarde (dump) dans un fichier .sql avec la date  pour faciliter l'import
	$fichierDump = "sauvegarde_cdc_".date("Ymd-Hi").".sql";
	$fichierDump = fopen($fichierDump, "wb");
	fwrite($fichierDump,$data);
	fclose($fichierDump);
	return $tableResult;
}

/**
* @brief Vidage de la table message
* Suppression de tous les mots de l'année écoulée après le dump
*/
function deleteMessage(){
	//global $compteur_message;
	$db = Connection::getInstance();
	if(!$db){
		throw new MyExeption (ERR_CONNECT_DB);
	}
	$sql = "DELETE FROM message";
	if (DEBUG==True)
		Logger::log('selection d\'un utilisateur : '.$sql);
    $stmt = $db->prepare($sql);
    if ($stmt === null) {
		throw new MyException ('erreur de préparation à la requête');
	}
	if ($stmt->execute() === false) {
		$stmt->errorInfo();
	}
	$result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $count = $stmt->rowCount();
    if (DEBUG == True)
		Logger::log('nombre de ligne renvoyées : '.$count);
    return($result);
}

/**
 * @brief Vidage de la table belong
 * Suppression de toutes les infos d'échange entre les émetteurs et les récepteurs des mots de l'année écoulée après le dump
 */
function deleteBelong(){
	global $compteur_belong;
	$db = Connection::getInstance();
	if(!$db){
		throw new MyExeption (ERR_CONNECT_DB);
	}
	$sql = "DELETE FROM belong";
	if (DEBUG==True)
		Logger::log('selection d\'un utilisateur : '.$sql);
	$stmt = $db->prepare($sql);
    if ($stmt === null) {
		throw new MyException ('erreur de préparation à la requête');
	}
    if ($stmt->execute() === false) {
		$stmt->errorInfo();
    }
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $count = $stmt->rowCount();
    if (DEBUG == True)
    Logger::log('nombre de ligne renvoyées : '.$count);
		return($result);
	//$compteur_belong++;
}

