<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file schoolReport.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Gère l'affichage des mots du carnet
 */
?>

<script type="text/javascript" src="./js/lib/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="./js/cdc.tables.js"></script>

<?php
if (($_SESSION['profile']==20)&&(!isset($_SESSION['adultStudent']))){
	if($_SESSION['infoSchoolReport'] == '') {
		echo '<h2>Carnet de '.$_SESSION['schoolReportFirstname'].'</h2>', chr(10);
		echo '<div id="empty">' .$_SESSION['schoolReportFirstname']. ' '.$GLOBALS["responsible"]["nostudentclass"].'</div>', chr(10);
	} else {
		echo '<h2>Carnet de '.$_SESSION['schoolReportFirstname'].'</h2>', chr(10);
	}
} else {
    if ((isset($_GET['view']))&&($_GET['view']=='notvalidate')) {
        echo '<h2>Mots non validés</h2>', chr(10);
    } else {
        echo '<h2>Votre carnet</h2>', chr(10);
    }
   }
// si demande d'affichage d'un message
if (isset($_POST['displaymessage'])) {
    $message = New Message;
    $oneMessage = $message->getMessage($_POST['id_message']);
    displaysubAction("schoolReport");
    displayOneMessage($oneMessage);
}
// si demande de validation d'un message
elseif (isset($_POST['validation'])) {
    $message = New Message;
    if ($message->validMessage($_POST['id_message'],$_SESSION['id_user'])) {
        $info = 'Le mot n\'a pas été validé correctement';
        $type_message = 'warning';
    } else {
        $info = 'Le mot a été validé';
        $typeMessage = 'info';
    }
    // infoboard
    echo '<script type="text/javascript">';
    echo 'var message = "'.$info.'";';
    echo 'displayInfoboard('.$typeMessage.',message);';
    echo '</script>';

    // Ré-affichage des messages
    displaySchoolReport($schoolReport->getSchoolReport($_SESSION['idSchoolReport']));
}
#elseif ((isset($_POST['voir']))&&($_POST['voir']=='Voir')) {
#    Message::validationMessage($_POST['id_message']);
#    echo 'Le mot a été validé';
#}
// sinon affichage du carnet
else {
    if (($_SESSION['status'] == False)||(SUSPEND==False)) {
        if ((isset($_GET['view']))&&($_GET['view']=='notvalidate')) {
            // affiche les messages non validés du carnet
            displaySchoolReport($schoolReport->getSchoolReportToValidate($_SESSION['idSchoolReport']));
        } else {
            // affiche tous les messages du carnet
            displaySchoolReport($schoolReport->getSchoolReport($_SESSION['idSchoolReport']));
        }
    } else {
        if ($_SESSION['profile']==20)
            echo '<div id="empty">Le carnet de '.$_SESSION['schoolReportFirstname'].' a été suspendu par xxx pour la raison suivante : xxx</div>', chr(10);
        else
            echo '<div id="empty">Votre carnet a été suspendu par xxx pour la raison suivante : xxx</div>', chr(10);
    }
}
// ===================================================
/**
 * @brief Affichage du carnet
 * @param $tabAllMessage tableau des messages
 */
function displaySchoolReport($tabAllMessage) {
	if ($_SESSION['profile'] == 20) {
		if($_SESSION['adultStudent'] == True) {
		displaysubAction("schoolReport");
		if (sizeof($tabAllMessage) != 0) {
			displayAllMessages($tabAllMessage);
		} else {
			echo '<div id="empty">Aucun mot !</div>', chr(10);
		}
    }else{
		if($_SESSION['infoSchoolReport'] == '') {
			echo '<div class="infoSchoolReport"><img class="icone" src="./images/icons/help-about.png"> En attente d\'affectation </div>', chr(10);
		}else {
			displaysubAction("schoolReport");
			if (sizeof($tabAllMessage) != 0) {
				displayAllMessages($tabAllMessage);
			} else {
				echo '<div id="empty">Aucun mot !</div>', chr(10);
			}
		}
		}
    }else {
		displaysubAction("schoolReport");
		if (sizeof($tabAllMessage) != 0) {
			displayAllMessages($tabAllMessage);
		} else {
			echo '<div id="empty">Aucun mot !</div>', chr(10);
		}
    }
}

/**
 * @brief Mise en forme de l'affichage des mots
 */
function displayAllMessages($tabAllMessage) {
    if (isset($tabAllMessage)) {
        echo '<table id="tableAllMessages" summary="Tableau des messages">', chr(10);
        echo '<caption />', chr(10);
        echo '<thead>', chr(10);
        echo '<tr>', chr(10);
        echo '<th>'.$GLOBALS['titleMessage']['titleObject'].'</th>', chr(10);
        echo '<th>'.$GLOBALS['titleMessage']['titleRecipient'].'</th>', chr(10);
        echo '<th>'.$GLOBALS['titleMessage']['titleTransmitter'].'</th>', chr(10);
        echo '<th>'.$GLOBALS['titleMessage']['titleDate'].'</th>', chr(10);
        echo '<th>'.$GLOBALS['titleMessage']['titleValidation'].'</th>', chr(10);
        echo '</tr>', chr(10);
        echo '</thead>', chr(10);
        echo '<tbody>', chr(10);
        foreach ($tabAllMessage as $ceMessage) {
            echo '<tr>', chr(10);
            echo '<td><p class="objet-message">'.$ceMessage['title'].'</p>', chr(10);
            echo '<div class="mcontent">';
            // on coupe le message
            echo cutMessage($ceMessage['content']), chr(10);
            echo '<form action="'.htmlentities($_SERVER['PHP_SELF']).'" method="post">', chr(10);
            echo '<input type="hidden" name="action" value="displaymessage" />', chr(10);
            echo '<input type="hidden" name="id_message" value="'.$ceMessage['id_message'].'" />', chr(10);
            // on affiche un bouton différent si le message est déjà validé ou non @fixme forcement une amélioration à faire
            if (($ceMessage['validation']==0)&&($_SESSION['profile']==20)&&($ceMessage['transmitter'] != $_SESSION['id_user'])) {
                // si l'expéditeur n'est pas l'id de l'utilisateur connecté c'est peut être un autre responsable
                foreach ($_SESSION['tabAllResponsible'] as $idTab => $idResponsible) {
                    if ($ceMessage['transmitter'] == $idResponsible)
                        $in = True;
                    else
                        $in = False;
                }
                if ($in == True)
                    echo '<input type="submit" name="displaymessage" value="'.$GLOBALS['formMessage']['seeotherresponsible'].'"/>', chr(10);
                else
                    echo '<input type="submit" name="displaymessage" value="'.$GLOBALS['formMessage']['toread'].'"/>', chr(10);
            }
            // si l'expediteur est le responsable connecté
            elseif ($ceMessage['transmitter'] == $_SESSION['id_user']) {
                echo '<input type="submit" name="displaymessage" value="'.$GLOBALS['formMessage']['seeyours'].'"/>', chr(10);
            }
            else
                echo '<input type="submit" name="displaymessage" value="'.$GLOBALS['formMessage']['see'].'"/>', chr(10);
            echo '</form>', chr(10);
            echo '</div><!-- mcontent -->';
            echo '</td>', chr(10);
            echo '<td>'.$ceMessage['lastnameRecipient'].' '.$ceMessage['firstnameRecipient'].'</td>', chr(10);
            echo '<td>'.$ceMessage['lastname'].' '.$ceMessage['firstname'].'</td>', chr(10);
            echo '<td>'.$ceMessage['date'].' à '.$ceMessage['time'].' </td>', chr(10);
            echo '<td>', chr(10);
            if ($ceMessage['validation']==0)
                echo '<span style="display:none;">0</span><img class="icone" src="./images/icons/mail-mark-important.png" alt="mot non validé" />', chr(10);
            else {
                echo '<span style="display:none;">1</span><img class="icone" src="./images/icons/dialog-ok.png" alt="mot validé" /><br />', chr(10);
                echo 'validé le '.$ceMessage['v_date'];
                echo ' à '.$ceMessage['v_time'];
            }
            echo '</td>', chr(10);
            echo '</tr>', chr(10);
        }
        echo '</tbody>', chr(10);
        echo '</table>', chr(10);
        echo '<br />', chr(10);
    }
    else
        echo '<div id="empty">Pour le moment le carnet est vide !</div>', chr(10);
}

/**
 * @brief Mise en forme de l'affichage d'un seul mot
 */
function displayOneMessage($oneMessage) {
    $in = False;
    // affichage un message
    if (isset($oneMessage)) {
        // affichage des libellés
        echo '<div class="table">', chr(10);
        echo '<div class="caption"></div>', chr(10);
        echo '<div class="tbody">', chr(10);
        echo '<div class="tr">', chr(10);
        echo '<div class="td1"><span class="title">'.$GLOBALS['titleMessage']['titleObject'].'</span></div>', chr(10);
        echo '<div class="td2"><span class="title">'.$GLOBALS['titleMessage']['titleRecipient'].'</span></div>', chr(10);
        echo '<div class="td3"><span class="title">'.$GLOBALS['titleMessage']['titleTransmitter'].'</span></div>', chr(10);
        echo '<div class="td4"><span class="title">'.$GLOBALS['titleMessage']['titleDate'].'</span></div>', chr(10);
        echo '<div class="tdend"><span class="title">'.$GLOBALS['titleMessage']['titleValidation'].'</span></div>', chr(10);
        echo '</div><!-- fermeture de tr -->', chr(10);
        echo '</div><!-- fermeture de tbody -->', chr(10);
        echo '</div><!-- fermeture de table -->', chr(10);
        foreach ($oneMessage as $id => $value) {
            echo '<div class="table">', chr(10);
            echo '<div class="caption"></div>', chr(10);
            echo '<div class="tbody">', chr(10);
            echo '<div class="tr">', chr(10);
            echo '<div class="td1">'.$oneMessage[$id]['title'].'</div>', chr(10);
            echo '<div class="td2">'.$oneMessage[$id]['firstnameRecipient'].' '.$oneMessage[$id]['lastnameRecipient'].'</div>', chr(10);
            echo '<div class="td3">'.$oneMessage[$id]['firstname'].' '.$oneMessage[$id]['lastname'].' <br/>', chr(10);
            if($oneMessage[$id]['id_profile']>=30){
				$tabUserDiscipline = Teacher::selectAllDisciplineForTeacher($oneMessage[$id]['id_user']);
				if(isset($tabUserDiscipline[0]['id_discipline']))
					echo ' Professeur de : '.$tabUserDiscipline[0]['name'];
				else
					echo ' Pas de matière ' ;
			}
            echo '</div>', chr(10);
            echo '<div class="td4">Le '.$oneMessage[$id]['date'].' à '.$oneMessage[$id]['time'].'</div>', chr(10);
            echo '<div class="tdend">', chr(10);
            if ($oneMessage[$id]['validation']==0)
                echo '<img class="icone" src="./images/icons/mail-mark-important.png" alt="mot non validé" />', chr(10);
            else {
                echo '<img class="icone" src="./images/icons/dialog-ok.png" alt="mot validé" /><br />', chr(10);
                echo 'validé le '.$oneMessage[$id]['v_date'];
                echo ' à '.$oneMessage[$id]['v_time'];
            }
            echo '</div><!-- fermeture de tdend -->', chr(10);
            echo '</div><!-- fermeture de tr -->', chr(10);
            echo '</div><!-- fermeture de tbody -->', chr(10);
            echo '</div><!-- fermeture de table -->', chr(10);
            echo '<br />', chr(10);
            echo '<div class="mcontent">';
            echo '<p>'.$oneMessage[$id]['content'].'</p><br />', chr(10);
            echo '</div>';
            echo '<form action="'.htmlentities($_SERVER['PHP_SELF']).'" method="post">', chr(10);
            echo '<input type="hidden" name="id_message" value="'.$oneMessage[$id]['id_message'].'" />', chr(10);
            // on affiche un bouton différent si le message est déjà validé ou non
            if (($oneMessage[$id]['validation']==0)&&($_SESSION['profile']==20)) {
                if ($oneMessage[$id]['transmitter'] != $_SESSION['id_user']) {
                    // si l'expéditeur n'est pas l'id de l'utilisateur connecté c'est peut être un autre responsable
                    foreach ($_SESSION['tabAllResponsible'] as $idTab => $idResponsible) {
                        if ($oneMessage[$id]['transmitter'] == $idResponsible)
                            $in = True;
                    }
                    if ($in == False)
                        echo '<input type="submit" name="validation" value="'.$GLOBALS['formMessage']['toapprove'].'"/>', chr(10);
                }
            }
            echo '<input type="submit" name="retour" value="'.$GLOBALS['formMessage']['back'].'"/>', chr(10);
            echo '</form>', chr(10);
        }
        echo '<br />', chr(10);
    }
    else
        echo '<div id="empty">Un problème est survenu</div>', chr(10);
}
?>
