<?php
/**
 * @author CETIAD Dijon
 * @date Janvier 2012
 * @file StudentSchoolReport.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Gère l'affichage du carnet d'un élève ou des mots du carnet vu par un professeur
 */
?>

<?php

// si demande d'affichage d'un message
if (isset($_POST['displaymessage'])) {
    $message = New Message;
    $oneMessage = $message->getMessage($_POST['id_message']);
    displayOneMessage($oneMessage);
}
// si demande de validation d'un message
elseif (isset($_POST['validation'])) {
    $message = New Message;
    if ($message->validMessage($_POST['id_message'],$_SESSION['id_user'])) {
        $info = 'Le mot n\'a pas été validé correctement';
        $type_message = 'warning';
    } else {
        $info = 'Le mot a été validé';
        $typeMessage = 'info';
    }
    // infoboard
    echo '<script type="text/javascript">';
    echo 'var message = "'.$info.'";';
    echo 'displayInfoboard('.$typeMessage.',message);';
    echo '</script>';

    // Ré-affichage des messages
    displaySchoolReport($schoolReport->getSchoolReport($_SESSION['idSchoolReport']));
}
    // doaction
elseif(isset($_POST['postSchoolReportAction'])) {
    // activer
    if($_POST['doAction']=="1"){
        // redirection vers l'envoi d'un mot à l'élève dont le carnet est ouvert
       $page = 'index.php?content=addmessage&selectStudent';
       echo '<script language="javascript" type="text/javascript">', chr(10);
       echo '<!--', chr(10);
       echo 'window.location.replace("'.$page.'")', chr(10);
       echo '-->', chr(10);
       echo '</script>';
       // window.location.href = "index.php?content=addmessage&selectStudent";
    }
    elseif($_POST['doAction']=="2"){
		//echo 'procedure de suspension de carnet';
        $tabUserInfos = SchoolReport::getOwnerInfos($_SESSION['schoolReportIdUser']);
        $u->suspend($_SESSION['schoolReportIdUser'],True);
        $info .= 'Le carnet de <span class=\"bold\">'.$_SESSION['schoolReportFirstname'].' '. $_SESSION['schoolReportLastname'].'<\/span> a bien été suspendu<br />\n';
        // infoboard
        echo '<script type="text/javascript">';
        echo 'var message = "'.$info.'";';
        echo 'displayInfoboard("info",message);';
        echo '</script>';
        displaysubAction("viewListSchoolReport");
		echo '<div id="empty">Le carnet a été suspendu</div>', chr(10);
		echo '<div id="actionSchoolReport">', chr(10);
		echo '<form action="index.php?content=viewSchoolReport&action=viewCarnet&idUser=' .$_SESSION['IdUserSelected']. '" method="post">', chr(10);
        //echo 'Action sur l\'élève : <input type="submit" name="makeSchoolReport" value="Rendre ce carnet" />', chr(10);
        echo '<div class="action">Action sur les élèves : <select name="doAction">
            <option value="3">Rendre ce carnet</option>
            </select>
            <input name="postSchoolReportAction" value="Valider" type="submit">
             </div></form>';
        echo '</form>', chr(10);
        echo '</div>', chr(10);
    }
    // Rendre
    elseif($_POST['doAction']=="3"){
		//echo 'procedure de remise de carnet';
        $tabUserInfos = SchoolReport::getOwnerInfos($_SESSION['schoolReportIdUser']);
        $u->suspend($_SESSION['schoolReportIdUser'],False);
        $info .= 'Le carnet de <span class=\"bold\">'.$_SESSION['schoolReportFirstname'].' '. $_SESSION['schoolReportLastname'].'<\/span> a bien été rendu<br />\n';
        // infoboard
        echo '<script type="text/javascript">';
        echo 'var message = "'.$info.'";';
        echo 'displayInfoboard("info",message);';
        echo '</script>';
		// affiche tous les messages du carnet
		// obtenir le statut du carnet en cours
		// création d'un carnet
        $schoolReport = New SchoolReport($_GET['idUser']);
        $status = $schoolReport->getStatus($_SESSION['schoolReportIdUser']);
        $_SESSION['status'] = $status[0]['status'];
		displaySchoolReport($schoolReport->getSchoolReport($_SESSION['schoolReportIdUser']));

    }
}
// Remise du carnet suspendu par un professeur lors de sa visualisation
elseif (isset($_POST['makeSchoolReport'])) {
        $tabUserInfos = SchoolReport::getOwnerInfos($_SESSION['schoolReportIdUser']);
        $u->suspend($_SESSION['schoolReportIdUser'],False);
        $info .= 'Le carnet de <span class=\"bold\">'.$tabUserInfos[0]['firstname'].' '.$tabUserInfos[0]['lastname'].'<\/span> a bien été rendu<br />\n';
        // infoboard
        echo '<script type="text/javascript">';
        echo 'var message = "'.$info.'";';
        echo 'displayInfoboard("info",message);';
        echo '</script>';
		// affiche tous les messages du carnet
		displaySchoolReport($schoolReport->getSchoolReport($_SESSION['schoolReportIdUser']));
}
#elseif ((isset($_POST['voir']))&&($_POST['voir']=='Voir')) {
#    Message::validationMessage($_POST['id_message']);
#    echo 'Le mot a été validé';
#}
// sinon affichage du carnet
else {
    if (($_SESSION['status'] == False)||(SUSPEND==False)) {
		if ((isset($_GET['view']))&&($_GET['view']=='notvalidate')) {
            // affiche les messages non validés du carnet
            displaySchoolReport($schoolReport->getSchoolReportToValidate($_SESSION['schoolReportIdUser']));
        } else {
            // affiche tous les messages du carnet
			displaySchoolReport($schoolReport->getSchoolReport($_SESSION['schoolReportIdUser']));
        }
    } else {
		displaysubAction("viewListSchoolReport");
		echo '<div id="empty">Le carnet a été suspendu par xxx pour la raison suivante : xxx</div>', chr(10);
		echo '<div id="actionSchoolReport">', chr(10);
		echo '<form action="index.php?content=viewSchoolReport&action=viewCarnet&idUser=' .$_SESSION['IdUserSelected']. '" method="post">', chr(10);
        //echo 'Action sur l\'élève : <input type="submit" name="makeSchoolReport" value="Rendre ce carnet" />', chr(10);
        echo '<div class="action">Action sur les élèves : <select name="doAction">
            <option value="3">Rendre ce carnet</option>
            </select>
            <input name="postSchoolReportAction" value="Valider" type="submit">
             </div></form>';
        echo '</form>', chr(10);
        echo '</div>', chr(10);
    }
}
// ===================================================
/**
 * @brief Affichage du carnet
 * @param $tabAllMessage tableau des messages
 */
function displaySchoolReport($tabAllMessage) {
	// Retour à la liste des classe
    displaysubAction("viewListSchoolReport");
    if (sizeof($tabAllMessage) != 0) {
        displayAllMessages($tabAllMessage);
    } else {
        echo '<div id="empty"> Aucun mot pour le moment !</div>', chr(10);
        // Envoi de message à l'élève dont le carnet est ouvert
        echo '<div id="actionSchoolReport">', chr(10);
        echo '<form action="index.php?content=addmessage&selectStudent" method="post">', chr(10);
        echo '<div class="action">Action sur les élèves : <select name="addMessage">
            <option value="3">Ajouter un mot dans ce carnet</option>
            </select>
            <input name="postaddMessage" value="Valider" type="submit">
             </div></form>';
        echo '</form>', chr(10);
        echo '</div>', chr(10);
    }
}


/**
 * @brief Mise en forme de l'affichage des mots
 */
function displayAllMessages($tabAllMessage) {
    if (isset($tabAllMessage)) {
		echo '<form action="index.php?content=viewSchoolReport&action=viewCarnet&idUser=' .$_SESSION['IdUserSelected']. '" method="post">', chr(10);
        echo '<table id="tableAllMessages" summary="Tableau des messages">', chr(10);
        echo '<caption />', chr(10);
        echo '<thead>', chr(10);
        echo '<tr>', chr(10);
        echo '<th>'.$GLOBALS['titleMessage']['titleObject'].'</th>', chr(10);
        echo '<th>'.$GLOBALS['titleMessage']['titleRecipient'].'</th>', chr(10);
        echo '<th>'.$GLOBALS['titleMessage']['titleTransmitter'].'</th>', chr(10);
        echo '<th>'.$GLOBALS['titleMessage']['titleDate'].'</th>', chr(10);
        echo '<th>'.$GLOBALS['titleMessage']['titleValidation'].'</th>', chr(10);
        echo '</tr>', chr(10);
        echo '</thead>', chr(10);
        echo '<tbody>', chr(10);
        foreach ($tabAllMessage as $ceMessage) {
            echo '<tr>', chr(10);
            echo '<td><p class="objet-message">'.$ceMessage['title'].'</p>', chr(10);
            echo '<div class="mcontent">';
            // on coupe le message
            echo cutMessage($ceMessage['content']), chr(10);
           echo '<form action="index.php?content=viewSchoolReport&action=viewCarnet&idUser=' .$_SESSION['IdUserSelected']. '" method="post">', chr(10);
            echo '<input type="hidden" name="action" value="displaymessage" />', chr(10);
            echo '<input type="hidden" name="id_message" value="'.$ceMessage['id_message'].'" />', chr(10);
            // on affiche un bouton différent si le message est déjà validé ou non @fixme forcement une amélioration à faire
            // si l'expediteur est le responsable connecté
            if ($ceMessage['transmitter'] == $_SESSION['id_user']) {
                echo '<input type="submit" name="displaymessage" value="'.$GLOBALS['formMessage']['seeyours'].'"/>', chr(10);
            }
            else
                echo '<input type="submit" name="displaymessage" value="'.$GLOBALS['formMessage']['see'].'"/>', chr(10);
            echo '</form>', chr(10);
            echo '</div><!-- mcontent -->';
            echo '</td>', chr(10);
            echo '<td>'.$ceMessage['lastnameRecipient'].' '.$ceMessage['firstnameRecipient'].'</td>', chr(10);
            echo '<td>'.$ceMessage['lastname'].' '.$ceMessage['firstname'].'</td>', chr(10);
            echo '<td>'.$ceMessage['date'].' à '.$ceMessage['time'].' </td>', chr(10);
            echo '<td>', chr(10);
            if ($ceMessage['validation']==0)
                echo '<span style="display:none;">0</span><img class="icone" src="./images/icons/mail-mark-important.png" alt="mot non validé" />', chr(10);
            else {
                echo '<span style="display:none;">1</span><img class="icone" src="./images/icons/dialog-ok.png" alt="mot validé" /><br />', chr(10);
                echo 'validé le '.$ceMessage['v_date'];
                echo ' à '.$ceMessage['v_time'];
            }
            echo '</td>', chr(10);
            echo '</tr>', chr(10);
        }
        echo '</tbody>', chr(10);
        echo '</table>', chr(10);
       echo '<br />', chr(10);
       echo '<div class="action">Action sur l\'élève : <select name="doAction">
           <option value="1">Ajouter un mot dans ce carnet</option>
           <option value="2">Suspendre ce carnet</option>
           </select>
           <input name="postSchoolReportAction" value="Valider" type="submit">
           </div></form>';
    }
    else
        echo '<div id="empty">Pour le moment le carnet est vide !</div>', chr(10);
}


/**
 * @brief Mise en forme de l'affichage d'un seul mot
 */
function displayOneMessage($oneMessage) {
	// Envoi de message à l'élève dont le carnet est ouvert
    echo '<a href="index.php?content=addmessage&selectStudent"><img class="icone" src="./images/icons/accessories-text-editor.png" title="Ajouter un mot dans son carnet" alt="nouveau message" /></a><br /><br />', chr(10);
    $in = False;
    // affichage un message
    if (isset($oneMessage)) {
        // affichage des libellés
        echo '<div class="table">', chr(10);
        echo '<div class="caption"></div>', chr(10);
        echo '<div class="tbody">', chr(10);
        echo '<div class="tr">', chr(10);
        echo '<div class="td1"><span class="title">'.$GLOBALS['titleMessage']['titleObject'].'</span></div>', chr(10);
        echo '<div class="td2"><span class="title">'.$GLOBALS['titleMessage']['titleRecipient'].'</span></div>', chr(10);
        echo '<div class="td3"><span class="title">'.$GLOBALS['titleMessage']['titleTransmitter'].'</span></div>', chr(10);
        echo '<div class="td4"><span class="title">'.$GLOBALS['titleMessage']['titleDate'].'</span></div>', chr(10);
        echo '<div class="tdend"><span class="title">'.$GLOBALS['titleMessage']['titleValidation'].'</span></div>', chr(10);
        echo '</div><!-- fermeture de tr -->', chr(10);
        echo '</div><!-- fermeture de tbody -->', chr(10);
        echo '</div><!-- fermeture de table -->', chr(10);
        foreach ($oneMessage as $id => $value) {
            echo '<div class="table">', chr(10);
            echo '<div class="caption"></div>', chr(10);
            echo '<div class="tbody">', chr(10);
            echo '<div class="tr">', chr(10);
            echo '<div class="td1">'.$oneMessage[$id]['title'].'</div>', chr(10);
            echo '<div class="td2">'.$oneMessage[$id]['firstnameRecipient'].' '.$oneMessage[$id]['lastnameRecipient'].'</div>', chr(10);
             echo '<div class="td3">'.$oneMessage[$id]['firstname'].' '.$oneMessage[$id]['lastname'].' <br/>', chr(10);
            if($oneMessage[$id]['id_profile']>=30){
				$tabUserDiscipline = Teacher::selectAllDisciplineForTeacher($oneMessage[$id]['id_user']);
				if(isset($tabUserDiscipline[0]['id_discipline']))
					echo ' Professeur de : '.$tabUserDiscipline[0]['name'];
				else
					echo " Pas de matière";
			}
			if($oneMessage[$id]['id_profile']==20)
				echo 'Responsable';
            echo '</div>', chr(10);
            echo '<div class="td4">Le '.$oneMessage[$id]['date'].' à '.$oneMessage[$id]['time'].'</div>', chr(10);
            echo '<div class="tdend">', chr(10);
            if ($oneMessage[$id]['validation']==0)
                echo '<img class="icone" src="./images/icons/mail-mark-important.png" alt="mot non validé" />', chr(10);
            else {
                echo '<img class="icone" src="./images/icons/dialog-ok.png" alt="mot validé" /><br />', chr(10);
                echo 'validé le '.$oneMessage[$id]['v_date'];
                echo ' à '.$oneMessage[$id]['v_time'];
            }
            echo '</div><!-- fermeture de tdend -->', chr(10);
            echo '</div><!-- fermeture de tr -->', chr(10);
            echo '</div><!-- fermeture de tbody -->', chr(10);
            echo '</div><!-- fermeture de table -->', chr(10);
            echo '<br />', chr(10);
            echo '<div class="mcontent">';
            echo '<p>'.$oneMessage[$id]['content'].'</p><br />', chr(10);
            echo '</div>';
            echo '<form action="index.php?content=viewSchoolReport&action=viewCarnet&idUser=' .$_SESSION['IdUserSelected']. '" method="post">', chr(10);
            echo '<input type="hidden" name="id_message" value="'.$oneMessage[$id]['id_message'].'" />', chr(10);
            echo '<input type="submit" name="retour" value="'.$GLOBALS['formMessage']['back'].'"/>', chr(10);
            echo '</form>', chr(10);
        }
        echo '<br />', chr(10);
    }
    else
        echo '<div id="empty">Un problème est survenu</div>', chr(10);
}

?>
