<?php
/**
 * @author CETIAD Dijon
 * @date December 2011
 * @file viewSchoolReport.content.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
  *@brief Gère l'affichage des CDC de tous les élèves suivis par un enseignant
 */
?>

<script type="text/javascript" src="./js/lib/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="./js/cdc.tables.js"></script>
<?php

// protection page enseignant
if (($_SESSION['profile'] >= 30)&&(SUSPEND == True)) {
	if(isset($_GET['action'])&&($_GET['action']=='viewCarnet')) {
		$UserInfos = $u->selectOneStudent($_GET['idUser']);
		$_SESSION['IdUserSelected'] = $UserInfos[0]['id_user'];
		$_SESSION['schoolReportFirstname'] = $UserInfos[0]['firstname'];
		$_SESSION['schoolReportLastname'] = $UserInfos[0]['lastname'];
		/* Vérification des droits pour voir les carnets */
		// Si le professeur enseigne la classe de l'élève
		if($_SESSION['selectedIdLevelTeacher'] == $UserInfos[0]['id_level']){
        // création d'un carnet
        $schoolReport = New SchoolReport($_GET['idUser']);
        $_SESSION['schoolReportIdUser'] = $schoolReport->getIdSchoolReport();
        // obtenir le statut du carnet en cours
        $status = $schoolReport->getStatus($_SESSION['schoolReportIdUser']);
        $_SESSION['status'] = $status[0]['status'];
        echo '<h2>Carnet de '.$_SESSION['schoolReportFirstname'].' '. $_SESSION['schoolReportLastname'].' - ' .$_SESSION['selectedNameLevelTeacher']. ' </h2>', chr(10);
        $unCheck = $schoolReport->getCountUncheck($_SESSION['schoolReportIdUser']);
        //echo '<a href="index.php?view=notvalidate">', chr(10);
        if ($unCheck == 0){
			echo '<div id="infoSchoolReport"><img class="icone" src="./images/icons/help-about.png"> Aucun mot à valider</div>', chr(10);
        } else {
			if ($unCheck > 1){
				echo '<div id="infoSchoolReport"><span style="display:none;">0</span><img class="icone" src="./images/icons/mail-mark-important.png" alt="mot non validé" /> '.$unCheck.' mots non validés dans son carnet</div>';
			} else {
                echo '<div id="infoSchoolReport"><span style="display:none;">0</span><img class="icone" src="./images/icons/mail-mark-important.png" alt="mot non validé" /> '.$unCheck.' mot non validé dans son carnet</div>';
			}
        }
        //echo '</a>', chr(10);
        // on affiche le carnet
        // @fixme revoir toutes les inclusions
        include('studentSchoolReport.content.php');
        }
        else {
			echo '<h2>Carnet de vos élèves</h2>', chr(10);
			displaysubAction("viewListSchoolReport");
			echo '<div id="empty">Vous n\'êtes pas autorisé à voir ce carnet !</div>', chr(10);
        }
    }
    // doaction
	elseif(isset($_POST['postMultipleSchoolReportAction'])) {
		// Envoi de message multiple
		if($_POST['doAction']=="1"){
			// redirection vers l'envoi d'un mot à l'élève dont le carnet est ouvert
			// window.location.href = "index.php?content=addmessage&selectStudent";
			$page = 'index.php?content=addmessage&multipleStudent';
			echo '<script language="javascript" type="text/javascript">', chr(10);
			echo '<!--', chr(10);
			echo 'window.location.replace("'.$page.'")', chr(10);
			echo '-->', chr(10);
			echo '</script>';
		}
		//Suspendre
		elseif($_POST['doAction']=="2"){
			foreach ($_POST['idSelect'] as $numTab => $idSchoolReport) {
                $tabUserInfos = SchoolReport::getOwnerInfos($idSchoolReport);
                $u->suspend($idSchoolReport,True);
                $info .= 'Le carnet de <span class=\"bold\">'.$tabUserInfos[0]['firstname'].' '.$tabUserInfos[0]['lastname'].'<\/span> a bien été suspendu<br />\n';
            }
            // infoboard
            echo '<script type="text/javascript">';
            echo 'var message = "'.$info.'";';
            echo 'displayInfoboard("info",message);';
            echo '</script>';
		}
		// Rendre
		elseif($_POST['doAction']=="3"){
			foreach ($_POST['idSelect'] as $numTab => $idSchoolReport) {
                $tabUserInfos = SchoolReport::getOwnerInfos($idSchoolReport);
                $u->suspend($idSchoolReport,False);
                $info .= 'Le carnet de <span class=\"bold\">'.$tabUserInfos[0]['firstname'].' '.$tabUserInfos[0]['lastname'].'<\/span> a bien été rendu<br />\n';
            }
            // infoboard
            echo '<script type="text/javascript">';
            echo 'var message = "'.$info.'";';
            echo 'displayInfoboard("info",message);';
            echo '</script>';
		}

		echo '<h2> Carnets des élèves de la classe de ' .' '. $_SESSION['selectedNameLevelTeacher'].' </h2>';
			displaysubAction("viewListSchoolReport");
			$tabAllInLevel = $u->selectAllInLevel($_SESSION['id_user']);
			// obtenir tous les membres d'une classe
			$tabAllMemberLevel = $u->selectAllMemberLevel($_SESSION['selectedIdLevelTeacher'],10);
			if (sizeof($tabAllMemberLevel) != 0) {
				displayUsers($tabAllMemberLevel);
			}
			else
				echo '<div id="empty">Vous n\'avez aucun élève dans votre ou vos classe(s) !</div>', chr(10);
    }
    // affichage des carnets de tous les élèves dont l'enseignant est professeur
    else {
		if (isset($_SESSION['id_user'])) {
			$tabAllLevelTeacher = $u->selectAllLevelForTeacher($_SESSION['id_user']);
			if($tabAllLevelTeacher){
				if (sizeof($tabAllLevelTeacher) != 0) {
					if (sizeof($tabAllLevelTeacher) == 1) {
						$tabAllStudentsInfos = $u->selectAllMemberLevel($tabAllLevelTeacher[0]['id_level'],10);
						$_SESSION['selectedIdLevelTeacher'] = $tabAllLevelTeacher[0]['id_level'];
						$_SESSION['selectedNameLevelTeacher'] = $tabAllLevelTeacher[0]['name'];
						if(count($tabAllStudentsInfos)>0){
							echo '<h2> Carnets des élèves de la classe de ' .' '. $tabAllLevelTeacher[0]['name'].' </h2>';
							displaysubAction("studentSchoolReport");
							displayUsers($tabAllStudentsInfos);
						}
						else {
							echo '<h2> Classe de ' .' '. $tabAllLevelTeacher[0]['name'].' </h2>';
							displaysubAction("studentSchoolReport");
							echo '<div id="empty">'.$GLOBALS["message"]["nostudentclass"].'</div>', chr(10);
						}
					}
					else {
						if (isset($_POST['selectedIdLevelTeacher'])){
							unset($_SESSION['selectedIdLevelTeacher']);
							unset($_SESSION['selectedNameLevelTeacher']);
							$tabLevelInfos = Level::selectLevel($_POST['selectedIdLevelTeacher']);
							$_SESSION['selectedIdLevelTeacher'] =  $tabLevelInfos[0]['id_level'];
							$_SESSION['selectedNameLevelTeacher'] =  $tabLevelInfos[0]['name'];
							echo '<h2> Carnets des élèves de la classe de ' .' '. $tabLevelInfos[0]['name'].' </h2>';
							}
						elseif (isset($_GET['idLevel'])){
							unset($_SESSION['selectedIdLevelTeacher']);
							unset($_SESSION['selectedNameLevelTeacher']);
							$tabAllLevel = Level::selectAllLevel();
							foreach($tabAllLevel as $id => $level){
								$compteur = 0;
								if($level['id_level'] == $_GET['idLevel']){
									$compteur = $compteur + 1;
									break;
								}
							}
							if(floor($compteur) == 1){
								$tabLevelInfos = Level::selectLevel($_GET['idLevel']);
							}
							else{
								$tabLevelInfos = Level::selectLevel($tabAllLevelTeacher[0]['id_level']);
							}
							$_SESSION['selectedIdLevelTeacher'] =  $tabLevelInfos[0]['id_level'];
							$_SESSION['selectedNameLevelTeacher'] =  $tabLevelInfos[0]['name'];
							echo '<h2> Carnets des élèves de la classe de ' .' '. $tabLevelInfos[0]['name'].' </h2>';
							}
						elseif (isset($_SESSION['selectedIdLevelTeacher']))
							echo '<h2> Carnets des élèves de la classe de ' .' '. $_SESSION['selectedNameLevelTeacher'].' </h2>';
						else{
							//unset($_SESSION['selectedIdLevelTeacher']);
							//unset($_SESSION['selectedNameLevelTeacher']);
							$_SESSION['selectedIdLevelTeacher'] = $tabAllLevelTeacher[0]['id_level'];
							$_SESSION['selectedNameLevelTeacher'] = $tabAllLevelTeacher[0]['name'];
							echo '<h2> Carnets des élèves de la classe de ' .' '. $tabAllLevelTeacher[0]['name'].' </h2>';
							}
						displaysubAction("addMessagetoLevel");
						echo '<form name="selectLevelTeacher" method="post" action="'.htmlentities($_SERVER['PHP_SELF']).'?content=viewSchoolReport">', chr(10);
						echo $GLOBALS["formMessage"]["classes"].' : <br />', chr(10);
						echo '<select name="selectedIdLevelTeacher">', chr(10);
						foreach($tabAllLevelTeacher as $id => $levelTeacher){
							echo '<option value="'.$levelTeacher['id_level'].'"';
							if ((isset($_POST['selectedIdLevelTeacher']))&&($_POST['selectedIdLevelTeacher'] == $levelTeacher['id_level']))
								echo ' selected="selected"';
							elseif ((isset($_SESSION['selectedIdLevelTeacher']))&&($_SESSION['selectedIdLevelTeacher'] == $levelTeacher['id_level']))
								echo ' selected="selected"';
							echo '>';
							echo $levelTeacher['name'];
							echo '</option>', chr(10);
						}
						if($_SESSION['javascript']== "inactif")
							echo '<input type="submit" name="submit" value="Ok"/>', chr(10);
						echo '</select>', chr(10);
						echo '</form>', chr(10);

						if (isset($_POST['selectedIdLevelTeacher'])){
							unset($_SESSION['selectedIdLevelTeacher']);
							//unset($_SESSION['selectedNameLevelTeacher']);
							$_SESSION['selectedIdLevelTeacher'] = $_POST['selectedIdLevelTeacher'];
							$idLevelteacher = $_POST['selectedIdLevelTeacher'];
							}
						elseif (isset($_SESSION['selectedIdLevelTeacher']))
							$idLevelteacher = $_SESSION['selectedIdLevelTeacher'];
						else{
							unset($_SESSION['selectedIdLevelTeacher']);
							unset($_SESSION['selectedNameLevelTeacher']);
							$idLevelteacher = $tabAllLevelTeacher[0]['id_level'];
							}
						foreach($tabAllLevelTeacher as $id => $levelTeacher){
							$compteur = 0;
							if($levelTeacher['id_level'] == $_SESSION['selectedIdLevelTeacher']){
								$compteur = $compteur + 1;
								break;
							}
						}
						if(floor($compteur) == 1){
							$levelInfos = Level::selectLevel($idLevelteacher);
							$tabAllStudentsInfos = $u->selectAllMemberLevel($idLevelteacher,10);
							if(count($tabAllStudentsInfos)>0){
								displayUsers($tabAllStudentsInfos);
							}else {
								echo '<div id="empty">'.$GLOBALS["message"]["nostudentclass"].'</div>', chr(10);
							}
						}
						else{
							echo '<div id="empty">Vous n\'êtes pas en charge de cette classe donc pas autorisé à voir les carnets !</div>', chr(10);
						}
					}
				}
				else {
					echo '<h2> Carnet de vos élèves </h2>', chr(10);
					echo '<div id="empty">'.$GLOBALS["message"]["noclass"].'</div>', chr(10);
				}
			}
			else{
				echo '<h2> Carnet de vos élèves </h2>', chr(10);
				displaysubAction();
				echo '<div id="empty">Vous ne pouvez voir de carnet car vous n\' avez pas de '.$GLOBALS["formMessage"]["classes"].' !</div>', chr(10);
				//echo '<div id="empty">Vous ne pouvez voir de carnet car vous n\' enseignez aucune discipline !</div>', chr(10);
			}
		}
    }
} else {
    $page = 'index.php';
    echo '<script language="javascript" type="text/javascript">', chr(10);
    echo '<!--', chr(10);
    echo 'window.location.replace("'.$page.'")', chr(10);
    echo '-->', chr(10);
    echo '</script>';
    exit;
}


/**
 * @brief Fonction d'affichage des utilisateurs en tableau
 * @param tableau contenant tous les utilisateurs
 */
 function displayUsers($tabAllStudentsInfos) {
	echo '<form name="viewCarnet" action="'.$_SERVER['PHP_SELF'].'?content=addmessage&multipleStudent" method="post" id="viewCarnet">', chr(10);
    echo '<table id="tableAllMessages" summary="Tableau des messages">', chr(10);
    echo '<caption />', chr(10);
    echo '<thead>', chr(10);
    echo '<tr>', chr(10);
    echo '<th></th>', chr(10);
    echo '<th>Nom</th>', chr(10);
    echo '<th>Prénom</th>', chr(10);
    echo '<th>Classe</th>', chr(10);
    echo '<th>Statut du carnet</th>', chr(10);
    echo '<th>Action</th>', chr(10);
    echo '</tr>', chr(10);
    echo '</thead>', chr(10);
    echo '<tbody>', chr(10);
    if (isset($tabAllStudentsInfos)) {
        foreach ($tabAllStudentsInfos as $id => $value) {
            echo '<tr>', chr(10);
            echo '<td><input type="checkbox" name="idSelect[]" value="'.$tabAllStudentsInfos[$id]['id_user'].'" /></td>', chr(10);
            echo '<td><a href="index.php?content=viewSchoolReport&action=viewCarnet&idUser='.$tabAllStudentsInfos[$id]['id_user'].'">'.$tabAllStudentsInfos[$id]['lastname'].'</a></td>', chr(10);
            echo '<td><a href="index.php?content=viewSchoolReport&action=viewCarnet&idUser='.$tabAllStudentsInfos[$id]['id_user'].'">'.$tabAllStudentsInfos[$id]['firstname'].'</a></td>', chr(10);
            echo '<td>'.$tabAllStudentsInfos[$id]['nameLevel'].'</td>', chr(10);
            echo '<td>';
            if ($tabAllStudentsInfos[$id]['status'] == True)
                echo '<span style="display:none;">0</span><img class="icone" src="./images/icons/preferences-desktop-user-password.png" alt="utilisateur cadenas" title="Carnet suspendu" />',chr(10);
            else
                echo '<span style="display:none;">1</span><img class="icone" src="./images/icons/user-identity.png" alt="utilisateur" title="Carnet non suspendu" />',chr(10);
            echo '</td>', chr(10);
            echo '<td><a href="index.php?content=viewSchoolReport&action=viewCarnet&idUser='.$tabAllStudentsInfos[$id]['id_user'].'"><img class="icone" src="./images/icons/document-preview.png" alt="Suspendre ce carnet " title="Voir le carnet de '.$tabAllStudentsInfos[$id]['firstname'].' '.$tabAllStudentsInfos[$id]['lastname'].' " /></a></td>', chr(10);
            echo '</tr>', chr(10);
        }
        echo '</tbody>', chr(10);
        echo '</table>', chr(10);
        echo '</table><tr><td><input type="checkbox" id="select_all" />Tous sélectionnés</td></tr></table>', chr(10);
        echo '<br />', chr(10);
        /*echo '<div class="action">Action sur les élèves :  <input name="postMultipleSchoolReportAction" value="Ajouter un mot dans ce(s) carnet(s)" type="submit">', chr(10);
        echo '<input type="submit" name="addMessagetoLevel" value="Ajouter un mot à la classe de '.$_SESSION['selectedNameLevelTeacher'].'"/>', chr(10);
        echo ' </div></form>';*/
        echo '<div class="action">Action sur les élèves : <select name="doAction">
            <option value="1">Ajouter un mot dans ce(s) carnet(s)</option>
            </select>
            <input name="postMultipleSchoolReportAction" value="Valider" type="submit">
             </div></form>';
         /*
         echo '<div class="action">Action sur les élèves : <select name="doAction">
            <option value="1">Ajouter un mot dans ce carnet</option>
            <option value="2">Suspendre ce carnet</option>
            <option value="3">Rendre ce carnet</option>
            </select>
            <input name="postMultipleSchoolReportAction" value="Valider" type="submit">
             </div></form>';
        */
    }

}
?>
