<?php
/**
 * @author CETIAD Dijon
 * @date Septembre 2011
 * @file cdc.config.php
 * @version 1.0
 * @copyright GNU Public License, see the LICENSE.txt file
 * @brief Fichier de configuration statique de l'application
 */

/**
 * paramètre de la base de données
 */
$dsn = 'mysql'; // nom du SGBD : MySQL uniquement, aucune BDD fournit pour PostgreSQL
$host = '%%adresse_ip_mysql'; // nom de l'hôte
$base = 'cdc'; // nom de la base
$user = 'cdc'; // nom de l'utilisateur de la base de données
$dbpass="motdepassetemp";
$pass = $dbpass; // mot de passe de l'utilisateur de la base de données

/**
 * authentification
 */
$auth = 'cas'; // sql, cas
$sel='%slurp
%%gen_random(8)%slurp
'; // 8 caractères maximum

/**
 * apparence de l'application
 */
$title = 'Carnet de Correspondance';
$theme='eole'; // vitteaux, cloe, eole
$lang = 'fr'; // fr, en
define("HEADER",True); // True, False : affichage du bandeau d'entête, False pour intégrer dans Envole

/**
 * personnalisation de l'application
 */
define("SUSPEND",True); // True, False : active la fonction de suspension d'un carnet
define("EMAIL",False); // True, False : envoi de courriel pour avertir d'un nouveau message
define("NAME_OF_SENDER","CDC"); // nom de l'expéditeur des courriels
// adresse de l'expéditeur des courriels
%if %%is_defined('domaine_messagerie_etab')
define("EMAIL_OF_SENDER","admin@%%domaine_messagerie_etab");
%else
define("EMAIL_OF_SENDER","admin@domaine.fr");
%end if
date_default_timezone_set('Europe/Paris'); // configuration de de la zone horaire utilisée

/**
 * paramétrage du debug
 */
define("DEBUG",False); // True ou False
// afficher les erreurs à l'écran
define("DEBUG_DISPLAY",False); // True ou False
// erreurs dans un fichier de log
$DEBUG_LOG = False; // True ou False
// chemin du fichier de log
define("DEBUG_PATH", "");
// nom du fichier de log
define("DEBUG_FILE", "cdc.log");

/**
 * OpenLDAP
 */
// Partie à adapter en dico eole pour l'import LDAP

%if %%is_defined("ldap_reader_passfile")
// Adresse du Serveur LDAP 2.4
define("__LDAP_HOST", "%%adresse_ip_ldap");
define("__LDAP_BASE_DN", "%%ldap_base_dn");
define("__LDAP_PORT", "%%ldap_port");
define("__LDAP_USER", "%%ldap_reader");
define("__LDAP_PASS", "%%pwdreader("",%%ldap_reader_passfile)");
%else
%if(%%eolesso_ldap[0] in ("localhost","127.0.0.1"))
define("__LDAP_HOST", "%%adresse_ip_ldap");
%else
define("__LDAP_HOST", "%%eolesso_ldap[0]");
%end if
define("__LDAP_BASE_DN", "%%eolesso_ldap[0].eolesso_base_ldap");
define("__LDAP_PORT", "%%eolesso_ldap[0].eolesso_port_ldap");
define("__LDAP_USER", "%%eolesso_ldap[0].eolesso_ldap_reader");
define("__LDAP_PASS", "%%pwdreader("",%%eolesso_ldap[0].eolesso_ldap_reader_passfile)");
%end if

define("__LDAP_NUM_ETAB", "%%numero_etab");
define("__LDAP_NOM_ACADEMIE", "%%nom_academie");

define("__LDAP_ELEVE_BRANCHE", "ou=local,ou=eleves,ou=utilisateurs,ou=".__LDAP_NUM_ETAB.",ou=".__LDAP_NOM_ACADEMIE.",ou=education");
define("__LDAP_PERS_BRANCHE", "ou=local,ou=personnels,ou=utilisateurs,ou=".__LDAP_NUM_ETAB.",ou=".__LDAP_NOM_ACADEMIE.",ou=education");
define("__LDAP_RESP_BRANCHE", "ou=local,ou=responsables,ou=utilisateurs,ou=".__LDAP_NUM_ETAB.",ou=".__LDAP_NOM_ACADEMIE.",ou=education");
define("__LDAP_GROUP_BRANCHE", "ou=local,ou=groupes,ou=".__LDAP_NUM_ETAB.",ou=".__LDAP_NOM_ACADEMIE.",ou=education");

// Valeur par défaut du champ user.enabled lors de l'import
define("__ENABLED_DEFAULT", True);

/**
 * Ne pas éditer cette section
 */
define("DSN",$dsn);
define("HOST",$host);
define("BASE",$base);
define("USER",$user);
define("PASS",$pass);
define("SEL",$sel);
define("AUTH",$auth);
define("LANG",$lang);
$DEBUGTAB = array(); // tableau global pour loguer les messages

session_name("CDCSession");
?>
