<?php
/********************************************************************************************************/
/* Widget pour posh											*/
/********************************************************************************************************/

//--> Definitions diverses
define ("nbJours", "14");	// Nombre de jours à vérifier pour y consulter la liste des devoirs

//--> Chargement de la session et des inclusions de cdt
session_name("WidgetCdt");
session_start();
require_once('Connections/conn_cahier_de_texte.php');
require_once('inc/functions_inc.php');
require_once('inc/sessions_params.php');

//--> Champs civilités dans le ldap : conversion en chaine de caractères
$ldap_civilite = array(0=>"M./Mme",1=>"M.",2=>"Mme",3=>"Mlle");

//--> Authentification CAS à l'intérieur d'envole
require_once('inc/cas_envole.inc.php');
$attributs = envole_cas_auth();
$profil = $attributs['utilisateur']['profil'][0];



//--> Entête HTML
?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<script type="text/javascript" src="/piwik/envoleTrackeur.js.php?appli=cdt&amp;profil=<?php print $profil ?>"></script>
	<style type="text/css">
		body {
			text-align: left;
			min-width: 100px;
			overflow: auto;
			margin: 5px;
			font-size: 12px;
			font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
		}
		a {
			color: #428BCA;
			text-decoration: none;
			text-decoration: none;
		}
		a:hover {
			text-decoration: underline;
		}
		table {
			border-collapse:collapse;
			width:100%;
		}
		td, th {
			border:1px solid #808080;
			padding: 5px;
		}
		#infobox{
			margin-bottom:10px;
		} 
		 
	</style>
</head>

<body>
<?php
//--> On n'autorise l'affichage que pour les parents (National_2) et les élèves (National_1)
if ($profil!='National_1' and $profil!='National_2')
	print "<div id='infobox'>Seuls les parents et &eacute;l&egrave;ves ont acc&eacute;s au cahier de texte de classe dans cette fen&ecirc;tre</div>\n";
else
{
	//--> Gerer la liste des classes en fonction du profil
	$_SESSION["liste_consultation"] = array();
	// Dans le cas d'un élève, on récupère son identité
	if($profil=='National_1' && isset($attributs['utilisateur']['classe']))
	{
		$classe = $attributs['utilisateur']['classe'][0];
		$id_classe = envole_get_classe($classe);
		if($id_classe)
		{
			$civ_id = intval($attributs['utilisateur']['civil'][0]);
			if(!array_key_exists($civ_id,$ldap_civilite)) $civ_id = 0;
			// suffisant pour l'accés à  sa classe
			$_SESSION["liste_consultation"][$classe] = array("id"=>$id_classe,"eleves"=>array()); 
			// inutile pour un élève mais procédons comme pour un responsable afin de pouvoir afficher son nom dans le cahier de texte
			$_SESSION["liste_consultation"][$classe]["eleves"][] = array
			(
			"nom" => $attributs['utilisateur']['lastname'][0],
			"prenom" => $attributs['utilisateur']['firstname'][0],
			"civilite" => $ldap_civilite[$civ_id]
			);
		}
	}
	// Dans le cas d'un responsable, lister les élèves 
	if($profil=='National_2' && isset($attributs['utilisateur']['eleves']))
	{
		$_SESSION["liste_consultation"] = envole_get_eleves($attributs['utilisateur']['eleves']);
		
	}

	//--> Selection encodage : Pas nécessaire sur 2.3
	#mysql_query("SET NAMES UTF8");

	//--> Connexion à la base de données
	mysql_select_db($database_conn_cahier_de_texte, $conn_cahier_de_texte);

	//--> Scrutation de la liste de consultation
	if(empty($_SESSION["liste_consultation"])) print "<div>Aucune consultation disponible</div>\n";
	else
	{
		// Pour les responsable, on va scruter la liste des classes (si plusieurs enfants dans des classes différentes)
		// Pour les élèves, il n'y a qu'une seule classe
		foreach($_SESSION["liste_consultation"] as $classe=>$infos)
		{
			// Récupération du code classe et du nom de l'élève
			$code_classe=$infos["id"];  
			// Dans le cas d'un responsable, il peut y avoir plusieurs élèves dans la même classe
			for ($x=0; $x < count ($infos["eleves"]) ; $x++)
			{
				$nom_eleve= /*$infos["eleves"][$x]["civilite"] . " " . */ $infos["eleves"][$x]["prenom"] . " " . $infos["eleves"][$x]["nom"];
				//--> Requête sur la base de données
				$query="
				SELECT cdt_travail.t_jour_pointe,cdt_travail.travail,cdt_matiere.nom_matiere FROM `cdt_travail`
				LEFT JOIN cdt_classe ON cdt_travail.classe_ID=cdt_classe.ID_classe
				LEFT JOIN cdt_matiere ON cdt_travail.matiere_ID =cdt_matiere.ID_matiere
				WHERE `t_jour_pointe`>= DATE(CURDATE())  and `t_jour_pointe`< DATE(CURDATE()+ INTERVAL " . nbJours . " DAY) and classe_ID=$code_classe  
				ORDER BY `t_jour_pointe`";
				$travail_db=mysql_query($query,$conn_cahier_de_texte) or die(mysql_error());
				// Affichage
				if (mysql_num_rows($travail_db)==0)
					print "<div id='ingobox'>El&egrave;ve = $nom_eleve </br> Pas de devoirs pr&egrave;vus dans les " . nbJours . " jours &agrave; venir</div>\n";
				else
				{
					// Génère le lien vers le cahier de texte en fonction du profil
					if ($profil=='National_1') $lienCdt = "consultation.php?classe=" . $classe;
					if ($profil=='National_2') $lienCdt = "consulter.php?classe_ID=" . $code_classe;
					?>
					<div id='infobox'>
					El&egrave;ve = <?php print $nom_eleve; ?></br>
					Travail &agrave; faire pour la classe de <?php print $classe; ?> dans les <?php print nbJours; ?> jours &agrave; venir</br>
					<a target="_blank" href="<?php print $lienCdt; ?>">Acc&eacute;der au cahier de texte</a>
					</div>
					
					<table cellpadding="0" cellspacing="0">
						<thead>
							<th  width="15%"><div align="center">Mati&egrave;re</div></td>
							<th width="left"><div align="center">Faire / Revoir </div></td>
						</thead>
						<?php
						while ($row_travail = mysql_fetch_assoc($travail_db)) 
						{
						?>
						<tr>
							<td width="15%" align="center">
								<b><?php print format($row_travail["nom_matiere"]); ?></b>
								<br />
								<span class="date_message""><?php print date_us_to_fr($row_travail["t_jour_pointe"]); ?></span>
							</td>
							<td align="left"><?php print $row_travail["travail"]; ?></td>
						</tr>
						<?php
						}
						?>
					</table>
				<?php
				}
			}
		}
	}
}

//--> Formatage
function format($message)
{
	$carriage_return   = array("\r\n", "\n", "\r");
	$message=utf8_encode($message);
	$message=str_replace($carriage_return,"",$message);
	return $message;
}

//--> Conversion de la date en style francais
function date_us_to_fr($date) 
{
	preg_match("/([0-9]{4})([0-9]{1,2})([0-9]{1,2})/",$date,$regs); 
   	if (isset($regs[3]) && isset($regs[2]) && isset($regs[1])) return($regs[3]."/".$regs[2]."/".$regs[1]); else return("");
}

//--> pied de page HTML
?>
</body>
</html>
