<?php
//envole : script gérant l'authentification adapté pour le CAS avec gestion de la consultation pour les élèves/responsables et création d'un compte pour les autres
session_start();

//profils autorisés et droits associés pour la création des comptes (tous les autres se verront créer un compte bloqué)
$profils = array
	(
	"National_3" => 2, //enseignants
	"National_6" => 0 //direction et vie scolaire : distinction faite par interrogation du ldap puis edu=3 et dir=4
	);

//connexion à la base de données
require_once('../Connections/conn_cahier_de_texte.php');
mysqli_select_db($conn_cahier_de_texte, $database_conn_cahier_de_texte) or die('Echec de connexion &agrave; la base de donn&eacute;es. '.mysqli_error($conn_cahier_de_texte));

//test utilisation d'un mobile (ajout de variables en session)
$detection_mobile = (version_compare(PHP_VERSION,'5.0.0')>=0) ? '../inc/detect_mobile.php' : '../inc/detect_mobile_old.php';
require_once($detection_mobile);

//client CAS + fonctions diverses
require_once('../inc/cas_envole.inc.php');

//authentification et récupération des informations de l'utilisateur
$attributs = envole_cas_auth();

//test sur un attribut particulier pour vérifier la bonne application du filtre par le serveur CAS
if(!isset($attributs['utilisateur']['profil'])) die("Probl&egrave;me de connexion : le serveur d&rsquo;authentification n&rsquo;a pas renvoy&eacute; les informations attendues.<br/>Veuillez r&eacute;essayer ult&eacute;rieurement.");

//lecture de la table cdt_params (nom etablissement, url ..) : déclaration de variables de session (à l'origine dans index.php)
require_once('../inc/sessions_params.php');

$login = $attributs['utilisateur']['user'][0];
$profil = $attributs['utilisateur']['profil'][0];

$GoTo = '';
$ldap_civilite = array(0=>"M./Mme",1=>"M.",2=>"Mme",3=>"Mlle");
if($profil=='administrateur') $login = 'Administrateur'; //repérer l'administrateur et lui donner le login d'administration du cdt
elseif(isset($_SESSION['site_ferme']) && $_SESSION['site_ferme']!='Non') $GoTo = '../index.php?envole_logout=7';
elseif($profil=='National_1' || $profil=='National_2') //redirection pour les élèves et les parents
	{
	$_SESSION["liste_consultation"] = array();
	$path_consultation = (!empty($_SESSION['mobile_browser']) && $_SESSION['mobile_browser']==true) ? "../mobile/" : "../";
	if($profil=='National_1' && isset($attributs['utilisateur']['classe']))
		{
		$classe = $attributs['utilisateur']['classe'][0];
		$id_classe = envole_get_classe($classe);
		if($id_classe)
			{
			$civ_id = intval($attributs['utilisateur']['civil'][0]);
			if(!array_key_exists($civ_id,$ldap_civilite)) $civ_id = 0;
			$_SESSION["liste_consultation"][$classe] = array("id"=>$id_classe,"eleves"=>array()); //suffisant pour l'accès à sa classe
			//inutile pour un élève mais procédons comme pour un responsable
			$_SESSION["liste_consultation"][$classe]["eleves"][] = array
				(
				"login" => $login,
				"nom" => $attributs['utilisateur']['lastname'][0],
				"prenom" => $attributs['utilisateur']['firstname'][0],
				"civilite" => $ldap_civilite[$civ_id]
				);
			$GoTo = $path_consultation.'consulter.php?classe_ID='.$id_classe;
			$_SESSION['consultation'] = $id_classe;
			}
		}
	elseif($profil=='National_2' && isset($attributs['utilisateur']['eleves']))
		{
		$_SESSION["liste_consultation"] = envole_get_eleves($attributs['utilisateur']['eleves']);
		$total_classes = count($_SESSION["liste_consultation"]);
		if(isset($_GET["classe"]) && array_key_exists($_GET["classe"],$_SESSION["liste_consultation"])) //accès direct
			{
			$classe = $_GET["classe"];
			$id_classe = $_SESSION["liste_consultation"][$classe]["id"];
			$GoTo = $path_consultation.'consulter.php?classe_ID='.$id_classe;
			$_SESSION['consultation'] = $id_classe;
			}
		elseif(!empty($_SESSION["liste_consultation"]))
			{
			if($total_classes==1)
				{
				$classe = current($_SESSION["liste_consultation"]);
				$id_classe = $classe["id"];
				$GoTo = $path_consultation.'consulter.php?classe_ID='.$id_classe;
				$_SESSION['consultation'] = $id_classe;
				}
			else $GoTo = '../index.php'; //la liste des cahiers de textes disponibles sera affichée
			}
		}
	if($GoTo=='') $GoTo = '../index.php?envole_logout=2';
	}
else //insérer si besoin l'utilisateur dans la table cdt_prof
	{
	//vérification de l'existence du compte
	$query_prof = "SELECT * FROM cdt_prof WHERE nom_prof='".$login."' LIMIT 1;";
	$result_prof = mysqli_query($conn_cahier_de_texte, $query_prof) or die(mysqli_error($conn_cahier_de_texte));
	if(mysqli_num_rows($result_prof)==0)
		{
		$ldap_nom = $attributs['utilisateur']['lastname'][0];
		$civ_id = intval($attributs['utilisateur']['civil'][0]);
		if(!array_key_exists($civ_id,$ldap_civilite)) $civ_id = 0;
		$nom = $ldap_civilite[$civ_id]." ".strtoupper($ldap_nom);
		if($profil=='National_6') //administratifs
			{
			$sous_profil = envole_get_service($login);
			$droits = ($sous_profil=="edu") ? 3 : ($sous_profil=="dir" ? 4 : 0);
			}
		elseif(array_key_exists($profil,$profils)) $droits = $profils[$profil];
		else $droits = 0; //compte créé mais bloqué

		//création du compte avec un mot de passe quelconque car inutilisé
		$query_insert = "INSERT INTO cdt_prof (nom_prof,passe,identite,droits) VALUES ('".$login."','".md5($login.$nom)."','".$nom."',".$droits.")";

		if(!mysqli_query($conn_cahier_de_texte,$query_insert)) $GoTo = '../index.php?envole_logout=1';
		elseif($droits==0) $GoTo = '../index.php?envole_logout=3';
		}
	mysqli_free_result($result_prof);
	}
/*
else //utilisateur authentifié mais profil non autorisé
	{
	header("Location: ../index.php?envole_logout=4");
	exit();
	}
*/


if(!empty($GoTo))
	{
	header(sprintf("Location: %s",$GoTo));
	exit();
	}

//à ce stade, on reprend la suite du traitement effectué dans le fichier original : variables mises en session et redirection appropriée
$query_RsProf = sprintf("SELECT * FROM cdt_prof WHERE nom_prof='%s'", $login);

$RsProf = mysqli_query($conn_cahier_de_texte, $query_RsProf) or die(mysqli_error($conn_cahier_de_texte));
$row_RsProf = mysqli_fetch_assoc($RsProf);

mysqli_free_result($RsProf);
//mot de passe ok


$_SESSION['last_access']=time();
$_SESSION['ipaddr']=$_SERVER['REMOTE_ADDR'];
$_SESSION['ID_prof'] = $row_RsProf['ID_prof'];
$_SESSION['nom_prof'] = $row_RsProf['nom_prof'];

// Les if permettent de rentrer pour les mises a jour

	if (isset($row_RsProf['identite'])){
	if ($row_RsProf['identite']==NULL){$_SESSION['identite'] = $row_RsProf['nom_prof'];} else {$_SESSION['identite']=$row_RsProf['identite'];};
	}	else {$_SESSION['identite']=$row_RsProf['nom_prof'];};

	if (isset($row_RsProf['email'])){$_SESSION['email'] = $row_RsProf['email'];};
	if (isset($row_RsProf['droits'])){$_SESSION['droits'] = $row_RsProf['droits'];};
	if (isset($row_RsProf['publier_cdt'])){$_SESSION['publier_cdt'] = $row_RsProf['publier_cdt'];};
	if (isset($row_RsProf['publier_travail'])){$_SESSION['publier_travail'] = $row_RsProf['publier_travail'];};
	if (isset($row_RsProf['stop_cdt'])){$_SESSION['stop_cdt'] = $row_RsProf['stop_cdt'];};
	if (isset($row_RsProf['date_maj'])){$_SESSION['date_visa'] = $row_RsProf['date_maj'];};
	if (isset($row_RsProf['path_fichier_perso'])){$_SESSION['path_fichier_perso'] = $row_RsProf['path_fichier_perso'];};
	if (isset($row_RsProf['xinha_editlatex'])){$_SESSION['xinha_editlatex'] = $row_RsProf['xinha_editlatex'];};
	if (isset($row_RsProf['xinha_equation'])){$_SESSION['xinha_equation'] = $row_RsProf['xinha_equation'];};
	if (isset($row_RsProf['xinha_stylist'])){$_SESSION['xinha_stylist'] = $row_RsProf['xinha_stylist'];};
	if (isset($row_RsProf['acces_rapide'])){$_SESSION['acces_rapide'] = $row_RsProf['acces_rapide'];};
	if (isset($row_RsProf['afficher_messages'])){$_SESSION['afficher_messages'] = $row_RsProf['afficher_messages'];};
	if (isset($row_RsProf['masque_edt_cloture'])){$_SESSION['masque_edt_cloture'] = $row_RsProf['masque_edt_cloture'];};
	if (isset($row_RsProf['id_etat'])){$_SESSION['id_etat'] = $row_RsProf['id_etat'];};
	if (isset($row_RsProf['id_remplace'])){$_SESSION['id_remplace'] = $row_RsProf['id_remplace'];};
	if (isset($row_RsProf['date_declare_absent'])){$_SESSION['date_declare_absent'] = $row_RsProf['date_declare_absent'];};
	if (isset($row_RsProf['type_affich'])){$_SESSION['type_affich'] = $row_RsProf['type_affich'];};


//depublier les messages dont la date de fin de publication est echue
require_once('../inc/depublier_messages.php');

if (isset($row_RsProf['droits'])){
switch ($row_RsProf['droits']) {
case 0:
    header("Location: ../index.php?envole_logout=3");
    break;
case 1:
    header("Location: ../administration/index.php");
    break;
case 2:// enseignant -  si id_etat = 2 et id_remplace=0 alors c'est un suppleant qui a fini son remplacement
case 8:// documentaliste
    if ($row_RsProf['stop_cdt']=='O'){
	header("Location: stop_enseignant.php");exit;}
	elseif ($row_RsProf['id_etat']=='2' && $row_RsProf['id_remplace']=='0')
	{header("Location: ../index.php?envole_logout=11");}
	else {


	if ($_SESSION['acces_rapide']=='O'){header("Location: ../enseignant/ecrire.php?date=".date('Ymd'));exit;} else {header("Location: ../enseignant/enseignant.php");exit;};
	}
    break;
case 3:
    header("Location: ../vie_scolaire/vie_scolaire.php");exit;
    break;
case 4:
    header("Location: ../direction/direction.php");exit;
    break;
case 5:
    header("Location: ../invite/invite.php");exit;
    break;
case 6:
    header("Location: ../assistant_education/assistant_educ.php");exit;
    break;
case 7: //periscolaire
    header("Location: ../vie_scolaire/vie_scolaire.php");exit;
    break;

default:
    header("Location: ../index.php?envole_logout=3");}
} else // cas avant mise a jour 304
{
if ($_SESSION['nom_prof']=='Administrateur') {
$_SESSION['droits']=1; //pour la mise  jour
header("Location: ../administration/index.php");exit;} else {header("Location: ../enseignant/enseignant.php");exit;};
}

?>
