<?php


session_start();
require_once('Connections/conn_cahier_de_texte.php');
require_once('inc/functions_inc.php');
require_once('inc/cas_envole.inc.php');
require_once('inc/sessions_params.php');

$ldap_civilite = array(0=>"M./Mme",1=>"M.",2=>"Mme",3=>"Mlle");
$attributs = envole_cas_auth();
if ($profil=='National_1' || $profil=='National_2')
{
    $_SESSION["liste_consultation"] = array();
}
$profil = $attributs['utilisateur']['profil'][0];

# Pour le moment que le profil responsable et eleve est géré
if ($profil!='National_1' and $profil!='National_2')
{
    die("");
}

if($profil=='National_1' && isset($attributs['utilisateur']['classe']))
{
    $classe = $attributs['utilisateur']['classe'][0];
    $id_classe = envole_get_classe($classe);
    if($id_classe)
    {
	$civ_id = intval($attributs['utilisateur']['civil'][0]);
        if(!array_key_exists($civ_id,$ldap_civilite)) $civ_id = 0;
        $_SESSION["liste_consultation"][$classe] = array("id"=>$id_classe,"eleves"=>array()); //suffisant pour l'accÃ¨s Ã  sa classe
            //inutile pour un Ã©lÃ¨ve mais procÃ©dons comme pour un responsable
        $_SESSION["liste_consultation"][$classe]["eleves"][] = array
                (
                "nom" => $attributs['utilisateur']['lastname'][0],
                "prenom" => $attributs['utilisateur']['firstname'][0],
                "civilite" => $ldap_civilite[$civ_id]
                );
    }
}
elseif($profil=='National_2' && isset($attributs['utilisateur']['eleves']))
{
    $_SESSION["liste_consultation"] = envole_get_eleves($attributs['utilisateur']['eleves']);
}


function postData($type,$message,$count=-1,$link="")
{
  echo "<html><body>";
  echo "<form id='form2submit' name='form2submit' method='POST' action='".$_GET["callback"]."'>";
  echo "<input name='id' id='id' type='hidden' value='".$_GET["id"]."' />";
  if ($count!= -1)
  {
    echo "<input name='count' id='count' type='hidden' value='".$count."' />";
  }
  echo "<input name='type' id='type' type='hidden' value='"."$type"."' />";
  echo "<input name='link' id='type' type='hidden' value='"."$link"."' />";
  echo "<input name='message' id='message' type='hidden' value='".htmlentities($message,ENT_QUOTES,"UTF-8")."' />";
  echo "</form>";
  echo "<script>";
  echo "document.form2submit.submit();";
  echo "</script>";
  echo "</body></html>";
  die();
}


function format($message)
{
	$carriage_return   = array("\r\n", "\n", "\r");
	$message=utf8_encode($message);
	$message=str_replace($carriage_return,"",$message);
	return $message;
}


#mysqli_query("SET NAMES UTF8"); # Pas nécessaire sur 2.3
mysqli_select_db($database_conn_cahier_de_texte, $conn_cahier_de_texte);

$travaux=array();

if(!empty($_SESSION["liste_consultation"]))
{
    foreach($_SESSION["liste_consultation"] as $classe=>$infos)
    {
        $code_classe=$infos["id"];
        $query="
SELECT cdt_travail.t_jour_pointe,cdt_travail.travail,cdt_matiere.nom_matiere FROM `cdt_travail`
LEFT JOIN cdt_classe ON cdt_travail.classe_ID=cdt_classe.ID_classe
LEFT JOIN cdt_matiere ON cdt_travail.matiere_ID =cdt_matiere.ID_matiere
WHERE `t_jour_pointe`>= DATE(CURDATE())  and `t_jour_pointe`< DATE(CURDATE()+ INTERVAL 3 DAY) and classe_ID=$code_classe  ORDER BY `t_jour_pointe`
";
        $travail_db=mysqli_query($conn_cahier_de_texte, $query) or die(mysqli_error($conn_cahier_de_texte));

        while ($row_travail = mysqli_fetch_assoc($travail_db)) {
	    $travail=array();
	    $travail["jour"]=$row_travail["t_jour_pointe"];
	    $travail["matiere"]=format($row_travail["nom_matiere"]);
	    $travail["travail"]=format($row_travail["travail"]);
	    array_push($travaux,$travail);
        }
    }
}

if(isset($_GET["format"]) and $_GET["format"]=="json")
{
	die(json_encode($travaux));
}

// Pas de travail, on ne fait rien
if (sizeof($travaux)==0)
{
   die("aucun travail");
}


// formatage html
$jour="";
$message="<titre class='fluo'>Travail pour les 2 prochains jours</titre><br /><div class='travail' style='font-size:0.8em'>";
// Le css se fera via un css
//$message=$message."<style>p { line-height:17px;margin:5px; } matiere {display:block;font-size:1.2em;font-weight:bold;color:black} jour { font-size:1.2em; color:#500; display:block;margin-left:-20px;}</style>";
foreach($travaux as $travail)
{
	if ($travail["jour"]!=$jour)
	{
		$a=strptime($travail["jour"],"%Y%m%d");
		$timestamp = mktime(0, 0, 0, $a['tm_mon']+1, $a['tm_mday'], $a['tm_year']+1900);
		$message.="<jour>".date("d/m/Y",$timestamp)."</jour><br />";
		$jour=$travail["jour"];
	}

	$message=$message ."<matiere>" . $travail["matiere"] . "</matiere><br /><travail>".  $travail["travail"]."</travail><br />";
}

$message=$message ."</div>";



if (isset($_GET["callback"]))
{
	 postData("infos",$message,sizeof($travaux),"");
}

?>
