<?php

session_start();
require_once('Connections/conn_cahier_de_texte.php');
require_once('inc/functions_inc.php');
require_once('inc/cas_envole.inc.php');
require_once('inc/sessions_params.php');

function endsWith($haystack, $needle)
{
    $length = strlen($needle);

    return $length === 0 || 
    (substr($haystack, -$length) === $needle);
}


$ldap_civilite = array(0 => 'M./Mme', 1 => 'M.', 2 => 'Mme', 3 => 'Mlle');

$attributs = envole_cas_auth();

if ($profil == 'National_1' || $profil == 'National_2'){
	$_SESSION['liste_consultation'] = array();
}
$profil = $attributs['utilisateur']['profil'][0];

# Pour le moment que le profil responsable et eleve est géré
if ($profil != 'National_1' and $profil != 'National_2'){
	// die();
}

if($profil == 'National_1' && isset($attributs['utilisateur']['classe'])){
	$classe = $attributs['utilisateur']['classe'][0];
	$id_classe = envole_get_classe($classe);
	if($id_classe){
		$civ_id = intval($attributs['utilisateur']['civil'][0]);
		if(!array_key_exists($civ_id,$ldap_civilite)) $civ_id = 0;
        $_SESSION['liste_consultation'][$classe] = array('id' => $id_classe, 'eleves' => array()); //suffisant pour l'accÃ¨s Ã  sa classe
            //inutile pour un Ã©lÃ¨ve mais procÃ©dons comme pour un responsable
        $_SESSION['liste_consultation'][$classe]['eleves'][] = array
        (
        	'nom' => $attributs['utilisateur']['lastname'][0],
        	'prenom' => $attributs['utilisateur']['firstname'][0],
        	'civilite' => $ldap_civilite[$civ_id]
        );
    }
}
elseif($profil=='National_2' && isset($attributs['utilisateur']['eleves'])){
	$_SESSION['liste_consultation'] = envole_get_eleves($attributs['utilisateur']['eleves']);
}


#mysql_query("SET NAMES UTF8"); # Pas nécessaire sur 2.3
mysqli_select_db($database_conn_cahier_de_texte, $conn_cahier_de_texte);

$travaux=array();

if(!empty($_SESSION['liste_consultation'])){
	foreach($_SESSION['liste_consultation'] as $classe => $infos){
		$code_classe = $infos['id'];
		$query="
		SELECT cdt_travail.t_jour_pointe,cdt_travail.travail,cdt_matiere.nom_matiere FROM `cdt_travail`
		LEFT JOIN cdt_classe ON cdt_travail.classe_ID=cdt_classe.ID_classe
		LEFT JOIN cdt_matiere ON cdt_travail.matiere_ID =cdt_matiere.ID_matiere
		WHERE `t_jour_pointe`>= DATE(CURDATE())  and `t_jour_pointe`< DATE(CURDATE()+ INTERVAL 15 DAY) and classe_ID=$code_classe  ORDER BY `t_jour_pointe`
		";
		//$travail_db=mysql_query($query, $conn_cahier_de_texte) or die(mysql_error());
		$travail_db=mysqli_query($conn_cahier_de_texte, $query) or die(mysqli_error($conn_cahier_de_texte));

		while ($row_travail = mysqli_fetch_assoc($travail_db)) {
			$travail = array();
			$travail['jour'] = $row_travail['t_jour_pointe'];
			$travail['matiere'] = $row_travail['nom_matiere'];
			$travail['travail'] = $row_travail['travail'];
			array_push($travaux, $travail);
		}
	}
}

if(isset($_GET['format']) and $_GET['format'] == 'json'){
	die(json_encode($travaux));
}

// Pas de travail, on ne fait rien
if (sizeof($travaux) == 0){
	$message = 'Aucun travail';
}
else{
  // formatage html
	$jour = '';
	$message = '<span> Travail pour les 14 prochains jours</span><hr />';
	$message .= '<div class=travail>';

	foreach($travaux as $travail){
		if ($travail['jour'] != $jour){
			$a = strptime($travail['jour'], "%Y%m%d");
			$timestamp = mktime(0, 0, 0, $a['tm_mon']+1, $a['tm_mday'], $a['tm_year']+1900);
			$message .= '<span class="jour">' . date("d/m/Y", $timestamp) . '</span><br />';
			$jour=$travail['jour'];
		}

		
		if(endsWith($travail['travail'],"<br />")) {
			$travail['travail']=substr($travail['travail'],0,-6);
		}

		$message .= '<span class="matiere">' . $travail['matiere'] . '</span><br /><span class="devoir">'.  $travail['travail'].'</span><br />';
	}
	$message .= '</div>';
}

$message = addslashes($message);
$message = preg_replace( "/\r|\n/", "", $message);
$ret="<script>";
$ret=$ret."parent.getMails(".$_GET["id"].",'$message');";
$ret=$ret."</script>";
echo $ret;