<?php
//client CAS utilis par index.php pour la connexion et logout.php pour la dconnexion
$envole_cas = null;

//prsent dans l'include_path du php.ini (/usr/share/php)
include_once("CAS-1.3.1/eoleCAS.php");
include_once("configCAS/cas.inc.php");
if(__CAS_DEBUG) EolephpCAS::setDebug('/var/log/posh/cdt-cas.log');

//vrification de constantes spcifiques au scribe 2.3 pour une version unique du fichier sur 2.2 et 2.3
if(!defined("__CAS_VALIDER_CA")) define("__CAS_VALIDER_CA",false);
if(!defined("__CAS_CA_LOCATION")) define("__CAS_CA_LOCATION","/etc/ssl/certs/ca.crt");

//instanciation du client CAS
function envole_cas_instance()
	{
	global $envole_cas;
	if(empty($envole_cas))
		{
		$envole_cas = new eolephpCAS();
		$envole_cas->client(__CAS_VERSION,__CAS_SERVER,__CAS_PORT,__CAS_FOLDER,false);
		if(__CAS_VALIDER_CA) $envole_cas->setCasServerCACert(__CAS_CA_LOCATION);
		elseif(method_exists($envole_cas,'setNoCasServerValidation')) $envole_cas->setNoCasServerValidation();
		if(method_exists($envole_cas,'EoleLogoutRequests')) $envole_cas->EoleLogoutRequests(false);
		}
	}

//authentification et rcupration des informations sur l'utilisateur
function envole_cas_auth()
	{
	global $envole_cas;

	//instanciation
	envole_cas_instance();
	$envole_cas->setNoClearTicketsFromUrl();

	//forcer  redemander les infos auprs du serveur CAS (au lieu de les lire en session alors que ce serait les infos d'une autre appli...)
	if(isset($_SESSION["phpCAS"])) unset($_SESSION["phpCAS"]);

	//authentification
	$envole_cas->forceAuthentication();
	
	//rcupration des informations de l'utilisateur
	return $envole_cas->getDetails();
	}

//dconnexion
function envole_cas_logout()
	{
	global $envole_cas;

	//instanciation
	envole_cas_instance();
	
	//procdure de dconnexion du serveur CAS
	$url = (isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS'])) ? "https://" : "http://";
	if(empty($_SERVER['SERVER_NAME'])) $url .= $_SERVER['HTTP_HOST'];
	else $url .= $_SERVER['SERVER_NAME'];
	$url .= "/cdt/index.php?envole_logout=5"; //variable "envole_logout" pour identifier la redirection
	$envole_cas->logout(array("url"=>$url));
	}

//pour diffrencier les administratifs (National_6) : EDU (vie scolaire) ou DIR (direction)
function envole_get_service($login)
	{
	$ldap_server = "localhost";
	$ldap_port = 389;
	$ldap_dn = "o=gouv,c=fr";
	$ldap_attr = array('cn');
	$ldap_filter = "(&(objectclass=ENTGroupe)(type=Service)(memberuid=".$login."))";
	$service = "";

	$ldapconn = @ldap_connect($ldap_server,$ldap_port);
	if($ldapconn)
		{
		$ldapbind = @ldap_bind($ldapconn);
		if($ldapbind)
			{
			$ldapsearch = @ldap_search($ldapconn,$ldap_dn,$ldap_filter,$ldap_attr);
			if($ldapsearch)
				{
				$infos = @ldap_get_entries($ldapconn,$ldapsearch);
				if(isset($infos['count']) && $infos['count']>0) $service = strtolower($infos[0]["cn"][0]);
				@ldap_free_result($ldapsearch);
				}
			}
		}

	return $service;	
	}

//complte les infos des lves renvoyes par le serveur CAS pour une connexion "responsable" (National_2)
function envole_get_eleves($logins)
	{
	$classes = array(); //classement par classe
	sort($logins);
	
	$ldap_server = "localhost";
	$ldap_port = 389;
	$ldap_dn = "o=gouv,c=fr";
	$ldap_civilite = array(0=>"M./Mme",1=>"M.",2=>"Mme",3=>"Mlle");
	$ldap_eleve_attr = array
		(
		'uid',          //login
		'sn',           //nom
		'givenname',    //prnom
		'codecivilite', //civilite
		'divcod'        //classe
		);

	$ldapconn = @ldap_connect($ldap_server,$ldap_port);
	if($ldapconn)
		{
		$ldapbind = @ldap_bind($ldapconn);
		if($ldapbind)
			{
			foreach($logins as $login)
				{
				$ldapsearch = @ldap_search($ldapconn,$ldap_dn,"(&(objectclass=entEleve)(uid=".$login."))",$ldap_eleve_attr);
				if($ldapsearch)
					{
					$infos = @ldap_get_entries($ldapconn,$ldapsearch);
					if(isset($infos['count']) && $infos['count']>0 && !empty($infos[0][$ldap_eleve_attr[4]][0]))
						{
						$classe = $infos[0][$ldap_eleve_attr[4]][0];
						if(!array_key_exists($classe,$classes))
							{
							$id_classe = envole_get_classe($classe);
							if($id_classe) $classes[$classe] = array("id"=>$id_classe,"eleves"=>array());
							else continue;
							}
						$civ_id = intval($infos[0][$ldap_eleve_attr[3]][0]);
						if(!array_key_exists($civ_id,$ldap_civilite)) $civ_id = 0;
						$classes[$classe]["eleves"][] = array
							(
							"login" => $infos[0][$ldap_eleve_attr[0]][0],
							"nom" => $infos[0][$ldap_eleve_attr[1]][0],
							"prenom" => $infos[0][$ldap_eleve_attr[2]][0],
							"civilite" => $ldap_civilite[$civ_id]
							);
						}
					@ldap_free_result($ldapsearch);
					}
				}
			}
		}

	return $classes;	
	}

//pour tester qu'une classe est bien connue du cdt
function envole_get_classe($classe)
	{
	global $conn_cahier_de_texte;

	$id = 0;
	$query_code = sprintf("SELECT ID_classe FROM cdt_classe WHERE code_classe='%s'",$classe);
	$query_nom = sprintf("SELECT ID_classe FROM cdt_classe WHERE nom_classe='%s'",$classe);
	$result_code = mysqli_query($conn_cahier_de_texte, $query_code) or die(mysqli_error($conn_cahier_de_texte));
	if(mysqli_num_rows($result_code)>0)
		{
		$row_code = mysqli_fetch_assoc($result_code);
		$id = intval($row_code["ID_classe"]);
		}
	else //si pas de code correspondant, on essaye les noms de classe sur lesquels l'admin a la main et donc pourra corriger si besoin
		{
		$result_nom = mysqli_query($conn_cahier_de_texte, $query_nom);
		if(mysqli_num_rows($result_nom)>0)
			{
			$row_nom = mysqli_fetch_assoc($result_nom);
			$id = intval($row_nom["ID_classe"]);
			}
		}
	return $id;
	}
?>
