<?php

define("__APP_CACHE_FOLDER","caches");
define("SEP_SIGAT","-sepSIGATsep-");

// Cache pour les ressources arena
// si les ressources arena ont été récupérées il y a moins de $_CACHE_TIME secondes
// on va récupérer la ressource en cache (même si $__USE_CACHE est a faux)
$_CACHE_TIME=300;

// Quelques fonction utilses
function postData($flux,$favoris,$message,$user_infos)
{
  global $__NOM;
  echo "<html><body>";
  echo "<form id='form2submit' name='form2submit' method='POST' action='".$_GET["callback"]."'>";
  echo "<input name='nom' id='nom' type='hidden' value='".$__NOM."' />";
  echo "<input name='flux' id='flux' type='hidden' value='".(htmlentities($flux,ENT_QUOTES,"UTF-8"))."' />";
  echo "<input name='message' id='message' type='hidden' value='".(htmlentities(str_replace('"',"'",$message),ENT_QUOTES,"UTF-8"))."' />";
  echo "<input name='favoris' id='favoris' type='hidden' value='".(htmlentities(str_replace('"',"'",$favoris),ENT_QUOTES,"UTF-8"))."' />";
  echo "<input name='userinfos' id='last' type='hidden' value='".(htmlentities(str_replace("'",'"',$user_infos),ENT_QUOTES,"UTF-8"))."' />";
  echo "<input name='last' id='last' type='hidden' value='".$_GET["last"]."' />";
  echo "<input name='id' id='id' type='hidden' value='".$_GET["id"]."' />";
  echo "</form>";
  echo "<script>";
  echo "document.form2submit.submit();";
  echo "</script>";
  echo "</body></html>";
  die();
}

// Convertit un objet du WebService Arena en tableau
function objectToArray($d)
{
    if (is_object($d)){$d = get_object_vars($d);}
    if (is_array($d)){return array_map(__FUNCTION__, $d);} else{return $d;}
}

// Ordonne les zones Arena par priorité de recherche
function orderZones($z1,$z2) {
  global $__ARENA_ZONES;
  if (!isset($__ARENA_ZONES[$z1])) return 0;
  if (!isset($__ARENA_ZONES[$z2])) return 0;
  return ($__ARENA_ZONES[$z1]["priorite"]<$__ARENA_ZONES[$z2]["priorite"])?-1:1;

}

// Récupération d'un fichier ARENA.csv qui defini les icones
function getArenaAppsFromCsv($files)
{
    global $LISTE_ICONES_ARENA;
    if (file_exists($files))
    {
        $row=1;
        if (($handle = fopen($files, "r")) !== FALSE) {
            while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {
		// Ref: #8528, Pouvoir mettre dans le fichier arena_apps.csv le nom de la constante définie pour la catégorie
		if ( defined($data[5]) ) $categorie=constant($data[5]);
                else $categorie=$data[5];
                $LISTE_ICONES_ARENA[strtolower($data[2])]=array("icone"=>$data[1],"nom"=>$data[3],"libelle"=>$data[4],"categorie"=>$categorie,"flag"=>$data[6]);
            }
            fclose($handle);
        }
    }
}


function getArenaApps() {
	getArenaAppsFromCsv("arena/arena_apps.envole.csv");
	getArenaAppsFromCsv("arena/arena_apps.local.csv");
}


function debug($msg)
{
    if (isset($_GET["debug"])) {echo $msg ."\n";}
}

function isDebug() { return isset($_GET["debug"]);}

function WS()      {return  new SoapClient(__ARENA_WSIDENTITE);}
function DB()      {return new SQLite3("arena/mxServices.sqlite");}


function callHandler($handler)
{
    if (function_exists("handle_".$handler))
    {
        try {
            call_user_func("handle_".$handler);
        } catch (Exception $e) {

        }
    }
}

function getZones() {
    $network="default";
    if (IsOTP())
    {
        $zones=__ARENA_ZONE_DEFAUT;
        $network="OTP";
    } elseif (!isset($_SESSION["ZONES"]))
    {
        // Récupération de l'IP
        if (isset($_SESSION["IP_CLIENT"])) {
            $ip = $_SESSION["IP_CLIENT"];
            $_SESSION["ip_source"]="ip_client";
        }
        // Si passé en paramètre on va la récupérer
        elseif (isset($_GET["provenance"])) {
            $ip = $_GET["provenance"];
            $_SESSION["ip_source"]="url";
        }
        // Sinon on va tenter de la determiner
        elseif($_SERVER['HTTP_X_FORWARDED_FOR'])
        {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
            $_SESSION["ip_source"]="x-forwarded";
        }elseif($_SERVER['REMOTE_ADDR']) {
            $ip = $_SERVER['REMOTE_ADDR'];
            $_SESSION["ip_source"]="remote-addr";
        }

        $les_portails=parse_ini_file("utils/portails.ini",true);

        $zones=__ARENA_ZONE_DEFAUT;
        if ($les_portails){
            foreach ($les_portails as $addr => $un_portail) {
            if (ip_in_network($ip,$addr,$un_portail['mask'])){
                $zones=$un_portail['arena'];
                $network="$addr/".$un_portail['mask'];
                break;
                }
            }
        }
    } else
    {
        $zones = $_SESSION["ZONES"];
        $ip = $_SESSION["IP_CLIENT"];
    }

    return array("zones"=>$zones,"ip"=>$ip,"network"=>$network);

}


# Quelques classes utiles ======================================

// Une categorie
class Categorie {
    var $nom;
    var $couleur;
    var $indice;
    var $icone;
    function Categorie($nom,$couleur,$indice,$icone="fa-folder") {
        $this->nom=$nom;
        $this->couleur=$couleur;
        $this->indice=$indice;
        $this->icone=$icone;
    }
}

// Pour la réorganisation des appli
// si $condition est véfifiée l'application prend comme attribut ceux passés
// dans le tableau associatif $app, les clefs sont definis plus bas, _N,_L,....
class Reorg {
    var $app;
    var $condition;
    function Reorg($app,$condition) {
        $this->app=$app;
        $this->condition=$condition;
    }
}
// ==============================================================

// Clefs
define("_N","nom");
define("_L","libelle");
define("_LC","libellecours");
define("_I","icon");
define("_U","url");
define("_E","external");
define("_C","categoriename");
define("_IU","infos_url");
define("_IT","infos_type");
define("_IM","infos_message");
define("_PT","piwik_tag");
define("_PM","piwik_marker");

?>
