<?php

// Récupération des messages Arena

session_name("edispatcher");
session_start();
if (!isset($_SESSION["phpCAS"])) {
    header('Content-Type: text/javascript');
    die("/**/");
}

include_once('include/dispatcher.config.php');
include_once('include/fonctions.php');

// Uniquemement le personnel avec une auth académique
if ( ! IsAuthAcad() ) {
    header('Content-Type: text/javascript');
    die("/**/");
}

// include arena
include_once("arena/arena_inc.php");

// Inclusion d'une configuration locale si elle existe
if (file_exists("arena/ressources.config.local.php")) {include_once("arena/ressources.config.local.php"); }

$id=$_GET["id"];
$api=$_GET["api"];
$messages=array();


// Récupération des messages de Arena
try {
    $client = WS();
    $result=$client->__call('getMessages',array("dateDuJour" => date('c')));
    $message=objectToArray($result);

    $messageArena=$message["item"]["corpsMessage"];
    $messageArena=nl2br($messageArena);
    $messageArena=preg_replace('/[\x00-\x1F\x7F]/', '', $messageArena);
    $messages[]=array(id=>time(),"message"=>$messageArena);
} catch (Exception $e) {
}

// Messages applicatifs
try  {
    $client = WS();
    $result=$client->getMessagesAppli(date('c'));
    $items=objectToArray($result);
    $items=$items["item"];

    // Cas d'un seul item, attention $items["0"] n'existe pas
    if (!isset($items["0"])) {$items=array("0"=>$items);}

    foreach ($items as $f)
    {
        $arr=explode(SEP_SIGAT,$f["domSousdomUrlCT"]);
        $message=$f["corpsMessageAppli"];

        // Pour flaguer le message
        $flag="";
        $lastChar=substr(trim($message), -1);
        $last2Chars=substr(trim($message), -2);
        if ($lastChar=="!") $flag="attention";
        if ($last2Chars=="!!") $flag="important";

        $messages[]=array(id=>md5($message),"message"=>$message,"url"=>$arr[2],"flag"=>$flag);
    }
} catch (Exception $e) {

}

//Retour de la réponse
$json=json_encode(array("messages"=>$messages));
if (isset($_GET["api"])) {
    header('Content-Type: text/javascript');
    echo "var data=$json;";
    echo "$api('$id',data);";
    callHandler('ArenaMessageJs');
} else {
    header('Content-Type: application/json');
    echo $json;
}
?>
