<?php

if(php_sapi_name() != "cli") {
  die("mode cli requis");
}

define("ROOT_DIR",dirname(__FILE__)."/..");
define("INC_DIR",ROOT_DIR."/include");
include_once(INC_DIR.'/dispatcher.config.php');
include_once(INC_DIR.'/db.config.php');
include_once(ROOT_DIR.'/arena/arena_inc.php');

// 1h avant expiration du cache
$date = new DateTime();
$date->sub(new DateInterval('PT'.max(__CACHE_DURATION - 1,1).'H'));

// WebServices Init
$client = WS();

$LIMIT=1000;

$time_start = microtime(true);
echo "Maj du cache < ".$date->format('Y-m-d H:i:s')." ($LIMIT plus anciens)\n";

$caches=R::find( 'arenacache', ' updated  < ? and ( locked is false ) ORDER BY updated ASC,uid ASC ' . "LIMIT $LIMIT", array($date->format('Y-m-d H:i:s')));

if (count($caches)==0) {
  // Rien a mettre a jour on va tout de même en faire 10 :)
  $caches=R::find( 'arenacache', ' ORDER BY updated ASC LIMIT 10');
}

echo count($caches) . " enregistrements à mettre à jour\n";

// Lock record
echo "Verouillage des enregistrements : ";
foreach ($caches as $cache) {
    $cache->locked=true;
    //R::store( $cache );
}
R::storeAll( $caches );
$time_end = microtime(true);
$time = $time_end - $time_start;
echo "$time seconds\n";

echo "Récupération du cache : ";
$time_start = microtime(true);
foreach ($caches as $cache) {
  #echo " ".$cache->updated.":".$cache->uid.":".$cache->zone;
  $result=$client->getRessourcesPortail($cache->uid,$cache->zone);
  $items=objectToArray($result);
  if (!is_array($items) || count($items)==0) {
    continue;
  }
  $cache->setCache($items);
  $cache->updated=new DateTime();
  #echo ":OK\n";
}
R::storeAll( $caches );
$time_end = microtime(true);
$time = $time_end - $time_start;
echo "$time seconds\n";

echo "---\n";
