<?php

// definition du nom de la session 
session_name("edispatcher");

include_once('CAS/eoleCAS.php');
include_once('configCAS/cas.inc.php');

// Initialisation du client PHP
if (__CAS_DEBUG){
    EolephpCAS::setDebug('/var/log/phpcas/phpcas-edispatcher.log');
}

EolephpCAS::client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, "", true);
if (__CAS_VALIDER_CA) {
    EolephpCAS::setCasServerCACert(__CAS_CA_LOCATION);
} else {
    if (method_exists('EolephpCAS', 'setNoCasServerValidation')){
        EolephpCAS::setNoCasServerValidation();
    }
}

if (__CAS_LOGOUT){
    if (method_exists('EolephpCAS', 'eolelogoutRequests')){
        EolephpCAS::eolelogoutRequests(false);
    }
}

// Sur la page principale
// force le check SSO , si la session est > 10s
if (strpos($_SERVER["REQUEST_URI"],"ng/hub")!==false &&
    strpos($_SERVER["REQUEST_URI"],"&ticket")===false &&
    isset($_SESSION["login_time"]))
{
    //print_r(time()-$_SESSION["login_time"]);die();
    if (time()-$_SESSION["login_time"] > 10) {
        unset($_SESSION['phpCAS']);
        unset($_SESSION["login_time"]);
        unset($_SESSION["CASATTRIBUTE"]);
        unset($_SESSION["GUID"]);
        unset($_SESSION["portails"]);
    }

}

// On force l'autehntification
if(EolephpCAS::forceAuthentication()) {
    // Récupérations des attributs
    $attributs=array();
    $attributs=EolephpCAS::getDetails();

    // Stocke les variables CAS dans un tableau $_SESSION["CASATTRIBUTE"]
    $_SESSION["CASATTRIBUTE"]=array();
    foreach ($attributs as $value) {
        $_SESSION["CASATTRIBUTE"] += $value;
    }
    $_SESSION["id"]=uniqid('sso');
    $_SESSION["arenb"]="";
    $_SESSION["login_time"]=time();
}

function logout() {
    EolephpCAS::logout();
}
