<?php
/**
 * personnalisation de l'application
 */


$scheme = isset($_SERVER["REQUEST_SCHEME"])?$_SERVER["REQUEST_SCHEME"]:"http" ;
if (isset($_SERVER["HTTP_X_FORWARDED_PROTO"])) {
    $scheme = $_SERVER["HTTP_X_FORWARDED_PROTO"];
}

// Possibilité de forcer le scheme par variable d'env 
// pour les reverse-proxy un peu récalcitrant
$scheme = getenv("SCHEME")  ?: $scheme;

if ($scheme == "https" ){
    $_SERVER['HTTPS'] = "on";
}

$port =  isset($_SERVER["SERVER_PORT"])?$_SERVER["SERVER_PORT"]:"80" ; 
if (isset($_SERVER["HTTP_X_FORWARDED_PORT"])) {
    $port = $_SERVER["HTTP_X_FORWARDED_PORT"];
}

// Possibilité de forcer le port par variable d'env 
// pour les reverse-proxy un peu récalcitrant
$port = getenv("PORT")  ?: $port;

if (!isset($_SERVER["SERVER_NAME"])) {
	$_SERVER["SERVER_NAME"]="edispatcher";
}

$_URL = $scheme . "://" . $_SERVER["SERVER_NAME"]. ":".  $port;

define("_URL_SESHAT",           getenv("URL_SESHAT")      ?:  $_URL);
define("_URL_DISPATCHER",       getenv("URL_DISPATCHER")  ?:  $_URL);
define("_HOST",                         getenv("HOST")                    ?: ($_SERVER["SERVER_NAME"]. ":".  $port) );

define("__LIBELLE_ETAB",	getenv("LIBELLE_ETAB") 	  ?: "Académie de la Réunion");

define("_RNE_PORTAIL_ACA",	getenv("RNE_PORTAIL_ACA") ?:  "1D");
define("_URL_PORTAIL_ACA",	getenv("URL_PORTAIL_ACA") ?:  ($_SERVER["SERVER_NAME"]. ":".  $port));
define("_LIBELLE_PORTAIL_ACA", getenv("LIBELLE_PORTAIL_ACA") ?: "METICE");
define("_FORCE_PIA",	       getenv("FORCE_PIA") === "true" );

define("_FORCE_PIA_SI_NOETAB", true);


define("_URL_PORTAIL_DEFAUT",  getenv("URL_PORTAIL_DEFAULT") ?: "$_URL/envole");
define("_PROTOCOLE_ENT","https");

# Variable décrivant le serveur SSO
define("_SERVEUR_SSO_PORT", getenv("SSO_PORT") ?: 443);
define("_SERVEUR_SSO_RACINE","");
define("_SERVEUR_SSO", getenv("SSO_HOST") ?: "sso.ac-reunion.fr");

define("_TEST_PORTAIL",false);

define("_ONE_REDIRECT",true);
define("_ONE_REDIRECT_DELAY",10);


define("_USE_NG",true);

define("_XDESKTOP",true);
define("_XDESKTOP_LIBELLE",getenv("XDESKTOP_LIBELLE")      ?:  "Profilage académique");
define("_XDESKTOP_URL",getenv("XDESKTOP_URL")      ?:  _HOST);
define("_RESSOURCES_URL_API",getenv("RESSOURCES_URL_API")      ?: false);
define("_RESSOURCES_HELLO_API",getenv("RESSOURCES_HELLO_API")      ?: false);
define("_RESSOURCES_XDESKTOP_FAVORIS",getenv("RESSOURCES_XDESKTOP_FAVORIS")      ?: false);
define("_CACHE_DEFAULT_DELAY_IN_DAYS",getenv("CACHE_DEFAULT_DELAY_IN_DAYS")      ?: 5);
define("_LIBELLE_MES_RESSOURCES",getenv("LIBELLE_MES_RESSOURCES")      ?: "Mes Ressources");

define("__ADMIN2","cleon");
define("__APP_MANAGER_ALIM_AUTO",true);

define("__USE_CACHE",true);
define("__CACHE_DURATION",10);

# WebService permettant de récupérer les ressources arena
define("__ARENA_WSIDENTITE", getenv("ARENA_WSIDENTITE") ?: "http://wsidentite.in.ac-reunion.fr/WSIdentite/WSIdentiteService?WSDL");


define("__ARENA_ZONE_DEFAUT", getenv("ARENA_ZONE_DEFAUT") ?: "rev-proxy-id");

# Liste des zones Arena
$__ARENA_ZONES=array();
$__ARENA_ZONES['edispatcher']=array("portail"=>"","libelle"=>"Académique","priorite"=>0,"couleur"=>"#E2B664");

$__ARENA_ZONES['rev-proxy-id']=array("portail"=>"https://portail.ac-reunion.fr",
	"libelle"=>"Internet",
	"priorite"=>4,
	"couleur"=>"#F93B91");
$__ARENA_ZONES['rev-proxy-agr']=array("portail"=>"https://scoweb.ac-reunion.fr",
	"libelle"=>"Réseau Administratif EPLE",
	"priorite"=>2,
	"couleur"=>"#D0CD0E");
$__ARENA_ZONES['rev-proxy-in']=array("portail"=>"https://accueil.in.ac-reunion.fr",
	"libelle"=>"Rectorat & Annexes",
	"priorite"=>1,
	"couleur"=>"#0371EA");

define("__NG_TEMPLATE","samples/acreunion_7");

$__CORS_ORIGIN=array();
$__CORS_ORIGIN[]="college-.*.re$";
$__CORS_ORIGIN[]="ac-reunion.fr$";

$__FEDERATIONS=array();
$__FEDERATIONS['scoweb']=array("service"=>"https://portail.ac-reunion.fr/arena/images/portail_titre.gif");

$__LOGOUTS=array();
$__LOGOUTS[]='https://portail.ac-reunion.fr/login/ct_logout.jsp';
$__LOGOUTS[]='https://seshat.ac-reunion.fr:8443/logout';
$__LOGOUTS[]='https://teleservices.ac-reunion.fr/login/ct_logout.jsp';
$__LOGOUTS[]='https://hubole.ac-reunion.fr/xdesktop/logout.php';
$__LOGOUTS[]='https://seshat.ac-reunion.fr:8443/logout';

// URL de redirection après logout
define("_LOGOUT_RELAYSTATE",       getenv("LOGOUT_RELAYSTATE")  ?:  null);

define("__PROXY",  getenv("PROXY")?: "proxy.ac-reunion.fr:3128");
$STREAM_CONTEXT_PARAMS = array(
	'http' => array(
		'proxy' => 'tcp:/'.__PROXY,
		'request_fulluri' => true,
	),
	'https' => array(
		'proxy' => 'tcp:/'.__PROXY,
		'request_fulluri' => true,
	),
);
$STREAM_CONTEXT = stream_context_create($STREAM_CONTEXT_PARAMS);

define("__ARENA_FAVORIS_MAX",10);

$__PIWIK="";
if(file_exists('/var/www/html/sondepiwik/envoleTrackeur.js.php')) {
	$__PIWIK=_URL_DISPATCHER."/sondepiwik/envoleTrackeur.js.php";
} elseif(file_exists('/var/www/html/piwik/envoleTrackeur.js.php')) {
	$__PIWIK=_URL_DISPATCHER."/piwik/envoleTrackeur.js.php";
} else {
	$__PIWIK =   getenv("PIWIK_URL") ?: "";
}

// Utilisation d'un fichier de configuration local si existant
if (file_exists(__DIR__ . "/../local.config.php")) {
	include_once(__DIR__ . "/../local.config.php");
}

