<?php

namespace Edispatcher\Controllers;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Edispatcher\Entity\Category;


class CategoryController extends BaseController  {
/*
 // A GARDER EVENTUELLEMENT SI ON SOUHAITE UTILISER
 // Utilisation : permet d'afficher un texte en blanc sur couleur de fond foncée ou texte noir sur couleur de fond claire
    public function getContrast50($hexcolor){
            return (hexdec($hexcolor) > 0xffffff/2) ? 'black':'white';
    }
 */
    public function showCategoriesAction(Request $request, Response $response, $args) {

    $this->requireReader();

    $categories    = \R::find( 'category', ' ORDER by indice');
  /*  
   // Exemple d'utilisation de la fonction ci-dessus
   // on envoie textcolor au template et la couleur du texte est automatique
   // Pour que cela serve vraiment, il faudrait implémenter cela dans l'affichage du desktop, et pas uniquement sur le gestionnaire de catégories 
   foreach ($categories as $category) {
        $category->textcolor = $this->getContrast50($category->color);
  }
   */
    return $this->ci["view"]->render($response, 'app/catlist.html.twig',$this->genParams(["categories"=>$categories]));
  }


   public function editCategoryAction(Request $request, Response $response, $args) {
        $this->requireManager();

        if ($args["id"]) {
            $category=\R::findOne( 'category','id = ?',[$args["id"]]);
            if (!$category) return ;
            return $this->ci["view"]->render($response,
                                     'app/catedit.html.twig',$this->genParams(["category"=>$category]));
        }

       return $this->ci["view"]->render($response,
                                     'app/catedit.html.twig');

    }



  public function saveCategoryAction(Request $request, Response $response, $args) {

    $this->requireManager();
    if ($args["id"]) {
    $category=\R::findOne( 'category','id = ?',[$args["id"]]);
    }
    if (!$category) {
      $category = \R::dispense("category");
    }

    $post = $request->getParsedBody();
    
    $category->libelle=$post['libelle'];
    $category->name=preg_replace("%[^a-zA-Z0-9 ]%","",$post['libelle']);
    $category->color=$post['color'];
    $category->fa=$post['fa'];
    $category->indice=intval($post['indice']);

    $files = $request->getUploadedFiles();
    if (!empty($files['icon'])) {
      $newfile = $files['icon'];
      
      if ($newfile->getError() === UPLOAD_ERR_OK) 
      {
        $category->fa="";
        $filecontent = file_get_contents($_FILES['icon']['tmp_name']);
        //print_r($filecontent);die();
        $icon = \R::findOne( 'icon', 'md5icon = ?', [md5($filecontent)]);
        if (!$icon) {
            $icon = \R::dispense("icon");
            $icon->icon = $filecontent;
            $icon->svg = strpos( $filecontent, "<svg ");
            $icon->md5icon = md5($filecontent);
            \R::store($icon);
        } else {
          $icon->svg = strpos( $filecontent, "<svg ");
          \R::store($icon);
        }

        $category->icon = $icon;
        

      } // END === UPLOAD_ERR_OK
    } // END !empty($files['icon'] 

    \R::store($category);
    return $response->withRedirect($this->ci->get('router')->pathFor('cats'));
 }



}



