<?php

namespace Edispatcher\Controllers;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;

use Prometheus\CollectorRegistry;
use Prometheus\RenderTextFormat;

use Edispatcher\Entity\Application;


class DefaultController extends BaseController {


  public function logoutSSOAction(Request $request, Response $response, $args) {
      include_once(INC_DIR."/cas.php");
      \logout();

      //return $this->ci["view"]->render($response, 'default/logout.html.twig',$params);

      
  }

  public function cssProfilAction(Request $request, Response $response, $args) {

    $profil = $this->ci["profil"];
    $hubToken = $profil->getHubToken();

    if(!$hubToken) die();

    $string = '
    $color :'. $profil->getProfilColor() .';
    .gradient-profil {
      background: linear-gradient(135deg, $color  0%, lighten($color,40%)  99%, lighten($color,60%) 100%);
    };
    ';

    $scss = new \Leafo\ScssPhp\Compiler();
    $content=$scss->compile($string);

    $response = $response->withHeader('Content-Type',  'text/css');
    $body = $response->getBody();
    $body->write($content);

    return $response;
  }

  public function cssAction(Request $request, Response $response, $args) {
    $scss = new \Leafo\ScssPhp\Compiler();
    //$scss->setImportPaths($importPaths);

    $content="";

    $cache=ROOT_DIR."/ng/cache/css";
    if (file_exists($cache)) {
        $content=file_get_contents($cache);
    } else {

        $path=ROOT_DIR."/ng/public/css/*.*css";
        $ressources=[];
        $ressources=array_merge($ressources,glob($path));

            foreach ($ressources as $filename)
            {
              // less compiler
              if (self::endsWith($filename,".less")) {
                $less = new \AcReunion\SocleBundle\Utils\lessc();
                $code=$less->compileFile($filename);
              }

              // scss compiler
              elseif (self::endsWith($filename,".scss")) {
                // Import
                if (self::startsWith(basename($filename),"_")) {
                  $scss->addImportPath(dirname($filename));
                }
                $code=$scss->compile(file_get_contents($filename));
              }

              // css classique
              else {
                $code=file_get_contents($filename);
              }

              $content.=$code;

          }
            // Remove comments
            $content = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $content);
            // Remove space after colons
            $content = str_replace(': ', ':', $content);
            // Remove whitespace
            $content = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $content);

          file_put_contents($cache, $content);
      }

      // Mise en cache HTTP du contenu
      header_remove("Cache-Control");
      header_remove("Pragma");
      header_remove("Expires");

      $response = $response->withHeader('Content-Type',  'text/css');
      $response = $this->ci['cache']->withExpires($response, time() + 3600*24*10); // Cache a 10jours
      $response = $this->ci['cache']->withEtag($response, md5($content));

      $body = $response->getBody();
      $body->write($content);

      return $response;


  }

  public function cssTagsAction(Request $request, Response $response, $args) {
    $params=[];

    $tags=\R::findAll("tag");
    $params["tags"]=$tags;

    $response = $response->withHeader('Content-Type',  'text/css');

    $content = $this->ci["view"]->fetch('tags.twig.css',$params);

    $scss = new \Leafo\ScssPhp\Compiler();
    $code=$scss->compile($content);

    $body = $response->getBody();
    $body->write($code);

    return $response;

  }

  public function jsAction(Request $request, Response $response, $args) {

    $content="";

    $cache=ROOT_DIR."/ng/cache/js";
    if (file_exists($cache)) {
        $content=file_get_contents($cache);
    } else {

        $path=ROOT_DIR."/ng/public/elements/behaviors/scripts/*.js";
        $ressources=[];
        $ressources=array_merge($ressources,glob($path));

            foreach ($ressources as $filename)
            {
              $code=file_get_contents($filename)."\n";
              $content.=$code;
          }
          file_put_contents($cache, $content);
      }

      // Mise en cache HTTP du contenu
      header_remove("Cache-Control");
      header_remove("Pragma");
      header_remove("Expires");

      $response = $response->withHeader('Content-Type', 'application/javascript');
      $response = $response->withHeader('Access-Control-Allow-Origin', "*");
      $response = $this->ci['cache']->withExpires($response, time() + 3600*24*10); // Cache a 10jours
      $response = $this->ci['cache']->withEtag($response, md5($content));

      $body = $response->getBody();
      $body->write($content);

      return $response;


  }

  public function elementsLatestAction(Request $request, Response $response, $args) {
    if (file_exists(__CACHE_DIR."/".VERSION_ELEMENTS)) {

      header_remove("Cache-Control");
      header_remove("Pragma");
      header_remove("Expires");

      $response = $response->withHeader('Content-Type', "text/html; charset=UTF-8");
      $response = $response->withHeader('Access-Control-Allow-Origin', "*");
      $response = $this->ci['cache']->withExpires($response, time() + 3600*24*10); // Cache a 10jours
      $response = $this->ci['cache']->withEtag($response, filemtime($filename));


      $body = $response->getBody();
      $body->write(file_get_contents(__CACHE_DIR."/".VERSION_ELEMENTS));
      return $response;
    }

    die("NO ELEMENTS ".__CACHE_DIR."/".VERSION_ELEMENTS);

  }

  public function elementsAction(Request $request, Response $response, $args) {
    $path=$request->getAttribute('params');
    $dir=ROOT_DIR."/ng/public/elements";
    $filename = $dir."/".$path ;
    if (file_exists($filename)) {
      $content = file_get_contents($filename);
      header_remove("Cache-Control");
      header_remove("Pragma");
      header_remove("Expires");

      $type = mime_content_type($filename);
      if (strpos($filename,".css")!==false)  $type="text/css";

      if (strpos($filename,"AppsBehavior.html")!==false)  {
        $content=str_replace("__VERSION__",VERSION_ELEMENTS,$content);
      }

      $response = $response->withHeader('Content-Type', $type);
      $response = $this->ci['cache']->withExpires($response, time() + 3600*24*10); // Cache a 10jours
      $response = $this->ci['cache']->withEtag($response, filemtime($filename));


      $body = $response->getBody();
      $body->write($content);
    }

    return $response;
  }

  public function piwikAction(Request $request, Response $response, $args) {

      $query=$request->getQueryParams();

      $params=[];
      $params["portail"]=$args["portail"];
      $params["rne"]    =$args["rne"];
      $params["appli"]  =$query["name"];

      // Va loguer les accès à app et url =======================================
      $app = null;
      if (array_key_exists("appid",$query)) {
          $app=\R::findOne( 'app','uid = ?',[$query["appid"]]);
      }

      $url = null;
      if (array_key_exists("appid",$query)) {
          $url=\R::findOne( 'url','id = ?',[$query["urlid"]]);
          $app = $url->app;
      }



      if ($url && $app) {
        $rnes=[];

        if ($params["rne"] == "xxx" || $params["rne"] == "GLOBAL" || ! $params["rne"] ) {
          @$rnes=array_unique(GetInfoArray("rne"));
          if (count( $rnes)>=1) $params["rne"] = $rnes[0];
        } else {
          $rnes=[$params["rne"]];
        }
        // fixes #22207 : Erreur remontée sonde piwik si pas de metrics
        $metrics = $this->getMetrics();
        if ($metrics) {
            foreach ($rnes as $rne) {
              $metrics->appAccess($app->id,$url->id,$this->ci["profil"]->getProfil(),$rne);
            }
        }


      }
      // =======================================================================


      global $__PIWIK;
      $params['ELEMENTS_VERSION']  =   VERSION_ELEMENTS;
      $params["PIWIK"]            = array("url"=>$__PIWIK,"name"=> $params["appli"]  );
      $params['profil']           = $this->ci["profil"]->getProfil();


       return $this->ci["view"]->render($response, 'default/piwik.html.twig',$params);

  }


  public function logoutAction(Request $request, Response $response, $args) {

      $cookies2destroy = array();
      include_once(ROOT_DIR.'/include/cookies2destroy.php');
      $cookies2destroy[] = "edispatcher";
      $cookies2destroy[] = "mxdesktop";
      $cookies = array_keys($_COOKIE);
      $badcookies = array_diff($cookies2destroy,$cookies);
      $message    =  "";
      if ($badcookies) {
          $message="console.log('ATTENTION : DES COOKIES A SUPPRIMER DU FICHIER include/cookies2destroy.php NE SONT PAS REELEMENT PRESENTS :');";
          foreach ($badcookies as $badcookie) {
            $message .= "console.log('- COOKIE : ".$badcookie."');";
          }

      }
      $cookies2reallydestroy = array_intersect($cookies2destroy,$cookies);
      foreach ($cookies2reallydestroy as $c) {
          setcookie($c, time().$c.'logout', time()+1, '/');
      }


      $profil = $this->ci["profil"];
      $hash       = $profil->getHash();
      $hashuser   = $profil->getHashWithUser();

      $token=$profil->getHubToken();
      if ($token) {
        $token->logout = true;
        $profil->saveToken($token);
      }


      global $__LOGOUTS;

      $params["portails"]  =   $profil->getPortails();
      $params["message"]   =   $message;

      $params["logouts"]=$__LOGOUTS;
      $params['profilClass']=$this->ci["profil"]->getProfilClass();
      $params['profil']=$this->ci["profil"]->getProfil();
      $params['SSO']='https://'._SERVEUR_SSO.':'._SERVEUR_SSO_PORT.'/logout';
      $params['REPLAYSTATE'] = _LOGOUT_RELAYSTATE;

      // Une orign de logout est en paramètre , on l'ajoute au process de logout
      $queryParams=$request->getQueryParams();
      if (isset($queryParams["orign"])) {
        $params["logouts"][] = $queryParams["orign"];
      }

      session_unset();
      session_destroy();

      

      return $this->ci["view"]->render($response, 'default/logout.html.twig',$params);
  }

  public function callbackAction(Request $request, Response $response, $args) {

      $params=[];
      $params["infosplus"]=false;
      if (isset($_GET["count"]) || isset($_POST["count"])   ) {

        if (isset($_GET["id"]))
        {
            $params["id"]=$_GET["id"];
            $params["message"]=addslashes($_GET["message"]);
            $params["count"]=$_GET["count"];
            $params["type"]=$_GET["type"];
            $params["link"]=$_GET["link"];
        } else
        {
            $params["id"]=$_POST["id"];
            $params["message"]=addslashes($_POST["message"]);
            $params["count"]=$_POST["count"];
            $params["type"]=$_POST["type"];
            $params["link"]=$_POST["link"];
        }
        $params["infosplus"]=true;

    } else {

        if (isset($_GET["message"]))
        {
            $params["message"]=$_GET["message"];
            $params["action"]=$_GET["action"];$success=$_GET["success"];$id=$_GET["id"];$callbackid=$_GET["callbackid"];
        } else
        {
            $params["message"]=$_POST["message"];
            $params["action"]=$_POST["action"];
            $params["success"]=$_POST["success"];
            $params["id"]=$_POST["id"];
            $params["callbackid"]=$_POST["callbackid"];
        }
    }



    return $this->ci["view"]->render($response, 'callback.js.twig',$params);
  }

  public function homeAction(Request $request, Response $response, $args) {

    return $this->ci["view"]->render($response, 'default/home.html.twig');
  }

  public function redirectAction(Request $request, Response $response, $args) {
    $profil = $this->ci["profil"];
    $hubToken = $profil->getHubToken();

    $queryParams=$request->getQueryParams();


    if ($hubToken) {

      $tmpl="";
      if (array_key_exists('tmpl',$queryParams)) {
         $tmpl=rtrim($queryParams['tmpl'],'/');
       }

       $uaj="";
       if (array_key_exists('uaj',$queryParams)) {
          $uaj=rtrim($queryParams['uaj'],'/');
        }

       $url= _URL_DISPATCHER . $this->ci["router"]->pathFor('hub')."?tmpl=".$tmpl."&uaj=".strtoupper($uaj);

       // js Mode ?
       if (!array_key_exists('js',$queryParams)) {
         return $response->withRedirect($url);
       }

       // Oui js mode redirect javascript
       $response=$response->withHeader('Content-Type', 'application/javascript');
       return $this->ci["view"]->render($response, 'redirect.js.twig',["url"=>$url]);
    }

    die();
  }

  // importJs 
  public function importjsAction(Request $request, Response $response, $args) {

    // Récupère les flags pour les passer à la request de importAction
    // simule ?nobootstrap&...
    $flags = array_flip(explode("-",$args["flags"]));
    $request = $request->withQueryParams($flags);

    $response = $this->importAction($request,$response, $args);

    // Mise en cache HTTP du contenu
    header_remove("Cache-Control");
    header_remove("Pragma");
    header_remove("Expires");

    $response = $response->withHeader('Content-Type',  'text/javascript');
    $response = $this->ci['cache']->withExpires($response, time() + 3600*24*10); // Cache a 10jours
    $response = $this->ci['cache']->withEtag($response, md5($args["id"].$args["flags"]));

    return $response;

  }

  public function importAction(Request $request, Response $response, $args) {

    global $__ARENA_ZONES;

    $profil = $this->ci["profil"];
    $metrics = $this->getMetrics();

    $params["_ONE_REDIRECT"]            =   _ONE_REDIRECT?"true":"false";
    $params["_ONE_REDIRECT_DELAY"]      =   _ONE_REDIRECT_DELAY;

    $params["_SSO"]             =   "https://" . _SERVEUR_SSO.':'._SERVEUR_SSO_PORT ;
    $params["_EDISPATCHER"]     =   _URL_DISPATCHER;
    $params["_URL_PORTAIL_ACA"] = _URL_PORTAIL_ACA;

    $queryParams=$request->getQueryParams();
    $params["nobootstrap"]      =   array_key_exists('nobootstrap',$queryParams);
    $params["nofont"]           =   array_key_exists('nofont',$queryParams);
    $params["nojquery"]         =   array_key_exists('nojquery',$queryParams);

    $params["zones_arena"]      =   json_encode($this->ci["profil"]->isPersAcad()?$__ARENA_ZONES:[]);

    $params['profil']           =   $profil;
    $params['delay']            =   "";
    $params['config']           =   "{}";

    if (defined("_RESSOURCES_XDESKTOP_FAVORIS") && _RESSOURCES_XDESKTOP_FAVORIS) {
        $params['_RESSOURCES_XDESKTOP_FAVORIS']           =   _RESSOURCES_XDESKTOP_FAVORIS;
    } else {
        $params['_RESSOURCES_XDESKTOP_FAVORIS']           = "";
    }

    if (defined("_CACHE_DEFAULT_DELAY_IN_DAYS") && _CACHE_DEFAULT_DELAY_IN_DAYS) {
        $params['_CACHE_DEFAULT_DELAY_IN_DAYS']           =   _CACHE_DEFAULT_DELAY_IN_DAYS;
    } else {
        $params['_CACHE_DEFAULT_DELAY_IN_DAYS']           = 5;
    }

    // ref #31882 Gérer les ressources perso de la catégorie 'Mes ressources'
    if (defined("_LIBELLE_MES_RESSOURCES") && _LIBELLE_MES_RESSOURCES) {
      $params['_LIBELLE_MES_RESSOURCES']           =   _LIBELLE_MES_RESSOURCES;
    } else {
      $params['_LIBELLE_MES_RESSOURCES']           = "";
    }



    // _EDISPATCHER_NO_REMOTE_CACHE a definir dans le config.local.php pour ne pas avoir de cache distant
    $params["_EDISPATCHER_NO_REMOTE_CACHE"] = defined("_EDISPATCHER_NO_REMOTE_CACHE")?true:false;

    $params['TOKENID']          = "";
    $hubToken = $profil->getHubToken();

    if (!isset($_SESSION["GUID"])) {
      $now=new \DateTime("now");
      $data=openssl_random_pseudo_bytes(16);
      $data[6] = chr(ord($data[6]) & 0x0f | 0x40); // set version to 0100
      $data[8] = chr(ord($data[8]) & 0x3f | 0x80); // set bits 6-7 to 10
      $guid=vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
      $_SESSION["GUID"]=$guid;
      $_SESSION["GUID_TIME"]=$now;
      $token = \R::dispense('token');
      $token->guid=$guid;
      $token->createdAt=$now;
      $token->attribues=serialize($_SESSION["CASATTRIBUTE"]);

      // On va loger le délta en seconds entre  2 visites
      $params['delay'] =   "n/a";
      if ($hubToken) {
        @$rnes=array_unique(GetInfoArray("rne"));
        if ($hubToken->lastGuidTime) {
          $last = (new \DateTime($hubToken->lastGuidTime))->getTimestamp();
          $delta = $now->getTimestamp() - $last;
            if ($metrics) {
                foreach ($rnes as $rne) {
                    $this->ci["metrics"]->visitDelayInSeconds($profil->getProfil(),$rne,$delta,$hubToken->intid);
                }
            }
          $params['delay']           =   $profil->getProfil().":".$delta;
        }

        $hubToken->lastGuidTime = $now;
        $profil->saveToken($hubToken);

        $token->intid=$hubToken->intid;
        
      }
      \R::store($token);
    }

    // GetPortails : this methods use de SESSION GUID
    $params["portails"]         =   $profil->getPortails();

    // Cache
    $caches = [];
    $params['CACHES']            =   $caches;

    $params['GUID']                 =   $_SESSION["GUID"];
    $params['ARENA_ZONE_DEFAUT']    = __ARENA_ZONE_DEFAUT;

    $params['hostname']             = getConfigHostname();


    $params['ELEMENTS_VERSION']  =   VERSION_ELEMENTS;
    if ($hubToken) {
        $params['config']            = $hubToken->config?$hubToken->config:"{}";
        $params['TOKENID']           = $hubToken->id;
    }

    if (file_exists(__CACHE_DIR."/".VERSION_ELEMENTS)) {
      $params['ELEMENTS_CACHE']  = true;
    }

    $response=$response->withHeader('Content-Type', 'application/javascript');

    return $this->ci["view"]->render($response, 'import.js.twig',$params);
  }

  // Metrics ---------------------------------------------------------------------------
  public function metricsAction(Request $request, Response $response, $args) {

    $registry = $this->ci["metrics"]->getRegistry();
    if (!$registry) {
      die("NO METRICS");
    }

    // Nb de comptes par profil
    $profils=\R::getAll("SELECT profil,count(profil) as nb FROM `hubtoken` WHERE 1 group by profil");
    foreach ($profils as $profil) {
      $this->ci["metrics"]->NbComptes($profil["profil"],$profil["nb"]);
    }

    // Nombre d'accès last minute
    $now=new \DateTime("now");
    $now->sub(new \DateInterval('PT1M'));
    $sql= "SELECT profil,count(profil) as nb FROM `hubtoken` WHERE timestamp >= '" . $now->format(\DateTime::ISO8601) . "' group by profil" ;

    $nbComptesLastMinute=\R::getAll($sql);

    $total=["national_1"=>0,"national_2"=>0,"national_3"=>0,"national_4"=>0,"national_5"=>0,"national_6"=>0,"national_7"=>0];
    foreach ($nbComptesLastMinute as $profil) {$total[$profil["profil"]]=$profil["nb"];}
    foreach ($total as $profil=>$count)       {$this->ci["metrics"]->NbAccessLastMinuteByProfil($profil,$count);}

    // byHost
    // first reset counter
    $total=[];
    $sql = "SELECT DISTINCT host FROM `hubtoken` WHERE host is NOT NULL";
    $hosts=\R::getAll($sql);
    foreach ($hosts as $host) {$total[$host["host"]]=0;}

    $sql= "SELECT host,count(host) as nb FROM `hubtoken` WHERE timestamp >= '" . $now->format(\DateTime::ISO8601) . "' group by host" ;
    $nbComptesLastMinute=\R::getAll($sql);
    foreach ($nbComptesLastMinute as $hosts) {
      $total[$hosts["host"]]=$hosts["nb"];
    }
    foreach ($total as $host=>$count) { $this->ci["metrics"]->NbAccessLastMinuteByHost($host,$count);}

    // ==============================================================================================================
    // byEtabType
    // first reset counter
    $total=[];
    $sql = "SELECT DISTINCT etabtype FROM `hubtoken` WHERE etabtype is NOT NULL AND etabtype != ''";
    $hosts=\R::getAll($sql);
    foreach ($types as $type) {$total[$type["etabtype"]]=0;}

    $sql= "SELECT etabtype,count(etabtype) as nb FROM `hubtoken` WHERE timestamp >= '" . $now->format(\DateTime::ISO8601) . "' group by etabtype" ;
    $nbComptesLastMinute=\R::getAll($sql);
    foreach ($nbComptesLastMinute as $types) {
      if (!$types["etabtype"]) {continue;}
      $total[$types["etabtype"]]=$types["nb"];
    }
 
    foreach ($total as $type=>$count) { $this->ci["metrics"]->NbAccessLastMinuteByEtabType($type,$count);}
    // ==================================================================================================================


    $renderer = new RenderTextFormat();
    $result = $renderer->render($registry->getMetricFamilySamples());

    header('Content-type: ' . RenderTextFormat::MIME_TYPE);
    echo $result;
    die();

  }

  public function hubSetTmplAction(Request $request, Response $response, $args) {

    $params=$request->getQueryParams();

    $token= $this->ci["profil"]->getHubToken();
    if ($token && isset($params['name'])) {
        $token->hub_tmpl = $params['name'];
        $this->ci["profil"]->saveToken($token);
        return $response->withJson(["success"=>true]);
    }

    return $response->withJson(["success"=>false]);

  }

  public function hubGetTmplAction(Request $request, Response $response, $args) {

    $token= $this->ci["profil"]->getHubToken();
    if ($token) {
        return $response->withJson(["success"=>true,"name"=>$token->hub_tmpl?$token->hub_tmpl:""]);
    }

    return $response->withJson(["success"=>false]);

  }

  public function hubAction(Request $request, Response $response, $args) {

    $tmpl=__NG_TEMPLATE;
    $params=$request->getQueryParams();
    $metrics = $this->getMetrics();

    $profil = $this->ci["profil"];


    // Un hub token de session : Ceci est utilisé pour savoir si un user est passé par le hub
    $token= $profil->getHubToken();
    if (!$token) {
        $token=\R::dispense( 'hubtoken' );
        $token->hash      = $profil->getHash();
        $token->hashuser  = $profil->getHashWithUser();
        $token->intid     = $profil->getIntid();
        $token->profil    = $profil->getProfil();
        $token->user      = $profil->getUser();
        $token->timestamp = new \DateTime();
        $profil->saveToken($token);
        if ($metrics) {
            $this->ci["metrics"]->newUser($profil);
            $this->ci["metrics"]->visit($profil);
        }
    } else {
        if (isset($_SESSION["GUID_TIME"])) {
            $now=new \DateTime("now");
            $deltaguid = $now->getTimestamp() - $_SESSION["GUID_TIME"]->getTimestamp();
            // Si la derniere session est > 5h, on force le renouvellement
            // test pour voir si corrige pb ou le navigateur reste ouvert toute la nuit
            if ( $deltaguid > 3600*5 /* 5heures, pour test TODO config.eol*/ ) {
                unset($_SESSION["GUID_TIME"]);
                setcookie('edispatcher', 'edispatcherlogout', time() - 3600, '/');
                setcookie('mxdesktop', 'mxdesktoplogout', time() - 3600, '/');
                $url = $this->ci["router"]->pathFor('hub');
                if (array_key_exists('tmpl',$params)) {
                    $url.="?tmpl=" . $params['tmpl'];
                }
                return $response->withRedirect($url);
            }
        }

    }


    $token->intid     = $profil->getIntid();
    if ($metrics)    {
      @$rnes=array_unique(GetInfoArray("rne"));
      foreach ($rnes as $rne) {$metrics->visitUaj($rne,$token->intid);}
      $metrics->activity($token->intid,$token->profil);
    }

    // token de plus de 20mn ou token logout => nouvelle visite
    $now=new \DateTime("now");
    $diff = $now->getTimestamp() - (new \DateTime($token->timestamp))->getTimestamp() ;
    if ($metrics && ($diff > 60*20 || $token->logout) ) {
     $metrics->visit($profil);
     if ($token->logout) {$token->host      = getConfigHostname();}
    }

    // Gestion du template
    if (array_key_exists('tmpl',$params)) {
       $tmpl=rtrim($params['tmpl'],'/');
    } else {
       $token->host      = getConfigHostname();
       // pas de template précisé, il s'agit du hub de dispatching
       if ($metrics) $metrics->dispatching($profil);
       // tmpl défini pour le user ?
       if ($token->hub_tmpl && file_exists(DIR_VIEW.'/hub/'.$token->hub_tmpl.'.html.twig') ) {
         $tmpl = $token->hub_tmpl;
       }

       // Page de transition ATEN => EDUCONNECT
       $aten2educonnect=isset($_GET["aten2educonnect"]) && $_GET["aten2educonnect"]=="true";
       if (!$aten2educonnect  && $profil->getAttribute("source")  == 'TS') {  
          $tmpl = 'samples/aten2educonnect';
       }

    }

    // uaj
    $uaj = "";
    if ($metrics && array_key_exists('uaj',$params)) {
      $uaj=strtoupper($params['uaj']);
      $metrics->uajAccess($profil->getProfil(),$uaj); // Accès établissement
    }

    $params=[];    

    // Refresh demandé
    if (array_key_exists('refresh',$params)) {
        $token->refresh = true;
    }
    $params["refresh"]          = $token->refresh?"true":"false";

    // Fag indiquant de faire un refresh du cache navigateur
    if ($token->refresh) {
      $token->refresh = false;
    }

    // Maj du token
    $token->timestamp = new \DateTime();

    // Type d'établissemments
    $etabtypes=$profil->getAttribute("etabtype",[]);
    if (count($etabtypes)) {
      // Que le premier 
      $etabtype          = reset($etabtypes);
      $token->etabtype   = $etabtype;
    }
    
    $token->logout    = false;


    // verif si token de session existe toujours en base
    $params['md5guid'] = time(); 
    if (isset($_SESSION["GUID"])) {
        $TOKEN=\R::findOne("token"," guid = ?",array($_SESSION["GUID"]));
        // N'existe plus on indique au navigateur qu'un refresh est nécessaire
        // et on efface le GUID de la session  il sera re-créé lors de importAction (import.js)
        // mettre refresh a true indique au layout de 
        // générer le link d'import avec un &_t=random()
        if (!$TOKEN) {
          $params["refresh"] = "true";
          $params['md5guid'] = time(); 
          unset($_SESSION["GUID"]);
        } else {
          $params['md5guid'] = md5($_SESSION["GUID"]); 
        }
    } 
   

    $profil->saveToken($token);


    $params['loading']          = true;
    $params['uaj']              = $uaj;
    $params['dispalyname']      = $profil->getDisplayName();
    $params['profilClass']      = $profil->getProfilClass();
    $params['profilLibelle']    = $profil->getProfilLibelle();
    $params['profil']           = $profil->getProfil();
    $params['intid']            = $profil->getIntId();
    $params['mail']             = strtolower($profil->getMail());
    $params['md5mail']          = md5($params['mail']);
    $params['groupes']          = $profil->getGroupes();
    $params['userProfil']       = $profil;
    $params["__LIBELLE_ETAB"]   = __LIBELLE_ETAB;
    $params["_ONE_REDIRECT"]    = _ONE_REDIRECT;
    $params['ELEMENTS_VERSION'] = VERSION_ELEMENTS;
    $params["template"]         = $tmpl;
    $params['hostname']         = getConfigHostname();


    global $__PIWIK;
    $params["PIWIK"]            = array("url"=>$__PIWIK,"name"=>"hub/". str_replace("/", "_", $tmpl) );

    // Propagattion de paramètres de config/plugin a Twig
    global $__PLUGINS;
    if (isset($__PLUGINS['twig']) ) {
      foreach($__PLUGINS['twig'] as $name) {
        if (isset($__PLUGINS[$name])) {
          $params["plugin_".$name]=$__PLUGINS[$name];
        }
      }
    }

    return $this->ci["view"]->render($response, 'hub/'.$tmpl.'.html.twig',$params);
  }


  private static function endsWith($haystack, $needle)
  {
      $length = strlen($needle);
      if ($length == 0) {
          return true;
      }

      return (substr($haystack, -$length) === $needle);
  }

  private static function startsWith($haystack, $needle)
  {
       $length = strlen($needle);
       return (substr($haystack, 0, $length) === $needle);
  }


}
