<?php

namespace Edispatcher\Entity;

class App extends \RedBeanPHP\SimpleModel {

  private $tmpUrls = [];

  public function update() {
    $this->updatedAt = new \DateTime("now");
  }

  public function getUrls()
  {
    if (!$this->id) return  $this->tmpUrls;
    return $this->bean->ownUrlList;
  }

  public function addUrl($url){
     if (!$this->id) {
         $this->tmpUrls[] = $url;
     } else {
         $this->bean->ownUrlList[] = $url;
     }

  }

  public function getFirstUrlLibelle() {
    if (count($this->bean->ownUrlList)!=0) {
      $first = reset($this->bean->ownUrlList);
      return $first->libelle;
    }
    return "";
  }

  public function getIcon()
  {
    return $this->icon;
  }

  public function getCategory()
  {
    return $this->category;
  }

  public function getHoster()
  {
    return $this->bean->hoster;
  }

  public function getEditor()
  {
    return $this->bean->editor;
  }

  public function tags()
  {
    return explode(",",$this->bean->tags);
  }

  public function getNbUrls()
  {
    return count($this->bean->ownUrlList);
  }

  public function isArena( ) {
      return !strcmp($this->origin, "Arena");
  }

  public function csv($sep="|") {
      if ($this->libelle == "_COMMUN_") return null;
      if (!$this->libelle && $this->origin != "Arena" ) return null;
      $a=[$this->id,
          $this->libelle?$this->libelle:$this->getFirstUrlLibelle(),
          $this->bean->category?$this->bean->category->libelle:"",
          str_replace("\r\n","",nl2br(trim($this->description))),
          $this->bean->hoster?$this->bean->hoster->libelle:"",
      ];
      return implode($sep,$a);
  }

  public function json() {
    $a=["id"=>$this->id,"color" => $this->color,
        "details" => $this->details?$this->details:"",
        "hoster" => $this->bean->hoster?$this->bean->hoster->libelle:"n/a",
        "libelle"=>$this->libelle?$this->libelle:$this->getFirstUrlLibelle(),
        "category" => $this->bean->category?$this->bean->category->json():null];

    return $a;
  }


  public function reorg($verbose) {
    $CR="<br>";
    if (php_sapi_name() == "cli") {$CR="\n";}
    
    if (!$this->pattern) {
      if ($verbose) { echo "no pattern$CR"; }
      return false;
    }

    $bChanged =false;
    $app = $this->bean;

    if (!$app->uid && $app->icon) {
      $app->uid=md5($app->icon);
      $bChanged = true;
    }

    if (!$app->color && $app->icon) {
        $icon = $app->icon;
        // DEBUT Modif CS - NICE (Prise en compte des SVG)
        if(substr($icon->icon,0,4) == "<svg"){
            $rgb = [0,0,0,0];
        }else {
            $rgb = \ColorThief\ColorThief::getColor($icon->icon, 1);
        }
        // FIN Modif CS - NICE
        $c = '#' . sprintf('%02x', $rgb[0]) . sprintf('%02x', $rgb[1]) . sprintf('%02x', $rgb[2]);
        $app->color = $c;
        //$bChanged = true;
    }

    $urlToStore = [];
    $urls=\R::find( 'url','url REGEXP ?',[$app->pattern]);
    if ($verbose) {
      echo " / " . count($urls) . " url(s) to check";
    }

    foreach ($urls as $url) {
      if ($url->app_id == $app->id) {
        continue;
      }

      if ($verbose) {
        echo "$CR =>  " .$url->url." ". $url->libelle . " =>  ". $app->libelle . " (" . $url->app_id.")";
      }

      if ($url->app) {
        unset( $url->app->ownUrlList[$url->id] );
        \R::store($url->app);
      }

      $app->ownUrlList[] = $url;
      $url->app          = $app;
      $urlToStore[]      = $url;

      $bChanged = true;

    }

    \R::storeAll($urlToStore);

    if ($bChanged) {
      echo "$CR";
      \R::store($app);
    } else {
      if ($verbose) {
        echo " / Nothing todo $CR";
      }
    }

    return $bChanged;
  }

  public function __toString() {
             return $this->libelle."";
  }

}
