<?php

namespace Edispatcher\Entity;

class Hubtoken extends \RedBeanPHP\SimpleModel {

  public function getUser() {
    return $this->user;
  }

  public function open() {
    $settings=json_decode($this->settings,true);
    if ($settings) {
      $this->bean->setMeta("settings",$settings);
    } else {
      $this->bean->setMeta("settings",[]);
    }
  }

  // Récupération dun parametre de l'utilisateur
  public function getSetting($key,$default){
    $settings =$this->bean->getMeta("settings");

    if (isset($settings[$key])) {
      $value = $settings[$key];
      // Cas particulier du boolean
      if (is_bool($default) && $value=="off") {
        $value=false;
      }
      return $value;
    }

    return $default;
  }




}
