<?php

namespace Edispatcher\plugins\mail;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;

use Edispatcher\Controllers\BaseController;


function imap_fgets($imap_stream) {
    $read = '';
    $buffer = 4096;
    $results = '';
    $offset = 0;
    while (strpos($results, "\r\n", $offset) === false) {
        if (!($read = fgets($imap_stream, $buffer))) {
        /* this happens in case of an error */
        /* reset $results because it's useless */
        $results = false;
            break;
        }
        if ( $results != '' ) {
            $offset = strlen($results) - 1;
        }
        $results .= $read;
    }
    return trim($results);
}

function error($code)
{
  acho($code,"");
  close();
}

function success($code,$message)
{
  acho($code,$message);
  close();
}

function close()
{
  global $fp;
  if ($fp!=-1 && $fp) fclose($fp);
  die();
}


function acho($count,$msg)
{
  $arr=Array();
  $arr["count"]=$count;

  if ($count > 0) {
    $plu = $count>1?"s":"";
    $message = $msg . "Vous avez <span class=\"badge\">$count</span> message$plu non lu$plu";
  } else {
    $message = $msg;
    $count="";
  }

  $json=json_encode(array("message"=>$message,"count"=>$count));
  if (isset($_GET["api"])) {
      $id=$_GET["id"];
      $api=$_GET["api"];
      header('Content-Type: text/javascript');
      echo "var data=$json;";
      echo "$api('$id',data);";
      die();
  }

  echo "<html><body>";
  echo "<form id='form2submit' name='form2submit' method='POST' action='".$_GET["callback"]."'>";
  echo "<input name='id' id='id' type='hidden' value='".$_GET["id"]."' />";
  echo "<input name='count' id='count' type='hidden' value='".$count."' />";
  echo "<input name='type' id='type' type='hidden' value='"."count"."' />";
  echo "<input name='message' id='message' type='hidden' value='$message' />";
  echo "</form>";
  echo "<script>";
  echo "document.form2submit.submit();";
  echo "</script>";
  echo "</body></html>";

  //echo json_encode($arr);
}

function human_filesize($size, $precision = 2) {
    for($i = 0; ($size / 1024) > 0.9; $i++, $size /= 1024) {}
    return round($size, $precision).['B','kB','MB','GB','TB','PB','EB','ZB','YB'][$i];
}




class Controller extends BaseController   {

  protected $ci;

  //Constructor
  public function __construct(Container $ci) {
    $this->ci = $ci;
    $this->client = curl_init();
    $this->setOption(CURLOPT_RETURNTRANSFER, false);
    $this->setOption(CURLOPT_RETURNTRANSFER, true);
    $this->setOption(CURLOPT_BINARYTRANSFER, true);
    $this->setOption(CURLOPT_SSL_VERIFYPEER, false);
    $this->setOption(CURLOPT_SSL_VERIFYHOST, false);
    $this->setOption(CURLOPT_FOLLOWLOCATION, true);
    $this->setOption(CURLOPT_CONNECTTIMEOUT ,5);
    $this->setOption(CURLOPT_TIMEOUT, 2);
    $this->setOption(CURLOPT_COOKIESESSION, true);
    $this->setOption(CURLOPT_POST, 0);
  }

  protected function setOption($option,$value) {
    curl_setopt($this->client,$option,$value);
  }


 private function getMbo($uid,$url_mbo,$token) {
     

     $profil = $this->ci["profil"];
     $mail   = $profil->getMail();

     $message ="";
     
     if ($this->getSetting("mail_display")) {
        $message = '<div style="color: darkgrey;font-size:11px">' .$mail . "</div>" ;
     }

     $path = "/api/user/" . $uid . "/mbo"; 

     // Options pour curl
     $cookiefile="/tmp/".md5($url_mbo.$token);
     $url = $url_mbo . $path ;
     
     $this->setOption(CURLOPT_URL,$url );
     $this->setOption(CURLOPT_COOKIEJAR,$cookiefile);
     $this->setOption(CURLOPT_COOKIEFILE,$cookiefile);
     if (isset($__PLUGINS['mail']['connecttimeout'])) {
        $this->setOption(CURLOPT_CONNECTTIMEOUT,$__PLUGINS['mail']['connecttimeout']);
     }
     if (isset($__PLUGINS['mail']['timeout'])) {
        $this->setOption(CURLOPT_TIMEOUT,$__PLUGINS['mail']['timeout']);
     }

     // token api
     $headers = array();
     $headers[] = "token: $token";
     $this->setOption(CURLOPT_HTTPHEADER, $headers);

     $data = curl_exec ($this->client);
     $status= curl_getinfo($this->client,CURLINFO_HTTP_CODE);
     if ($status!="200") {
        return $message;
     }
     $resp=json_decode($data,true);

     if (isset($resp["data"]) && isset($resp["data"]["values"] )  && isset($resp["data"]["values"]["quota"]) ) {
        $quota    = $resp["data"]["values"]["quota"];
        

            $text    = 'quota ' . $quota["percent"] . "% sur " . human_filesize($quota["limit"]*1024,1);
            $percent = $quota["percent"];
            
            $style = 'position: absolute;mix-blend-mode: darken;font-size: 11px;';
            if ($percent<=50) {
                $color = 'progress-bar-success';
            } elseif ($percent<=90) {
                $color = 'progress-bar-warning';
            } else {
                $color = 'progress-bar-danger';
                $style = 'position: fixed;margin-left: 5px;color:white;font-size: 11px;';
                $text  = '<i class="fa fa-exclamation-triangle"></i> &nbsp;&nbsp;' . $text;
            } 

            $quotaSettings = $this->getSetting("mail_quota");
            $bDisplay = false;
            if ( $quotaSettings == "always" ) {$bDisplay=true;}
            elseif( $quotaSettings == "gt50" && $percent>=50 ) {$bDisplay=true ;}
            elseif( $quotaSettings == "gt80" && $percent>=80 ) {$bDisplay=true ;}

            if ($bDisplay) {
                $progress='<div class="progress" style="height:15px;margin-bottom:0px;"><span style="'.$style.'">'.$text.'</span><div class="progress-bar '.$color.' "  role="progressbar" aria-valuenow="'.$percent.'" aria-valuemin="0" aria-valuemax="100" style="width:'.$percent.'%"></div></div>';
                $message='<table style="width:100%" class="hide-in-tooltip"><tr><td>'.$message.'</td><td style="width:120px;">'.$progress.'</td></tr></table><br>';
            }
           
     }
    

     return $message;
 }

 public function checkMdp(Request $request, Response $response, $args) {
    global $__PLUGINS;

    if (!isset($__PLUGINS['mail']))  {die("NOT CONFIGURED");}

    $profil = $this->ci["profil"];
    if (!$profil->isPersAcad()) {
        return  $response->withJson(0);
    }

    $url    = $__PLUGINS['mail']['checkuser_url'];
    $token  = $__PLUGINS['mail']['checkuser_api'];

    $uid = $profil->getUser();
    $path = "/api/user/" . $uid . "/mdp"; 

     // Options pour curl
     $cookiefile="/tmp/".md5($url.$token);
     $url = $url . $path ;
     
     $this->setOption(CURLOPT_URL,$url );
     $this->setOption(CURLOPT_COOKIEJAR,$cookiefile);
     $this->setOption(CURLOPT_COOKIEFILE,$cookiefile);

     if (isset($__PLUGINS['mail']['connecttimeout'])) {
        $this->setOption(CURLOPT_CONNECTTIMEOUT,$__PLUGINS['mail']['connecttimeout']);
     }
     if (isset($__PLUGINS['mail']['timeout'])) {
        $this->setOption(CURLOPT_TIMEOUT,$__PLUGINS['mail']['timeout']);
     }
     

     // token api
     $headers = array();
     $headers[] = "token: $token";
     $this->setOption(CURLOPT_HTTPHEADER, $headers);

     $data = curl_exec ($this->client);
     $status= curl_getinfo($this->client,CURLINFO_HTTP_CODE);
     if ($status!="200") {
        die("1");
     }
     $resp=json_decode($data,true);
     if (isset($resp["data"]) && isset($resp["data"]["values"]) 
         && isset($resp["data"]["values"]["strength"])) {
            return  $response->withJson($resp["data"]["values"]["strength"]);
     }

 }

 public function checkAction(Request $request, Response $response, $args) {


    global $__PLUGINS;
    global $fp;

    if (!isset($__PLUGINS['mail']))  {die("NOT CONFIGURED");}



    $profil = $this->ci["profil"];
    if (!$profil->isPersAcad()) {
        die('NO PERS ACAD');
    }

    $token  = $profil->getHubToken();
    if (!$token) {
        die("NO TOKEN");
    }


    $uid = $profil->getUser();

    $adm_user =$__PLUGINS['mail']['user'];
    $adm_pwd  =$__PLUGINS['mail']['password'];
    $host     =$__PLUGINS['mail']['host'];
    $port     =$__PLUGINS['mail']['port'];
    $domaine  =$__PLUGINS['mail']['domaine'];

    $message = "";
    if (isset($__PLUGINS['mail']['checkuser_api']) && isset($__PLUGINS['mail']['checkuser_url'] ) ) {
        $message = $this->getMbo($uid,$__PLUGINS['mail']['checkuser_url'],$__PLUGINS['mail']['checkuser_api']);
    }

    # fixes #
    if ($mailHostFromAttribut = $profil->getAttribute("mailHost","") ) {
        $host = $mailHostFromAttribut;
    }

    $plain=base64_encode("$uid@$domaine\0$adm_user\0$adm_pwd");

    $fp = fsockopen($host, $port);
    if(!$fp) {
        $fp=-1;
        error(-1);
    }

    $ret=imap_fgets($fp);

    fwrite($fp, ". AUTHENTICATE PLAIN $plain\r\n");

    $ret=imap_fgets($fp);
    if ($ret != ". OK User $uid logged in") error(-2);

    fwrite($fp,". STATUS INBOX (UNSEEN)\r\n");
    $ret=imap_fgets($fp);

    $regs = array(false, false);
    if (preg_match("/UNSEEN ([0-9]+)/", $ret, $regs)) {
        success($regs[1],$message);
    }

    error(-3);


 }


}
