<?php

namespace Edispatcher\plugins\profilage;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Edispatcher\Controllers\BaseController;


class Controller extends BaseController {

  public function applicationsAction(Request $request, Response $response, $args) {

    global $__PLUGINS;
    $config = $__PLUGINS["profilage"];

    $username = $config["username"];
    $password = $config["password"];
    $context = stream_context_create(array(
      'http' => array(
          'header'  => "Authorization: Basic " . base64_encode("$username:$password")
      )
    ));

    $applications = file_get_contents("http://". $config["host"] ."/profilage/applications",false,$context);
    $applications = json_decode($applications,true);

    $profils = []; $uid ="";
    if (isset($args["uid"])) {
        $uid = $args["uid"];
        $all =  file_get_contents("http://". $config["host"] ."/applications/PersEducNat/" . $uid ,false,$context);
        $all = json_decode($all,true);
        foreach ($all as $p) {
            $profils[$p["name"]] = $p["profile"];
        }
        //print_r($profils);die();

    }


    foreach ($applications as $name => $app) {
      $url=\R::findOne( 'url', 'url  = ?',[$app["url"]]);
      if ($url ) {
        $applications[$name]["ref"] = $url->getApp();
      }
    }

    return $this->ci["view"]->render($response, '@profilage/applications.html.twig',
                                     $this->genParams(["applications"=>$applications,"profils"=>$profils,"uid"=>$uid]));
  }

}
