<?php

if(php_sapi_name() != "cli") {
  die("mode cli requis");
}

define("ROOT_DIR",dirname(__FILE__)."/..");
define("INC_DIR",ROOT_DIR."/include");
include_once(INC_DIR.'/dispatcher.config.php');
include_once(INC_DIR.'/db.config.php');

include_once(ROOT_DIR.'/arena/arena_inc.php');

// WebServices Init
$client = WS();

chdir(ROOT_DIR.'/caches');
foreach (glob("*:*") as $filename) {
    $time=filemtime($filename);
    $a=explode(":",$filename);
    if (!is_array($a) || count($a)!=2) continue;

    $uid=$a[0];
    $zone=$a[1];

    echo R::isoDateTime().":$uid:$zone";
    $cache  = R::findOne( 'arenacache', ' uid = ? and zone  = ? ', array($uid,$zone));

    // Création du cache si inexistant
    if (!$cache) {
      $cache = R::dispense('arenacache');
      $cache->uid=$uid;
      $cache->zone=$zone;
    }

    // Si c'est a jour on ne fait rien
    if ($cache->isRecent()) {
      echo " A JOUR\n";
      continue;
    }

    // Le temps de création sera celui du fichier
    $date = new DateTime();
    $date->setTimestamp($time);

    $result=$client->getRessourcesPortail($uid,$zone);
    $items=objectToArray($result);

    // Ne semble pas être un bon uid, suppression du fichier
    if (!is_array($items) || count($items)==0) {
      echo " --\n";
      unlink($filename);
      continue;
    }

    $cache->setCache($items);
    $cache->updated=$date;
    $cache->access();
    R::store( $cache );

    echo " OK\n";

}

?>
