<?php

include_once "uinc.php";
use Edispatcher\Controllers\ParamController;
use Edispatcher\Entity\Param;

// Script pour créer une structure de base de edispatcher

// Création d'une category
$cat=\R::dispense("category");
$cat->name    = "CATEGORY";
$cat->libelle = "CATEGORY_LIBELLE";
$cat->icon    = "fa-check";
$cat->color   = "#FFF";
$cat->arenaid = 1234;
$cat->indice  = 1;
\R::store($cat);


// Tag
$tag=\R::dispense("tag");
$tag->name="TAGNAME";
$tag->color="color";
\R::store($tag);


// Création d'un hebergeur
$host=\R::dispense("hoster");
$host->libelle = "libelle";
\R::store($host);

include_once "icon2SepTable.php";

// Création d'une url
$eUrl=\R::dispense("url");
$eUrl->url      = "http://xxx.uyuyyy.ac-reunion.fr";
$eUrl->arenaid  = "arenaid";
$eUrl->urlct    = "/xxx";
$eUrl->resarena = "Gestion des personnels-sepSIGATsep-Gestion des déplacements temporaires (DT)-sepSIGATsep-chorus-dt";
$eUrl->zone     = "rev-proxy-id";
$eUrl->host     = "www.ac-reunion.fr";
$eUrl->libelle  = "libelle long";
$eUrl->description = "sdsd dsds s dsd sd sd s dsds";
$eUrl->category  = $cat;
$eUrl->hoster    = $host;
$eUrl->iconUpdatedAt = new \DateTime();
$eUrl->updatedAt     = new \DateTime();
$eUrl->md5url     ="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
$eUrl->new = true;
$eUrl->obsolete  = false;
$eUrl->hidden = false;

// Création d'une app
$a=\R::dispense("app");
$a->uid     = "todelete";
$a->arenaid = "arenaid";
$a->libelle = "libelle";
$a->origin  = "arena";
$a->description  = "sdsd  dsds s dsd sd sd s dsds";
$a->pattern      = "(.*)";
$a->new     = true;
$a->iconUpdatedAt = new \DateTime();
$a->updatedAt     = new \DateTime();
$a->category      = $cat;
$a->hoster        = $host;
$a->color         = "color";
$a->zone          = "zonerzo";
$a->tags          = "tags1,tags2";
$a->details       = "dsdsds dsdsd";
$a->obsolete = false;
$a->hidden = false;
$a->used   = false; // indique si les infos de app sont utiliser par api/ressources

// Cache arena
$arenacache=\R::dispense("arenacache");
$arenacache->created = new \DateTime();
$arenacache->updated = new \DateTime();
$arenacache->acceded = new \DateTime();
$arenacache->locked = false;
$arenacache->uid = "uid";
$arenacache->zone = "zone-arena";
$arenacache->content = "sldmlsdmlsmdlsmdlsdmlsd sdlsmdlsmdlsmdlsm sdmsldmsldmsldmsl sdlsmdlsmdlsd";
$arenacache->timetoload = 1234.56;
\R::store($arenacache);
\R::trash($arenacache);

// hubtoken :
$hubtoken=\R::dispense("hubtoken");
$hubtoken->hash      = md5("hash de token");
$hubtoken->hashuser  = md5("hash de token");
$hubtoken->intid     = "123456";
$hubtoken->profil    = "national_1";
$hubtoken->host      = "hostaname";
$hubtoken->logout    = true;
$hubtoken->etabtype  = "XXXXXXXXXX";
$hubtoken->user      = "uid_de_l_utilisateur";
$hubtoken->settings  = str_repeat("x",5024); // ref #25767 Pour forcer le type TEXT en bdd
$hubtoken->timestamp = new \DateTime();
\R::store($hubtoken);
\R::trash($hubtoken);

// token de session
$token = R::dispense('token');
$token->guid        = md5(time());
$token->intid       = 123456789;
$token->createdAt   = new DateTime();
$token->attribues   = serialize(["mail","uid","xxx"]);
\R::store($token);
\R::trash($token);

// Relation app -> url
$a->ownUrlList[] = $eUrl;
\R::store($a);

// url -> app
$eUrl->app = $a;
\R::store($eUrl);

// Suppression des entrées manuelles
\R::trash($a);
\R::trash($eUrl);
\R::trash($cat);
\R::trash($host);
\R::trash($tag);



// creation des roles ==================================================

$roleAdmin=\R::findOne("role","name = ?",[Edispatcher\Entity\Deleg::ADMIN]);
if (!$roleAdmin) {
    $roleAdmin =  \R::dispense("role");
    $roleAdmin->name = Edispatcher\Entity\Deleg::ADMIN;
    $roleAdmin->libelle = "Administrateur";
    \R::store($roleAdmin);
}


$roleReader=\R::findOne("role","name = ?",[Edispatcher\Entity\Deleg::READER]);
if (!$roleReader) {
    $roleReader =  \R::dispense("role");
    $roleReader->name = Edispatcher\Entity\Deleg::READER;
    $roleReader->libelle = "Consultation";
    \R::store($roleReader);
}


$roleCache=\R::findOne("role","name = ?",[Edispatcher\Entity\Deleg::CACHE]);
if (!$roleCache) {
    $roleCache =  \R::dispense("role");
    $roleCache->name = Edispatcher\Entity\Deleg::CACHE;
    $roleCache->libelle = "Actualiser le cache";
    \R::store($roleCache);
}

$roleGest=\R::findOne("role","name = ?",[Edispatcher\Entity\Deleg::GEST]);
if (!$roleGest) {
    $roleGest =  \R::dispense("role");
    $roleGest->name = Edispatcher\Entity\Deleg::GEST;
    $roleGest->libelle = "Gestionnaire";
    \R::store($roleGest);
}


$admin=\R::findOne("deleg","value = ?",["admin"]);
if (!$admin) {
  $admin = \R::dispense("deleg");
}
$admin->value = "admin";
$admin->role  = $roleAdmin;
\R::store($admin);

// Prise en compte du 2eme admin de genConfig
if (defined('__ADMIN2') &&  __ADMIN2) {
  $admin2=\R::findOne("deleg","value = ?",[__ADMIN2]);
  if (!$admin2) {
    $admin2 = \R::dispense("deleg");
  }
  $admin2->value = __ADMIN2;
  $admin2->role  = $roleAdmin;
  \R::store($admin2);
}


// ==================================================================

// A SUPPRIMER
$cleon=\R::findOne("deleg","value = ?",["christophe.leon@ac-reunion.fr"]);
if (!$cleon) {
  $cleon = \R::dispense("deleg");
}
$cleon->value = "christophe.leon@ac-reunion.fr";
$cleon->role  = $roleAdmin;
//\R::store($cleon);

// Ajustement des autres champs
\R::exec("ALTER TABLE  `app` CHANGE  `uid`  `uid` VARCHAR( 50 );");
\R::exec("ALTER TABLE `url`  CHANGE `md5url` `md5url` CHAR(32) CHARACTER SET ascii COLLATE ascii_general_ci NOT NULL;");
\R::exec("UPDATE `url` SET `md5url`= md5(`url`);");
try {
        \R::exec("ALTER TABLE `url` DROP INDEX UQ_d199ec153ccff2bb155aa543f7c4957823daa439;");
 } catch( \Exception $e) {
}
try {
          \R::exec("ALTER TABLE `url` DROP INDEX url;");
 } catch( \Exception $e) {
}
\R::exec("ALTER TABLE  `url` CHANGE  `url`  `url` VARCHAR( 2048 );"); // fixes #22746 :
//\R::exec("ALTER TABLE  `url` ADD INDEX(`url`);");
\R::exec("ALTER TABLE  `arenacache` CHANGE  `uid`  `uid` VARCHAR( 50 );");
\R::exec("ALTER TABLE  `arenacache` CHANGE  `zone`  `zone` VARCHAR( 50 );");
\R::exec("ALTER TABLE  `arenacache` CHANGE  `content`  `content` longtext;");


// Création d'un param
$param=\R::dispense("param");
$param->name="XXXX";
$param->value="XXXXYYYYZZZZZ";
\R::store($param);
\R::trash($param);


  // Ajout des Index si besoin
  try {
    $a = \R::dispense("app");
    $a->uid = md5(time())."xx";
    $a->uid2 = md5(time())."xx";
    $a->setMeta("buildcommand.unique" , [["uid"]]);
    \R::store($a);
    \R::trash($a);
  } catch( \Exception $e) {
    print_r($e->getMessage());
  }

  try {
    $u = \R::dispense("url");
    $u->md5url="xxxxxxxx";
    $u->setMeta("buildcommand.unique" , [["md5url"]]);        // UQ_3cd0dff23014597359ec507188fd3ca1f21527f9
    \R::store($u);
    \R::trash($u);
    // ref #23635 et # 24325 | Flag pour gérer la version
    // flag utilisé dans ApiController
    ParamController::setValue(Param::DB_VERSION,Param::DB_VERSION_2);

  } catch( \Exception $e) {
    print_r($e->getMessage());
  }

  try {
    $c = \R::dispense("arenacache");
    $c->setMeta("buildcommand.unique" , [["uid","zone"]]);
    \R::store($c);
    \R::trash($c);
  } catch( \Exception $e) {
    print_r($e->getMessage());
  }


