<?php

include_once "uinc.php";

\R::exec('CREATE TABLE IF NOT EXISTS icon (id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY, icon BLOB NULL, md5icon CHAR(32) NULL UNIQUE, updated_at DATETIME NULL)');

$columns_app = \R::inspect('app');  //On vérifie que la table n'est pas déjà sur la novuelle structure
if (array_key_exists('icon_id', $columns_app)) {    //Si c'est le cas on ne fait rien
    echo "\nVerification des icones : La table app est deja sur la nouvelle structure (champ icon_id existe)\n";
}
else {              //En revanche, si c'est encore l'ancienne structure, on lance le scrpt

$apps=\R::findAll( 'app');

foreach ($apps as $app ) {
    $icone = $app->icon;
    if ($icone) {
        $md5icon = md5($icone);
        $icon = \R::findone('icon', 'md5icon = ?', [$md5icon]);
        if ($icon) {
            $app->icon = $icon;
        }
        else {
            $icon = \R::dispense("icon");
            $icon->icon = $app->icon;
            $icon->md5icon = $md5icon;
            $icon->updated_at = new DateTime();
            $app->icon = $icon;
            \R::store($icon);
        }
        \R::store($app);
    }
}

    \R::exec('ALTER TABLE `app` CHANGE `icon` `old_icon` BLOB NULL DEFAULT NULL');
}


$columns_url = \R::inspect('url');  //On vérifie que la table n'est pas déjà sur la novuelle structure
if (array_key_exists('icon_id', $columns_url)) {    //Si c'est le cas on ne fait rien
        echo "\nVerification des icones : La table url est deja sur la nouvelle structure (champ icon_id existe)\n";
}
else {              //En revanche, si c'est encore l'ancienne structure, on lance le scrpt

$urls=\R::findAll( 'url');

foreach ($urls as $url ) {
    $icone = $url->icon;
    if ($icone) {
        $md5icon = md5($icone);
        $icon = \R::findone('icon', 'md5icon = ?', [$md5icon]);
        if ($icon) {
            $url->icon = $icon;
        }
        else {
            $icon = \R::dispense("icon");
            $icon->icon = $url->icon;
            $icon->md5icon = $md5icon;
            $icon->updated_at = new DateTime();
            $url->icon = $icon;
            \R::store($icon);
        }
        \R::store($url);
    }
}

    \R::exec('ALTER TABLE `url` CHANGE `icon` `old_icon` BLOB NULL DEFAULT NULL');
}


// CATEGORY 
$columns_category = \R::inspect('category');  //On vérifie que la table n'est pas déjà sur la novuelle structure
if (array_key_exists('icon_id', $columns_category)) {    //Si c'est le cas on ne fait rien
        echo "\nVerification des icones : La table category est deja sur la nouvelle structure (champ icon_id existe)\n";
}
else {              
    //En revanche, si c'est encore l'ancienne structure, on lance le scrpt

    $categories=\R::findAll( 'category');

    $default_icon_content=file_get_contents(__DIR__.'/../icones/default-categorie.svg');
    $md5default  = md5($default_icon_content);
    $defaultIcon = \R::findone('icon', 'md5icon = ?', [$md5default]);
    if (!$defaultIcon) {
        $defaultIcon = \R::dispense("icon");
        $defaultIcon->icon = $default_icon_content;
        $defaultIcon->md5icon = $md5default;
        $defaultIcon->updated_at = new DateTime();
        \R::store($defaultIcon);
    }

    foreach ($categories as $cat ) {
        $icone   = $cat->icon;
        if ($icone) {
            $cat->fa = $icone;
        } else {
            $cat->icon=$defaultIcon;
        }
        
        \R::store($cat);
    }

    \R::exec('ALTER TABLE `category` DROP `icon`');

    
}

$icon = \R::dispense("icon");
$icon->svg=false;
\R::store($icon);
\R::trash($icon);

