<?php

namespace Edispatcher\Bot;

class GrafanaWorkerThread {


  static public $GRAPHS = array();
  static public $CLIENT = null;

  public $channnel = null;

  public static function init($client) {
    self::$GRAPHS=[
      "LDAP" => ["dashboard" => "metice-metrics" , "panel" => 1, "message" => "Temps de réponse LDAP" ,"title"=>"LDAP"],
      "HUBACC" => ["dashboard" => "metice-metrics" , "panel" => 7, "message" => "Répartition des accès par serveur hubole" ,"title"=>"HUBACC"],
      "HUBPRO" => ["dashboard" => "metice-metrics" , "panel" => 3, "message" => "Répartition des accès par profil" ,"title"=>"HUBPRO"],
      "COHOUR" => ["dashboard" => "metice-metrics" , "panel" => 15, "message" => "Connexion /heure" ,"title"=>"COHOUR"],
      "CODAY"  => ["dashboard" => "metice-metrics" , "panel" => 16, "message" => "Connexion /jour" ,"title"=>"CODAY"],
      "ARCHI"  => ["dashboard" => "metice-metrics" , "panel" => 18, "message" => "Charge CPU de l'architecture" ,"title"=>"ARCHI"],

      "HUBMASTERCPU" => ["dashboard" => "systeme-hubole" , "panel" => 7, "message" => "Charge CPU hubole-master" ,"title"=>"HUBMASTERCPU","extra"=>"var-node=hubole-master.ac-reunion.fr%3A9100"],
      "HUBSLAVECPU" => ["dashboard" => "systeme-hubole" , "panel" => 7, "message" => "Charge CPU hubole-slave" ,"title"=>"HUBSLAVECPU","extra"=>"var-node=hubole-slave.ac-reunion.fr%3A9100"],
      "HUBCPU" => ["set"=>["HUBMASTERCPU","HUBSLAVECPU"],"title"=>"HUBCPU","message"=>"Charge CPU des hubole"],

      "SSOMASTERCPU" => ["dashboard" => "systeme-sso" , "panel" => 7, "message" => "Charge CPU sso-master" ,"title"=>"SSOMASTERCPU","extra"=>"var-node=sso-master.ac-reunion.fr%3A9100"],
      "SSOSLAVECPU" => ["dashboard" => "systeme-sso" , "panel" => 7, "message" => "Charge CPU sso-slave" ,"title"=>"SSOSLAVECPU","extra"=>"var-node=sso-slave.ac-reunion.fr%3A9100"],
      "SSOHACPU" => ["dashboard" => "systeme-sso" , "panel" => 7, "message" => "Charge CPU sso-ha" ,"title"=>"SSOHACPU","extra"=>"var-node=sso.ac-reunion.fr%3A9100"],
      "SSOCPU" => ["set"=>["SSOMASTERCPU","SSOSLAVECPU","SSOHACPU"],"title"=>"SSOCPU","message"=>"Charge CPU des SSO"],
      "SSOMEM" => ["dashboard" => "sso" , "panel" => 3, "message" => "Mémoire des serveurs SSO" ,"title"=>"SSOMEM"],

      "SSOTIC" => ["dashboard" => "metice-metrics" , "panel" => 11, "message" => "Nombre de tickets SSO" ,"title"=>"SSOTIC"],
      "SSOACC" => ["dashboard" => "metice-metrics" , "panel" => 12, "message" => "Connexions SSO" ,"title"=>"SSOACC"],

      "ACTIME" => ["dashboard" => "metice-metrics" , "panel" => 5, "message" => "Temps de chargement du cache ARENA" ,"title"=>"ACTIME"],
      "AWTIME" => ["dashboard" => "metice-metrics" , "panel" => 6, "message" => "Temps de récupération du WebService ARENA" ,"title"=>"AWTIME"],




    ];

    foreach (self::$GRAPHS as $key => $data) {
        $data["title"] = $key;
    }

    self::$CLIENT = $client;
  }

  public static function GenerateGraphique($bot,$type,$from=null,$message=true) {

    if (!isset(GrafanaWorkerThread::$GRAPHS[$type])) {
      return;
    }

    $params=GrafanaWorkerThread::$GRAPHS[$type];

    // Plusieurs graph a afficher
    if (isset($params["set"])) {
      $bot->reply("à votre service, je demande tout de suite la génération des graphiques *".$params["message"]."*, cela peut prendre un peu de temps...");
      foreach ($params["set"] as $type) {
        self::GenerateGraphique($bot,$type,$from,false);
      }
      return;
    }

    $data=openssl_random_pseudo_bytes(16);
    $uid=vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    $dashboard=$params["dashboard"];
    $panel=$params["panel"];

    // Gestion de la periode
    $periode ="";
    if (!$from) {
        $from=(time() - 3600 * 12)*1000;
    } else {
        $periode = "débutant le ".date("d/m/Y H:i:s",$from);
        $from = $from * 1000;
    }
    $to="now";


    $extra="extra=1";
    if (isset($params["extra"])) {
      $extra=$params["extra"];
    }

    $channel = $bot->getMessage()->getChannel();

    $DIR="/var/www/html/edispatcher/utils";

    $b=\Edispatcher\Entity\Metrics::instance()->addGrafanaWorker($uid,$channel,$params["title"],"$dashboard|$panel|$from|$to|$uid|$extra");
    if ($b) {
        if ($message) $bot->reply(":construction: à votre service, je demande tout de suite la génération du graphique *".$params["message"]."* $periode, cela peut prendre un peu de temps...");
        exec("nohup php $DIR/grafanaworker.php >> /tmp/grafana.worker 2>&1 &");
    } else {
        $bot->reply(":warning: Service de genération des graphiques indisponible, désolé !!");
    }

  }

  public function __construct($data){
    $data = explode(";",$data);

    $this->uid=$data[0];
    $this->channel=$data[1];

    $key = $data[2];
    $this->data=self::$GRAPHS[$key];

    $this->task=$data[3];

  }

  public function run(){

    $img_url = _URL_DISPATCHER  . '/edispatcher/ng/public/api/grafana/img/g-'.$this->uid.'.png';
    echo $img_url."\n";
    $c = 0;
    while ($c<60){
      if (@file_get_contents($img_url,0,null,0,1) === FALSE) {
        sleep(1);
        $c=$c+1;
      } else {
        break;
      }
    }

    $message=$this->data["message"];
    $title=$this->data["title"];

    if ($c>=60) {
        $message="La génération à échoué, désolé !!";
        $title="La génération à échoué, désolé !!";
        $img_url = "";
    }



    $attach = [
      'fallback'=> $message,
      'text'=> "*".$title."* " . $message,
      'pretext'=> "",

      'color'       => "good",
      'ts'          => time(),

      'fields'  => [],

      'author_name' => "Metice BOT",
      'author_icon' => "http://grafana.org/assets/img/fav32.png",
      'footer'      => "",
    ];

    if ($img_url) $attach["image_url"] = $img_url;

    GrafanaWorkerThread::$CLIENT->to($this->channel)->attach($attach)->send(":bar_chart: voici votre graphique ");
  }
}
