<?php

namespace Edispatcher\Entity;

class Deleg extends \RedBeanPHP\SimpleModel {

    const ADMIN   = "ADMIN";
    const READER  = "READER";
    const CACHE   = "CACHE";
    const GEST    = "GEST";


    public function getRoleLibelle()
    {
      return $this->bean->role->libelle;
    }

    public function isGroupe() {
        return $this->value[0]=="#";
    }

    public function isMail() {
        return strpos($this->value, "@")!==false;
    }

    public function isUid() {
        return !$this->isGroupe() && ! $this->isMail();
    }

    public function getType() {
        if ($this->isGroupe()) { return "groupe"; }
        if ($this->isMail())   { return "mail"; }
        return "uid";
    }

    public function getIcon() {
        if ($this->isGroupe()) { return "fa-users"; }
        if ($this->isMail())   { return "fa-envelope"; }
        return "fa-user";

    }

    public function check($token) {
        if ($this->isGroupe()) {
            $groupes=$token->getAttribute("groupes",[]);
            //print_r($groupes);die($token->value);
            return in_array(str_replace("#","",$this->value),$groupes);
        }


        if ($this->isMail()) {
            $mail=$token->getAttribute("mail","");
            return strcasecmp($mail,$this->value)==0;
        }


        $uid=$token->getUser();
        return strcasecmp($uid,$this->value)==0;


    }



}
