<?php

include_once 'apps-inc.php';

// Routage ===============================================================
$app->get('/'                   ,'Default:homeAction'       )->setName('home');

$app->post('/callback.php'      ,'Default:callbackAction'   )->setName('calback');
$app->get('/callback.php'       ,'Default:callbackAction'   )->setName('calback');
$app->get('/import.js'          ,'Default:importAction'     )->setName('import');

// Import js avec flags pour pouvoir mettre en cache côté navigateur
// avec import.js on a
// /edispatcher/ng/import.js?nojquery&nofont&nobootstrap
// L'idée serait d'avoir plutot
// /edispatcher/ng/importjs/<id du user>/<version_ed>/nojquery-nofont-nobootstrap
// Qui pourait être mis en cache côté navigateur
$app->get('/importjs/{id}/{version}/{flags}'  ,'Default:importjsAction'     )->setName('importjs');

$app->get('/redirect'          ,'Default:redirectAction'     )->setName('redirect');

$app->get('/hub'                ,'Default:hubAction'        )->setName('hub');
$app->post('/hub/tmpl'          ,'Default:hubSetTmplAction' )->setName('hub_set_tmpl');
$app->get('/hub/tmpl'          ,'Default:hubGetTmplAction' )->setName('hub_get_tmpl');

$app->get('/logout'             ,'Default:logoutAction'     )->setName('logout');
$app->get('/_logout'            ,'Default:logout2Action'     )->setName('logout2');
$app->get('/logoutSSO'          ,'Default:logoutSSOAction'  )->setName('logoutSSO');


$app->get('/public/metrics'     ,  'Default:metricsAction' );

//if ($deleg->isReader() || $deleg->isGest() || $deleg->isManager() ) {
if ($deleg->isReader()) {
    $app->get('/list'               ,'App:showAppsAction'   )->setName('apps2');
    $app->get('/app/list'           ,'App:showAppsAction'   )->setName('apps');
    $app->get('/app/export'         ,'App:exportAppsAction' )->setName('apps_export');
    $app->get('/url/orphan'         ,'App:urlOrphanAction'  )->setName('url_orphan');
    $app->get('/url/list'           ,'App:urlListAction'    )->setName('urls');
    $app->get('/url/arena/list'     ,'App:urlArenaListAction'    )->setName('urls_arena');
    $app->get('/cat/list'           ,'Category:showCategoriesAction'   )->setName('cats');
}

// fixes #25604 app_view , url_view doivent être accessibles pour tout le monde
// utilisé dans import.js.twig pour affichage en mode card
$app->get('/app/{id}/view'        ,'App:viewAppAction'    )->setName('app_view');
$app->get('/url/{id}/view'       ,'App:viewUrlAction'    )->setName('url_view');


//if ($deleg->isGest() || $deleg->isManager() ) {
if ($deleg->isGest()) {
    $app->get('/app/{id}/edit'      ,'App:editAppAction'    )->setName('app_edit');
    $app->get('/app/create'         ,'App:createAppAction'  )->setName('app_create');
    $app->post('/app/{id}/save'     ,'App:saveAppAction'    )->setName('app_save');
    $app->post('/url/set'           ,'App:urlOrphanSetAction' )->setName('url_set');
}

if ($deleg->isManager() ) {
    $app->get('/deleg'              ,'Deleg:delegAction'    )->setName('deleg');
    $app->post('/deleg/create'      ,'Deleg:createAction'    )->setName('deleg_create');
    $app->get('/deleg/{id}/delete'  ,'Deleg:deleteAction'    )->setName('deleg_delete');
    $app->post('/deleg/{id}/edit'   ,'Deleg:editAction'    )->setName('deleg_edit');

    $app->get('/app/init'           ,'App:initAction'   )->setName('apps_init');
    $app->get('/cat/{id}/edit'      ,'Category:editCategoryAction'    )->setName('cat_edit');
    $app->get('/cat/create'         ,'Category:editCategoryAction'    )->setName('cat_create');
    $app->post('/cat/{id}/save'      ,'Category:saveCategoryAction'    )->setName('cat_save');
    $app->post('/cat/save'      ,'Category:saveCategoryAction'    )->setName('cat_savenew');

    $app->get('/app/verif'           ,'App:verifAppAction'   )->setName('apps_verif');
    $app->get('/url/verif'           ,'App:verifUrlAction'   )->setName('urls_verif');
}

if ($deleg->isCacheManager()   ) {
    $app->get("/arena/cache", 'Arena:cacheAction')->setName('arena_cache_search');
    $app->get("/arena/cache/", 'Arena:cacheAction');
    $app->get("/arena/cache/{uid}", 'Arena:cacheAction')->setName('arena_cache');
    $app->get("/arena/cache/{uid}/refresh", 'Arena:refreshAction')->setName('arena_refresh');
}

$app->get('/accueil'      ,'App:accueilAction'    )->setName('accueil');

$app->get('/app/{id}/count'       ,'App:statsAppAction'    )->setName('app_stats');
$app->get('/app/{id}/byProfil'    ,'App:statsAppByProfilAction'    )->setName('app_profil_stats');
$app->get('/app/{id}/byUaj'       ,'App:statsAppByUajAction'    )->setName('app_uaj_stats');
$app->get('/app/byProfilAndApp'   ,'App:statsAppsByProfilAppAction'    )->setName('apps_profilAndApp_stats');
$app->get('/app/byProfil'         ,'App:statsAppsByProfilAction'    )->setName('apps_profil_stats');


$app->get('/accounts/available/byProfil'         ,'App:statsAccountsAvailableByProfilAction'    )->setName('accounts_available_profil_stats');
$app->get('/accounts/used/byProfil/{by}'         ,'App:statsAccountsUsedByProfilAction'         )->setName('accounts_used_profil_stats');
$app->get('/accounts/delay/byProfil'             ,'App:statsAccountsDelayProfilAction'          )->setName('accounts_delay_profil_stats');

$app->get('/accounts/available/{uaj}/byProfil'         ,'App:statsAccountsAvailableUajByProfilAction'    )->setName('accounts_available_uaj_profil_stats');
$app->get('/accounts/used/{uaj}/byProfil/{by}'         ,'App:statsAccountsUsedUajByProfilAction'         )->setName('accounts_used_uaj_profil_stats');
$app->get('/accounts/used/{profil}/byUaj/{by}[/{format}]'         ,'App:statsAccountsUsedProfilByUajAction'         )->setName('accounts_used_profil_uaj_stats');

$app->get('/url/{id}/count'      ,'App:statsUrlAction'    )->setName('url_stats');
$app->get('/url/{id}/byProfil'   ,'App:statsUrlByProfilAction'    )->setName('url_profil_stats');
$app->get('/url/{id}/byUaj'      ,'App:statsUrlByUajAction'    )->setName('url_uaj_stats');
$app->get('/url/{id}/json'       ,'App:jsonUrlAction'    )->setName('url_json');
$app->get('/url/byProfil'        ,'App:statsUrlsByProfilAction'    )->setName('urls_profil_stats');


$app->get('/uaj/{uaj}/access/{delay}'     ,'App:accessUajAction'      )->setName('uaj_access');

$app->get('/uaj/{uaj}/view'       ,'App:viewUajAction'          )->setName('uaj_view');
$app->get('/uaj/{uaj}/byProfil'   ,'App:statsUajByProfilAction' )->setName('uaj_profil_stats');
$app->get('/uaj/{uaj}/byApp'      ,'App:statsUajByAppAction'    )->setName('uaj_app_stats');
$app->get('/uaj/{uaj}/byUrl'      ,'App:statsUajByUrlAction'    )->setName('uaj_url_stats');
$app->get('/uaj/byProfil'         ,'App:statsUajsByProfilAction')->setName('uajs_profil_stats');

$app->post('/api/metrics/{name}'  ,'Api:incMetricsAction')->setName('api_metrics');

// Passage des icones app en publiques
$app->get('/public/api/app/{id}/icon'    ,'Api:appIconAction')->setName('app_icon');
$app->get('/api/app/{id}/icon'           ,'Api:appIconAction');

// Passage des icones url en publiques
$app->get('/public/api/url/{id}/icon'    ,'Api:urlIconAction')->setName('url_icon');
$app->get('/api/url/{id}/icon'           ,'Api:urlIconAction');

// Passage des icones cat en publiques
$app->get('/public/api/cat/{id}/icon'    ,'Api:catIconAction')->setName('cat_icon');
$app->get('/api/cat/{id}/icon'           ,'Api:catIconAction');


//Icones (dans table separee, plus besoin de faire appel à app_icon et url_icon)
$app->get('/public/api/icon/{id}/view'    ,'Api:viewIconAction')->setName('icon_view');
$app->get('/api/icon/{id}/view'           ,'Api:viewIconAction');
//Permet de gérer les apps ou urls sans icones (id vide)
$app->get('/public/api/icon//view'           ,'Api:viewIconAction');
$app->get('/api/icon//view'           ,'Api:viewIconAction');

$app->post('/api/ressources'      ,'Api:ressourcesAction');
$app->get('/api/ressources'      ,'Api:ressourcesAction');

// Regresssion suite commit
$app->post('/api/ressources/save'           ,'Api:ressourcesSaveAction');
$app->get('/api/ressources/restore'         ,'Api:ressourcesRestoreAction');

$app->get('/api/config'           ,'Api:configGetAction')->setName('config_get');
$app->post('/api/config'          ,'Api:configSetAction')->setName('config_set');
$app->get('/api/gd/{id}/transparent' ,'Api:gdTransparentAction')->setName('api_gd');
$app->get('/api/apps/top'        ,'Api:AppsTopAction'    )->setName('apps_top');

$app->post('/api/cache/{key}'       ,'Api:cacheSetAction')->setName('cache_set');
$app->delete('/api/cache/{key}'       ,'Api:cacheDelAction')->setName('cache_del');
$app->get('/api/cache'              ,'Api:cacheGetAction')->setName('cache_get');

$app->get('/api/_healthcheck','Api:healthcheckAction' )->setName('healthcheck');
$app->get('/public/api/version','Api:versionAction' )->setName('apiVersion');

// Voir plugin piwik 
//$app->get('/piwik/{rne}/{portail}' ,'Default:piwikAction')->setName('piwik');




$app->get('/public/api/uaj/access/{delay}'   ,'App:accessUajsAction'      )->setName('uajs_access');
$app->put('/public/api/grafana/hook','Api:grafanaHookAction');
$app->get('/public/api/grafana/img/{id}','Api:grafanaImageAction')->setName('grafana_image');

$app->get('/public/api/tokenHub/{hash}','Api:tokenHubAction');
$app->get('/public/assets/css/profil' ,'Default:cssProfilAction' )->setName('css_profil');
$app->get('/public/assets/css/tags' ,'Default:cssTagsAction' )->setName('css_tags');
$app->get('/public/css[/{id:.*}]' ,'Default:cssAction'    )->setName('css');
$app->get('/public/assets/css[/{id:.*}]' ,'Default:cssAction'    )->setName('css_assets');
$app->get('/public/assets/js[/{id:.*}]','Default:jsAction'       )->setName('js');

$app->get('/public/assets/allelements/{id}','Default:elementsLatestAction' )->setName('elementsLatest');


$app->get('/public/assets/{id}/allelements','Default:elementsLatestAction' )->setName('elementsLatest');
$app->get('/public/assets/elements/{id}[/{params:.*}]'    ,'Default:elementsAction' )->setName('elements');


$app->group('/doc', function () {
    $this->get('', 'Doc:indexAction');
    $this->get('/accueil', 'Doc:accueilAction')->setName("doc_accueil");
    $this->get('/page'  , 'Doc:pageAction')->setName("doc_page");
    $this->get('/component/{name}', 'Doc:componentAction')->setName("doc_component");
});


$app->run();
R::close();
