<?php

namespace Edispatcher\plugins\isotope;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Edispatcher\Controllers\BaseController;



class Controller extends BaseController {

    protected $ci;

      //Constructor
      public function __construct(Container $ci) {
        $this->ci = $ci;
        $this->client = curl_init();
        $this->setOption(CURLOPT_RETURNTRANSFER, false);
        $this->setOption(CURLOPT_RETURNTRANSFER, true);
        $this->setOption(CURLOPT_BINARYTRANSFER, true);
        $this->setOption(CURLOPT_SSL_VERIFYPEER, false);
        $this->setOption(CURLOPT_SSL_VERIFYHOST, false);
        $this->setOption(CURLOPT_FOLLOWLOCATION, true);
        $this->setOption(CURLOPT_CONNECTTIMEOUT ,0);
        $this->setOption(CURLOPT_TIMEOUT, 60);
        $this->setOption(CURLOPT_COOKIESESSION, true);
        $this->setOption(CURLOPT_POST, 0);
      }

      protected function setOption($option,$value) {
        curl_setopt($this->client,$option,$value);
      }

      private function _checkAccess(){
          global $__PLUGINS;
          // On verifie que la conf existe
          if (!isset($__PLUGINS['isotope']))           {die("NOT CONFIGURED");}
          if (!isset($__PLUGINS['isotope']["url"]))    {die("URL NON DEFINIE");}
          if (!isset($__PLUGINS['isotope']["token"]))  {die("TOKEN NON DEFINI");}

          $profil = $this->getProfil();
          if (!$profil->isPersAcad()) {
              die("NO PERS ACAD");
          }
      }

      private function _getRessource($path) {

          $this->_checkAccess();

          global $__PLUGINS;

          // récupération de la conf
          $url_isotope   = $__PLUGINS['isotope']["url"];
          $token         = $__PLUGINS['isotope']["token"];



          // Options pour curl
          $cookiefile="/tmp/".md5($url.$token);
          $url = $url_isotope . $path ;
          $this->setOption(CURLOPT_URL,$url );
          $this->setOption(CURLOPT_COOKIEJAR,$cookiefile);
          $this->setOption(CURLOPT_COOKIEFILE,$cookiefile);

          // token api
          $headers = array();
          $headers[] = "token: $token";
          $this->setOption(CURLOPT_HTTPHEADER, $headers);

          $data = curl_exec ($this->client);
          $status= curl_getinfo($this->client,CURLINFO_HTTP_CODE);
          if ($status!="200") {
              die("ERROR: $status");
          }
          $resp=json_decode($data,true);
          return $resp;
      }

      public function callerAction(Request $request, Response $response, $args) {

         $profil = $this->getProfil();
         $uid    = $profil->getUser();
         //if ($uid!="cleon" && $uid!="pcadeot") die();

         $resp = $this->_getRessource("/api/caller/$uid/summary");

         $setting = $this->getSetting("msg_itop");

         $message = "";

         if (in_array('pending', $setting) && isset($resp["status"]) && isset($resp["status"]["pending"])) {
             $plu   = $resp["status"]["pending"]["total"]>1?"s":"";
             $message .="<br><span class=\"badge\">".$resp["status"]["pending"]["total"]."</span> en attente" ;
         }

         if (in_array('assigned', $setting) &&  isset($resp["status"]) && isset($resp["status"]["assigned"])) {
             $plu   = $resp["status"]["assigned"]["total"]>1?"s":"";
             $message .="<br><span class=\"badge\">".$resp["status"]["assigned"]["total"]."</span> en cours de traitement" ;
         }

         if (in_array('new', $setting) &&  isset($resp["status"]) && (isset($resp["status"]["dispatched"]) || isset($resp["status"]["redispatched"]) )  ) {
             $c1 = isset($resp["status"]["dispatched"])?($resp["status"]["dispatched"]["total"]):0;
             $c2 = isset($resp["status"]["redispatched"])?($resp["status"]["redispatched"]["total"]):0;
             $c  = $c1+$c2;
             $plu   = $c>1?"s":"";
             $message .="<br><span class=\"badge\">".$c."</span> en attente de prise en charge" ;
         }

         if (in_array('resolved', $setting) && isset($resp["status"]) && isset($resp["status"]["resolved"])) {
             $plu   = $resp["status"]["resolved"]["total"]>1?"s":"";
             $message .="<br>Vous avez <span class=\"badge\">".$resp["status"]["resolved"]["total"]."</span> <span class=\"exergue\">dossier$plu résolu$plu à évaluer et à clôturer</span>" ;
         }

         if (!$message) {
             die("--");
         }

         if ($resp["total"] && $message) {
            $plu   = $resp["total"]>1?"s":"";
            $message = "Vous avez <span class=\"badge\">" . $resp["total"] . "</span> dossier$plu en cours $message" ;
        }

         $this->sendResponse($resp["total"],$message);


     }

     public function summaryAction(Request $request, Response $response, $args) {

        $profil = $this->getProfil();
        $uid    = $profil->getUser();
        $resp = $this->_getRessource("/api/summary/" . $uid);

        $message = "";

        $setting = $this->getSetting("msg_isotope");

        // total
        if (in_array('followed', $setting) && $resp["total"]) {
            $plu   = $resp["user"]>1?"s":"";
            $small = "";
            if ($resp["total"]!=$resp["user"]) {
                $small="<small> (+". ($resp["total"]-$resp["user"]). ")</small>";
            }
            $message="<span class=\"badge\">" . $resp["user"] . $small . "</span> dossier$plu suivi$plu" ;
        }

        // affected
        if (in_array('new', $setting) && $resp["affected"]) {
            $plu=$resp["affected"]>1?"s":"";
            $message.="<br><span class=\"text-danger\"><span class=\"badge\">" . $resp["affected"] . "</span> dossier$plu en attente de prise en charge par vous ou un membre de vos équipes</span>";
        }

        // mis a jour
        if (in_array('unread', $setting) && $resp["unread"]) {
            $plu=$resp["unread"]>1?"s":"";
            $message.="<br><span class=\"exergue\"><span class=\"badge\">" . $resp["unread"] . "</span> dossier$plu mis à jour</span>";
        }

        if ($message=="") {
            return;
        }

        $count="";
        if (in_array('followed', $setting)) {$count =  $resp["user"] ; }
        if (in_array('new', $setting))      {$count .= ($count?" / ":"") . $resp["affected"] ; }
        if (in_array('unread', $setting))   {$count .= ($count?" / ":"") . $resp["unread"] ; }


        $this->sendResponse($count,$message);

    }

    public function sendResponse($count,$message) {

        $json=json_encode(array("message"=>$message,"count"=>$count));
        if (isset($_GET["api"])) {
            $id=$_GET["id"];
            $api=$_GET["api"];
            header('Content-Type: text/javascript');
            echo "var data=$json;";
            echo "$api('$id',data);";
            die();
        }

        echo "<html><body>";
        echo "<form id='form2submit' name='form2submit' method='POST' action='".$_GET["callback"]."'>";
        echo "<input name='id' id='id' type='hidden' value='".$_GET["id"]."' />";
        echo "<input name='count' id='count' type='hidden' value='".$count."' />";
        echo "<input name='type' id='type' type='hidden' value='"."count"."' />";
        echo "<input name='message' id='message' type='hidden' value='$message' />";
        echo "</form>";
        echo "<script>";
        echo "document.form2submit.submit();";
        echo "</script>";
        echo "</body></html>";
    }

}
